unit SetVoteDlg;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, SysUtils, Forms, Dialogs, Classes, Controls, StdCtrls, Buttons, ComCtrls,
  _NetVote_const;

type
  TSetVote = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Label1: TLabel;
    NameEdt: TEdit;
    Label2: TLabel;
    CommentEdt: TEdit;
    DateLbl: TLabel;
    RatingBar: TTrackBar;
    Label3: TLabel;
    CelebrityBar: TTrackBar;
    Label4: TLabel;
    RatingLbl: TLabel;
    CelebrityLbl: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    GroupBox1: TGroupBox;
    Label8: TLabel;
    FilenameLbl: TLabel;
    Label10: TLabel;
    TitleLbl: TLabel;
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure RatingBarChange(Sender: TObject);
    procedure CelebrityBarChange(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    Vote:TVote;
    procedure SetCreate(_Vote:TVote);
    procedure LoadVote;
    procedure SaveVote;
  end;

var
  SetVote: TSetVote;

implementation

uses _const;

{$R *.dfm}

procedure TSetVote.SetCreate(_Vote:TVote);
begin
  Vote:=_Vote;
  LoadVote;
end;

procedure TSetVote.LoadVote;
begin
  NameEdt.Text:=Vote.Name;
  CommentEdt.Text:=Vote.Comment;
  if Vote.Date=0 then Vote.Date:=now;
  DateLbl.Caption:=formatdatetime('yyyy/mm/dd hh:nn:ss',Vote.Date);
  RatingBar.Position:=Vote.Rating;
  CelebrityBar.Position:=Vote.Celebrity;

  FilenameLbl.Caption:=Vote.Filename;
  TitleLbl.Caption:=Vote.Title;

  RatingBarChange(nil);
  CelebrityBarChange(nil);
end;

procedure TSetVote.SaveVote;
begin
  Vote.Name:=NameEdt.Text;
  Vote.Comment:=CommentEdt.Text;
  Vote.Rating:=RatingBar.Position;
  Vote.Celebrity:=CelebrityBar.Position;
end;

procedure TSetVote.OKBtnClick(Sender: TObject);
var
  errmsg:string;
begin
  errmsg:='';

  if NameEdt.Text='' then errmsg:=errmsg+'O͂Ă܂B'+CRLF;
  if Length(NameEdt.Text)>=255 then errmsg:=errmsg+'Oɂ255ȏ͂ł܂B'+CRLF;
  if CommentEdt.Text='' then errmsg:=errmsg+'Rg͂Ă܂B'+CRLF;
  if Length(CommentEdt.Text)>=255 then errmsg:=errmsg+'Rgɂ255ȏ͂ł܂B'+CRLF;

  if errmsg<>'' then begin
    ShowMessage('ȉ̃G[o܂B'+CRLF+CRLF+errmsg);
    exit;
  end;

  if MessageDlg('[T[oɐڑĂ낵łH',mtConfirmation,[mbYes,mbNo],0)=mrNo then begin
    exit;
  end;

  SaveVote;
  ModalResult:=mrOk;
end;

procedure TSetVote.CancelBtnClick(Sender: TObject);
begin
  if MessageDlg('[𒆒fĂ낵łH',mtConfirmation,[mbYes,mbNo],0)=mrNo then begin
    exit;
  end;

  ModalResult:=mrCancel;
end;

procedure TSetVote.RatingBarChange(Sender: TObject);
begin
  RatingLbl.Caption:=format('(%d)',[RatingBar.Position]);
end;

procedure TSetVote.CelebrityBarChange(Sender: TObject);
begin
  CelebrityLbl.Caption:=format('(%d)',[CelebrityBar.Position]);
end;

end.
