unit _CSkin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, _PicTools,INIFiles;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

const SKIFormat='SimpleSkin';
const SKIVersion='1.0';

type
  TCSkin = class
  private
    { Private 錾 }
    procedure SetDefaultColor;
    procedure SaveCurrentColor;
    procedure LoadCurrentColor;
  public
    { Public 錾 }
    SKIFilename,SKQFilename,SKQUnpath:string;

    // ------------------

    sFormat,sVersion:string;
    sSkinName,sCreator,sLastDate:string;

    // ------------------

    dwTitleBarBG,dwTitleBarIcon,dwTitleBarText,dwTitleBarNega:dword;

    dwBright,dwMask,dwText,dwBG,dwWhite:dword;

    dwFrameBright,dwFrameMask,dwFrameGrip:dword;

    dwTitleBG,dwTitleText:dword;

    dwGridBG,dwGridLine,dwGridSelectBG,dwGridPlayBG:dword;
    dwGridDrive,dwGridDir,dwGridFile:dword;

    dwFuncBG:dword;
    dwFuncEnabledBG,dwFuncEnabledText:dword;
    dwFuncDisabledBG,dwFuncDisabledText:dword;
    dwFuncLoopBG,dwFuncLoop:dword;
    dwFuncTextBG,dwFuncText:dword;

    dwVisSpeScr,dwVisLine0,dwVisLine1,dwVisBar0,dwVisBar1:dword;
    dwVisParaText:dword;

    dwVisKeyBG,dwVisKeyTrackText,dwVisKeyInfoText:dword;
    dwVisKeyFlat,dwVisKeySharp:dword;
    dwVisKey1to8,dwVisKey9to16:dword;

    dwNetPrgBG,dwNetPrgText,dwNetPrgFrameBright,dwNetPrgFrameMask:dword;

    dwPlayCntVolumeText,dwPlayCntTempoText:dword;

    dwWinSpeFrameBG,dwWinSpeBG,dwWinVelBG,dwWinParamBG:dword;

    dwCompactFrameBright,dwCompactFrameMask:dword;
    dwCompactBG:dword;
    dwCompactButtonBG:dword;
    dwCompactTitleBG,dwCompactTitle:dword;
    dwCompactTimeBG,dwCompactTime:dword;

    dwEtcBG,dwEtcBright,dwEtcMask,dwEtcText:dword;

    dwEtcFrameBright,dwEtcFrameMask,dwEtcFrameGrip:dword;

    dwEtcGridBG,dwEtcGridLine:dword;
    dwEtcGridFixedBG,dwEtcGridSelectBG:dword;
    dwEtcGridText:dword;

    // ------------------

    ColTitleBarBG,ColTitleBarIcon,ColTitleBarText,ColTitleBarNega:TRGB;

    ColBright,ColMask,ColText,ColBG,ColWhite:TRGB;

    ColFrameBright,ColFrameMask,ColFrameGrip:TRGB;

    ColTitleBG,ColTitleText:TRGB;

    ColGridBG,ColGridLine,ColGridSelectBG,ColGridPlayBG:TRGB;
    ColGridDrive,ColGridDir,ColGridFile:TRGB;

    ColFuncBG:TRGB;
    ColFuncEnabledBG,ColFuncEnabledText:TRGB;
    ColFuncDisabledBG,ColFuncDisabledText:TRGB;
    ColFuncLoopBG,ColFuncLoop:TRGB;
    ColFuncTextBG,ColFuncText:TRGB;

    ColVisSpeScr,ColVisLine0,ColVisLine1,ColVisBar0,ColVisBar1:TRGB;
    ColVisParaText:TRGB;

    ColVisKeyBG,ColVisKeyTrackText,ColVisKeyInfoText:TRGB;
    ColVisKeyFlat,ColVisKeySharp:TRGB;
    ColVisKey1to8,ColVisKey9to16:TRGB;

    ColNetPrgBG,ColNetPrgText,ColNetPrgFrameBright,ColNetPrgFrameMask:TRGB;

    ColPlayCntVolumeText,ColPlayCntTempoText:TRGB;

    ColWinSpeFrameBG,ColWinSpeBG,ColWinVelBG,ColWinParamBG:TRGB;

    ColCompactFrameBright,ColCompactFrameMask:TRGB;
    ColCompactBG:TRGB;
    ColCompactButtonBG:TRGB;
    ColCompactTitleBG,ColCompactTitle:TRGB;
    ColCompactTimeBG,ColCompactTime:TRGB;

    ColEtcBG,ColEtcBright,ColEtcMask,ColEtcText:TRGB;

    ColEtcFrameBright,ColEtcFrameMask,ColEtcFrameGrip:TRGB;

    ColEtcGridBG,ColEtcGridLine:TRGB;
    ColEtcGridFixedBG,ColEtcGridSelectBG:TRGB;
    ColEtcGridText:TRGB;

    // ------------------

    TitleBarBGAlpha,TitleBarSysBtnAlpha,TitleBarNegaAlpha:byte;
    BGAlpha:byte;
    TitleBGAlpha:byte;
    ScrollBarGripAlpha:byte;
    VisKeyBGAlpha,VisKeyBGLineAlpha,VisKeyNoteAlpha:byte;
    FuncBGAlpha:byte;
    FuncBGEnabledAlpha,FuncBGDisabledAlpha:byte;
    FuncLoopAlpha,FuncTextAlpha:byte;
    NetPrgBGAlpha,NetPrgBarNegaAlpha,NetPrgBarPosiAlpha:byte;
    PlayCntSeekBarNegaAlpha,PlayCntSeekBarPosiAlpha:byte;
    PlayCntVolumeBarNegaAlpha,PlayCntVolumeBarPosiAlpha:byte;
    PlayCntTempoBarNegaAlpha,PlayCntTempoBarPosiAlpha:byte;
    WinSpeFrameAlpha,WinSpeAlpha,WinVelAlpha,WinParamAlpha:byte;
    CompactBGAlpha:byte;

    constructor Create;
    destructor Destroy; override;
    procedure SaveSkin(_SKIFilename:string);
    procedure LoadSkin(_SKIFilename:string);
    procedure LoadBitmap(ID:string;bm:TBitmap;x,y:integer;pf:TPixelFormat);
  end;

var
  CSkin:TCSkin;

implementation

constructor TCSkin.Create;
begin
  SetDefaultColor;
end;

destructor TCSkin.Destroy;
begin

  inherited Destroy;
end;

procedure TCSkin.SaveSkin(_SKIFilename:string);
begin
  if _SKIFilename<>'' then begin
    SKIFilename:=_SKIFilename;
    SKQFilename:=ChangeFileExt(SKIFilename,'.skq');
    SKQUnpath:=ChangeFileExt(SKIFilename,'')+'\';
  end;

  SaveCurrentColor;
end;

procedure TCSkin.LoadSkin(_SKIFilename:string);
begin
  if _SKIFilename<>'' then begin
    SKIFilename:=_SKIFilename;
    SKQFilename:=ChangeFileExt(SKIFilename,'.skq');
    SKQUnpath:=ChangeFileExt(SKIFilename,'')+'\';
  end;

  LoadCurrentColor;
end;

procedure TCSkin.LoadBitmap(ID:string;bm:TBitmap;x,y:integer;pf:TPixelFormat);
begin
  if FileExists(SKQUnpath+ID)=True then begin
    bm.LoadFromFile(SKQUnpath+ID);
    end else begin
    LoadBitmapFromQDA(SKQFilename,ID,bm);
  end;

  bm.PixelFormat:=pf;
  if x<>-1 then bm.Width:=x;
  if x=0 then bm.Width:=1;
  if y<>-1 then bm.Height:=y;
  if y=0 then bm.Height:=1;
end;

procedure TCSkin.SetDefaultColor;
var
  Section:string;
  procedure SetColor(Ident:string;var rgb:TRGB;var dw:dword;_dw:dword);
  begin
    rgb:=dword2rgb(_dw);
    dw:=_dw;
  end;
  procedure SetAlpha(Ident:string;var Alpha:byte;_Alpha:byte);
  begin
    Alpha:=_Alpha;
  end;
begin
  Section:='ID';
//  txt:=SKIFormat;
//  txt:=SKIVersion;
  sFormat:=SKIFormat;
  sVersion:=SKIVersion;
  sSkinName:='noname';
  sCreator:='noregist';
  sLastDate:='0000/00/00';

  Section:='TitleBar';
  SetColor('BG',ColTitleBarBG,dwTitleBarBG,$000000);
  SetColor('Icon',ColTitleBarIcon,dwTitleBarIcon,$ffffff);
  SetColor('Text',ColTitleBarText,dwTitleBarText,$e0d0d0);
  SetColor('Nega',ColTitleBarNega,dwTitleBarNega,$404040);
  SetAlpha('BGAlpha',TitleBarBGAlpha,$40);
  SetAlpha('SysBtnAlpha',TitleBarSysBtnAlpha,$e0);
  SetAlpha('NegaAlpha',TitleBarNegaAlpha,$80);

  Section:='General';
  SetColor('Bright',ColBright,dwBright,$ffc0c0);
  SetColor('Mask',ColMask,dwMask,$d08080);
  SetColor('Text',ColText,dwText,$ffffff);
  SetColor('BG',ColBG,dwBG,$000000);
  SetColor('White',ColWhite,dwWhite,$ffffff);
  SetAlpha('BGAlpha',BGAlpha,$00);
  SetAlpha('TitleBGAlpha',TitleBGAlpha,$40);
  SetAlpha('ScrollBarGripAlpha',ScrollBarGripAlpha,$ff);

  Section:='Frame';
  SetColor('Bright',ColFrameBright,dwFrameBright,$f0b0b0);
  SetColor('Mask',ColFrameMask,dwFrameMask,$c08080);
  SetColor('Grip',ColFrameGrip,dwFrameGrip,$ffc0c0);

  Section:='Title';
  SetColor('BG',ColTitleBG,dwTitleBG,$000000);
  SetColor('Text',ColTitleText,dwTitleText,$fff0f0);

  Section:='Grid';
  SetColor('BG',ColGridBG,dwGridBG,$261E15);
  SetColor('Line',ColGridLine,dwGridLine,$d08080);
  SetColor('SelectBG',ColGridSelectBG,dwGridSelectBG,$d08080);
  SetColor('PlayBG',ColGridPlayBG,dwGridPlayBG,$b06060);
  SetColor('Drive',ColGridDrive,dwGridDrive,$ffc0c0);
  SetColor('Dir',ColGridDir,dwGridDir,$ffc0c0);
  SetColor('File',ColGridFile,dwGridFile,$ffe0e0);

  Section:='Func';
  SetColor('BG',ColFuncBG,dwFuncBG,$000000);
  SetColor('EnabledBG',ColFuncEnabledBG,dwFuncEnabledBG,$c08080);
  SetColor('EnabledText',ColFuncEnabledText,dwFuncEnabledText,$fff0f0);
  SetColor('DisabledBG',ColFuncDisabledBG,dwFuncDisabledBG,$804040);
  SetColor('DisabledText',ColFuncDisabledText,dwFuncDisabledText,$ffc0c0);
  SetColor('LoopBG',ColFuncLoopBG,dwFuncLoopBG,$000000);
  SetColor('Loop',ColFuncLoop,dwFuncLoop,$f0b0b0);
  SetColor('TextBG',ColFuncTextBG,dwFuncTextBG,$000000);
  SetColor('Text',ColFuncText,dwFuncText,$ffffff);
  SetAlpha('BGAlpha',FuncBGAlpha,$00);
  SetAlpha('BGEnabledAlpha',FuncBGEnabledAlpha,$80);
  SetAlpha('BGDisabledAlpha',FuncBGDisabledAlpha,$80);
  SetAlpha('LoopAlpha',FuncLoopAlpha,$80);
  SetAlpha('TextAlpha',FuncTextAlpha,$a0);

  Section:='Vis';
  SetColor('SpeScr',ColVisSpeScr,dwVisSpeScr,$ffb0b0);
  SetColor('Line0',ColVisLine0,dwVisLine0,$f0a0a0);
  SetColor('Line1',ColVisLine1,dwVisLine1,$905050);
  SetColor('Bar0',ColVisBar0,dwVisBar0,$f0a0a0);
  SetColor('Bar1',ColVisBar1,dwVisBar1,$905050);
  SetColor('ParaText',ColVisParaText,dwVisParaText,$fff0f0);

  Section:='VisKey';
  SetColor('BG',ColVisKeyBG,dwVisKeyBG,$000000);
  SetColor('TrackText',ColVisKeyTrackText,dwVisKeyTrackText,$f0b0b0);
  SetColor('InfoText',ColVisKeyInfoText,dwVisKeyInfoText,$c07070);
  SetColor('Flat',ColVisKeyFlat,dwVisKeyFlat,$ffffff);
  SetColor('Sharp',ColVisKeySharp,dwVisKeySharp,$404040);
  SetColor('1to8',ColVisKey1to8,dwVisKey1to8,$60f060);
  SetColor('9to16',ColVisKey9to16,dwVisKey9to16,$ff7070);
  SetAlpha('BGAlpha',VisKeyBGAlpha,$60);
  SetAlpha('BGLineAlpha',VisKeyBGLineAlpha,$80);
  SetAlpha('NoteAlpha',VisKeyNoteAlpha,$a0);

  Section:='NetPrg';
  SetColor('BG',ColNetPrgBG,dwNetPrgBG,$000000);
  SetColor('Text',ColNetPrgText,dwNetPrgText,$f0c0c0);
  SetColor('FrameBright',ColNetPrgFrameBright,dwNetPrgFrameBright,$c09090);
  SetColor('FrameMask',ColNetPrgFrameMask,dwNetPrgFrameMask,$806060);
  SetAlpha('BGAlpha',NetPrgBGAlpha,$80);
  SetAlpha('NegaAlpha',NetPrgBarNegaAlpha,$20);
  SetAlpha('PosiAlpha',NetPrgBarPosiAlpha,$80);

  Section:='PlayCnt';
  SetColor('VolumeText',ColPlayCntVolumeText,dwPlayCntVolumeText,$ffc0c0);
  SetColor('TempoText',ColPlayCntTempoText,dwPlayCntTempoText,$ffc0c0);
  SetAlpha('SeekBarNegaAlpha',PlayCntSeekBarNegaAlpha,$40);
  SetAlpha('SeekBarPosiAlpha',PlayCntSeekBarPosiAlpha,$80);
  SetAlpha('VolumeBarNegaAlpha',PlayCntVolumeBarNegaAlpha,$60);
  SetAlpha('VolumeBarPosiAlpha',PlayCntVolumeBarPosiAlpha,$e0);
  SetAlpha('TempoBarNegaAlpha',PlayCntTempoBarNegaAlpha,$60);
  SetAlpha('TempoBarPosiAlpha',PlayCntTempoBarPosiAlpha,$e0);

  Section:='Win';
  SetColor('SpeFrameBG',ColWinSpeFrameBG,dwWinSpeFrameBG,$000000);
  SetColor('SpeBG',ColWinSpeBG,dwWinSpeBG,$000000);
  SetColor('VelBG',ColWinVelBG,dwWinVelBG,$000000);
  SetColor('ParamBG',ColWinParamBG,dwWinParamBG,$000000);
  SetAlpha('SpeFrameAlpha',WinSpeFrameAlpha,$80);
  SetAlpha('SpeAlpha',WinSpeAlpha,$80);
  SetAlpha('VelAlpha',WinVelAlpha,$40);
  SetAlpha('ParamAlpha',WinParamAlpha,$40);

  Section:='Compact';
  SetColor('FrameBright',ColCompactFrameBright,dwCompactFrameBright,$f0b0b0);
  SetColor('FrameMask',ColCompactFrameMask,dwCompactFrameMask,$c08080);
  SetColor('BG',ColCompactBG,dwCompactBG,$202020);
  SetColor('ButtonBG',ColCompactButtonBG,dwCompactButtonBG,$00ff00);
  SetColor('TitleBG',ColCompactTitleBG,dwCompactTitleBG,$000000);
  SetColor('Title',ColCompactTitle,dwCompactTitle,$ffffff);
  SetColor('TimeBG',ColCompactTimeBG,dwCompactTimeBG,$000000);
  SetColor('Time',ColCompactTime,dwCompactTime,$f0d0d0);
  SetAlpha('BGAlpha',CompactBGAlpha,$a0);

  Section:='EtcGeneral';
  SetColor('BG',ColEtcBG,dwEtcBG,$261e15);
  SetColor('Bright',ColEtcBright,dwEtcBright,$ffc0c0);
  SetColor('Mask',ColEtcMask,dwEtcMask,$d08080);
  SetColor('Text',ColEtcText,dwEtcText,$ffffff);

  Section:='EtcFrame';
  SetColor('Bright',ColEtcFrameBright,dwEtcFrameBright,$f0b0b0);
  SetColor('Mask',ColEtcFrameMask,dwEtcFrameMask,$c08080);
  SetColor('Grip',ColEtcFrameGrip,dwEtcFrameGrip,$ffc0c0);

  Section:='EtcGrid';
  SetColor('BG',ColEtcGridBG,dwEtcGridBG,$261e15);
  SetColor('Line',ColEtcGridLine,dwEtcGridLine,$d08080);
  SetColor('FixedBG',ColEtcGridFixedBG,dwEtcGridFixedBG,$804040);
  SetColor('SelectBG',ColEtcGridSelectBG,dwEtcGridSelectBG,$d08080);
  SetColor('Text',ColEtcGridText,dwEtcGridText,$ffe0e0);
end;

procedure TCSkin.SaveCurrentColor;
var
  AppINI:TextFile;
  Section,LastSection:string;
  procedure WriteValue(Ident:string;Value:string);
  begin
    if LastSection<>Section then begin
      LastSection:=Section;
      Writeln(AppINI,'['+Section+']');
    end;
    Writeln(AppINI,Ident+'='+Value);
  end;
  procedure SetString(Ident:string;var Value:string);
  begin
    WriteValue(Ident,Value);
  end;
  procedure SetColor(Ident:string;var rgb:TRGB;var dw:dword;_dw:dword);
  begin
    WriteValue(Ident,'$'+inttohex(dw,6));
  end;
  procedure SetAlpha(Ident:string;var Alpha:byte;_Alpha:byte);
  begin
    WriteValue(Ident,'$'+inttohex(Alpha,2));
  end;
begin
  LastSection:='';

  DeleteFile(SKIFilename);
  AssignFile(AppINI,SKIFilename);
  Rewrite(AppINI);

  Section:='ID';
//  txt:=SKIFormat;
//  txt:=SKIVersion;
  SetString('Format',sFormat);
  SetString('Version',sVersion);
  SetString('SkinName',sSkinName);
  SetString('Creator',sCreator);
  SetString('LastDate',sLastDate);

  Section:='TitleBar';
  SetColor('BG',ColTitleBarBG,dwTitleBarBG,$000000);
  SetColor('Icon',ColTitleBarIcon,dwTitleBarIcon,$ffffff);
  SetColor('Text',ColTitleBarText,dwTitleBarText,$e0d0d0);
  SetColor('Nega',ColTitleBarNega,dwTitleBarNega,$404040);
  SetAlpha('BGAlpha',TitleBarBGAlpha,$40);
  SetAlpha('SysBtnAlpha',TitleBarSysBtnAlpha,$e0);
  SetAlpha('NegaAlpha',TitleBarNegaAlpha,$80);

  Section:='General';
  SetColor('Bright',ColBright,dwBright,$ffc0c0);
  SetColor('Mask',ColMask,dwMask,$d08080);
  SetColor('Text',ColText,dwText,$ffffff);
  SetColor('BG',ColBG,dwBG,$000000);
  SetColor('White',ColWhite,dwWhite,$ffffff);
  SetAlpha('BGAlpha',BGAlpha,$00);
  SetAlpha('TitleBGAlpha',TitleBGAlpha,$40);
  SetAlpha('ScrollBarGripAlpha',ScrollBarGripAlpha,$ff);

  Section:='Frame';
  SetColor('Bright',ColFrameBright,dwFrameBright,$f0b0b0);
  SetColor('Mask',ColFrameMask,dwFrameMask,$c08080);
  SetColor('Grip',ColFrameGrip,dwFrameGrip,$ffc0c0);

  Section:='Title';
  SetColor('BG',ColTitleBG,dwTitleBG,$000000);
  SetColor('Text',ColTitleText,dwTitleText,$fff0f0);

  Section:='Grid';
  SetColor('BG',ColGridBG,dwGridBG,$261E15);
  SetColor('Line',ColGridLine,dwGridLine,$d08080);
  SetColor('SelectBG',ColGridSelectBG,dwGridSelectBG,$d08080);
  SetColor('PlayBG',ColGridPlayBG,dwGridPlayBG,$b06060);
  SetColor('Drive',ColGridDrive,dwGridDrive,$ffc0c0);
  SetColor('Dir',ColGridDir,dwGridDir,$ffc0c0);
  SetColor('File',ColGridFile,dwGridFile,$ffe0e0);

  Section:='Func';
  SetColor('BG',ColFuncBG,dwFuncBG,$000000);
  SetColor('EnabledBG',ColFuncEnabledBG,dwFuncEnabledBG,$c08080);
  SetColor('EnabledText',ColFuncEnabledText,dwFuncEnabledText,$fff0f0);
  SetColor('DisabledBG',ColFuncDisabledBG,dwFuncDisabledBG,$804040);
  SetColor('DisabledText',ColFuncDisabledText,dwFuncDisabledText,$ffc0c0);
  SetColor('LoopBG',ColFuncLoopBG,dwFuncLoopBG,$000000);
  SetColor('Loop',ColFuncLoop,dwFuncLoop,$f0b0b0);
  SetColor('TextBG',ColFuncTextBG,dwFuncTextBG,$000000);
  SetColor('Text',ColFuncText,dwFuncText,$ffffff);
  SetAlpha('BGAlpha',FuncBGAlpha,$00);
  SetAlpha('BGEnabledAlpha',FuncBGEnabledAlpha,$80);
  SetAlpha('BGDisabledAlpha',FuncBGDisabledAlpha,$80);
  SetAlpha('LoopAlpha',FuncLoopAlpha,$80);
  SetAlpha('TextAlpha',FuncTextAlpha,$a0);

  Section:='Vis';
  SetColor('SpeScr',ColVisSpeScr,dwVisSpeScr,$ffb0b0);
  SetColor('Line0',ColVisLine0,dwVisLine0,$f0a0a0);
  SetColor('Line1',ColVisLine1,dwVisLine1,$905050);
  SetColor('Bar0',ColVisBar0,dwVisBar0,$f0a0a0);
  SetColor('Bar1',ColVisBar1,dwVisBar1,$905050);
  SetColor('ParaText',ColVisParaText,dwVisParaText,$fff0f0);

  Section:='VisKey';
  SetColor('BG',ColVisKeyBG,dwVisKeyBG,$000000);
  SetColor('TrackText',ColVisKeyTrackText,dwVisKeyTrackText,$f0b0b0);
  SetColor('InfoText',ColVisKeyInfoText,dwVisKeyInfoText,$c07070);
  SetColor('Flat',ColVisKeyFlat,dwVisKeyFlat,$ffffff);
  SetColor('Sharp',ColVisKeySharp,dwVisKeySharp,$404040);
  SetColor('1to8',ColVisKey1to8,dwVisKey1to8,$60f060);
  SetColor('9to16',ColVisKey9to16,dwVisKey9to16,$ff7070);
  SetAlpha('BGAlpha',VisKeyBGAlpha,$60);
  SetAlpha('BGLineAlpha',VisKeyBGLineAlpha,$80);
  SetAlpha('NoteAlpha',VisKeyNoteAlpha,$a0);

  Section:='NetPrg';
  SetColor('BG',ColNetPrgBG,dwNetPrgBG,$000000);
  SetColor('Text',ColNetPrgText,dwNetPrgText,$f0c0c0);
  SetColor('FrameBright',ColNetPrgFrameBright,dwNetPrgFrameBright,$c09090);
  SetColor('FrameMask',ColNetPrgFrameMask,dwNetPrgFrameMask,$806060);
  SetAlpha('BGAlpha',NetPrgBGAlpha,$80);
  SetAlpha('NegaAlpha',NetPrgBarNegaAlpha,$20);
  SetAlpha('PosiAlpha',NetPrgBarPosiAlpha,$80);

  Section:='PlayCnt';
  SetColor('VolumeText',ColPlayCntVolumeText,dwPlayCntVolumeText,$ffc0c0);
  SetColor('TempoText',ColPlayCntTempoText,dwPlayCntTempoText,$ffc0c0);
  SetAlpha('SeekBarNegaAlpha',PlayCntSeekBarNegaAlpha,$40);
  SetAlpha('SeekBarPosiAlpha',PlayCntSeekBarPosiAlpha,$80);
  SetAlpha('VolumeBarNegaAlpha',PlayCntVolumeBarNegaAlpha,$60);
  SetAlpha('VolumeBarPosiAlpha',PlayCntVolumeBarPosiAlpha,$e0);
  SetAlpha('TempoBarNegaAlpha',PlayCntTempoBarNegaAlpha,$60);
  SetAlpha('TempoBarPosiAlpha',PlayCntTempoBarPosiAlpha,$e0);

  Section:='Win';
  SetColor('SpeFrameBG',ColWinSpeFrameBG,dwWinSpeFrameBG,$000000);
  SetColor('SpeBG',ColWinSpeBG,dwWinSpeBG,$000000);
  SetColor('VelBG',ColWinVelBG,dwWinVelBG,$000000);
  SetColor('ParamBG',ColWinParamBG,dwWinParamBG,$000000);
  SetAlpha('SpeFrameAlpha',WinSpeFrameAlpha,$80);
  SetAlpha('SpeAlpha',WinSpeAlpha,$80);
  SetAlpha('VelAlpha',WinVelAlpha,$40);
  SetAlpha('ParamAlpha',WinParamAlpha,$40);

  Section:='Compact';
  SetColor('FrameBright',ColCompactFrameBright,dwCompactFrameBright,$f0b0b0);
  SetColor('FrameMask',ColCompactFrameMask,dwCompactFrameMask,$c08080);
  SetColor('BG',ColCompactBG,dwCompactBG,$202020);
  SetColor('ButtonBG',ColCompactButtonBG,dwCompactButtonBG,$00ff00);
  SetColor('TitleBG',ColCompactTitleBG,dwCompactTitleBG,$000000);
  SetColor('Title',ColCompactTitle,dwCompactTitle,$ffffff);
  SetColor('TimeBG',ColCompactTimeBG,dwCompactTimeBG,$000000);
  SetColor('Time',ColCompactTime,dwCompactTime,$f0d0d0);
  SetAlpha('BGAlpha',CompactBGAlpha,$a0);

  Section:='EtcGeneral';
  SetColor('BG',ColEtcBG,dwEtcBG,$261e15);
  SetColor('Bright',ColEtcBright,dwEtcBright,$ffc0c0);
  SetColor('Mask',ColEtcMask,dwEtcMask,$d08080);
  SetColor('Text',ColEtcText,dwEtcText,$ffffff);

  Section:='EtcFrame';
  SetColor('Bright',ColEtcFrameBright,dwEtcFrameBright,$f0b0b0);
  SetColor('Mask',ColEtcFrameMask,dwEtcFrameMask,$c08080);
  SetColor('Grip',ColEtcFrameGrip,dwEtcFrameGrip,$ffc0c0);

  Section:='EtcGrid';
  SetColor('BG',ColEtcGridBG,dwEtcGridBG,$261e15);
  SetColor('Line',ColEtcGridLine,dwEtcGridLine,$d08080);
  SetColor('FixedBG',ColEtcGridFixedBG,dwEtcGridFixedBG,$804040);
  SetColor('SelectBG',ColEtcGridSelectBG,dwEtcGridSelectBG,$d08080);
  SetColor('Text',ColEtcGridText,dwEtcGridText,$ffe0e0);

  CloseFile(AppINI);
end;

procedure TCSkin.LoadCurrentColor;
var
  AppINI:TMemIniFile;
  Section:string;
  procedure SetString(Ident:string;var Value:string);
  begin
    Value:=AppINI.ReadString(Section,Ident,Value);
  end;
  procedure SetColor(Ident:string;var rgb:TRGB;var dw:dword;_dw:dword);
  begin
    _dw:=AppINI.ReadInteger(Section,Ident,0);
    rgb:=dword2rgb(_dw);
    dw:=_dw;
  end;
  procedure SetAlpha(Ident:string;var Alpha:byte;_Alpha:byte);
  begin
    _Alpha:=AppINI.ReadInteger(Section,Ident,0);
    Alpha:=_Alpha;
  end;
begin
  AppINI:=TMemIniFile.Create(SKIFilename);

  Section:='ID';
//  txt:=SKIFormat;
//  txt:=SKIVersion;
  SetString('Format',sFormat);
  SetString('Version',sVersion);
  SetString('SkinName',sSkinName);
  SetString('Creator',sCreator);
  SetString('LastDate',sLastDate);

  Section:='TitleBar';
  SetColor('BG',ColTitleBarBG,dwTitleBarBG,$000000);
  SetColor('Icon',ColTitleBarIcon,dwTitleBarIcon,$ffffff);
  SetColor('Text',ColTitleBarText,dwTitleBarText,$e0d0d0);
  SetColor('Nega',ColTitleBarNega,dwTitleBarNega,$404040);
  SetAlpha('BGAlpha',TitleBarBGAlpha,$40);
  SetAlpha('SysBtnAlpha',TitleBarSysBtnAlpha,$e0);
  SetAlpha('NegaAlpha',TitleBarNegaAlpha,$80);

  Section:='General';
  SetColor('Bright',ColBright,dwBright,$ffc0c0);
  SetColor('Mask',ColMask,dwMask,$d08080);
  SetColor('Text',ColText,dwText,$ffffff);
  SetColor('BG',ColBG,dwBG,$000000);
  SetColor('White',ColWhite,dwWhite,$ffffff);
  SetAlpha('BGAlpha',BGAlpha,$00);
  SetAlpha('TitleBGAlpha',TitleBGAlpha,$40);
  SetAlpha('ScrollBarGripAlpha',ScrollBarGripAlpha,$ff);

  Section:='Frame';
  SetColor('Bright',ColFrameBright,dwFrameBright,$f0b0b0);
  SetColor('Mask',ColFrameMask,dwFrameMask,$c08080);
  SetColor('Grip',ColFrameGrip,dwFrameGrip,$ffc0c0);

  Section:='Title';
  SetColor('BG',ColTitleBG,dwTitleBG,$000000);
  SetColor('Text',ColTitleText,dwTitleText,$fff0f0);

  Section:='Grid';
  SetColor('BG',ColGridBG,dwGridBG,$261E15);
  SetColor('Line',ColGridLine,dwGridLine,$d08080);
  SetColor('SelectBG',ColGridSelectBG,dwGridSelectBG,$d08080);
  SetColor('PlayBG',ColGridPlayBG,dwGridPlayBG,$b06060);
  SetColor('Drive',ColGridDrive,dwGridDrive,$ffc0c0);
  SetColor('Dir',ColGridDir,dwGridDir,$ffc0c0);
  SetColor('File',ColGridFile,dwGridFile,$ffe0e0);

  Section:='Func';
  SetColor('BG',ColFuncBG,dwFuncBG,$000000);
  SetColor('EnabledBG',ColFuncEnabledBG,dwFuncEnabledBG,$c08080);
  SetColor('EnabledText',ColFuncEnabledText,dwFuncEnabledText,$fff0f0);
  SetColor('DisabledBG',ColFuncDisabledBG,dwFuncDisabledBG,$804040);
  SetColor('DisabledText',ColFuncDisabledText,dwFuncDisabledText,$ffc0c0);
  SetColor('LoopBG',ColFuncLoopBG,dwFuncLoopBG,$000000);
  SetColor('Loop',ColFuncLoop,dwFuncLoop,$f0b0b0);
  SetColor('TextBG',ColFuncTextBG,dwFuncTextBG,$000000);
  SetColor('Text',ColFuncText,dwFuncText,$ffffff);
  SetAlpha('BGAlpha',FuncBGAlpha,$00);
  SetAlpha('BGEnabledAlpha',FuncBGEnabledAlpha,$80);
  SetAlpha('BGDisabledAlpha',FuncBGDisabledAlpha,$80);
  SetAlpha('LoopAlpha',FuncLoopAlpha,$80);
  SetAlpha('TextAlpha',FuncTextAlpha,$a0);

  Section:='Vis';
  SetColor('SpeScr',ColVisSpeScr,dwVisSpeScr,$ffb0b0);
  SetColor('Line0',ColVisLine0,dwVisLine0,$f0a0a0);
  SetColor('Line1',ColVisLine1,dwVisLine1,$905050);
  SetColor('Bar0',ColVisBar0,dwVisBar0,$f0a0a0);
  SetColor('Bar1',ColVisBar1,dwVisBar1,$905050);
  SetColor('ParaText',ColVisParaText,dwVisParaText,$fff0f0);

  Section:='VisKey';
  SetColor('BG',ColVisKeyBG,dwVisKeyBG,$000000);
  SetColor('TrackText',ColVisKeyTrackText,dwVisKeyTrackText,$f0b0b0);
  SetColor('InfoText',ColVisKeyInfoText,dwVisKeyInfoText,$c07070);
  SetColor('Flat',ColVisKeyFlat,dwVisKeyFlat,$ffffff);
  SetColor('Sharp',ColVisKeySharp,dwVisKeySharp,$404040);
  SetColor('1to8',ColVisKey1to8,dwVisKey1to8,$60f060);
  SetColor('9to16',ColVisKey9to16,dwVisKey9to16,$ff7070);
  SetAlpha('BGAlpha',VisKeyBGAlpha,$60);
  SetAlpha('BGLineAlpha',VisKeyBGLineAlpha,$80);
  SetAlpha('NoteAlpha',VisKeyNoteAlpha,$a0);

  Section:='NetPrg';
  SetColor('BG',ColNetPrgBG,dwNetPrgBG,$000000);
  SetColor('Text',ColNetPrgText,dwNetPrgText,$f0c0c0);
  SetColor('FrameBright',ColNetPrgFrameBright,dwNetPrgFrameBright,$c09090);
  SetColor('FrameMask',ColNetPrgFrameMask,dwNetPrgFrameMask,$806060);
  SetAlpha('BGAlpha',NetPrgBGAlpha,$80);
  SetAlpha('NegaAlpha',NetPrgBarNegaAlpha,$20);
  SetAlpha('PosiAlpha',NetPrgBarPosiAlpha,$80);

  Section:='PlayCnt';
  SetColor('VolumeText',ColPlayCntVolumeText,dwPlayCntVolumeText,$ffc0c0);
  SetColor('TempoText',ColPlayCntTempoText,dwPlayCntTempoText,$ffc0c0);
  SetAlpha('SeekBarNegaAlpha',PlayCntSeekBarNegaAlpha,$40);
  SetAlpha('SeekBarPosiAlpha',PlayCntSeekBarPosiAlpha,$80);
  SetAlpha('VolumeBarNegaAlpha',PlayCntVolumeBarNegaAlpha,$60);
  SetAlpha('VolumeBarPosiAlpha',PlayCntVolumeBarPosiAlpha,$e0);
  SetAlpha('TempoBarNegaAlpha',PlayCntTempoBarNegaAlpha,$60);
  SetAlpha('TempoBarPosiAlpha',PlayCntTempoBarPosiAlpha,$e0);

  Section:='Win';
  SetColor('SpeFrameBG',ColWinSpeFrameBG,dwWinSpeFrameBG,$000000);
  SetColor('SpeBG',ColWinSpeBG,dwWinSpeBG,$000000);
  SetColor('VelBG',ColWinVelBG,dwWinVelBG,$000000);
  SetColor('ParamBG',ColWinParamBG,dwWinParamBG,$000000);
  SetAlpha('SpeFrameAlpha',WinSpeFrameAlpha,$80);
  SetAlpha('SpeAlpha',WinSpeAlpha,$80);
  SetAlpha('VelAlpha',WinVelAlpha,$40);
  SetAlpha('ParamAlpha',WinParamAlpha,$40);

  Section:='Compact';
  SetColor('FrameBright',ColCompactFrameBright,dwCompactFrameBright,$f0b0b0);
  SetColor('FrameMask',ColCompactFrameMask,dwCompactFrameMask,$c08080);
  SetColor('BG',ColCompactBG,dwCompactBG,$202020);
  SetColor('ButtonBG',ColCompactButtonBG,dwCompactButtonBG,$00ff00);
  SetColor('TitleBG',ColCompactTitleBG,dwCompactTitleBG,$000000);
  SetColor('Title',ColCompactTitle,dwCompactTitle,$ffffff);
  SetColor('TimeBG',ColCompactTimeBG,dwCompactTimeBG,$000000);
  SetColor('Time',ColCompactTime,dwCompactTime,$f0d0d0);
  SetAlpha('BGAlpha',CompactBGAlpha,$a0);

  Section:='EtcGeneral';
  SetColor('BG',ColEtcBG,dwEtcBG,$261e15);
  SetColor('Bright',ColEtcBright,dwEtcBright,$ffc0c0);
  SetColor('Mask',ColEtcMask,dwEtcMask,$d08080);
  SetColor('Text',ColEtcText,dwEtcText,$ffffff);

  Section:='EtcFrame';
  SetColor('Bright',ColEtcFrameBright,dwEtcFrameBright,$f0b0b0);
  SetColor('Mask',ColEtcFrameMask,dwEtcFrameMask,$c08080);
  SetColor('Grip',ColEtcFrameGrip,dwEtcFrameGrip,$ffc0c0);

  Section:='EtcGrid';
  SetColor('BG',ColEtcGridBG,dwEtcGridBG,$261e15);
  SetColor('Line',ColEtcGridLine,dwEtcGridLine,$d08080);
  SetColor('FixedBG',ColEtcGridFixedBG,dwEtcGridFixedBG,$804040);
  SetColor('SelectBG',ColEtcGridSelectBG,dwEtcGridSelectBG,$d08080);
  SetColor('Text',ColEtcGridText,dwEtcGridText,$ffe0e0);

  AppINI.Free;
end;

initialization
  CSkin:=TCSkin.Create;

finalization
  CSkin.Free;
  CSkin:=nil;

end.
