unit _KeyDef_const;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

const
  VK_NONE = 0;
  VK_CANCEL = 3;
  VK_BACK = 8;
  VK_TAB = 9;
  VK_CLEAR = 12;
  VK_RETURN = 13;
  VK_SHIFT = 16;
  VK_CONTROL = 17;
  VK_MENU = 18;
  VK_PAUSE = 19;
  VK_CAPITAL = 20;
  VK_ESCAPE = 27;
  VK_SPACE = 32;
  VK_PRIOR = 33;
  VK_NEXT = 34;
  VK_END = 35;
  VK_HOME = 36;
  VK_LEFT = 37;
  VK_UP = 38;
  VK_RIGHT = 39;
  VK_DOWN = 40;
  VK_SELECT = 41;
  VK_PRINT = 42;
  VK_EXECUTE = 43;
  VK_SNAPSHOT = 44;
  VK_INSERT = 45;
  VK_DELETE = 46;
  VK_HELP = 47;
  VK_LWIN = 91;
  VK_RWIN = 92;
  VK_APPS = 93;
  VK_NUMPAD0 = 96;
  VK_NUMPAD1 = 97;
  VK_NUMPAD2 = 98;
  VK_NUMPAD3 = 99;
  VK_NUMPAD4 = 100;
  VK_NUMPAD5 = 101;
  VK_NUMPAD6 = 102;
  VK_NUMPAD7 = 103;
  VK_NUMPAD8 = 104;
  VK_NUMPAD9 = 105;
  VK_MULTIPLY = 106;
  VK_ADD = 107;
  VK_SEPARATOR = 108;
  VK_SUBTRACT = 109;
  VK_DECIMAL = 110;
  VK_DIVIDE = 111;
  VK_F1 = 112;
  VK_F2 = 113;
  VK_F3 = 114;
  VK_F4 = 115;
  VK_F5 = 116;
  VK_F6 = 117;
  VK_F7 = 118;
  VK_F8 = 119;
  VK_F9 = 120;
  VK_F10 = 121;
  VK_F11 = 122;
  VK_F12 = 123;
  VK_F13 = 124;
  VK_F14 = 125;
  VK_F15 = 126;
  VK_F16 = 127;
  VK_F17 = 128;
  VK_F18 = 129;
  VK_F19 = 130;
  VK_F20 = 131;
  VK_F21 = 132;
  VK_F22 = 133;
  VK_F23 = 134;
  VK_F24 = 135;
  VK_NUMLOCK = 144;
  VK_SCROLL = 145;
  VK_OEM_4 = 219; // [
  VK_OEM_5 = 220; // \
  VK_OEM_6 = 221; // ]
  VK_OEM_7 = 222; // ^
  VK_OEM_8 = 223; // _
  VK_OEM_9 = 224;
  VK_OEM_AX = 225;
  VK_OEM_102 = 226; // _
  VK_PROCESSKEY = 229;
  VK_ATTN = 246;
  VK_CRSEL = 247;
  VK_EXSEL = 248;
  VK_EREOF = 249;
  VK_PLAY = 250;
  VK_ZOOM = 251;
  VK_NONAME = 252;
  VK_PA1 = 253;
  VK_OEM_CLEAR = 254;

const DCT_nil=0;

const DCT_sdFadeout=100;
const DCT_sdFadeoutStop=101;
const DCT_sdPlay=102;
const DCT_sdStop=103;
const DCT_sdPause=104;
const DCT_sdSeekTop=105;

const DCT_KeyCustomize=200;
const DCT_DisableDisplay=201;
const DCT_ShowTitle=202;
const DCT_ToggleCompactMode=203;
const DCT_Minimized=204;
const DCT_ShowHelp=205;
const DCT_ShowFileMenu=206;
const DCT_ShowDriveMenu=207;
const DCT_ShowVisualMenu=208;
const DCT_ShowPlayModeMenu=209;
const DCT_OpenFileOutputWindow=210;
const DCT_OpenCatalogCompressWindow=211;
const DCT_ShowMainMenu=212;
const DCT_ShowPCMOutMenu=213;
const DCT_ReloadSKI=214;
const DCT_SelectSKI=215;

const DCT_VolumeUP=250;
const DCT_VolumeDown=251;
const DCT_TempoUP=252;
const DCT_TempoDown=253;
const DCT_LoopInc=254;
const DCT_LoopDec=255;

const DCT_PressF1=300;
const DCT_PressF2=301;
const DCT_PressF3=302;
const DCT_PressF4=303;
const DCT_PressF5=304;
const DCT_PressF6=305;
const DCT_PressF7=306;
const DCT_PressF8=307;
const DCT_PressF9=308;
const DCT_PressF10=309;
const DCT_PressF11=310;
const DCT_PressF12=311;

const DCT_Execute=400;
const DCT_MoveDirUpper=401;
const DCT_MainClose=402;
const DCT_ToWave=403;
const DCT_ToWaveAndNext=404;
const DCT_ToWaveAndAll=405;
const DCT_NextPlayNext=406;
const DCT_NextPlayBack=407;
const DCT_NextPlayMode=408;
const DCT_FilePageUP=409;
const DCT_FilePageDown=410;
const DCT_FilePageTop=411;
const DCT_FilePageEnd=412;
const DCT_MoveDefaultPath=413;
const DCT_SetFileDialog=414;
const DCT_SetFileClipboard=415;

const DCT_MuteShowMenu=500;
const DCT_MuteToggleAll=501;
const DCT_MuteSetAll=502;
const DCT_MuteResetAll=503;
const DCT_MuteCh01=510;
const DCT_MuteCh02=511;
const DCT_MuteCh03=512;
const DCT_MuteCh04=513;
const DCT_MuteCh05=514;
const DCT_MuteCh06=515;
const DCT_MuteCh07=516;
const DCT_MuteCh08=517;
const DCT_MuteCh09=518;
const DCT_MuteCh10=519;
const DCT_MuteCh11=520;
const DCT_MuteCh12=521;
const DCT_MuteCh13=522;
const DCT_MuteCh14=523;
const DCT_MuteCh15=524;
const DCT_MuteCh16=525;

const DCT_CopyPlayFilename=600;
const DCT_CopyPlayFilenameTitle=601;
const DCT_CopyPlayTitle=602;
const DCT_CopyPlayURL=603;
const DCT_CopyPlayURLTitle=604;
const DCT_CopyPlayHTMLURL=605;
const DCT_CopyPlayHTMLURLTitle=606;
const DCT_CopyPlayHTMLTitle=607;

const DCT_CopyCursorFilename=610;
const DCT_CopyCursorFilenameTitle=611;
const DCT_CopyCursorTitle=612;
const DCT_CopyCursorURL=613;
const DCT_CopyCursorURLTitle=614;
const DCT_CopyCursorHTMLURL=615;
const DCT_CopyCursorHTMLURLTitle=616;
const DCT_CopyCursorHTMLTitle=617;

const DCT_SoundRateDialog=700;
const DCT_SoundRate22050Hz=701;
const DCT_SoundRate44100Hz=702;
const DCT_SoundRate48000Hz=703;
const DCT_SoundRate96000Hz=704;
const DCT_SoundRate192000Hz=705;

const DCT_SoundWADP_Enabled=707;
const DCT_SoundWADP_Disabled=708;
const DCT_SoundWADP_RegInit=709;

const DCT_SoundMXDRV_SelectMoonlight=710;
const DCT_SoundMXDRV_SelectGORRY=711;
const DCT_SoundMXDRV_Config=712;

const DCT_SoundOutNull=720;
const DCT_SoundOutNullSet=721;
const DCT_SoundOutWSS=722;
const DCT_SoundOutWSSSet=723;
const DCT_SoundOutDS=724;
const DCT_SoundOutDSSet=725;
const DCT_SoundOutASIO2=726;
const DCT_SoundOutASIO2Set=727;
const DCT_SoundOutWA=728;
const DCT_SoundOutWASet=729;
const DCT_SoundOutWAAbout=730;

const DCT_SoundSRC_Nearest=740;
const DCT_SoundSRC_Liner=741;
const DCT_SoundSRC_Spline=742;

const DCT_SetupMain=800;
const DCT_SetupDSPPlugin=803;
const DCT_SetupNetwork=804;
const DCT_SetupVisualEffect=805;
const DCT_SetupCompactShowFile=806;
const DCT_SetupCompactWithMain=807;

const DCT_mdxoInstall=900;
const DCT_mdxoUninstall=901;
const DCT_mdxoReference=902;

const DCT_SetVisMode_Keyboard=1000;
const DCT_SetVisMode_Sonar=1001;
const DCT_SetVisMode_MDXDis=1002;
const DCT_SetVisMode_Wire=1003;
const DCT_SetVisMode_Wave=1004;
const DCT_SetVisMode_Fly=1005;
const DCT_SetVisMode_Pool=1006;
const DCT_SetVisMode_Box=1007;
const DCT_SetVisMode_Rain=1008;

const DCT_SetVisMode_FillCopy=1050;
const DCT_SetVisMode_FillReduction=1051;
const DCT_SetVisMode_FillShade=1052;

const DCT_SetPlayMode_Single=1100;
const DCT_SetPlayMode_ALL=1101;
const DCT_SetPlayMode_ALLRepeat=1102;
const DCT_SetPlayMode_Random=1103;
const DCT_SetPlayMode_None=1104;

const DCT_EmulateTrayIcon_DoubleClick=1200;
const DCT_EmulateTrayIcon_LeftButtonClick=1201;
const DCT_EmulateTrayIcon_RightButtonClick=1202;

const DCT_Network_StartOnlineUpdate=1300;
const DCT_Network_ToggleAutoOnlineUpdate=1301;
const DCT_Network_SelectMirrorServer=1302;
const DCT_Network_OpenBBS=1303;
const DCT_Network_OpenSkinUploadBBS=1304;
const DCT_Network_OpenDataFindWindow=1305;
const DCT_Network_OpenRankingWindow=1306;
const DCT_Network_OpenVoteWindow=1307;

type
  TDefineCommand=record
    DCT:integer;
    Name,Info:string;
    VK:word;
    Shift,Ctrl,Alt:boolean;
  end;

type
  TDefine=record
    CommandCount:integer;
    Command:array of TDefineCommand;
  end;

procedure CopyDefine(var srcDefine,dstDefine:TDefine);
procedure DC_SetDefault(var Command:TDefineCommand;_DCT:integer);
function VKtoStr(VK:word):string;
function KeytoStr(_VK:word;_Shift,_Ctrl,_Alt:boolean):string;

implementation

procedure CopyDefine(var srcDefine,dstDefine:TDefine);
var
  cnt:integer;
begin
  with dstDefine do begin
    CommandCount:=srcDefine.CommandCount;
    SetLength(Command,CommandCount);
    for cnt:=0 to CommandCount-1 do begin
      Command[cnt]:=srcDefine.Command[cnt];
    end;
  end;
end;

procedure DC_SetDefault(var Command:TDefineCommand;_DCT:integer);
begin
  with Command do begin
    DCT:=_DCT;
    Name:='nil';
    Info:='`';
    VK:=0;
    Shift:=False;
    Ctrl:=False;
    Alt:=False;
    case DCT of
      DCT_nil: begin
      end;
      DCT_sdFadeout: begin
        Name:='sdFadeout';
        Info:='tF[hAEg';
        VK:=word('N');
        Shift:=True;
      end;
      DCT_sdFadeoutStop: begin
        Name:='sdFadeoutStop';
        Info:='tF[hAEgXgbv';
        VK:=word('V');
        Shift:=True;
      end;
      DCT_sdPlay: begin
        Name:='sdPlay';
        Info:='vC';
        VK:=0;
        Shift:=True;
      end;
      DCT_sdStop: begin
        Name:='sdStop';
        Info:='Xgbv';
        VK:=word('S');
        Shift:=True;
      end;
      DCT_sdPause: begin
        Name:='sdPause';
        Info:='|[Y';
        VK:=word('P');
        Shift:=True;
      end;
      DCT_sdSeekTop: begin
        Name:='sdSeekTop';
        Info:='擪ɖ߂';
        VK:=word('X');
        Shift:=True;
      end;

      DCT_KeyCustomize: begin
        Name:='KeyCustomize';
        Info:='L[JX^}CY';
        VK:=word('Q');
        Shift:=True;
      end;
      DCT_DisableDisplay: begin
        Name:='DisableDisplay';
        Info:='ʃGtFNg~';
        VK:=word('D');
        Shift:=True;
      end;
      DCT_ShowTitle: begin
        Name:='ShowTitle';
        Info:='^Cg\';
        VK:=word('T');
        Shift:=True;
      end;
      DCT_ToggleCompactMode: begin
        Name:='ToggleCompactMode';
        Info:='RpNg[hؑ';
        VK:=word('C');
        Shift:=True;
      end;
      DCT_Minimized: begin
        Name:='Minimized';
        Info:='ŏ';
        VK:=word('M');
        Shift:=True;
      end;
      DCT_ShowHelp: begin
        Name:='ShowHelp';
        Info:='ICwv';
        VK:=word('H');
        Shift:=True;
      end;
      DCT_ShowFileMenu: begin
        Name:='ShowFileMenu';
        Info:='t@Cj[J';
        VK:=0;
      end;
      DCT_ShowDriveMenu: begin
        Name:='ShowDriveMenu';
        Info:='hCuj[J';
        VK:=0;
      end;
      DCT_ShowVisualMenu: begin
        Name:='ShowVisualMenu';
        Info:='BWAj[J';
        VK:=0;
      end;
      DCT_ShowPlayModeMenu: begin
        Name:='ShowPlayModeMenu';
        Info:='vC[hj[J';
        VK:=0;
      end;
      DCT_OpenFileOutputWindow: begin
        Name:='OpenFileOutputWindow';
        Info:='t@Co̓EBhEJ';
        VK:=0;
      end;
      DCT_OpenCatalogCompressWindow: begin
        Name:='OpenCatalogCompressWindow';
        Info:='J^Ot@CœKEBhEJ';
        VK:=0;
      end;
      DCT_ShowMainMenu: begin;
        Name:='ShowMainMenu';
        Info:='Cj[J';
        VK:=0;
      end;
      DCT_ShowPCMOutMenu: begin;
        Name:='ShowPCMOutMenu';
        Info:='gݒ^o̓foCXj[J';
        VK:=0;
      end;
      DCT_ReloadSKI: begin;
        Name:='ReloadSKI';
        Info:='XLt@CēǍ';
        VK:=0;
      end;
      DCT_SelectSKI: begin;
        Name:='SelectSKI';
        Info:='XLt@CI';
        VK:=0;
      end;

      DCT_VolumeUP: begin
        Name:='VolumeUP';
        Info:='{[UP';
        VK:=VK_UP;
        Shift:=True;
      end;
      DCT_VolumeDown: begin
        Name:='VolumeDown';
        Info:='{[DOWN';
        VK:=VK_DOWN;
        Shift:=True;
      end;
      DCT_TempoUP: begin
        Name:='TempoUP';
        Info:='e|UP';
        VK:=VK_RIGHT;
        Shift:=True;
      end;
      DCT_TempoDown: begin
        Name:='TempoDown';
        Info:='e|DOWN';
        VK:=VK_LEFT;
        Shift:=True;
      end;
      DCT_LoopInc: begin
        Name:='LoopInc';
        Info:='[v񐔑';
        VK:=VK_OEM_4;
        Shift:=False;
      end;
      DCT_LoopDec: begin
        Name:='LoopDec';
        Info:='[v񐔌';
        VK:=VK_OEM_6;
        Shift:=False;
      end;

      DCT_PressF1: begin
        Name:='PressF1';
        Info:='F1L[(hCuj[)';
        VK:=VK_F1;
      end;
      DCT_PressF2: begin
        Name:='PressF2';
        Info:='F2L[(|[Y)';
        VK:=VK_F2;
      end;
      DCT_PressF3: begin
        Name:='PressF3';
        Info:='F3L[(Xgbv)';
        VK:=VK_F3;
      end;
      DCT_PressF4: begin
        Name:='PressF4';
        Info:='F4L[(t[hύX)';
        VK:=VK_F4;
      end;
      DCT_PressF5: begin
        Name:='PressF5';
        Info:='F5L[(gύX)';
        VK:=VK_F5;
      end;
      DCT_PressF6: begin
        Name:='PressF6';
        Info:='F6L[(ʃGtFNg~)';
        VK:=VK_F6;
      end;
      DCT_PressF7: begin
        Name:='PressF7';
        Info:='F7L[(ʃGtFNgύX)';
        VK:=VK_F7;
      end;
      DCT_PressF8: begin
        Name:='PressF8';
        Info:='F8L[(WAVEo)';
        VK:=VK_F8;
      end;
      DCT_PressF9: begin
        Name:='PressF9';
        Info:='F9L[(ZbgAbv)';
        VK:=VK_F9;
      end;
      DCT_PressF10: begin
        Name:='PressF10';
        Info:='F10L[(j[)';
        VK:=VK_F10;
      end;
      DCT_PressF11: begin
        Name:='PressF11';
        Info:='F11L[(lbg[Nj[)';
        VK:=VK_F11;
      end;
      DCT_PressF12: begin
        Name:='PressF12';
        Info:='F12L[(`)';
        VK:=VK_F12;
      end;

      DCT_Execute: begin
        Name:='Execute';
        Info:='J[\ʒu̍ڂs';
        VK:=VK_RETURN;
      end;
      DCT_MoveDirUpper: begin
        Name:='MoveDirUpper';
        Info:='fBNgオ';
        VK:=VK_BACK;
      end;
      DCT_MainClose: begin
        Name:='MainClose';
        Info:='I';
        VK:=VK_ESCAPE;
      end;
      DCT_ToWave: begin
        Name:='ToWave';
        Info:='WAVEo͂ɑ';
        VK:=VK_RETURN;
        Shift:=True;
      end;
      DCT_ToWaveAndNext: begin
        Name:='ToWaveAndNext';
        Info:='WAVEo͂ɑ莟ֈړ';
        VK:=VK_SPACE;
        Shift:=True;
      end;
      DCT_ToWaveAndAll: begin
        Name:='ToWaveAndAll';
        Info:='J[\ȉSĂWAVEo͂ɑ';
        VK:=VK_SPACE;
        Ctrl:=True;
      end;
      DCT_NextPlayNext: begin
        Name:='NextPlayNext';
        Info:='̋ȂĐ';
        VK:=VK_SPACE;
      end;
      DCT_NextPlayBack: begin
        Name:='NextPlayBack';
        Info:='ŐȂĐ';
        VK:=word('Z');
        Shift:=True;
      end;
      DCT_NextPlayMode: begin
        Name:='NextPlayMode';
        Info:='vC[hɏ]čĐ';
        VK:=word('B');
        Shift:=True;
      end;
      DCT_FilePageUP: begin
        Name:='FilePageUP';
        Info:='t@CXgy[Wړ';
        VK:=VK_PRIOR;
      end;
      DCT_FilePageDown: begin
        Name:='FilePageDown';
        Info:='t@CXgy[Wړ';
        VK:=VK_NEXT;
      end;
      DCT_FilePageTop: begin
        Name:='FilePageTop';
        Info:='t@CXg̈ԍŏɈړ';
        VK:=VK_HOME;
      end;
      DCT_FilePageEnd: begin
        Name:='FilePageEnd';
        Info:='t@CXg̈ԍŌɈړ';
        VK:=VK_END;
      end;
      DCT_MoveDefaultPath: begin
        Name:='MoveDefaultPath';
        Info:='WpXɈړ';
        VK:=VK_OEM_5;
      end;
      DCT_SetFileDialog: begin
        Name:='SetFileDialog';
        Info:='t@Cw肵čĐ/ړ';
        VK:=0;
      end;
      DCT_SetFileClipboard: begin
        Name:='SetFileClipboard';
        Info:='Nbv{[hĐ/ړ';
        VK:=0;
      end;

      DCT_MuteShowMenu: begin
        Name:='MuteShowMenu';
        Info:='~[gj[\';
        VK:=0;
      end;
      DCT_MuteToggleAll: begin
        Name:='MuteToggleAll';
        Info:='S`l~[g]';
        VK:=word('0');
        Shift:=False;
      end;
      DCT_MuteSetAll: begin
        Name:='MuteSetAll';
        Info:='S`l~[gL';
        VK:=word('0');
        Shift:=True;
      end;
      DCT_MuteResetAll: begin
        Name:='MuteResetAll';
        Info:='S`l~[g';
        VK:=word('0');
        Ctrl:=True;
      end;
      DCT_MuteCh01: begin
        Name:='MuteCh01';
        Info:='Ch.01 ~[g]';
        VK:=word('1');
        Shift:=False;
      end;
      DCT_MuteCh02: begin
        Name:='MuteCh02';
        Info:='Ch.02 ~[g]';
        VK:=word('2');
        Shift:=False;
      end;
      DCT_MuteCh03: begin
        Name:='MuteCh03';
        Info:='Ch.03 ~[g]';
        VK:=word('3');
        Shift:=False;
      end;
      DCT_MuteCh04: begin
        Name:='MuteCh04';
        Info:='Ch.04 ~[g]';
        VK:=word('4');
        Shift:=False;
      end;
      DCT_MuteCh05: begin
        Name:='MuteCh05';
        Info:='Ch.05 ~[g]';
        VK:=word('5');
        Shift:=False;
      end;
      DCT_MuteCh06: begin
        Name:='MuteCh06';
        Info:='Ch.06 ~[g]';
        VK:=word('6');
        Shift:=False;
      end;
      DCT_MuteCh07: begin
        Name:='MuteCh07';
        Info:='Ch.07 ~[g]';
        VK:=word('7');
        Shift:=False;
      end;
      DCT_MuteCh08: begin
        Name:='MuteCh08';
        Info:='Ch.08 ~[g]';
        VK:=word('8');
        Shift:=False;
      end;
      DCT_MuteCh09: begin
        Name:='MuteCh09';
        Info:='Ch.09 ~[g]';
        VK:=word('1');
        Shift:=True;
      end;
      DCT_MuteCh10: begin
        Name:='MuteCh10';
        Info:='Ch.10 ~[g]';
        VK:=word('2');
        Shift:=True;
      end;
      DCT_MuteCh11: begin
        Name:='MuteCh11';
        Info:='Ch.11 ~[g]';
        VK:=word('3');
        Shift:=True;
      end;
      DCT_MuteCh12: begin
        Name:='MuteCh12';
        Info:='Ch.12 ~[g]';
        VK:=word('4');
        Shift:=True;
      end;
      DCT_MuteCh13: begin
        Name:='MuteCh13';
        Info:='Ch.13 ~[g]';
        VK:=word('5');
        Shift:=True;
      end;
      DCT_MuteCh14: begin
        Name:='MuteCh14';
        Info:='Ch.14 ~[g]';
        VK:=word('6');
        Shift:=True;
      end;
      DCT_MuteCh15: begin
        Name:='MuteCh15';
        Info:='Ch.15 ~[g]';
        VK:=word('7');
        Shift:=True;
      end;
      DCT_MuteCh16: begin
        Name:='MuteCh16';
        Info:='Ch.16 ~[g]';
        VK:=word('8');
        Shift:=True;
      end;

      DCT_CopyPlayFilename: begin
        Name:='CopyPlayFilename';
        Info:='Nbv{[hɍĐ̃t@CRs[';
      end;
      DCT_CopyPlayFilenameTitle: begin
        Name:='CopyPlayFilenameTitle';
        Info:='Nbv{[hɍĐ̃t@C{^CgRs[';
      end;
      DCT_CopyPlayTitle: begin
        Name:='CopyPlayTitle';
        Info:='Nbv{[hɍĐ̃^CgRs[';
      end;
      DCT_CopyPlayURL: begin
        Name:='CopyPlayURL';
        Info:='Nbv{[hɍĐURLRs[';
      end;
      DCT_CopyPlayURLTitle: begin
        Name:='CopyPlayURLTitle';
        Info:='Nbv{[hɍĐURL{^CgRs[';
      end;
      DCT_CopyPlayHTMLURL: begin
        Name:='CopyPlayHTMLURL';
        Info:='Nbv{[hHTML`ōĐURLRs[';
      end;
      DCT_CopyPlayHTMLURLTitle: begin
        Name:='CopyPlayHTMLURLTitle';
        Info:='Nbv{[hHTML`ōĐURL{^CgRs[';
      end;
      DCT_CopyPlayHTMLTitle: begin
        Name:='CopyPlayHTMLTitle';
        Info:='Nbv{[hHTML`ōĐ̃^CgRs[';
      end;

      DCT_CopyCursorFilename: begin
        Name:='CopyCursorFilename';
        Info:='Nbv{[hɃJ[\ʒũt@CRs[';
      end;
      DCT_CopyCursorFilenameTitle: begin
        Name:='CopyCursorFilenameTitle';
        Info:='Nbv{[hɃJ[\ʒũt@C{^CgRs[';
      end;
      DCT_CopyCursorTitle: begin
        Name:='CopyCursorTitle';
        Info:='Nbv{[hɃJ[\ʒũ^CgRs[';
      end;
      DCT_CopyCursorURL: begin
        Name:='CopyCursorURL';
        Info:='Nbv{[hɃJ[\ʒuURLRs[';
      end;
      DCT_CopyCursorURLTitle: begin
        Name:='CopyCursorURLTitle';
        Info:='Nbv{[hɃJ[\ʒuURL{^CgRs[';
      end;
      DCT_CopyCursorHTMLURL: begin
        Name:='CopyCursorHTMLURL';
        Info:='Nbv{[hHTML`ŃJ[\ʒuURLRs[';
      end;
      DCT_CopyCursorHTMLURLTitle: begin
        Name:='CopyCursorHTMLURLTitle';
        Info:='Nbv{[hHTML`ŃJ[\ʒuURL{^CgRs[';
      end;
      DCT_CopyCursorHTMLTitle: begin
        Name:='CopyCursorHTMLTitle';
        Info:='Nbv{[hHTML`ŃJ[\ʒũ^CgRs[';
      end;

      DCT_SoundRateDialog: begin
        Name:='SoundRateDialog';
        Info:='o͎g𐔒lݒ肷B';
      end;
      DCT_SoundRate22050Hz: begin
        Name:='SoundRate22050Hz';
        Info:='o͎g22050Hzɐݒ肷B';
      end;
      DCT_SoundRate44100Hz: begin
        Name:='SoundRate44100Hz';
        Info:='o͎g44100Hzɐݒ肷B';
      end;
      DCT_SoundRate48000Hz: begin
        Name:='SoundRate48000Hz';
        Info:='o͎g48000Hzɐݒ肷B';
      end;
      DCT_SoundRate96000Hz: begin
        Name:='SoundRate96000Hz';
        Info:='o͎g96000Hzɐݒ肷B';
      end;
      DCT_SoundRate192000Hz: begin
        Name:='SoundRate192000Hz';
        Info:='o͎g192000Hzɐݒ肷B';
      end;

      DCT_SoundWADP_Enabled: begin
        Name:='SoundWADP_Enabled';
        Info:='EnhancervOCLɂB';
      end;
      DCT_SoundWADP_Disabled: begin
        Name:='SoundWADP_Disabled';
        Info:='EnhancervOC𖳌ɂB';
      end;
      DCT_SoundWADP_RegInit: begin
        Name:='SoundWADP_RegInit';
        Info:='EnhancervOC̐ݒB';
      end;

      DCT_SoundMXDRV_SelectMoonlight: begin
        Name:='SoundMXDRV_SelectMoonlight';
        Info:='MXDRVm.dll MXDRVhCogB';
      end;
      DCT_SoundMXDRV_SelectGORRY: begin
        Name:='SoundMXDRV_SelectGORRY';
        Info:='MXDRVg.dll GORRYlMXDRVhCogB';
      end;
      DCT_SoundMXDRV_Config: begin
        Name:='SoundMXDRV_Config';
        Info:='MXDRVݒEBhEJ';
      end;

      DCT_SoundOutNull: begin
        Name:='SoundOutNull';
        Info:='o̓foCX𖳏o͂Ɋ蓖ĂB';
      end;
      DCT_SoundOutNullSet: begin
        Name:='SoundOutNullSet';
        Info:='o̓foCXo͂ݒ肷B';
      end;
      DCT_SoundOutWSS: begin
        Name:='SoundOutWSS';
        Info:='o̓foCXWindowsSoundɊ蓖ĂB';
      end;
      DCT_SoundOutWSSSet: begin
        Name:='SoundOutWSSSet';
        Info:='o̓foCXWindowsSoundݒ肷B';
      end;
      DCT_SoundOutDS: begin
        Name:='SoundOutDS';
        Info:='o̓foCXDirect-SoundɊ蓖ĂB';
      end;
      DCT_SoundOutDSSet: begin
        Name:='SoundOutDSSet';
        Info:='o̓foCXDirect-Soundݒ肷B';
      end;
      DCT_SoundOutASIO2: begin
        Name:='SoundOutASIO2';
        Info:='o̓foCXASIO2Ɋ蓖ĂB';
      end;
      DCT_SoundOutASIO2Set: begin
        Name:='SoundOutASIO2Set';
        Info:='o̓foCXASIO2ݒ肷B';
      end;
      DCT_SoundOutWA: begin
        Name:='SoundOutWA';
        Info:='o̓foCXWinAMPOutputPluginɊ蓖ĂB';
      end;
      DCT_SoundOutWASet: begin
        Name:='SoundOutWASet';
        Info:='o̓foCXWinAMPOutputPluginݒ肷B';
      end;
      DCT_SoundOutWAAbout: begin
        Name:='SoundOutWAAbout';
        Info:='o̓foCXWinAMPOutputPlugin\B';
      end;

      DCT_SoundSRC_Nearest: begin
        Name:='SoundSRC_Nearest';
        Info:='gϊASYŋߖT⊮ɂB';
      end;
      DCT_SoundSRC_Liner: begin
        Name:='SoundSRC_Liner';
        Info:='gϊASY`⊮ɂB';
      end;
      DCT_SoundSRC_Spline: begin
        Name:='SoundSRC_Spline';
        Info:='gϊASYXvC⊮ɂB';
      end;

      DCT_SetupMain: begin
        Name:='SetupMain';
        Info:='Setup->SʃZbgAbv';
      end;
      DCT_SetupDSPPlugin: begin
        Name:='SetupDSPPlugin';
        Info:='Setup->GnT[vOCݒ';
      end;
      DCT_SetupNetwork: begin
        Name:='SetupNetwork';
        Info:='Setup->lbg[Nݒ';
      end;
      DCT_SetupVisualEffect: begin
        Name:='SetupVisualEffect';
        Info:='Setup->BWAGtFNgݒ';
      end;
      DCT_SetupCompactShowFile: begin
        Name:='SetupCompactShowFile';
        Info:='SetupCompact->t@CXg\';
      end;
      DCT_SetupCompactWithMain: begin
        Name:='SetupCompactWithMain';
        Info:='SetupCompact->CEBhEɋߕtƋz';
      end;

      DCT_mdxoInstall: begin
        Name:='mdxoInstall';
        Info:='mdxovgR->CXg[ėLɂ';
      end;
      DCT_mdxoUninstall: begin
        Name:='mdxoUninstall';
        Info:='mdxovgR->ACXg[Ėɂ';
      end;
      DCT_mdxoReference: begin
        Name:='mdxoReference';
        Info:='mdxovgR->y[WJ';
      end;

      DCT_SetVisMode_Keyboard: begin
        Name:='SetVisMode_Keyboard';
        Info:='BWA[h->L[{[h';
      end;
      DCT_SetVisMode_Sonar: begin
        Name:='SetVisMode_Sonar';
        Info:='BWA[h->\i[';
      end;
      DCT_SetVisMode_MDXDis: begin
        Name:='SetVisMode_MDXDis';
        Info:='BWA[h->MDXDis';
      end;
      DCT_SetVisMode_Wire: begin
        Name:='SetVisMode_Wire';
        Info:='BWA[h->C[';
      end;
      DCT_SetVisMode_Wave: begin
        Name:='SetVisMode_Wave';
        Info:='BWA[h->EF[u';
      end;
      DCT_SetVisMode_Fly: begin
        Name:='SetVisMode_Fly';
        Info:='BWA[h->tC';
      end;
      DCT_SetVisMode_Pool: begin
        Name:='SetVisMode_Pool';
        Info:='BWA[h->v[';
      end;
      DCT_SetVisMode_Box: begin
        Name:='SetVisMode_Box';
        Info:='BWA[h->{bNX';
      end;
      DCT_SetVisMode_Rain: begin
        Name:='SetVisMode_Rain';
        Info:='BWA[h->C';
      end;

      DCT_SetVisMode_FillCopy: begin
        Name:='SetVisMode_FillCopy';
        Info:='Direct-3DtB[h->y[WRs[';
      end;
      DCT_SetVisMode_FillReduction: begin
        Name:='SetVisMode_FillReduction';
        Info:='Direct-3DtB[h->At@u[';
      end;
      DCT_SetVisMode_FillShade: begin
        Name:='SetVisMode_FillShade';
        Info:='Direct-3DtB[h->VF[hu[';
      end;

      DCT_SetPlayMode_Single: begin
        Name:='SetPlayMode_Single';
        Info:='vC[h->Pȃs[g';
      end;
      DCT_SetPlayMode_ALL: begin
        Name:='SetPlayMode_ALL';
        Info:='vC[h->S';
      end;
      DCT_SetPlayMode_ALLRepeat: begin
        Name:='SetPlayMode_ALLRepeat';
        Info:='vC[h->Sȃs[g';
      end;
      DCT_SetPlayMode_Random: begin
        Name:='SetPlayMode_Random';
        Info:='vC[h->_';
      end;
      DCT_SetPlayMode_None: begin
        Name:='SetPlayMode_None';
        Info:='vC[h->s[gȂ';
      end;

      DCT_EmulateTrayIcon_DoubleClick: begin
        Name:='EmulateTrayIcon_DoubleClick';
        Info:='gCACR_uNbN';
      end;
      DCT_EmulateTrayIcon_LeftButtonClick: begin
        Name:='EmulateTrayIcon_LeftButtonClick';
        Info:='gCACRNbN';
      end;
      DCT_EmulateTrayIcon_RightButtonClick: begin
        Name:='EmulateTrayIcon_RightButtonClick';
        Info:='gCACRENbN';
      end;

      DCT_Network_StartOnlineUpdate: begin
        Name:='Network_StartOnlineUpdate';
        Info:='Network->ICAbvf[gN';
      end;
      DCT_Network_ToggleAutoOnlineUpdate: begin
        Name:='Network_ToggleAutoOnlineUpdate';
        Info:='Network->ICAbvf[g̎XVʒmON/OFF';
      end;
      DCT_Network_SelectMirrorServer: begin
        Name:='Network_SelectMirrorServer';
        Info:='Network->~[T[oI';
      end;
      DCT_Network_OpenBBS: begin
        Name:='Network_OpenBBS';
        Info:='Network->fJ';
      end;
      DCT_Network_OpenSkinUploadBBS: begin
        Name:='Network_OpenSkinUploadBBS';
        Info:='Network->XLAbv[hfJ';
      end;
      DCT_Network_OpenDataFindWindow: begin
        Name:='Network_OpenDataFindWindow';
        Info:='Network->f[^EBhEJ';
      end;
      DCT_Network_OpenRankingWindow: begin
        Name:='Network_OpenRankingWindow';
        Info:='Network->LOEBhEJ';
      end;
      DCT_Network_OpenVoteWindow: begin
        Name:='Network_OpenVoteWindow';
        Info:='Network->[EBhEJ';
      end;
    end;
  end;
end;

function VKtoStr(VK:word):string;
begin
  case VK of
    VK_NONE:Result:='NoAssign';
    VK_CANCEL: Result:='CANCEL';
    VK_BACK: Result:='BACK';
    VK_TAB: Result:='TAB';
    VK_CLEAR: Result:='CLEAR';
    VK_RETURN: Result:='RETURN';
    VK_SHIFT: Result:='SHIFT';
    VK_CONTROL: Result:='CONTROL';
    VK_MENU: Result:='MENU';
    VK_PAUSE: Result:='PAUSE';
    VK_CAPITAL: Result:='CAPITAL';
    VK_ESCAPE: Result:='ESCAPE';
    VK_SPACE: Result:='SPACE';
    VK_PRIOR: Result:='PRIOR';
    VK_NEXT: Result:='NEXT';
    VK_END: Result:='END';
    VK_HOME: Result:='HOME';
    VK_LEFT: Result:='LEFT';
    VK_UP: Result:='UP';
    VK_RIGHT: Result:='RIGHT';
    VK_DOWN: Result:='DOWN';
    VK_SELECT: Result:='SELECT';
    VK_PRINT: Result:='PRINT';
    VK_EXECUTE: Result:='EXECUTE';
    VK_SNAPSHOT: Result:='SNAPSHOT';
    VK_INSERT: Result:='INSERT';
    VK_DELETE: Result:='DELETE';
    VK_HELP: Result:='HELP';
    VK_LWIN: Result:='LWIN';
    VK_RWIN: Result:='RWIN';
    VK_APPS: Result:='APPS';
    VK_NUMPAD0: Result:='NUMPAD0';
    VK_NUMPAD1: Result:='NUMPAD1';
    VK_NUMPAD2: Result:='NUMPAD2';
    VK_NUMPAD3: Result:='NUMPAD3';
    VK_NUMPAD4: Result:='NUMPAD4';
    VK_NUMPAD5: Result:='NUMPAD5';
    VK_NUMPAD6: Result:='NUMPAD6';
    VK_NUMPAD7: Result:='NUMPAD7';
    VK_NUMPAD8: Result:='NUMPAD8';
    VK_NUMPAD9: Result:='NUMPAD9';
    VK_MULTIPLY: Result:='MULTIPLY';
    VK_ADD: Result:='ADD';
    VK_SEPARATOR: Result:='SEPARATOR';
    VK_SUBTRACT: Result:='SUBTRACT';
    VK_DECIMAL: Result:='DECIMAL';
    VK_DIVIDE: Result:='DIVIDE';
    VK_F1: Result:='F1';
    VK_F2: Result:='F2';
    VK_F3: Result:='F3';
    VK_F4: Result:='F4';
    VK_F5: Result:='F5';
    VK_F6: Result:='F6';
    VK_F7: Result:='F7';
    VK_F8: Result:='F8';
    VK_F9: Result:='F9';
    VK_F10: Result:='F10';
    VK_F11: Result:='F11';
    VK_F12: Result:='F12';
    VK_F13: Result:='F13';
    VK_F14: Result:='F14';
    VK_F15: Result:='F15';
    VK_F16: Result:='F16';
    VK_F17: Result:='F17';
    VK_F18: Result:='F18';
    VK_F19: Result:='F19';
    VK_F20: Result:='F20';
    VK_F21: Result:='F21';
    VK_F22: Result:='F22';
    VK_F23: Result:='F23';
    VK_F24: Result:='F24';
    VK_NUMLOCK: Result:='NUMLOCK';
    VK_SCROLL: Result:='SCROLL';
    VK_OEM_4: Result:='OEM_4-[';
    VK_OEM_5: Result:='OEM_5-\';
    VK_OEM_6: Result:='OEM_6-]';
    VK_OEM_7: Result:='OEM_7-^';
    VK_OEM_8: Result:='OEM_8-_';
    VK_OEM_9: Result:='OEM_9';
    VK_OEM_AX: Result:='OEM_AX';
    VK_OEM_102: Result:='OEM_102-_';
    VK_PROCESSKEY: Result:='PROCESSKEY';
    VK_ATTN: Result:='ATTN';
    VK_CRSEL: Result:='CRSEL';
    VK_EXSEL: Result:='EXSEL';
    VK_EREOF: Result:='EREOF';
    VK_PLAY: Result:='PLAY';
    VK_ZOOM: Result:='ZOOM';
    VK_NONAME: Result:='NONAME';
    VK_PA1: Result:='PA1';
    VK_OEM_CLEAR: Result:='OEM_CLEAR';
    else begin
      if ((word('0')<=VK) and (VK<=word('9'))) or ((word('A')<=VK) and (VK<=word('Z'))) then begin
        Result:=''''+char(VK)+'''';
        end else begin
        Result:='';
      end;
    end;
  end;
end;

function KeytoStr(_VK:word;_Shift,_Ctrl,_Alt:boolean):string;
begin
  Result:='';

  if _Shift=True then Result:=Result+'Shift+';
  if _Ctrl=True then Result:=Result+'Ctrl+';
  if _Alt=True then Result:=Result+'Alt+';
  Result:=Result+VKtoStr(_VK);
end;

end.
