unit _MXDRVm_Moonlight;

interface

uses
  Windows,SysUtils,Types;

var
  HMXDRVm:HMODULE;
  MXDRVm_GetVersion:function:integer;stdcall;
  MXDRVm_Init:function(PCMRate:integer;UseRomeo:boolean;DSoundSafeTime:integer):boolean;stdcall;
  MXDRVm_OPMEmuStopDisable:procedure;stdcall;
  MXDRVm_FreeMemory:procedure;stdcall;
  MXDRVm_GetPCM:function(buf:PByteArray;len:LongInt):LongInt;stdcall;
  MXDRVm_MDXLoad:function(MDXFilename:PChar):boolean;stdcall;
  MXDRVm_PDXLoad:function(PDXFilename:PChar):boolean;stdcall;
  MXDRVm_MDXReset:procedure;stdcall;
  MXDRVm_MDXStop:procedure;stdcall;
  MXDRVm_StartFadeout:procedure;stdcall;
  MXDRVm_MMLSeek:procedure(SeekClock:integer);stdcall;
  MXDRVm_SetPlus17Mode:procedure(m:boolean);stdcall;
  MXDRVm_SetMarcuryVolume:procedure(vol:integer);stdcall;
  MXDRVm_SetTransTempo:procedure(_TransTempo:integer);stdcall;
  MXDRVm_SetMute:procedure(Ch:byte;MuteFlag:boolean);stdcall;
  MXDRVm_GetInfomationMessage:procedure(msg:PChar);stdcall;
  MXDRVm_ClearInfomationMessage:procedure;stdcall;
  MXDRVm_GetParamStr:procedure(Ch:byte;Line:integer;msg:PChar);stdcall;
  MXDRVm_GetRealVolume:function(ch:integer):byte;stdcall;
  MXDRVm_GetEndFlag:function:boolean;stdcall;
  MXDRVm_GetTotalClock:function:integer;stdcall;
  MXDRVm_GetPlayTimems:function:double;stdcall;
  MXDRVm_GetMesureClock:function:integer;stdcall;
  MXDRVm_GetTempo:function:byte;stdcall;
  MXDRVm_GetLoopCount:function:integer;stdcall;
  MXDRVm_GetVoice:function(ch:integer):integer;stdcall;
  MXDRVm_GetPanpot:function(ch:integer):byte;stdcall;
  MXDRVm_GetKeycode:function(ch:integer):byte;stdcall;
  MXDRVm_GetNoteon:function(ch:integer):boolean;stdcall;
  MXDRVm_GetLastPitch:function(ch:integer):longint;stdcall;
  MXDRVm_SetTimerBEnabled:procedure(e:boolean);stdcall;
  MXDRVm_SetADPCMSRCMode:procedure(m:integer);stdcall;

function  MXDRVm_LoadDLL:boolean;
procedure MXDRVm_FreeDLL;

implementation

uses _SimpleDialog,_const;

function MXDRVm_LoadDLL:boolean;
begin
  Result:=False;

  HMXDRVm:=LoadLibrary('MXDRVm.dll');
  if HMXDRVm=0 then exit;

  MXDRVm_GetVersion:=GetProcAddress(HMXDRVm,'MXDRVm_GetVersion');

  if addr(MXDRVm_GetVersion)=nil then exit;

  if MXDRVm_GetVersion<>010 then begin
    ShowMessage('MXDRVm.DLL','MXDRVm.dll Ver'+format('%.2f',[MXDRVm_GetVersion/100])+'o܂B'+CRLF+'Ver0.10ȊO͖ΉłB');
    exit;
  end;

  MXDRVm_Init:=GetProcAddress(HMXDRVm,'MXDRVm_Init');
  MXDRVm_OPMEmuStopDisable:=GetProcAddress(HMXDRVm,'MXDRVm_OPMEmuStopDisable');
  MXDRVm_FreeMemory:=GetProcAddress(HMXDRVm,'MXDRVm_FreeMemory');
  MXDRVm_GetPCM:=GetProcAddress(HMXDRVm,'MXDRVm_GetPCM');
  MXDRVm_MDXLoad:=GetProcAddress(HMXDRVm,'MXDRVm_MDXLoad');
  MXDRVm_PDXLoad:=GetProcAddress(HMXDRVm,'MXDRVm_PDXLoad');
  MXDRVm_MDXReset:=GetProcAddress(HMXDRVm,'MXDRVm_MDXReset');
  MXDRVm_MDXStop:=GetProcAddress(HMXDRVm,'MXDRVm_MDXStop');
  MXDRVm_StartFadeout:=GetProcAddress(HMXDRVm,'MXDRVm_StartFadeout');
  MXDRVm_MMLSeek:=GetProcAddress(HMXDRVm,'MXDRVm_MMLSeek');
  MXDRVm_SetPlus17Mode:=GetProcAddress(HMXDRVm,'MXDRVm_SetPlus17Mode');
  MXDRVm_SetMarcuryVolume:=GetProcAddress(HMXDRVm,'MXDRVm_SetMarcuryVolume');
  MXDRVm_SetTransTempo:=GetProcAddress(HMXDRVm,'MXDRVm_SetTransTempo');
  MXDRVm_SetMute:=GetProcAddress(HMXDRVm,'MXDRVm_SetMute');
  MXDRVm_GetInfomationMessage:=GetProcAddress(HMXDRVm,'MXDRVm_GetInfomationMessage');
  MXDRVm_ClearInfomationMessage:=GetProcAddress(HMXDRVm,'MXDRVm_ClearInfomationMessage');
  MXDRVm_GetParamStr:=GetProcAddress(HMXDRVm,'MXDRVm_GetParamStr');
  MXDRVm_GetRealVolume:=GetProcAddress(HMXDRVm,'MXDRVm_GetRealVolume');
  MXDRVm_GetEndFlag:=GetProcAddress(HMXDRVm,'MXDRVm_GetEndFlag');
  MXDRVm_GetTotalClock:=GetProcAddress(HMXDRVm,'MXDRVm_GetTotalClock');
  MXDRVm_GetPlayTimems:=GetProcAddress(HMXDRVm,'MXDRVm_GetPlayTimems');
  MXDRVm_GetMesureClock:=GetProcAddress(HMXDRVm,'MXDRVm_GetMesureClock');
  MXDRVm_GetTempo:=GetProcAddress(HMXDRVm,'MXDRVm_GetTempo');
  MXDRVm_GetLoopCount:=GetProcAddress(HMXDRVm,'MXDRVm_GetLoopCount');
  MXDRVm_GetVoice:=GetProcAddress(HMXDRVm,'MXDRVm_GetVoice');
  MXDRVm_GetPanpot:=GetProcAddress(HMXDRVm,'MXDRVm_GetPanpot');
  MXDRVm_GetKeycode:=GetProcAddress(HMXDRVm,'MXDRVm_GetKeycode');
  MXDRVm_GetNoteon:=GetProcAddress(HMXDRVm,'MXDRVm_GetNoteon');
  MXDRVm_GetLastPitch:=GetProcAddress(HMXDRVm,'MXDRVm_GetLastPitch');
  MXDRVm_SetTimerBEnabled:=GetProcAddress(HMXDRVm,'MXDRVm_SetTimerBEnabled');
  MXDRVm_SetADPCMSRCMode:=GetProcAddress(HMXDRVm,'MXDRVm_SetADPCMSRCMode');

  Result:=True;
end;

procedure MXDRVm_FreeDLL;
begin
  if addr(HMXDRVm)=nil then exit;
  
  if addr(MXDRVm_FreeMemory)<>nil then MXDRVm_FreeMemory;
  FreeLibrary(HMXDRVm);
end;

end.



