unit _Network;

interface

uses
  Classes, ShellAPI, Windows, SysUtils,
  _SimpleDialog,_NetworkCatalog,_netconst;

type
  TNetwork = class
  private
    { Private 錾 }
    NetworkEnabled:boolean;
    StartDir:string;
  public
    { Public 錾 }
    CFG:TCFG;
    NetworkCatalog:TNetworkCatalog;
    MXDRVPDXFileList,FMPMDPCMFileList:TStringList;
    procedure StartOnlineUpdate(UpdateCheckOnly:boolean);
    procedure Startup(_StartDir:string);
    procedure FreeMemory;
    function GetNetworkEnabled:boolean;
    function NetworkEnable:boolean;
    function LoadCFG:boolean;
    function LoadCatalog:boolean;
    procedure LoadFiles(path:string;var TempList:TStrings;cnvSJIS:boolean);
    procedure LoadPCMFileList;
    function MXDRVPlay(const DriverMode:integer):boolean;
    function FMPPlay:boolean;
    function PMDPlay:boolean;
    function SPCPlay:boolean;
    function GetHTTPDataFile(_url,_WriteFilename,msg:string):boolean;
//    function GetHTTPDataFileZip(_url,_WriteFilename,msg:string):boolean;
    function GetHTTPDataFileSZip(_url,_WriteFilename,msg:string):boolean;
    function GetNetworkPDXFilename(PDXFilename:string):string;
    function GetNetworkPCMFilename(PCMFilename:string):string;
  end;

implementation

uses MainWin,
     _const,_MDXWinINI,_SndDrv_const,_SndDrv,_MDXWin_const,_m_Tools,_SZip_Tools,_filebuf;

procedure TNetwork.Startup(_StartDir:string);
begin
  StartDir:=_StartDir;
  NetworkEnabled:=False;
  NetworkCatalog:=TNetworkCatalog.Create;
  MXDRVPDXFileList:=TStringList.Create;
  FMPMDPCMFileList:=TStringList.Create;
end;

procedure TNetwork.FreeMemory;
begin
  NetworkEnabled:=False;
  NetworkCatalog.Free;
  MXDRVPDXFileList.Free;
  FMPMDPCMFileList.Free;
end;

function TNetwork.GetNetworkEnabled:boolean;
begin
  Result:=NetworkEnabled;
end;

function TNetwork.NetworkEnable:boolean;
begin
  if NetworkEnabled=True then begin
    result:=True;
    exit;
  end;

  if LoadCFG=False then begin
    ShowMessage('MDXOnline','lbg[N{ݒt@C̃_E[hɎs܂B');
    result:=False;
    exit;
  end;

  if LoadCatalog=False then begin
    ShowMessage('MDXOnline','lbg[NJ^Ot@C̃_E[hɎs܂B');
    result:=False;
    exit;
  end;

  if MainINI.MDXOnlineAutoUpdate=True then StartOnlineUpdate(True);

  NetworkEnabled:=True;
  result:=True;
end;

procedure TNetwork.StartOnlineUpdate(UpdateCheckOnly:boolean);
var
  ExeFilename,InstansFilename:string;
begin
  ExeFilename:=StartDir+'OnlineUpdate.exe';
  InstansFilename:=StartDir+'OnlineUpdate_Instans.exe';
  if FileExists(ExeFilename)=True then begin
    DeleteFile(InstansFilename);
    if FileExists(InstansFilename)=True then begin
      if UpdateCheckOnly=False then begin
        ShowMessage('MDXOnline','ICAbvf[g͊ɋNĂ܂B');
      end;
      end else begin
      CopyFile(pchar(ExeFilename),pchar(InstansFilename),False);
      if UpdateCheckOnly=True then begin
        ShellExecute(0,'open',PChar(InstansFilename),pchar('-UpdateCheckOnly'), nil,SW_SHOW);
        end else begin
        ShellExecute(0,'open',PChar(InstansFilename),pchar('-Normal'), nil,SW_SHOW);
      end;
    end;
  end;
end;

function TNetwork.LoadCFG:boolean;
var
  NeedFile:TNeedFile;
begin

  with NeedFile do begin
    Port:=11080;
    Host:='moonlight.servehttp.com';
    if MainINI.MDXOnlineBufferSize<>0 then begin
      BufferSize:=MainINI.MDXOnlineBufferSize;
      end else begin
      BufferSize:=256;
    end;
    URL:='/mdxonline213.cfg';
    UserAgent:='MDXOnline';
    WriteFileSize:=0;
    WriteFileCheckSum:=0;
    WriteFilename:='';
  end;
  Main.HTTPSocket.SetNeedFile(NeedFile);
  Main.HTTPSocket.GetHTTPFile('lbg[Nt@C_E[hĂ܂c');

  if Main.HTTPSocket.NetworkResult=ResultSuccess then begin
    result:=True;
    LoadCFGfromBuffer(CFG,Main.HTTPSocket.Buffer,Main.HTTPSocket.BufferCount);
    DeleteFile(NeedFile.WriteFilename);
    with CFG do begin
      UserAgent:=UserAgent+'/'+MDXWinVersion;
{$ifdef mdxwin}
      if MainINI.UseRomeo=True then begin
        UserAgent:=UserAgent+'r';
        end else begin
        if MXDRVgINI.Enabled=True then begin
          UserAgent:=UserAgent+'g';
          end else begin
          UserAgent:=UserAgent+'m';
        end;
      end;
{$else}
      UserAgent:=UserAgent+'a'; // MDXAss
{$endif}
      CatalogURL:=BasePath;
      CatalogBasePath:=StartDir+NetCachePath;
      CatalogSeek:=CatalogBasePath+'catalog.seek';
      RankingURL:=BasePath+'ranking.dat';
      RankingPath:=StartDir+NetCachePath+'ranking.dat';
      PCMFileListURL:=BasePath+'pcmfilelist.dat';
      PCMFileListFilename:=StartDir+NetCachePath+'pcmfilelist.dat';
      MXDRV_PDXPath:=StartDir+NetCachePath+'MXDRV_PDX\';
      FMPPMD_PCMPath:=StartDir+NetCachePath+'FMPPMD_PCM\';
      MusicPath:=StartDir+NetCachePath+'Music\';
      VoteSendURL:=BasePath+'votesend.fnc';
      VoteDataURL:=BasePath+'vote.dat';
      VoteDataFilename:=StartDir+NetCachePath+'vote.dat';
    end;
    end else begin
    result:=False;
  end;
end;

function TNetwork.LoadCatalog:boolean;
var
  FileSize:dword;
  url,WriteFilename:string;
  netres:boolean;
begin
  NetworkCatalog.Init(CFG.CatalogBasePath);

  // ܂f[^t@C̃TCYCFGt@C̏Ɣr
  if FileExists(NetworkCatalog.GetDataFilename)=True then begin
    FileSize:=GetFileSize(NetworkCatalog.GetDataFilename);
    if CFG.CatalogDataSize<>FileSize then begin
      ShowMessage('MDXOnline','lbg[NLbVXV܂B'+CRLF+'_E[hɂ͐ꍇ܂B'+CRLF+'΂炭҂B');
      DeleteFile(NetworkCatalog.GetIndexFilename);
      DeleteFile(NetworkCatalog.GetDataFilename);
      DeleteFile(NetworkCatalog.GetCatalogFilePath+'catalog.seek');
      DeleteFile(CFG.PCMFileListFilename);
    end;
  end;

  // MDXWino[WAbvƂ́At@CꗗXg𖳏ō폜
  if FileExists(NetworkCatalog.GetCatalogFilePath+'catalog.seek')=True then begin
    FileSize:=GetFileSize(NetworkCatalog.GetCatalogFilePath+'catalog.seek');
    if (FileSize=0) or (FileSize=1) then DeleteFile(NetworkCatalog.GetCatalogFilePath+'catalog.seek');
  end;

  // SẴt@C(SEEK)Ă΃LbVǂݍ
  if (FileExists(NetworkCatalog.GetIndexFilename)=True) and
     (FileExists(NetworkCatalog.GetDataFilename)=True) and
     (FileExists(CFG.PCMFileListFilename)=True) then begin
    NetworkCatalog.LoadIndex;
    LoadPCMFileList;
    Result:=True;
    exit;
  end;

  // ÔߑS폜
  ForceDirectories(CFG.CatalogBasePath);
  DeleteFile(NetworkCatalog.GetIndexFilename);
  DeleteFile(NetworkCatalog.GetDataFilename);
  DeleteFile(NetworkCatalog.GetCatalogFilePath+'catalog.seek');
  DeleteFile(CFG.PCMFileListFilename);

  // _E[h
  url:=CFG.CatalogURL+'catalog.idx';
  WriteFilename:=NetworkCatalog.GetIndexFilename;
  netres:=GetHTTPDataFileSZip(url,WriteFilename,'lbg[NCfbNX_E[hĂ܂c');
  if netres=False then begin
    Result:=False;
    exit;
  end;

  url:=CFG.CatalogURL+'catalog.dat';
  WriteFilename:=NetworkCatalog.GetDataFilename;
  netres:=GetHTTPDataFileSZip(url,WriteFilename,'lbg[NJ^O_E[hĂ܂c');
  if netres=False then begin
    Result:=False;
    exit;
  end;

  url:=CFG.PCMFileListURL;
  WriteFilename:=CFG.PCMFileListFilename;
  netres:=GetHTTPDataFileSZip(url,WriteFilename,'lbg[NPCMt@CXg_E[hĂ܂c');
  if netres=False then begin
    Result:=False;
    exit;
  end;

  // _E[hꂽLbVǂݍ
  NetworkCatalog.LoadIndex;
  LoadPCMFileList;

  Result:=True;
end;

procedure TNetwork.LoadFiles(path:string;var TempList:TStrings;cnvSJIS:boolean);
begin
  if NetworkEnable=False then exit;

  if length(path)<=3 then begin
    NetworkCatalog.LoadData('\',TempList,cnvSJIS);
    end else begin
    TempList.Add('_ < Directory >  ..');
    NetworkCatalog.LoadData(copy(path,4,255)+'\',TempList,cnvSJIS);
    TempList.Add(TempList[0]);
  end;
end;

function TNetwork.MXDRVPlay(const DriverMode:integer):boolean;
var
  url:string;
  WriteFilename:string;
  netres:boolean;
  PDXFilename:string;
  SetPCMPath:string;
begin
  if (DriverMode<>DriverModeMXDRVm) and (DriverMode<>DriverModeMXDRVg) then begin
    Main.InfomationVisible('sK؂DriverModeG[');
    Result:=False;
    exit;
  end;

  url:=ConvPath2URL(CFG.BasePath,Main.gFileInfo.GetFullPath);
  WriteFilename:=Main.gFileInfo.GetNetworkDownloadPath;
  DeleteFile(WriteFilename);
  netres:=GetHTTPDataFileSZip(url,WriteFilename,'lbg[NMDXt@C_E[hĂ܂c');
  if netres=False then begin
    Main.InfomationVisible('MDX_E[hs');
    Result:=False;
    exit;
  end;

{$ifdef mdxwin}
  SetPCMPath:=CFG.MXDRV_PDXPath;
{$else}
  if Main.gFileInfo.GetNetworkToRealPath=True then begin
    SetPCMPath:=ExtractFilePath(Main.gFileInfo.GetNetworkDownloadPath);
    end else begin
    SetPCMPath:=CFG.MXDRV_PDXPath;
  end;
{$endif}

  PDXFilename:=thChangeFileExt(GetPDXFilename(WriteFilename),'');
  if copy(PDXFilename,1,1)='\' then PDXFilename:=copy(PDXFilename,2,255);
  if PDXFilename<>'' then PDXFilename:=GetNetworkPDXFilename(PDXFilename);
  if PDXFilename<>'' then begin
    url:=CFG.BasePath+CFG.MXDRV_PDXURL+PDXFilename;
    WriteFilename:=SetPCMPath+PDXFilename;
    if FileExists(WriteFilename)=False then begin
      netres:=GetHTTPDataFileSZip(url,WriteFilename,'lbg[NPDXt@C_E[hĂ܂c');
      if (netres=False) and (Main.HTTPSocket.NetworkResult<>Result404Error) then begin // 404Error͖
        Main.InfomationVisible('PDX_E[hs');
        Result:=False;
        exit;
      end;
    end;
  end;

{$ifdef mdxwin}
  case DriverMode of
    DriverModeMXDRVm: Result:=MXDRVm.MDXPlay;
    DriverModeMXDRVg: Result:=MXDRVg.MDXPlay;
    else Result:=False;
  end;
{$else}
  case DriverMode of
    DriverModeMXDRVm: Result:=Main.PrgAss.BootMXDRV(Main.gFileInfo);
    DriverModeMXDRVg: Result:=Main.PrgAss.BootMXDRV(Main.gFileInfo);
    else Result:=False;
  end;
{$endif}
end;

function TNetwork.FMPPlay:boolean;
var
  url:string;
  WriteFilename:string;
  netres:boolean;
  MusFilename,PVIFilename,PPZFilename:string;
  SetPCMPath:string;
begin
  url:=ConvPath2URL(CFG.BasePath,Main.gFileInfo.GetFullPath);
  WriteFilename:=Main.gFileInfo.GetNetworkDownloadPath;
  MusFilename:=WriteFilename;
  DeleteFile(WriteFilename);
  netres:=GetHTTPDataFileSZip(url,WriteFilename,'lbg[NFMPt@C_E[hĂ܂c');
  if netres=False then begin
    Main.InfomationVisible('FMP_E[hs');
    Result:=False;
    exit;
  end;

{$ifdef mdxwin}
  SetPCMPath:=CFG.FMPPMD_PCMPath;
{$else}
  if Main.gFileInfo.GetNetworkToRealPath=True then begin
    SetPCMPath:=ExtractFilePath(Main.gFileInfo.GetNetworkDownloadPath);
    end else begin
    SetPCMPath:=CFG.FMPPMD_PCMPath;
  end;
{$endif}

  PVIFilename:=FMP.GetPVIFilename(MusFilename);
  if PVIFilename<>'' then PVIFilename:=GetNetworkPCMFilename(PVIFilename);
  if PVIFilename<>'' then begin
    url:=CFG.BasePath+CFG.FMPPMD_PCMURL+PVIFilename;
    WriteFilename:=SetPCMPath+PVIFilename;
    if FileExists(WriteFilename)=False then begin
      netres:=GetHTTPDataFileSZip(url,WriteFilename,'lbg[NPVIt@C_E[hĂ܂c');
      if (netres=False) and (Main.HTTPSocket.NetworkResult<>Result404Error) then begin // 404Error͖
        Main.InfomationVisible('PVI_E[hs');
        Result:=False;
        exit;
      end;
    end;
  end;

  PPZFilename:=FMP.GetPPZFilename(MusFilename);
  if PPZFilename<>'' then PPZFilename:=GetNetworkPCMFilename(PPZFilename);
  if PPZFilename<>'' then begin
    url:=CFG.BasePath+CFG.FMPPMD_PCMURL+PPZFilename;
    WriteFilename:=SetPCMPath+PPZFilename;
    if FileExists(WriteFilename)=False then begin
      netres:=GetHTTPDataFileSZip(url,WriteFilename,'lbg[NPPZt@C_E[hĂ܂c');
      if (netres=False) and (Main.HTTPSocket.NetworkResult<>Result404Error) then begin // 404Error͖
        Main.InfomationVisible('PPZ_E[hs');
        Result:=False;
        exit;
      end;
    end;
  end;

{$ifdef mdxwin}
  Result:=FMP.FMPPlay;
{$else}
  Result:=Main.PrgAss.BootFMP(Main.gFileInfo);
{$endif}
end;

function TNetwork.PMDPlay:boolean;
var
  url:string;
  WriteFilename:string;
  netres:boolean;
  MusFilename,PPCFilename,PPSFilename,PPZFilename:string;
  SetPCMPath:string;
begin
  url:=ConvPath2URL(CFG.BasePath,Main.gFileInfo.GetFullPath);
  WriteFilename:=Main.gFileInfo.GetNetworkDownloadPath;
  MusFilename:=WriteFilename;
  DeleteFile(WriteFilename);
  netres:=GetHTTPDataFileSZip(url,WriteFilename,'lbg[NPMDt@C_E[hĂ܂c');
  if netres=False then begin
    Main.InfomationVisible('PMD_E[hs');
    Result:=False;
    exit;
  end;

{$ifdef mdxwin}
  SetPCMPath:=CFG.FMPPMD_PCMPath;
{$else}
  if Main.gFileInfo.GetNetworkToRealPath=True then begin
    SetPCMPath:=ExtractFilePath(Main.gFileInfo.GetNetworkDownloadPath);
    end else begin
    SetPCMPath:=CFG.FMPPMD_PCMPath;
  end;
{$endif}

  PPCFilename:=PMD.GetPPCFilename(MusFilename);
  if PPCFilename<>'' then PPCFilename:=GetNetworkPCMFilename(PPCFilename);
  if PPCFilename<>'' then begin
    url:=CFG.BasePath+CFG.FMPPMD_PCMURL+PPCFilename;
    WriteFilename:=SetPCMPath+PPCFilename;
    if FileExists(WriteFilename)=False then begin
      netres:=GetHTTPDataFileSZip(url,WriteFilename,'lbg[NPPCt@C_E[hĂ܂c');
      if (netres=False) and (Main.HTTPSocket.NetworkResult<>Result404Error) then begin // 404Error͖
        Main.InfomationVisible('PPC_E[hs');
        Result:=False;
        exit;
      end;
    end;
  end;

  PPSFilename:=PMD.GetPPSFilename(MusFilename);
  if PPSFilename<>'' then PPSFilename:=GetNetworkPCMFilename(PPSFilename);
  if PPSFilename<>'' then begin
    url:=CFG.BasePath+CFG.FMPPMD_PCMURL+PPSFilename;
    WriteFilename:=SetPCMPath+PPSFilename;
    if FileExists(WriteFilename)=False then begin
      netres:=GetHTTPDataFileSZip(url,WriteFilename,'lbg[NPPSt@C_E[hĂ܂c');
      if (netres=False) and (Main.HTTPSocket.NetworkResult<>Result404Error) then begin // 404Error͖
        Main.InfomationVisible('PPS_E[hs');
        Result:=False;
        exit;
      end;
    end;
  end;

  PPZFilename:=PMD.GetPPZFilename(MusFilename);
  if PPZFilename<>'' then PPZFilename:=GetNetworkPCMFilename(PPZFilename);
  if PPZFilename<>'' then begin
    url:=CFG.BasePath+CFG.FMPPMD_PCMURL+PPZFilename;
    WriteFilename:=SetPCMPath+PPZFilename;
    if FileExists(WriteFilename)=False then begin
      netres:=GetHTTPDataFileSZip(url,WriteFilename,'lbg[NPPZt@C_E[hĂ܂c');
      if (netres=False) and (Main.HTTPSocket.NetworkResult<>Result404Error) then begin // 404Error͖
        Main.InfomationVisible('PPZ_E[hs');
        Result:=False;
        exit;
      end;
    end;
  end;

{$ifdef mdxwin}
  Result:=PMD.PMDPlay;
{$else}
  Result:=Main.PrgAss.BootPMD(Main.gFileInfo);
{$endif}
end;

function TNetwork.SPCPlay:boolean;
var
  url:string;
  WriteFilename:string;
  netres:boolean;
begin
  url:=ConvPath2URL(CFG.BasePath,Main.gFileInfo.GetFullPath);
  WriteFilename:=Main.gFileInfo.GetNetworkDownloadPath;
  DeleteFile(WriteFilename);
  netres:=GetHTTPDataFileSZip(url,WriteFilename,'lbg[NSPCt@C_E[hĂ܂c');
  if netres=False then begin
    Main.InfomationVisible('SPC_E[hs');
    Result:=False;
    exit;
  end;

{$ifdef mdxwin}
  Result:=SPC.SPCPlay;
{$else}
  Result:=Main.PrgAss.BootSPC(Main.gFileInfo);
{$endif}
end;

function TNetwork.GetHTTPDataFile(_url,_WriteFilename,msg:string):boolean;
var
  NeedFile:TNeedFile;
begin
  with NeedFile do begin
    Port:=CFG.Port;
    Host:=CFG.Host;
    URL:=_url;
    UserAgent:=CFG.UserAgent;
    WriteFileSize:=0;
    WriteFileCheckSum:=0;
    WriteFilename:=_WriteFilename;
  end;
  Main.HTTPSocket.SetNeedFile(NeedFile);
  Main.HTTPSocket.GetHTTPFile(msg);

  if Main.HTTPSocket.NetworkResult=ResultSuccess then begin
    result:=True;
    end else begin
    result:=False;
  end;
end;

{
function TNetwork.GetHTTPDataFileZip(_url,_WriteFilename,msg:string):boolean;
var
  zipurl,zipFilename:string;
  ArcFile:TArchiveFile;
  cond:integer;
begin
  zipurl:=_url+'.zip';
  zipFilename:=_WriteFilename+'.zip';
  with Main.HTTPSocket.NeedFile do begin
    Port:=SocketPortNo;
    Host:=CFG.Host;
    URL:=zipurl;
    UserAgent:=CFG.UserAgent;
    WriteFileSize:=0;
    WriteFileCheckSum:=0;
    WriteFilename:=zipFilename;
  end;
  Main.HTTPSocket.GetHTTPFile(msg);

  if Main.HTTPSocket.NeedFile.NetworkResult<>ResultSuccess then begin
    result:=False;
    exit;
  end;

  // CRC`FbN
  ArcFile:=TArchiveFile.Create(nil);
  try
    ArcFile.FileName:=zipFilename;
    if (ArcFile.CheckArchive(CHECKARCHIVE_FULLCRC,0) and $7FFF)=0 then begin
      ShowMessage('_E[hA[JCuCRĈُ߃J^OWJł܂B');
      Result:=False;
      exit;
    end;
  finally
    ArcFile.Free;
  end;

  // ɂ̉
  ArcFile:=TArchiveFile.Create(nil);
  try
    ArcFile.FileName:=zipFilename;

    ArcFile.Options.x:=1; // fBNgWJ
    ArcFile.OutputSize:=0; // o̓obt@TCY

    ArcFile.Options.n:=1;
    ArcFile.OnProgress:=nil;

    cond:=ArcFile.UnpackFiles(0,nil,ExtractFilePath(zipFilename),[nil]);
    if cond<>0 then begin
      ShowMessage('𓀂Ɏs܂B󂫗eʂ̉\܂BResult:'+inttohex(cond,4));
      Result:=False;
      exit;
    end;
  finally
    ArcFile.Free;
  end;

  DeleteFile(zipFilename);
  Result:=True;
end;
}

function TNetwork.GetHTTPDataFileSZip(_url,_WriteFilename,msg:string):boolean;
var
  res:integer;
  NeedFile:TNeedFile;
begin
  with NeedFile do begin
    Port:=CFG.Port;
    Host:=CFG.Host;
    if MainINI.MDXOnlineBufferSize<>0 then begin
      BufferSize:=MainINI.MDXOnlineBufferSize;
      end else begin
      BufferSize:=256;
    end;
    URL:=_url+'.szip';
    UserAgent:=CFG.UserAgent;
    WriteFileSize:=0;
    WriteFileCheckSum:=0;
    WriteFilename:='';
  end;
  Main.HTTPSocket.SetNeedFile(NeedFile);
  Main.HTTPSocket.GetHTTPFile(msg);

  if Main.HTTPSocket.NetworkResult<>ResultSuccess then begin
    result:=False;
    exit;
  end;

  res:=SZipDecompress(Main.HTTPSocket.Buffer,Main.HTTPSocket.BufferCount,_WriteFilename);
  DeleteFile(NeedFile.WriteFilename);
  if res<>SZipSuccess then begin
    ShowMessage('MDXOnline','𓀂Ɏs܂BResult:'+inttostr(res));
    Result:=False;
    exit;
  end;

  Result:=True;
end;

procedure TNetwork.LoadPCMFileList;
var
  fname:string;
  rfb:TReadFileBuf;
  cnt,Count:integer;
begin
  MXDRVPDXFileList.Clear;
  FMPMDPCMFileList.Clear;

  fname:=CFG.PCMFileListFilename;
  if FileExists(fname)=False then exit;

  rfb:=TReadFileBuf.Create;
  rfb.Init(fname);
  rfb.LoadFile;
  Count:=rfb.GetWord;
  for cnt:=0 to Count-1 do begin
    case rfb.GetByte of
      0: MXDRVPDXFileList.Add(rfb.GetMString);
      1: FMPMDPCMFileList.Add(rfb.GetMString);
    end;
  end;
  rfb.Free;
end;

function TNetwork.GetNetworkPDXFilename(PDXFilename:string):string;
var
  cnt:integer;
  ext:string;
  fname,fnames,fnamef,fname8:string;
begin
  Result:='';

  ext:='.pdx';
  fname:=thChangeFileExt(AnsiLowerCase(PDXFilename),'');
  fnamef:=fname+ext;
  fname8:=copy(fname,1,8)+ext;

  with MXDRVPDXFileList do begin
    for cnt:=0 to Count-1 do begin
      fnames:=AnsiLowerCase(Strings[cnt]);
      if (fnames=fnamef) or (fnames=fname8) then begin
        Result:=Strings[cnt];
        exit;
      end;
    end;
  end;
end;

function TNetwork.GetNetworkPCMFilename(PCMFilename:string):string;
var
  cnt:integer;
  fnames,fnamef:string;
begin
  Result:='';

  fnamef:=AnsiLowerCase(PCMFilename);

  with FMPMDPCMFileList do begin
    for cnt:=0 to Count-1 do begin
      fnames:=AnsiLowerCase(Strings[cnt]);
      if fnames=fnamef then begin
        Result:=Strings[cnt];
        exit;
      end;
    end;
  end;
end;

end.
