unit _gFileInfo;

interface

uses
  Windows, SysUtils;

type
  TgFileInfoBody=record
    FullPath:string;
    FullTitle,FullTitleFMPPMD,CompactTitle:string;
    TitleLoaded:boolean;
    NetworkMode:boolean;
    DriverMode:integer;
    NetworkToRealPath:boolean;
  end;

type
  TgFileInfo = class
  private
    { Private 錾 }
    Body:TgFileInfoBody;
  public
    { Public 錾 }
    procedure Init;
    function SetFileInfo(_FullPath:string;_NetworkToRealPath:boolean):TgFileInfoBody;
    function LoadTitleFromFile:string;
    function LoadTitleFromCatalog:string;
    function GetDriverMode:integer;
    function GetFullPath:string;
    function GetPlayPath:string;
    function GetFullTitle:string;
    function GetFullTitleFMPPMD:string;
    function GetCompactTitle:string;
    function GetNetworkDownloadPath:string;
    function GetNetworkToRealPath:boolean;
    function isNetworkMode:boolean;
  end;

implementation

uses MainWin,
     _MainFileCtl,_MDXWinINI,_SimpleDialog, _SndDrv_const,_SndDrv, _m_Tools;

procedure TgFileInfo.Init;
begin
  SetFileInfo('',False);
end;

function TgFileInfo.SetFileInfo(_FullPath:string;_NetworkToRealPath:boolean):TgFileInfoBody;
var
  ext:string;
begin
  with Body do begin
    FullPath:=_FullPath;
    FullTitle:='';
    CompactTitle:='';
    TitleLoaded:=False;
    NetworkMode:=False;
    DriverMode:=DriverModeUnknown;
    NetworkToRealPath:=_NetworkToRealPath;
  end;

  if _FullPath='' then exit;

  if _FullPath[1]<>'\' then begin
    if _FullPath[2]<>':' then begin
      ShowMessage('MDXWin.exe',_FullPath+' cnt2 not :');
      exit;
    end;
    if _FullPath[3]<>'\' then begin
      ShowMessage('MDXWin.exe',_FullPath+' cnt3 not \');
      exit;
    end;
    if _FullPath[4]='\' then begin
      ShowMessage('MDXWin.exe',_FullPath+' cnt4 equal \');
      exit;
    end;
    if _FullPath[4]='/' then begin
      ShowMessage('MDXWin.exe',_FullPath+' cnt4 equal /');
      exit;
    end;
  end;

  with Body do begin
    if FullPath[1]='#' then begin
      NetworkMode:=True;
      end else begin
      NetworkMode:=False;
    end;
  end;

  ext:=lowercase(thExtractFileExt(Body.FullPath));

  if ext='.mdx' then begin // MXDRV
{$ifdef mdxwin}
    if MXDRVgINI.Enabled=False then begin
      Body.DriverMode:=DriverModeMXDRVm;
      end else begin
      Body.DriverMode:=DriverModeMXDRVg;
    end;
{$else}
    Body.DriverMode:=DriverModeMXDRVm;
{$endif}
  end;

  if (ext='.opi') or (ext='.ovi') or (ext='.ozi') then begin
    Body.DriverMode:=DriverModeFMP;
  end;

  if (ext='.m') or (ext='.m2') or (ext='.mz') then begin
    Body.DriverMode:=DriverModePMD;
  end;

  if (ext='.spc') or (ext='.sp0') or (ext='.sp1') or (ext='.sp2') or (ext='.sp3') or (ext='.sp4') or (ext='.sp5') or (ext='.sp6') or (ext='.sp7') or (ext='.sp8') or (ext='.sp9') then begin
    Body.DriverMode:=DriverModeSPC;
  end;
end;

function TgFileInfo.LoadTitleFromFile;
var
  Filename:string;
begin
  Body.TitleLoaded:=True;
  Body.FullTitle:='';
  Body.FullTitleFMPPMD:='';

  Filename:=GetPlayPath;
  if FileExists(Filename)=False then begin
    Body.FullTitle:='[file not found]';
    exit;
  end;

  with Body do begin
    case DriverMode of
      DriverModeMXDRVm: begin
        FullTitle:=GetMDXTitle(Filename);
      end;
      DriverModeMXDRVg: begin
        FullTitle:=GetMDXTitle(Filename);
      end;
      DriverModeFMP: begin
        if FMPLoadFlag=False then sdLoadDLL_FMP;
        if FMPLoadFlag=True then begin
          FullTitle:=FMP.GetTitle(Filename);
          FullTitleFMPPMD:=FMP.GetTitleInESC(Filename);
          end else begin
          FullTitle:='';
        end;
      end;
      DriverModePMD: begin
        if PMDLoadFlag=False then sdLoadDLL_PMD;
        if PMDLoadFlag=True then begin
          FullTitle:=PMD.GetTitle(Filename);
          FullTitleFMPPMD:=PMD.GetTitleInESC(Filename);
          end else begin
          FullTitle:='';
        end;
      end;
      DriverModeSPC: begin
        if SPCLoadFlag=False then sdLoadDLL_SPC;
        if SPCLoadFlag=True then begin
          FullTitle:=SPC.GetTitle(Filename);
          end else begin
          FullTitle:='';
        end;
      end;
      DriverModeUnknown: begin
        FullTitle:='';
      end;
    end;
  end;

  if Body.FullTitle='' then Body.FullTitle:='['+thExtractFilename(Body.FullPath)+']';
end;

function TgFileInfo.LoadTitleFromCatalog;
var
  path,filename:string;
begin
  Body.TitleLoaded:=True;
  Body.FullTitle:='';

  if isNetworkMode=True then begin
    path:=copy(thExtractFilePath(GetFullPath),4,255);
    filename:=thExtractFilename(GetFullPath);
    Body.FullTitle:=Main.Network.NetworkCatalog.GetTitle(path,filename,False);
    if Body.FullTitle='' then Body.FullTitle:='no title - '+filename;
    end else begin
    LoadTitleFromFile;
  end;
end;

function TgFileInfo.GetDriverMode:integer;
begin
  Result:=Body.DriverMode;
end;

function TgFileInfo.GetFullPath:string;
begin
  Result:=Body.FullPath;
end;

function TgFileInfo.GetFullTitle:string;
begin
  if Body.TitleLoaded=False then begin
    Result:='t@Cǂݍ܂Ă܂B\IG[܂B';
    end else begin
    Result:=Body.FullTitle;
  end;
end;

function TgFileInfo.GetFullTitleFMPPMD:string;
begin
  if Body.TitleLoaded=False then begin
    Result:='t@Cǂݍ܂Ă܂B\IG[܂B';
    end else begin
    Result:=Body.FullTitleFMPPMD;
  end;
end;

function TgFileInfo.isNetworkMode:boolean;
begin
  Result:=Body.NetworkMode;
end;

function TgFileInfo.GetCompactTitle:string;
begin
  if Body.TitleLoaded=False then begin
    Result:='t@Cǂݍ܂Ă܂B\IG[܂B';
    exit;
  end;

  with Body do begin
    if CompactTitle='' then begin
      CompactTitle:=strCnvAnk2to1byte(strGetCompact(strCnvX68kPlusSJIS(strClearESC(FullTitle))));
//      CompactTitle:=FullTitle;
      if CompactTitle='' then CompactTitle:='no title';
    end;
  end;

  Result:=Body.CompactTitle;
end;

function TgFileInfo.GetNetworkDownloadPath:string;
begin
  if Body.NetworkToRealPath=False then begin
    Result:=Main.Network.CFG.MusicPath+'networkdownload'+thExtractFileExt(Body.FullPath);
    end else begin
    Result:=Main.Network.CFG.MusicPath+copy(Body.FullPath,4,255);
  end;
end;

function TgFileInfo.GetNetworkToRealPath:boolean;
begin
  Result:=Body.NetworkToRealPath;
end;

function TgFileInfo.GetPlayPath:string;
begin
  if isNetworkMode=True then begin
    Result:=GetNetworkDownloadPath;
    end else begin
    Result:=MainFileCtl.GetTruePathFromVirtualPath(GetFullPath);
  end;
end;

end.

