unit _mp3enc;

interface

uses
  Windows, Messages, Forms, SysUtils, Variants, Classes, Controls, Dialogs,
  GogoTea, _ID3_const, _wavesout_const;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

type
  Tmp3enc = class
  private
    { Private 錾 }
  public
    { Public 錾 }
    Enabled:boolean;
    GogoTea:TGogoTea;
    GogoVersion:string;
    procedure Init;
    procedure FreeDLL;
    procedure SetID3Tag(const mp3Filename:string;const ID3:TID3);
    function  isID3Passed(const ID3:TID3):boolean;
    procedure SetGogoTeaSetting(const GogoTeaSetting:TGogoTeaSetting);
    procedure Execute(const GogoTeaSetting:TGogoTeaSetting;const ID3:TID3);
    function  IsEncoding:boolean;
    function  GetVersion:string;
  end;

implementation

procedure Tmp3enc.Init;
var
  v:string;
begin
  try
    GogoTea:=TGogoTea.Create(nil);
    v:=GogoTea.VersionString;
    v:=copy(v,6,1)+copy(v,8,2);
    if StrToIntDef(v,-1)>=239 then begin
      GogoVersion:=copy(GogoTea.VersionString,6,255);
      Enabled:=True;
      end else begin
      GogoVersion:='invalidversion';
      Enabled:=False;
      MessageDlg(GogoTeaDLLVerErrorMsg,mtWarning,[mbOk],0);
      GogoTea.Free;
    end;
  except
    Enabled:=False;
    GogoVersion:='notinstalled';
  end;
end;

procedure Tmp3enc.FreeDLL;
begin
  if Enabled=True then GogoTea.Free;
end;

procedure Tmp3enc.SetID3Tag(const mp3Filename:string;const ID3:TID3);
var
  IDTag:TID3Tag;
  f:TFileStream;
  procedure PackStr(var Buf: array of Char; Str: string);
  var
    I: Integer;
  begin
    for I:= 0 to High(Buf) do begin
      if Length(Str) >= (I + 1) then
        Buf[I]:= Str[I + 1]
        else
        Buf[I]:= #32;
    end;
  end;
begin
  FillChar(IDTag, SizeOf(IDTag), $20);
  StrLCopy(IDTag.Tag, 'TAG', 3);
  PackStr(IDTag.Title  ,ID3.Title);
  PackStr(IDTag.Artist ,ID3.Artist);
  PackStr(IDTag.Album  ,ID3.Album);
  PackStr(IDTag.Comment,ID3.Comment);
  PackStr(IDTag.Year   ,ID3.Year);
  IDTag.Genre:=ID3.Genre;
  PackStr(IDTag.ID     ,ID3.ID);
  try
    f:=TFileStream.Create(mp3Filename,fmOpenReadWrite or fmShareDenyWrite);
    f.Seek(0,soFromEnd);
    f.WriteBuffer(IDTag,SizeOf(IDTag));
    f.Free;
    except else ShowMessage('t@CLᔽ߁AID3^O߂܂łB');
  end;
end;

function Tmp3enc.isID3Passed(const ID3:TID3):boolean;
begin
  if (Length(ID3.Title)>30) or (Length(ID3.Artist)>30) or (Length(ID3.Album)>30) or (Length(ID3.Comment)>30) then begin
    Result:=False;
    end else begin
    Result:=True;
  end;
end;

procedure Tmp3enc.SetGogoTeaSetting(const GogoTeaSetting:TGogoTeaSetting);
begin
  if Enabled=False then exit;

  with GogoTeaSetting do begin
    GogoTea.BitRate:=BitRate;
    if CPUExtend=True then
      GogoTea.Optimization:=[_USE_MMX,_USE_3DNOW,_USE_KNI,_USE_EX_3DNOW]
      else
      GogoTea.Optimization:=[];
    GogoTea.Processors:=Processors;

    GogoTea.EncodeType:=EncodeType;
    GogoTea.Priority:=Priority;
    GogoTea.UseLPF:=UseLPF;
    GogoTea.UsePsyAnalize:=UsePsyAnalize;

    GogoTea.UseVBR:=UseVBR;
    GogoTea.VBRLevel:=VBRLevel;
    GogoTea.VBRBitrate.Enabled:=VBRBitrateEnabled;
    GogoTea.VBRBitrate.Low:=VBRBitrateLow;
    GogoTea.VBRBitrate.High:=VBRBitrateHigh;

    GogoTea.Frequency:=Frequency;
    GogoTea.SourceFile:=SourceFile;
    GogoTea.DestinationFile:=DestinationFile;
  end;
end;

procedure Tmp3enc.Execute(const GogoTeaSetting:TGogoTeaSetting;const ID3:TID3);
begin
  if Enabled=False then exit;

  SetGogoTeaSetting(GogoTeaSetting);
  GogoTea.Execute;
  while IsEncoding do begin
    sleep(100);
    Application.ProcessMessages;
  end;
  DeleteFile(GogoTeaSetting.SourceFile);
  SetID3Tag(GogoTeaSetting.DestinationFile,ID3);
end;

function Tmp3enc.IsEncoding:boolean;
begin
  if Enabled=False then begin
    Result:=False;
    end else begin
    Result:=GogoTea.IsEncoding;
  end;
end;

function Tmp3enc.GetVersion:string;
begin
  Result:=GogoVersion;
end;

end.
