unit _wavesout_const;

interface

uses
  Windows, Classes, SysUtils, GogoTea, _const, _ID3_const;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

const MPPID01='MDXWinMP3ListFile(mpp) Ver0.1';
const MPPID02='MDXWinMP3ListFile Ver0.2';

const GogoTeaDLLVerErrorMsg='ߌ̂`[gogo.dll] Ver2.39ȍ~CXg[Ă܂B'+chr(13)+'ICwvQƂĂB';

const MP3BitRateCount=14;
const MP3VBRBitRateCount=14;

const SortKeyNone=0;
const SortKeyFullPath=1;
const SortKeyFilename=2;
const SortKeyTitle=3;
const SortKeyWaveFilename=4;

const FileFormat_Wave=0;
const FileFormat_MP3=1;
const FileFormat_Ogg=2;

const OggManage_Quality=0;
const OggManage_ABR=1;
const OggManage_CBR=2;

type
  TGogoTeaSetting=record
    BitRate:integer;
    CPUExtend:boolean;
    Processors:integer;
    EncodeType:TEncodeType;
    Priority:TThreadPriority;
    UseLPF:boolean;
    UsePsyAnalize:boolean;
    UseVBR:boolean;
    VBRLevel:integer;
    VBRBitrateEnabled:boolean;
    VBRBitrateLow:integer;
    VBRBitrateHigh:integer;
    Frequency:integer;
    SourceFile,DestinationFile:string;
  end;

type
  TID3Tag = packed record
    ID: array[0..127] of Char;
    Tag: array[0..2] of Char;
    Title: array[0..29] of Char;
    Artist: array[0..29] of Char;
    Album: array[0..29] of Char;
    Year: array[0..3] of Char;
    Comment: array[0..29] of Char;
    Genre: Byte;
  end;
  PID3Tag = ^TID3Tag;

type
  TMPPSetting=record
    TotalVolume:integer;
    LoopMax:integer;
    UseFadeout:boolean;
    EnableDSP:boolean;
    PCMRate:integer;
    StartBlankTime,EndBlankTime:integer;
    FileFormat:integer;
    MP3BitRate:integer;
    MP3CPUExtendEnabled:boolean;
    MP3Processors:integer;
    MP3EncordType:integer;
    MP3ThreadLevel:integer;
    MP3LPFEnabled:boolean;
    MP3PsyAnalizeEnabled:boolean;
    MP3VBREnabled:boolean;
    MP3VBRQuality:integer;
    MP3VBRBitrateEnabled:boolean;
    MP3VBRBitrateLow:integer;
    MP3VBRBitrateHigh:integer;
    MP3ID3GetTitlePos:integer;
    MP3ID3Year:string;
    MP3ID3Genre:integer;
    OggManageMode:integer;
    OggQuality:integer;
    OggABRMin,OggABRNorm,OggABRMax:integer;
    OggCBRNorm:integer;
    OggDownmix:boolean;
    OggIgnoreID3:boolean;
    OggAddOption:string;
  end;

type
  TencFile=record
    FullPath:string;
    Title:string;
    WaveFilename:string;
    ID3:TID3;
  end;

  TencFiles=record
    Count:integer;
    encFile:array of TencFile;
  end;

procedure ClearMPPSetting(var MPPSetting:TMPPSetting);
function GetGogoTeaSetting(var MPPSetting:TMPPSetting):TGogoTeaSetting;
procedure ClearMP3ID3(var ID3:TID3);
function GetMP3BitRateStr(idx:integer):string;
function GetMP3BitRateInt(idx:integer):integer;
function GetMP3VBRBitRateStr(idx:integer):string;
function GetMP3VBRBitRateInt(idx:integer):integer;
function GetOggCommandLine(var MPPSetting:TMPPSetting;PureTitle:string;ID3:TID3;encUTF8:boolean;WaveFilename:string):string;

implementation

procedure ClearMPPSetting(var MPPSetting:TMPPSetting);
begin
  with MPPSetting do begin
    TotalVolume:=1024;
    LoopMax:=2;
    UseFadeout:=True;
    EnableDSP:=False;
    PCMRate:=PCMRate_44kHz;
    StartBlankTime:=0;
    EndBlankTime:=0;
    FileFormat:=FileFormat_Wave;
    MP3BitRate:=9;
    MP3CPUExtendEnabled:=True;
    MP3Processors:=1;
    MP3EncordType:=1;
    MP3ThreadLevel:=0;
    MP3LPFEnabled:=False;
    MP3PsyAnalizeEnabled:=False;
    MP3VBREnabled:=False;
    MP3VBRQuality:=4;
    MP3VBRBitrateEnabled:=False;
    MP3VBRBitrateLow:=8;
    MP3VBRBitrateHigh:=10;
    MP3ID3GetTitlePos:=1;
    MP3ID3Year:=formatdatetime('yyyy',now);
    MP3ID3Genre:=36;
    OggManageMode:=OggManage_Quality;
    OggQuality:=300;
    OggABRMin:=128;
    OggABRNorm:=128;
    OggABRMax:=128;
    OggCBRNorm:=128;
    OggDownmix:=False;
    OggIgnoreID3:=False;
    OggAddOption:='';
  end;
end;

function GetGogoTeaSetting(var MPPSetting:TMPPSetting):TGogoTeaSetting;
begin
  with MPPSetting do begin
    Result.BitRate:=GetMP3BitRateInt(MP3BitRate);
    Result.CPUExtend:=MP3CPUExtendEnabled;
    Result.Processors:=MP3Processors;

    case MP3EncordType of
      0: Result.EncodeType:=_STEREO;
      1: Result.EncodeType:=_JOINT;
      2: Result.EncodeType:=_MSSTEREO;
      3: Result.EncodeType:=_MONO;
      4: Result.EncodeType:=_DUALCHANNEL;
      else Result.EncodeType:=_JOINT;
    end;

    case MP3ThreadLevel of
      0: Result.Priority:=tpIdle;
      1: Result.Priority:=tpLowest;
      2: Result.Priority:=tpLower;
      3: Result.Priority:=tpNormal;
      4: Result.Priority:=tpHigher;
      5: Result.Priority:=tpHighest;
      6: Result.Priority:=tpTimeCritical;
      else Result.Priority:=tpIdle;
    end;

    Result.UseLPF:=MP3LPFEnabled;
    Result.UsePsyAnalize:=MP3PsyAnalizeEnabled;

    Result.UseVBR:=MP3VBREnabled;
    Result.VBRLevel:=MP3VBRQuality;
    Result.VBRBitrateEnabled:=MP3VBRBitrateEnabled;
    Result.VBRBitrateLow:=GetMP3VBRBitRateInt(MP3VBRBitrateLow);
    Result.VBRBitrateHigh:=GetMP3VBRBitRateInt(MP3VBRBitrateHigh);

    Result.Frequency:=32;
    Result.SourceFile:='';
    Result.DestinationFile:='';
  end;
end;

procedure ClearMP3ID3(var ID3:TID3);
begin
  with ID3 do begin
    Title:='';
    Artist:='';
    Album:='';
    Comment:='';
    Year:='';
    Genre:=0;
    ID:='';
  end;
end;

function GetMP3BitRateStr(idx:integer):string;
begin
  case idx of
     0: Result:=' 32kbit/s';
     1: Result:=' 40kbit/s';
     2: Result:=' 48kbit/s';
     3: Result:=' 56kbit/s';
     4: Result:=' 64kbit/s';
     5: Result:=' 80kbit/s';
     6: Result:=' 96kbit/s';
     7: Result:='112kbit/s';
     8: Result:='128kbit/s()';
     9: Result:='160kbit/s(Y)';
    10: Result:='192kbit/s';
    11: Result:='224kbit/s';
    12: Result:='256kbit/s';
    13: Result:='320kbit/s';
    else Result:='';
  end;
end;

function GetMP3BitRateInt(idx:integer):integer;
begin
  case idx of
     0: Result:= 32;
     1: Result:= 40;
     2: Result:= 48;
     3: Result:= 56;
     4: Result:= 64;
     5: Result:= 80;
     6: Result:= 96;
     7: Result:=112;
     8: Result:=128;
     9: Result:=160;
    10: Result:=192;
    11: Result:=224;
    12: Result:=256;
    13: Result:=320;
    else Result:=0;
  end;
end;

function GetMP3VBRBitRateStr(idx:integer):string;
begin
  case idx of
     0: Result:=' 32kbit/s';
     1: Result:=' 40kbit/s';
     2: Result:=' 48kbit/s';
     3: Result:=' 56kbit/s';
     4: Result:=' 64kbit/s';
     5: Result:=' 80kbit/s';
     6: Result:=' 96kbit/s';
     7: Result:='112kbit/s';
     8: Result:='128kbit/s';
     9: Result:='160kbit/s';
    10: Result:='192kbit/s';
    11: Result:='224kbit/s';
    12: Result:='256kbit/s';
    13: Result:='320kbit/s';
    else Result:='';
  end;
end;

function GetMP3VBRBitRateInt(idx:integer):integer;
begin
  case idx of
     0: Result:= 32;
     1: Result:= 40;
     2: Result:= 48;
     3: Result:= 56;
     4: Result:= 64;
     5: Result:= 80;
     6: Result:= 96;
     7: Result:=112;
     8: Result:=128;
     9: Result:=160;
    10: Result:=192;
    11: Result:=224;
    12: Result:=256;
    13: Result:=320;
    else Result:=0;
  end;
end;

function GetOggCommandLine(var MPPSetting:TMPPSetting;PureTitle:string;ID3:TID3;encUTF8:boolean;WaveFilename:string):string;
  procedure AddString(name,value:string);
  begin
    if value='' then exit;
    if encUTF8=False then begin
      Result:=Result+' '+name+'="'+value+'"';
      end else begin
      Result:=Result+' '+name+'="'+value+'"'; // oggenc.exeŏUTF-8GR[hĂ݂H
    end;
  end;
begin
  Result:='';

  with MPPSetting do begin
    case OggManageMode of
      OggManage_Quality: begin
        Result:=Result+' --quality='+format('%1.2f',[OggQuality/100]);
      end;
      OggManage_ABR: begin
        Result:=Result+' --bitrate='+inttostr(OggABRNorm);
        Result:=Result+' --min-bitrate='+inttostr(OggABRMin);
        Result:=Result+' --max-bitrate='+inttostr(OggABRMax);
      end;
      OggManage_CBR: begin
        Result:=Result+' --bitrate='+inttostr(OggCBRNorm);
        Result:=Result+' --min-bitrate='+inttostr(OggCBRNorm);
        Result:=Result+' --max-bitrate='+inttostr(OggCBRNorm);
      end;
      else begin
        Result:='ExtractError';
        exit;
      end;
    end;

    if OggDownmix=True then Result:=Result+' --downmix';

    if OggIgnoreID3=True then begin
      AddString('--title',PureTitle);
      end else begin
      with ID3 do begin
        AddString('--title',Title);
        AddString('--artist',Artist);
        AddString('--album',Album);
        if Comment<>'' then Result:=Result+' -c"comment='+Comment+'"';
        if PureTitle<>'' then Result:=Result+' -c"puretitle='+PureTitle+'"';
      end;
    end;

    if OggAddOption<>'' then Result:=Result+' '+OggAddOption;
  end;

  Result:=Result+' "'+WaveFilename+'"';

  if Result<>'' then Result:=copy(Result,2,length(Result));
end;

end.
