(******************************************************************************

  Do the DirectSound with Delphi
     MCMXCVII,MCMXCVIII,MCMXCIX,MM (c) SANDMAN

******************************************************************************)
unit ddsd;

// dwFlags:=dwFlags Or DSBCAPS_STICKYFOCUS;
// 
// dwFlags:=dwFlags Or DSBCAPS_STICKYFOCUS or DSBCAPS_GLOBALFOCUS;
// ɕύX by Moonlight
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DSound, OLE2, MMSystem, d3dtypes,QDArc;


//C++Builder3.0, 4.0ł́AV{ FOR_CPPBUILDER `
{$IFDEF VER110}
  {$DEFINE FOR_CPPBUILDER}
{$ENDIF}

{$IFDEF VER125}
  {$DEFINE FOR_CPPBUILDER}
{$ENDIF}


{܁AR|[lg}
procedure Register;

(****************************************************************************
 *
 * fobOpϐcTDDSD.DebugOptionŐ䂳܂B
 *
 ****************************************************************************)
var
  DDSD_HaltOnError:Boolean;        {G[N炷Halt}
  DDSD_DebugMessage:Boolean;       {fobObZ[Wt@Cɏo}
  DDSD_ExceptOnError:Boolean;      {G[NO𔭐}

//fobOIvV
type TDDSDDebugOption = set of (dsoHaltOnError, dsoDebugMessage, dsoExceptOnError);


(******************************************************************************
  ƂR[h
******************************************************************************)
//3ĎJnE
type TDDSDDistance = record
  Min,Max:D3DValue;
end;

//R[px
type TDDSDConeAngle = record
  Inside,Outside:DWord;
end;

//Xi[̌
type TDDSDOrientation = record
  Front,Top:D3DVector;
end;

(******************************************************************************
  NX
******************************************************************************)
type

TDDSDGenWave = class;
TDDSDChannel = class;
TDDSDCapture = class;

//Xg[XVCxg
TDDSDUpdateEvent = procedure (Sender:TDDSDGenWave; Player:TDDSDChannel; availableOffset,bufferSize:DWord) of object;

//L̂Ƃ܂ŃLv`񂷃Cxg
TDDSDRecordingEvent = procedure (Sender:TDDSDCapture; StartOffset,bufferSize:DWord) of object;


//I[fBIXg[XVpCxgĎXbh
TDDSDNotifyThread = class(TThread)
  private
    FOwner:TDDSDGenWave; //̃XbhoTDDSDGenWaveIuWFNg
  public
    IsTop:Boolean;                          //݁Aobt@̐擪ɍĐʒu邩
    constructor Create(owner:TDDSDGenWave);
    procedure Execute; override;
end;

//I[fBIXg[XVpCxgĎXbhALv`p
TDDSDCaptureNotifyThread = class(TThread)
  private
    FOwner:TDDSDCapture; //̃XbhoTDDSDCaptureIuWFNg
  public
    IsTop:Boolean;                          //݁Aobt@̐擪ɘ^ʒu邩
    constructor Create(owner:TDDSDCapture);
    procedure Execute; override;
end;


//WAVt@CJvZ
TDDSDGenWave = class
  private
    FSoundBuffer:IDirectSoundBuffer;
    FWaveFormat:TWaveFormatEx;
    FLength:DWord;                  //obt@̒
    FOwner:TObject;                   //I[i[ƂȂDDSDIuWFNg
    FIsStream:Boolean;                //Xg[łȂ
    FHalfPos:DWord;                   //^̃ItZbg
    FDSNotify:IDirectSoundNotify;     //NotifypIuWFNg
    FEvent:Array[0..2] of THandle;    //CxgIuWFNgւ̃nh
    FNotifyThread:TDDSDNotifyThread;  //Xg[̏ꍇACxg̊ĎXbh
    FOnUpdate:TDDSDUpdateEvent;       //uobt@XVȂvCxg
    FPlayer:TDDSDChannel;             //WaveDataĐĂTDDSDChannelIuWFNgcXg[̏ꍇ̂ݗL
    procedure Sync;                   //NotifyThreadĂ΂āAXg[XVCxgĂԃ[`cقƂSynchronizeׂȂ񂾂ǁc
  public
    constructor Create(OWner:TObject; fname:String; is3D:Boolean); //WAVEt@Cǂݍ
    constructor CreateFromQDA(OWner:TObject; QDAname:String; id:String; is3D:Boolean); //QDAWAVEt@Cǂݍ
    constructor CreateEmptyBuffer(OWner:TObject; freq,bps:DWord; isStereo:Boolean; length:DWord; is3D:Boolean; isStream:Boolean);

    destructor Destroy; override;
    procedure BlockCopy(offset:DWord; src:Pointer; length:DWord);
    property Buffer:IDirectSoundBuffer read FSoundBuffer;
    property IsStream:Boolean read FIsStream;
    property WaveFormat:TWaveFormatEx read FWaveFormat;
    property Length:DWord read FLength;
    property OnUpdate:TDDSDUpdateEvent read FOnUpdate write FOnUpdate;
end;

//3Dp[^
TDDSDParams3D = class
  private
    FOwner:TObject;  //TDDSDChannelIuWFNg

    FDsb:DS3DBUFFER;  //i[p

    function getPosition:D3DVector;
    function getVelocity:D3DVector;
    function getConeOrientation:D3DVector;
    function getConeAngle:TDDSDConeAngle;
    function getConeOutsideVolume:Integer;
    function getMinDistance:D3DValue;
    function getMaxDistance:D3DValue;
    function getRaw:DS3DBuffer;

    procedure setPosition(const v:D3DVector);
    procedure setVelocity(const v:D3DVector);
    procedure setConeOrientation(const v:D3DVector);
    procedure setConeAngle(const v:TDDSDConeAngle);
    procedure setConeOutsideVolume(const v:Integer);
    procedure setMinDistance(const v:D3DValue);
    procedure setMaxDistance(const v:D3DValue);
    procedure setRaw(const v:DS3DBuffer);
  public
    constructor Create(Owner:TObject);
    destructor Destroy; override;
    property Position:D3DVector         read getPosition          write setPosition;
    property Velocity:D3DVector         read getVelocity          write setVelocity;
    property ConeOrientation:D3DVector  read getConeOrientation   write setConeOrientation;
    property ConeAngle:TDDSDConeAngle   read getConeAngle         write setConeAngle;
    property ConeOutsideVolume:Integer  read getConeOutsideVolume write setConeOutsideVolume;
    property MinDistance:D3DValue       read getMinDistance       write setMinDistance;
    property MaxDistance:D3DValue       read getMaxDistance       write setMaxDistance;
    property RawParams:DS3DBuffer       read getRaw               write setRaw;
    procedure Assign(v:TDDSDParams3D);
end;

//Xi[p[^
TDDSDListener = class
  private
    FOwner:TObject;     //I[i[ƂȂDDSDR|[lg
    FDsl:DS3DListener;  //i[p

    function getPosition:D3DVector;
    function getVelocity:D3DVector;
    function getOrientation:TDDSDOrientation;
    function getDistanceFactor:D3DValue;
    function getRollOffFactor:D3DValue;
    function getDopplerFactor:D3DValue;
    function getRaw:DS3DListener;

    procedure setPosition(const v:D3DVector);
    procedure setVelocity(const v:D3DVector);
    procedure setOrientation(const v:TDDSDOrientation);
    procedure setDistanceFactor(const v:D3DValue);
    procedure setRollOffFactor(const v:D3DValue);
    procedure setDopplerFactor(const v:D3DValue);
    procedure setRaw(const v:DS3DListener);

  public
    constructor Create(Owner:TObject);
    destructor Destroy; override;
    property Position:D3DVector       read getPosition          write setPosition;
    property Velocity:D3DVector       read getVelocity          write setVelocity;
    property Orientation:TDDSDOrientation read getOrientation   write setOrientation;
    property DistanceFactor:D3DValue  read getDistanceFactor    write setDistanceFactor;
    property RolloffFactor:D3DValue   read getRollOffFactor     write setRollOffFactor;
    property DopplerFactor:D3DValue   read getDopplerFactor     write setDopplerFactor;
    property RawParams:DS3DListener   read getRaw               write setRaw;
    procedure Assign(v:TDDSDListener);
end;


//WAVt@C(ʂ)
TDDSDWaveData = class(TDDSDGenWave)
  public
    //ʃRXgN^
    constructor Create(OWner:TObject; fname:String);
    constructor CreateFromQDA(OWner:TObject; QDAname:String; id:String); //QDAWAVEt@Cǂݍ

    {$IFNDEF FOR_CPPBUILDER}
    //DelphipRXgN^
    constructor CreateBuffer(OWner:TObject; freq,bps:DWord; isStereo:Boolean; length:DWord); //t@Cǂ܂Ƀobt@
    constructor CreateStream(OWner:TObject; freq,bps:DWord; isStereo:Boolean; length:DWord); //Xg[쐬
    {$ELSE}
    //C++BuilderpRXgN^
    constructor CreateEmptyBuffer(OWner:TObject; freq,bps:DWord; isStereo:Boolean; length:DWord; isStream:Boolean);
    {$ENDIF}
    destructor Destroy; override;
end;

//WAVt@C(3D)
TDDSDWave3D = class(TDDSDGenWave)
  private
    FParams3D:TDDSDParams3D;
  public
    //ʃRXgN^
    constructor Create(OWner:TObject; fname:String);
    constructor CreateFromQDA(OWner:TObject; QDAname:String; id:String); //QDAWAVEt@Cǂݍ

    {$IFNDEF FOR_CPPBUILDER}
    //DelphipRXgN^
    constructor CreateBuffer(OWner:TObject; freq,bps:DWord; isStereo:Boolean; length:DWord); //t@Cǂ܂Ƀobt@
    constructor CreateStream(OWner:TObject; freq,bps:DWord; isStereo:Boolean; length:DWord); //Xg[쐬
    {$ELSE}
    //C++BuilderpRXgN^
    constructor CreateEmptyBuffer(OWner:TObject; freq,bps:DWord; isStereo:Boolean; length:DWord; isStream:Boolean);
    {$ENDIF}

    destructor Destroy; override;
    property Params3D:TDDSDParams3D read FParams3D write FParams3D;
end;



//񎟃obt@JvZ
TDDSDChannel = class
  private
    FSoundBuffer:IDirectSoundBuffer;
    F3DBuffer:IDirectSound3DBuffer;

    FIs3D:Boolean;  //3DTEhf[^WaveDataɎw肳Ă
    FOwner:TObject; //I[i[ƂȂTDDSDR|[lg
    FPan:Integer;     //p|bg
    FFreq:DWORD;    //Đg
    FSrcFreq:DWORD; //WAV̎g
    FFreqRate:Double; //̎gɑ΂Đg̊
    FVolume:Integer;  //{[(1/100dBP)
    FWaveData:TDDSDGenWave;
    FParams3D:TDDSDParams3D;
    FIsStream:Boolean; //Xg[~OΉWaveDataڂĂ邩
    //3DE3Dp
    procedure setFreqRate(v:Double);
    procedure setVolume(v:Integer);
    procedure setPan(v:Integer);
    procedure setWaveData(wav:TDDSDGenWave);
    function getStatus:DWORD;
    function getPlayPosition:DWord;   //obt@̉oCgڂ݉t
    procedure setPlayPosition(pos:DWord);  //Đʒu̎w
    //3Dp
    procedure setParams3D(v:TDDSDParams3D);
  public
    constructor Create(Owner:TObject);
    destructor Destroy; override;
    procedure Play;
    procedure LoopPlay;
    procedure PlayAt(ofs:DWord);    //obt@̔Cӂ̃ItZbgĐ
    procedure LoopPlayAt(ofs:DWord);
    procedure Stop;
    property Buffer:IDirectSoundBuffer read FSoundBuffer;
    //3Dp
    property Pan:Integer read FPan write setPan;  //pjÓA3DĂꍇ
    //3Dp
    property Params3D:TDDSDParams3D read FParams3D write setParams3D;  //3Dp[^
    //p
    property FreqRate:Double read FFreqRate write setFreqRate;
    property Volume:Integer read FVolume write setVolume;
    property SrcFreq:DWORD read FSrcFreq;
    property Status:DWORD read getStatus;
    property WaveData:TDDSDGenWave read FWaveData write setWavedata;
    property Is3D:Boolean read FIs3D;
    property IsStream:Boolean read FIsStream;
    property PlayPosition:DWord read getPlayPosition write setPlayPosition;
end;

TDDSDChannelArray = Array[0..$FFFFFF] of TDDSDChannel;
PDDSDChannelArray = ^TDDSDChannelArray;
EDDSD = class(Exception);

//DDSD{
TDDSD = class(TComponent)
  private
    FDSound:IDirectSound;
    FPrimaryBuffer:IDirectSoundBuffer;
    F3DListener:IDirectSound3DListener;
    FChannels:PDDSDChannelArray;          //e`l
    FChannelCount:DWORD;                  //`l
    FInitialized:Boolean;                 //uTEhJ[hvtO
    FUse3D:Boolean;                       //u3DTEhgvtO
    FListener:TDDSDListener;
    FStickyFocus:Boolean;
    FDebugOption: TDDSDDebugOption;                 //ق̃Avɐ䂪ڂĂAĐł悤
    function GetChannels(iCh:Integer):TDDSDChannel;
    //3Dp
    procedure setListener(const v:TDDSDListener);
    procedure SetDebugOption(const Value: TDDSDDebugOption);
  protected
    procedure Loaded; override;
  public
    constructor Create(AOWner:TComponent); override;
    destructor Destroy; override;
    function forceInitialize:Boolean;     //DirectSound̍ď
    property DSound:IDirectSound read FDSound;
    property PrimaryBuffer:IDirectSoundBuffer read FPrimaryBuffer;
    property Channels[iCh:Integer]:TDDSDChannel read GetChannels; default;
    property Initialized:Boolean read FInitialized;
    property Listener:TDDSDListener read FListener write setListener;
    procedure SetPrimaryBufferFotmat(freq, bps:DWord; isStereo:Boolean);

  published
    property DebugOption:TDDSDDebugOption read FDebugOption write SetDebugOption;
    property Use3D:Boolean read FUse3D write FUse3D default False;
    property ChannelCount:DWORD read FChannelCount write FChannelCount default 8;
    property StickyFocus:Boolean read FStickyFocus write FStickyFocus default True;
end;


//Lv`foCX
TDDSDCapture = class
  private
    FWaveFormat:TWaveFormatEx;

    FDSCapture:IDirectSoundCapture;
    FCaptureBuffer:IDirectSoundCaptureBuffer;

    FLength:DWord;                    //Lv`obt@̒
    FOwner:TObject;                   //I[i[ƂȂDDSDIuWFNg
    FHalfPos:DWord;                   //^̃ItZbg
    FDSNotify:IDirectSoundNotify;     //NotifypIuWFNg
    FEvent:Array[0..2] of THandle;    //CxgIuWFNgւ̃nh
    FNotifyThread:TDDSDCaptureNotifyThread;  //Cxg̊ĎXbh
    FOnRecording:TDDSDRecordingEvent;    //uL̂Ƃ܂Ř^vCxg

    FInitialized:Boolean;             //ƏłH

    function GetPosition:DWord;       //TEhobt@̂ǂɃLv`Ă邩
    function GetStatus:DWord;         //^ɂĂ̏
  public
    constructor Create(OWner:TObject); //Xg[쐬
    procedure SetupCaptureBuffer(freq,bps:DWord; isStereo:Boolean; length:DWord); //Lv`obt@𐶐

    destructor Destroy; override;
    procedure Sync;                   //NotifyThreadĂ΂āAXg[XVCxgĂԃ[`cقƂSynchronizeׂȂ񂾂ǁc

    procedure Start(wait:Boolean);    //obt@̍ŏŌ𖄂߂镪Lv`
    procedure StartLoop;              //Xg[~OLv`
    procedure Stop;                   //Lv`~

    procedure BlockCopy(offset:DWord; dest:Pointer; length:DWord); //ubN]
    function IsSupportedFormat(freq,bps:DWord; isStereo:Boolean):Boolean; //̃tH[}bg͒ʗp邩

    property DSCapture:IDirectSoundCapture read FDSCapture;
    property Buffer:IDirectSoundCaptureBuffer read FCaptureBuffer;
    property Status:DWord read GetStatus;

    property Position:DWord read GetPosition; //Lv`ɎgĂLv`obt@̃ItZbg

    property OnRecording:TDDSDRecordingEvent read FOnRecording write FOnRecording;
    property Length:DWord read FLength;
end;

implementation

(****************************************************************************
  o^
 ****************************************************************************)
procedure Register;
begin
  RegisterComponents('Quadruple D',[TDDSD]);
end;

(******************************************************************************
  fobO⏕֐
******************************************************************************)
var
  DebugCount:Integer = 0;
  ErrDDSD:EDDSD;       //OIuWFNg

procedure PutDebugMessage(mes:String);
var
  F:TextFile;
  fname:String;
begin
  //fobObZ[W̏o͂֎~ɂȂĂȂAȂ
  if DDSD_DebugMessage then begin

    //EXEt@ĈfBNgdddd.debugƂt@CɈs
    fname:=ExtractFilePath(Application.Exename) + 'ddsd.debug';

    //t@CJ
    AssignFile(F,fname);
    //AvO̎sA͂߂Ă݂̏ȂAt@CNA
    if debugCount = 0 then
      ReWrite(F)
    else
      Append(F);

    Inc(debugCount);

    //s
    Writeln(F,Format('debug#%.5d ... %s',[debugCount,mes]));

    //t@C
    CloseFile(F);
  end;

  //O̔OnȂAO𔭐
  if DDSD_ExceptOnError then begin
    ErrDDSD:=EDDSD.Create(mes);
    raise ErrDDSD;
  end;

end;

function TRYDS(err:HRESULT; failMes:String):HRESULT;
begin
  result:=err;

  if err = DS_OK then
    exit;

	PutDebugMessage(failMes+Format('(Error Code(%x))',[err]));

  if DDSD_HaltOnError then
    Halt; //Ŝ߁AHaltႤ

end;



(******************************************************************************
  wp[֐
******************************************************************************)

function BufferFormatToDWord(freq,bps:DWord; IsStereo:Boolean):DWord;
var
  fmt:DWord;
begin
  //FormatwpDWORDl̐
  fmt:=1;

  Case freq of
    11025: ;
    22050: fmt := fmt Shl 4;
    44100: fmt := fmt Shl 8;
    else
      fmt:=WAVE_INVALIDFORMAT;
  end;

  Case bps of
    8:  ;
    16: fmt:=fmt Shl 2;
    else
      fmt:=WAVE_INVALIDFORMAT;
  end;

  if IsStereo then
    fmt:=fmt Shl 1;

  result:=fmt;

end;



(******************************************************************************
  GenWaveIuWFNg
******************************************************************************)
constructor TDDSDGenWave.Create(Owner:TObject; fname:String; is3D:Boolean); //WAVEt@Cǂݍ
var
  hm:HMMIO;
  mckP:TMMCKINFO;    //e`N̏
  mckC:TMMCKINFO;    //q`N̏

  fmtSize:DWord;    //fmt`ÑTCY
  dataSize:DWord;  //data`ÑTCY

  dsbd:DSBUFFERDESC;
  lpBuf1,lpBuf2:Pointer;
  dwBuf1,dwBuf2:DWord;

  function MakeFourCC(ch0,ch1,ch2,ch3:Char):DWord;
  begin
    result:= Integer(Ord(ch0)) + Integer(Ord(ch1)) Shl 8 +
             Integer(Ord(ch2)) Shl 16 + Integer(Ord(ch3)) Shl 24;
  end;
begin
  inherited Create;

  FIsStream:=False;
  FOwner:=Owner;

  //TEhJ[hȂAȂ
  if not TDDSD(FOwner).Initialized then
    Exit;

  hm := mmioOpen(PChar(fname), Nil, MMIO_READ Or MMIO_ALLOCBUF);

  if hm = 0 then begin
    PutDebugMessage(fname + 'A܂');
    Exit;
  end;

  //WAVEɓ
  mckP.fccType:=MakeFourCC('W','A','V','E');
  if (mmioDescend(hm, @mckP, Nil, MMIO_FINDRIFF)) <> 0 then begin
    mmioClose(hm, 0);
    PutDebugMessage(fname + '́AWAVEt@Cł͂܂');
    Exit;
  end;

  //fmt`Nɓ
  mckC.ckID:=MakeFourCC('f','m','t',' ');
  if (mmioDescend(hm, @mckC, @mckP, MMIO_FINDCHUNK)) <> 0 then begin
    mmioClose(hm, 0);
    PutDebugMessage(fname + 'ɂ́Afmt`NL܂');
    Exit;
  end;

  //fmt`Nǂݎ
  fmtSize := mckC.cksize;
  if mmioRead(hm, Pointer(@FWaveFormat), fmtSize) <> integer(fmtSize) then begin
    mmioClose(hm, 0);
    PutDebugMessage(fname + 'fmt`Nsł');
    Exit;
  end;

  //fmt`N𔲂Adata`Nɓ
  mmioAscend(hm, @mckC, 0);
  mckC.ckID:=MakeFourCC('d','a','t','a');
  if (mmioDescend(hm, @mckC, @mckP, MMIO_FINDCHUNK)) <> 0 then begin
    mmioClose(hm, 0);
    PutDebugMessage(fname + 'ɂ́Adata`NL܂');
    Exit;
  end;

  dataSize:=mckC.cksize;

  //񎟃obt@̍쐬
  ZeroMemory(@dsbd,sizeof(dsbd));
  with dsbd do begin
    dwSize:=sizeof(dsbd);
    if Is3D then
      dwFlags:=DSBCAPS_STATIC + DSBCAPS_CTRLDEFAULT + DSBCAPS_CTRL3D - DSBCAPS_CTRLPAN
    else
      dwFlags:=DSBCAPS_STATIC Or DSBCAPS_CTRLDEFAULT;

    if TDDSD(FOwner).StickyFocus then
      dwFlags:=dwFlags Or DSBCAPS_STICKYFOCUS or DSBCAPS_GLOBALFOCUS;

    dwBufferBytes:=dataSize;
    lpwfxFormat:=@FWaveFormat;
  end;

  FLength:=dataSize;

  TRYDS(TDDSD(FOwner).FDSound.CreateSoundBuffer(@dsbd,FSoundBuffer,Nil),'TEhobt@̍쐬Ɏs܂');

  //񎟃obt@̃bN
  TRYDS(FSoundBuffer.Lock(0,dataSize, lpBuf1,@dwBuf1,lpBuf2,@dwBuf2,0),'LoadWAVɁATEhobt@̃bNs܂');

  //f[^̃[h(data`Nǂݎ)
  mmioRead(hm, Pointer(lpBuf1), dwBuf1);
  if dwBuf2 <> 0 then begin
    mmioRead(hm, Pointer(lpBuf2), dwBuf2);
  end;

  TRYDS(FSoundBuffer.UnLock(lpBuf1,dwBuf1,lpBuf2,dwBuf2),'LoadWAVɁATEhobt@̃AbNs܂');
  FSoundBuffer.SetFrequency(FWaveFormat.nSamplesPerSec);
  mmioClose(hm, 0);

end;

//QDAWAVEt@Cǂݍ
constructor TDDSDGenWave.CreateFromQDA(OWner:TObject; QDAname:String; id:String; is3D:Boolean);
var
  TempPath:Array[0..MAX_PATH] of Char;
  TempName:Array[0..MAX_PATH] of Char;
  ms:TMemoryStream; //𓀌ʂꂽXg[
  fs:TFileStream;
  err:EDDSD;
begin
  try
    ms:=ExtractFromQDAFile(QDAName,id);
  except
    err:=EDDSD.Create(Format('A[JCut@C %s  %s ̃I[vɎs܂',[QDAName,id]));
    raise err;
  end;

  //e|t@C̍쐬
  try
    GetTempPath(MAX_PATH,@TempPath);
    GetTempFileName(@TempPath,PChar('tmp'),0,@TempName);

    fs:=TFileStream.Create(StrPas(TempName), fmCreate);
    fs.Write(ms.Memory^,ms.Size);
    fs.Free;
  except
    err:=EDDSD.Create(Format('WaveData̓WJɎs܂',[QDAName,id]));
    raise err;
  end;

  ms.Free;
  //e|ǂ݂
  Create(Owner,StrPas(TempName),is3D);

  //e|̍폜
  DeleteFile(StrPas(TempName));
end;


//t@Cǂ܂Ƀobt@
constructor TDDSDGenWave.CreateEmptyBuffer(OWner:TObject; freq,bps:DWord; isStereo:Boolean; length:DWord; is3D:Boolean; isStream:Boolean);
var
  dsbd:DSBUFFERDESC;
  pn:Array[0..2] of DSBPOSITIONNOTIFY;
  flagBase:DWord;
begin
  inherited Create;

  FIsStream:=isStream;
  FOwner:=Owner;
  FLength:=length;
  FOnUpdate:=Nil;

  //TEhJ[hȂAȂ
  if not TDDSD(FOwner).Initialized then
    Exit;

  //WaveFormatLq
  with FWaveFormat do begin
    wFormatTag:=WAVE_FORMAT_PCM;
    if isStereo then
      nChannels:=2
    else
      nChannels:=1;
    nSamplesPerSec:=freq;
    nBlockAlign:=nChannels * bps div 8;
    nAvgBytesPerSec:=freq * nBlockAlign;
    wBitsPerSample:=bps;
    cbSize:=0;
  end;

  //񎟃obt@̍쐬
  if isStream then
    flagBase:=DSBCAPS_CTRLDEFAULT + DSBCAPS_CTRLPOSITIONNOTIFY
  else
    flagBase:=DSBCAPS_CTRLDEFAULT + DSBCAPS_STATIC;

  ZeroMemory(@dsbd,sizeof(dsbd));
  with dsbd do begin
    dwSize:=sizeof(dsbd);
    if Is3D then
      dwFlags:=flagBase + DSBCAPS_CTRL3D - DSBCAPS_CTRLPAN
    else
      dwFlags:=flagBase;

    if TDDSD(FOwner).StickyFocus then
      dwFlags:=dwFlags Or DSBCAPS_STICKYFOCUS or DSBCAPS_GLOBALFOCUS;

    dwBufferBytes:=length;
    lpwfxFormat:=@FWaveFormat;
  end;

  TRYDS(TDDSD(FOwner).FDSound.CreateSoundBuffer(@dsbd,FSoundBuffer,Nil),'TEhobt@̍쐬Ɏs܂');


  if isStream then begin

    FHalfPos:=length shr 1;

    //CxgIuWFNg̐
    FEvent[0]:=CreateEvent(Nil,False,False,Nil);
    FEvent[1]:=CreateEvent(Nil,False,False,Nil);
    FEvent[2]:=CreateEvent(Nil,False,False,Nil);

    //Cxg̐ݒ
    pn[0].dwOffset:=0;  //擪
    pn[0].hEventNotify:=FEvent[0];

    pn[1].dwOffset:=FHalfPos;  //^
    pn[1].hEventNotify:=FEvent[1];

    pn[2].dwOffset:=DSBPN_OFFSETSTOP;  //Đ~
    pn[2].hEventNotify:=FEvent[2];

    //m[eBt@CIuWFNg̍쐬
    TRYDS(FSoundBuffer.QueryInterface(IID_IDirectSoundNotify,FDSNotify),'DirectSoundNotifyIuWFNg̍쐬Ɏs܂');
    TRYDS(FDSNotify.SetNotificationPositions(3,@pn), 'NotifyPosition̐ݒɎs܂');

    //CxgʒmpXbh̍쐬
    FNotifyThread:=TDDSDNotifyThread.Create(Self);
    //FnotifyThread.Priority:=tpHigher;
  end;
end;




{
constructor TDDSDGenWave.Create(Owner:TObject; fname:String; is3D:Boolean); //WAVEt@Cǂݍ
var
  fs:TFileStream;
  dsbd:DSBUFFERDESC;
  dwWavSize:DWORD;
  lpBuf1,lpBuf2:Pointer;
  dwBuf1,dwBuf2:DWord;
  fmt:DWORD;
begin

  FOwner:=Owner;

  //TEhJ[hȂAȂ
  if not TDDSD(FOwner).Initialized then
    Exit;

  try
    fs:=TFileStream.Create(fname,fmOpenRead);
  except
    PutDebugMessage(fname+'ǂݍ߂܂');
    if DDSD_HaltOnError then
      Halt;
    Exit;
  end;

  //t@Cǂ݂ASoundBuffer
  try
    //wb_̃`FbN
    fs.Position:=0;
    fs.Read(fmt,4);
    if fmt <> (Ord('R') + Ord('I') Shl 8 + Ord('F') Shl 16 + Ord('F') Shl 24) then begin
      PutDebugMessage('ΉłȂtH[}bgł');
      Abort;
    end;
    fs.Position:=8;
    fs.Read(fmt,4);
    if fmt <> (Ord('W') + Ord('A') Shl 8 + Ord('V') Shl 16 + Ord('E') Shl 24) then begin
      PutDebugMessage('ΉłȂtH[}bgł');
      Abort;
    end;
    fs.Position:=12;
    fmt:=0;
    fs.Read(fmt,3);
    if fmt <> (Ord('f') + Ord('m') Shl 8 + Ord('t') Shl 16) then begin
      PutDebugMessage('ΉłȂtH[}bgł');
      Abort;
    end;
    fs.Position:=36;
    fs.Read(fmt,4);
    if fmt <> (Ord('d') + Ord('a') Shl 8 + Ord('t') Shl 16 + Ord('a') Shl 24) then begin
      PutDebugMessage('ΉłȂtH[}bgł');
      Abort;
    end;


    fs.Position:=40; //wb_΂
    fs.Read(dwWavSize,sizeof(DWORD));
    fs.Position:=20; //WAVEtH[}bgǂ
    fs.Read(FWaveFormat,sizeOf(FWaveFormat));

    //񎟃obt@̍쐬
    ZeroMemory(@dsbd,sizeof(dsbd));
    with dsbd do begin
      dwSize:=sizeof(dsbd);
      if Is3D then
        dwFlags:=DSBCAPS_STATIC + DSBCAPS_CTRLDEFAULT + DSBCAPS_CTRL3D - DSBCAPS_CTRLPAN
      else
        dwFlags:=DSBCAPS_STATIC Or DSBCAPS_CTRLDEFAULT;
      dwBufferBytes:=dwWavSize;
      lpwfxFormat:=@FWaveFormat;
    end;

    TRYDS(TDDSD(FOwner).FDSound.CreateSoundBuffer(@dsbd,FSoundBuffer,Nil),'TEhobt@̍쐬Ɏs܂');

    //񎟃obt@̃bN
    TRYDS(FSoundBuffer.Lock(0,dwWavSize, lpBuf1,@dwBuf1,lpBuf2,@dwBuf2,0),'LoadWAVɁATEhobt@̃bNs܂');

    //f[^̃[h
    fs.Position:=44;
    fs.Read(lpBuf1^,dwBuf1);
    if dwBuf2<>0 then begin
      fs.Read(lpBuf2^,dwBuf2);
    end;

    TRYDS(FSoundBuffer.UnLock(lpBuf1,dwBuf1,lpBuf2,dwBuf2),'LoadWAVɁATEhobt@̃AbNs܂');
    FSoundBuffer.SetFrequency(FWaveFormat.nSamplesPerSec);

  finally
    fs.Free;
  end;

end;
}

destructor TDDSDGenWave.Destroy;
begin
  if TDDSD(FOwner).Initialized then begin

    if Assigned(FSoundBuffer) then begin
      TRYDS(FSoundBuffer.Release,'񎟃obt@̉Ɏs܂');
      if FIsStream And Assigned(FnotifyThread) then begin
        FNotifyThread.Free;
      end;
    end;

  end;

  inherited destroy;
end;

//TEhobt@փubNRs[
procedure TDDSDGenWave.BlockCopy(offset:DWord; src:Pointer; length:DWord);
var
  len1,len2:DWord;
  pBuf1,pBuf2:Pointer;
begin
  //TEhJ[hȂAȂ
  if not TDDSD(FOwner).Initialized then
    Exit;

  //bN
  TRYDS(FSoundBuffer.Lock(offset,length,pBuf1,@len1,pBuf2,@len2,0),'DirectSoundBuffer̃bNɎs܂');

  //Buf1փRs[
  Move(src^,pBuf1^,len1);

  //Buf2փRs[
  if len1 < length then begin
    Inc(pByte(src),len1);
    Move(src^,pBuf2^,len2);
  end;

  //AbN
  FSoundBuffer.Unlock(pBuf1,len1,pBuf2,len2);
end;


//obt@̍XVCxgĂԃ[`BNotifyThreadĂ΂B
procedure TDDSDGenWave.Sync;
begin
  if Assigned(FOnUpdate) then begin
    if FNotifyThread.IsTop then
      FOnUpdate(Self,FPlayer,FHalfPos,FLength - FHalfPos)
    else
      FOnUpdate(Self,FPlayer,0,FHalfPos);
  end;
end;


(******************************************************************************
  TDDSDGenWavẽXg[~OĐpXbh
******************************************************************************)
constructor TDDSDNotifyThread.Create(owner:TDDSDGenWave);
begin
  inherited Create(False);
  FOwner:=Owner;
end;

procedure TDDSDNotifyThread.Execute;
var
  e,flg:Integer;
  Rpos,Wpos : DWORD;
begin
  flg := 1;

  while not Terminated do begin
    e:=WaitForMultipleObjects(3,@FOwner.FEvent,False,100);  //100~bԊuTerminatedtO̊Ď

    case e of
      //擪ɍĐʒu߂Ă
      WAIT_OBJECT_0: begin
        FOwner.FSoundBuffer.GetCurrentPosition(@Rpos,@Wpos);
        PutDebugMessage(Format('擪ʒuɂĂ:HalfLen(%6d),ReadPos(%6d),WritePos(%6d),Flag(%d)',[FOwner.FHalfPos,Rpos,Wpos,flg]));
        //RPosƃ{[hɂċU̒lԂ̂ŁAWPospĔf
        if ((WPos <= FOwner.FHalfPos)and(flg = 1)) then
        begin
          IsTop:=True;
          FOwner.Sync;
          flg := 0;
          //Synchronize(FOwner.Sync);
          PutDebugMessage(Format('obt@XVCxgM',[]));
        end;
      end;

      //obt@ɍĐʒu
      WAIT_OBJECT_0 + 1: begin
        FOwner.FSoundBuffer.GetCurrentPosition(@Rpos,@Wpos);
        PutDebugMessage(Format('ʒuɂĂ:HalfLen(%6d),ReadPos(%6d),WritePos(%6d)mFlag(%d)',[FOwner.FHalfPos,Rpos,Wpos,flg]));
        //RPosƃ{[hɂċU̒lԂ̂ŁAWPospĔf
        if ((WPos >= FOwner.FHalfPos)and(flg = 0)) then
        begin
          IsTop:=False;
          FOwner.Sync;
          flg := 1;
          //Synchronize(FOwner.Sync);
          PutDebugMessage(Format('obt@XVCxgM',[]));
        end;
      end;

      //Đ~v
      WAIT_OBJECT_0 + 2: begin
        //Suspend;
        PutDebugMessage(Format('~',[]));
        flg := 1;
      end;
    end;
  end;

end;

(******************************************************************************
  ^pXbh
******************************************************************************)
constructor TDDSDCaptureNotifyThread.Create(owner:TDDSDCapture);
begin
  inherited Create(False);
  FOwner:=Owner;
end;

procedure TDDSDCaptureNotifyThread.Execute;
var
  e:Integer;
begin

  while not Terminated do begin
    e:=WaitForMultipleObjects(3,@FOwner.FEvent,False,100);  //100~bԊuTerminatedtO̊Ď

    case e of
      //擪ɘ^ʒu߂Ă
      WAIT_OBJECT_0: begin
        IsTop:=True;
        FOwner.Sync;
        //Synchronize(FOwner.Sync);
      end;

      //obt@ɍĐʒu
      WAIT_OBJECT_0 + 1: begin
        IsTop:=False;
        FOwner.Sync;
        //Synchronize(FOwner.Sync);
      end;

      //Đ~v
      WAIT_OBJECT_0 + 2: begin
        //Suspend;
      end;
    end;
  end;

end;

(******************************************************************************
  Params3DIuWFNg
******************************************************************************)
constructor TDDSDParams3D.Create(Owner:TObject);
begin
  inherited Create;

  FOwner:=Owner;

  //p[^̐ݒ
  //ftHgł́AwŗLW0`100m
  with FDsb do begin
    dwSize:=sizeof(DS3DBuffer);
    with vPosition do begin
      x:=0; y:=0; z:=0;
    end;
    with vVelocity do begin
      x:=0; y:=0; z:=0;
    end;
    dwInsideConeAngle:=DS3D_DEFAULTCONEANGLE;
    dwOutsideConeAngle:=DS3D_DEFAULTCONEANGLE;
    with vConeOrientation do begin
      x:=0; y:=0; z:=1;
    end;
    lConeoutsideVolume:= DS3D_DEFAULTCONEOUTSIDEVOLUME; //R[̊OłȂ
    flMinDistance:=5;     //5mȓȂAƂȂ{[ŕ
    flMaxDistance:=100.0; //100m̂ƂŁASɕȂȂ
    dwMode:=DS3DMODE_NORMAL;
  end;

end;

destructor TDDSDParams3D.destroy;
begin
  inherited destroy;
end;



function TDDSDParams3D.getPosition:D3DVector;
begin
  if (FOwner <> Nil) And (TDDSDChannel(FOwner).F3DBuffer <> Nil) then begin
    TDDSDChannel(FOwner).F3DBuffer.GetPosition(@FDsb.vPosition);
  end;
  result:=FDsb.vPosition;
end;

function TDDSDParams3D.getVelocity:D3DVector;
begin
  if (FOwner <> Nil) And (TDDSDChannel(FOwner).F3DBuffer <> Nil) then begin
    TDDSDChannel(FOwner).F3DBuffer.GetVelocity(@FDsb.vVelocity);
  end;
  result:=FDsb.vVelocity;
end;

function TDDSDParams3D.getConeOrientation:D3DVector;
begin
  if (FOwner <> Nil) And (TDDSDChannel(FOwner).F3DBuffer <> Nil) then begin
    TDDSDChannel(FOwner).F3DBuffer.GetConeOrientation(@FDsb.vConeOrientation);
  end;
  result:=FDsb.vConeOrientation;
end;

function TDDSDParams3D.getConeAngle:TDDSDConeAngle;
begin
  if (FOwner <> Nil) And (TDDSDChannel(FOwner).F3DBuffer <> Nil) then begin
    TDDSDChannel(FOwner).F3DBuffer.GetConeAngles(@FDsb.dwInsideConeAngle,@FDsb.dwOutsideConeAngle);
  end;
  with result do begin
    Inside :=FDsb.dwInsideConeAngle;
    OutSide:=FDsb.dwOutsideConeAngle;
  end;
end;

function TDDSDParams3D.getConeOutsideVolume:Integer;
begin
  if (FOwner <> Nil) And (TDDSDChannel(FOwner).F3DBuffer <> Nil) then begin
    TDDSDChannel(FOwner).F3DBuffer.GetConeOutsideVolume(@FDsb.lConeOutsideVolume);
  end;
  result:=FDsb.lConeOutsideVolume;
end;

function TDDSDParams3D.getMinDistance:D3DValue;
begin
  if (FOwner <> Nil) And (TDDSDChannel(FOwner).F3DBuffer <> Nil) then begin
    TDDSDChannel(FOwner).F3DBuffer.GetMinDistance(@FDsb.flMinDistance);
  end;
  result:=FDsb.flMinDistance;
end;

function TDDSDParams3D.getMaxDistance:D3DValue;
begin
  if (FOwner <> Nil) And (TDDSDChannel(FOwner).F3DBuffer <> Nil) then begin
    TDDSDChannel(FOwner).F3DBuffer.GetMaxDistance(@FDsb.flMaxDistance);
  end;
  result:=FDsb.flMaxDistance;
end;

function TDDSDParams3D.getRaw:DS3DBuffer;
begin
  if (FOwner <> Nil) And (TDDSDChannel(FOwner).F3DBuffer <> Nil) then begin
    TDDSDChannel(FOwner).F3DBuffer.GetAllParameters(@FDsb);
  end;
  result:=FDsb;
end;


procedure TDDSDParams3D.setPosition(const v:D3DVector);
begin
  if (FOwner <> Nil) And (TDDSDChannel(FOwner).F3DBuffer <> Nil) then begin
    TDDSDChannel(FOwner).F3DBuffer.SetPosition(v.x, v.y, v.z, DS3D_IMMEDIATE);
  end;
  FDsb.vPosition:=v;
end;

procedure TDDSDParams3D.setVelocity(const v:D3DVector);
begin
  if (FOwner <> Nil) And (TDDSDChannel(FOwner).F3DBuffer <> Nil) then begin
    TDDSDChannel(FOwner).F3DBuffer.SetVelocity(v.x, v.y, v.z, DS3D_IMMEDIATE);
  end;
  FDsb.vVelocity:=v;
end;

procedure TDDSDParams3D.setConeOrientation(const v:D3DVector);
begin
  if (FOwner <> Nil) And (TDDSDChannel(FOwner).F3DBuffer <> Nil) then begin
    TDDSDChannel(FOwner).F3DBuffer.SetConeOrientation(v.x, v.y, v.z, DS3D_IMMEDIATE);
  end;
  FDsb.vConeOrientation:=v;
end;

procedure TDDSDParams3D.setConeAngle(const v:TDDSDConeAngle);
begin
  if (FOwner <> Nil) And (TDDSDChannel(FOwner).F3DBuffer <> Nil) then begin
    TDDSDChannel(FOwner).F3DBuffer.SetConeAngles(v.Inside,v.Outside, DS3D_IMMEDIATE);
  end;
   FDsb.dwInsideConeAngle:=v.Inside;
   FDsb.dwInsideConeAngle:=v.Outside;
end;

procedure TDDSDParams3D.setConeOutsideVolume(const v:Integer);
begin
  if (FOwner <> Nil) And (TDDSDChannel(FOwner).F3DBuffer <> Nil) then begin
    TDDSDChannel(FOwner).F3DBuffer.SetConeOutsideVolume(v, DS3D_IMMEDIATE);
  end;
  FDsb.lConeOutsideVolume:=v;
end;

procedure TDDSDParams3D.setMinDistance(const v:D3DValue);
begin
  if (FOwner <> Nil) And (TDDSDChannel(FOwner).F3DBuffer <> Nil) then begin
    TDDSDChannel(FOwner).F3DBuffer.SetMinDistance(v, DS3D_IMMEDIATE);
  end;
  FDsb.flMinDistance:=v;
end;

procedure TDDSDParams3D.setMaxDistance(const v:D3DValue);
begin
  if (FOwner <> Nil) And (TDDSDChannel(FOwner).F3DBuffer <> Nil) then begin
    TDDSDChannel(FOwner).F3DBuffer.SetMaxDistance(v, DS3D_IMMEDIATE);
  end;
  FDsb.flMaxDistance:=v;
end;

procedure TDDSDParams3D.setRaw(const v:DS3DBuffer);
begin
  if (FOwner <> Nil) And (TDDSDChannel(FOwner).F3DBuffer <> Nil) then begin
    TRYDS(TDDSDChannel(FOwner).F3DBuffer.SetAllParameters(@v, DS3D_IMMEDIATE),'Params3DɎw肳ꂽp[^sK؂ł');
  end;
  FDsb:=v;
end;

procedure TDDSDParams3D.Assign(v:TDDSDParams3D);
begin
  //̏o
   FDsb:=v.RawParams;

  if (FOwner <> Nil) And (TDDSDChannel(FOwner).F3DBuffer <> Nil) then begin
    TRYDS(TDDSDChannel(FOwner).F3DBuffer.SetAllParameters(@FDsb, DS3D_IMMEDIATE),'Params3DɎw肳ꂽp[^sK؂ł');
  end;
end;


(******************************************************************************
  ListnerIuWFNg
******************************************************************************)

constructor TDDSDListener.Create(Owner:TObject);
begin
  inherited Create;

  FOwner:=Owner;

  ZeroMemory(@FDsl,sizeof(FDsl));
  with FDsl do begin
    dwSize:=sizeOf(FDsl);
    with vPosition do begin
      x:=0; y:=0; z:=0;
    end;
    with vVelocity do begin
      x:=0; y:=0; z:=0;
    end;
    with vOrientFront do begin
      x:=0; y:=0; z:=1;
    end;
    with vOrientTop do begin
      x:=0; y:=1; z:=0;
    end;
    flDistanceFactor:=1.0; //DS3D_DEFAULTDISTANCEFACTOR;
    flRolloffFactor:=1.0; //DS3D_DEFAULTROLLOFFFACTOR;
    flDopplerFactor:=1.0; //DS3D_DEFAULTDOPPLERFACTOR;
  end;

  if TDDSD(FOwner).F3DListener <> Nil then begin
    TRYDS(TDDSD(FOwner).F3DListener.SetAllParameters(@FDsl, DS3D_IMMEDIATE),'ListenerɎw肳ꂽp[^sK؂ł');
  end;
end;

destructor TDDSDListener.Destroy;
begin
  inherited Destroy;
end;


function TDDSDListener.getPosition:D3DVector;
begin
  if TDDSD(FOwner).F3DListener <> Nil then begin
    TDDSD(FOwner).F3DListener.GetPosition(@FDsl.vPosition);
  end;
  result:=FDsl.vPosition;
end;

function TDDSDListener.getVelocity:D3DVector;
begin
  if TDDSD(FOwner).F3DListener <> Nil then begin
    TDDSD(FOwner).F3DListener.GetVelocity(@FDsl.vVelocity);
  end;
  result:=FDsl.vVelocity;
end;

function TDDSDListener.getOrientation:TDDSDOrientation;
begin
  if TDDSD(FOwner).F3DListener <> Nil then begin
    TDDSD(FOwner).F3DListener.GetOrientation(@FDsl.vOrientFront,@FDsl.vOrientTop);
  end;
  with result do begin
    Front:=FDsl.vOrientFront;
    Top:=FDsl.vOrientTop;
  end;
end;

function TDDSDListener.getDistanceFactor:D3DValue;
begin
  if TDDSD(FOwner).F3DListener <> Nil then begin
    TDDSD(FOwner).F3DListener.GetDistanceFactor(@FDsl.flDistanceFactor);
  end;
  result:=FDsl.flDistanceFactor;
end;

function TDDSDListener.getRollOffFactor:D3DValue;
begin
  if TDDSD(FOwner).F3DListener <> Nil then begin
    TDDSD(FOwner).F3DListener.GetRollOffFactor(@FDsl.flRollOffFactor);
  end;
  result:=FDsl.flRollOffFactor;
end;

function TDDSDListener.getDopplerFactor:D3DValue;
begin
  if TDDSD(FOwner).F3DListener <> Nil then begin
    TDDSD(FOwner).F3DListener.GetDopplerFactor(@FDsl.flDopplerFactor);
  end;
  result:=FDsl.flDopplerFactor;
end;

function TDDSDListener.getRaw:DS3DListener;
begin
  if (FOwner <> Nil) And (TDDSD(FOwner).F3DListener <> Nil) then begin
    TDDSD(FOwner).F3DListener.GetAllParameters(@FDsl);
  end;
  result:=FDsl;
end;


procedure TDDSDListener.setPosition(const v:D3DVector);
begin
  if TDDSD(FOwner).F3DListener <> Nil then begin
    TDDSD(FOwner).F3DListener.SetPosition(v.x,v.y,v.z, DS3D_IMMEDIATE);
  end;
  FDsl.vPosition:=v;
end;

procedure TDDSDListener.setVelocity(const v:D3DVector);
begin
  if TDDSD(FOwner).F3DListener <> Nil then begin
    TDDSD(FOwner).F3DListener.SetVelocity(v.x,v.y,v.z, DS3D_IMMEDIATE);
  end;
  FDsl.vVelocity:=v;
end;

procedure TDDSDListener.setOrientation(const v:TDDSDOrientation);
begin
  if TDDSD(FOwner).F3DListener <> Nil then begin
    TDDSD(FOwner).F3DListener.SetOrientation(v.Front.x,v.Front.y,v.Front.z, v.Top.x,v.Top.y,v.Top.z, DS3D_IMMEDIATE);
  end;
  FDsl.vOrientFront:=v.Front;
  FDsl.vOrientTop:=v.Top;
end;

procedure TDDSDListener.setDistanceFactor(const v:D3DValue);
begin
  if TDDSD(FOwner).F3DListener <> Nil then begin
    TDDSD(FOwner).F3DListener.SetDistanceFactor(v, DS3D_IMMEDIATE);
  end;
  FDsl.flDistanceFactor:=v;
end;

procedure TDDSDListener.setRollOffFactor(const v:D3DValue);
begin
  if TDDSD(FOwner).F3DListener <> Nil then begin
    TDDSD(FOwner).F3DListener.SetRolloffFactor(v, DS3D_IMMEDIATE);
  end;
  FDsl.flRolloffFactor:=v;
end;

procedure TDDSDListener.setDopplerFactor(const v:D3DValue);
begin
  if TDDSD(FOwner).F3DListener <> Nil then begin
    TDDSD(FOwner).F3DListener.SetDopplerFactor(v, DS3D_IMMEDIATE);
  end;
  FDsl.flDopplerFactor:=v;
end;

procedure TDDSDListener.setRaw(const v:DS3DListener);
begin
  if (FOwner <> Nil) And (TDDSD(FOwner).F3DListener <> Nil) then begin
    TRYDS(TDDSD(FOwner).F3DListener.SetAllParameters(@v, DS3D_IMMEDIATE),'ListenerɎw肳ꂽp[^sK؂ł');
  end;
  FDsl:=v;
end;

procedure TDDSDListener.Assign(v:TDDSDListener);
begin
  //̏o
   FDsl:=v.RawParams;

  if (FOwner <> Nil) And (TDDSD(FOwner).F3DListener <> Nil) then begin
    TRYDS(TDDSD(FOwner).F3DListener.SetAllParameters(@FDsl, DS3D_IMMEDIATE),'ListenerɎw肳ꂽp[^sK؂ł');
  end;
end;

(******************************************************************************
  WaveDataIuWFNg
******************************************************************************)
constructor TDDSDWaveData.Create(Owner:TObject; fname:String); //WAVEt@Cǂݍ
begin
  inherited Create(Owner,fname,False);
end;

constructor TDDSDWaveData.CreateFromQDA(OWner:TObject; QDAname:String; id:String); //QDAWAVEt@Cǂݍ
begin
  inherited CreateFromQDA(Owner,QDAname,id, False);
end;

{$IFNDEF FOR_CPPBUILDER}
constructor TDDSDWaveData.CreateBuffer(owner:TObject; freq,bps:DWord; isStereo:Boolean; length:DWord);
begin
  inherited CreateEmptyBuffer(Owner,freq,bps,isStereo,length,False, False);
end;

constructor TDDSDWaveData.CreateStream(OWner:TObject; freq,bps:DWord; isStereo:Boolean; length:DWord);
begin
  inherited CreateEmptyBuffer(Owner,freq,bps,isStereo,length,False, True);
end;

{$ELSE}
constructor TDDSDWaveData.CreateEmptyBuffer(OWner:TObject; freq,bps:DWord; isStereo:Boolean; length:DWord; isStream:Boolean);
begin
  inherited CreateEmptyBuffer(Owner,freq,bps,isStereo,length,False, isStream);
end;

{$ENDIF}  //FOR_CPPBUILDER



destructor TDDSDWaveData.Destroy;
begin
  inherited Destroy;
end;

(******************************************************************************
  Wave3DIuWFNg
******************************************************************************)
constructor TDDSDWave3D.Create(Owner:TObject; fname:String); //WAVEt@Cǂݍ
begin
  inherited Create(Owner,fname,True);

  FParams3D:=TDDSDParams3D.Create(Nil); //p[^
end;

constructor TDDSDWave3D.CreateFromQDA(OWner:TObject; QDAname:String; id:String); //QDAWAVEt@Cǂݍ
begin
  inherited CreateFromQDA(Owner,QDAname,id,True);

  FParams3D:=TDDSDParams3D.Create(Nil); //p[^
end;

{$IFNDEF FOR_CPPBUILDER}

constructor TDDSDWave3D.CreateBuffer(owner:TObject; freq,bps:DWord; isStereo:Boolean; length:DWord);
begin
  inherited CreateEmptyBuffer(Owner,freq,bps,isStereo,length,True, False);

  FParams3D:=TDDSDParams3D.Create(Nil); //p[^
end;

constructor TDDSDWave3D.CreateStream(OWner:TObject; freq,bps:DWord; isStereo:Boolean; length:Dword); //Xg[쐬
begin
  inherited CreateEmptyBuffer(Owner,freq,bps,isStereo,length,True, True);

  FParams3D:=TDDSDParams3D.Create(Nil); //p[^
end;

{$ELSE}
constructor TDDSDWave3D.CreateEmptyBuffer(OWner:TObject; freq,bps:DWord; isStereo:Boolean; length:DWord; isStream:Boolean);
begin
  inherited CreateEmptyBuffer(Owner,freq,bps,isStereo,length,True, isStream);

  FParams3D:=TDDSDParams3D.Create(Nil); //p[^
end;

{$ENDIF}  //FOR_CPPBUILDER



destructor TDDSDWave3D.Destroy;
begin
  FParams3D.Free;

  inherited Destroy;
end;






(******************************************************************************
  ChannelIuWFNg
******************************************************************************)
constructor TDDSDChannel.Create(Owner:TObject);
begin
  inherited Create;
  FOwner:=Owner;
  FSoundBuffer:=Nil;
  F3DBuffer:=Nil;
  FWaveData:=Nil;
  FIs3D:=False;
  FIsStream:=False;

  FPan:=0;
  FFreqRate:=1.0;
  FVolume:=0;

  FParams3D:=TDDSDParams3D.Create(Self);
end;


destructor TDDSDChannel.Destroy;
begin
  if Assigned(F3DBuffer) then
    F3DBuffer.Release;
  if Assigned(FSoundBuffer) then
    FSoundBuffer.Release;

  if Assigned(FParams3D) then
    FParams3D.Free;

  inherited destroy;
end;

procedure TDDSDChannel.setWaveData(wav:TDDSDGenWave);
begin
  //TEhJ[hł́Ao
  if not TDDSD(FOwner).Initialized then
    Exit;

  //̃TEhobt@̉
  if not IsStream then begin
    if Assigned(F3DBuffer) then
      TRYDS(F3DBuffer.Release,'setWaveData 3DTEhobt@̉Ɏs܂');
    if Assigned(FSoundBuffer) then
      TRYDS(FSoundBuffer.Release,'setWaveData TEhobt@̉Ɏs܂');
  end else begin
    //܏悹Ă̂ƓIuWFNgȂAȂ
    if wav = FWaveData then
      Exit;

    //܂܂ł̍Đ~߂
    Stop;
  end;

  if wav = Nil then
    Exit;

  //Xg[Ȃ΁APɑBłȂȂDuplicateSoundBufferđdĐł悤ɂ
  if wav.IsStream then begin
    FSoundBuffer:=wav.Buffer;
    wav.FPlayer:=Self;
  end else
    TRYDS(TDDSD(FOwner).DSound.DuplicateSoundBuffer(wav.Buffer,FSoundBuffer),'setWaveData TEhobt@̕Ɏs܂');

  FIsStream:=wav.IsStream;


  //3DĐł悤ɂ
  if wav is TDDSDWave3D then begin
    FIs3D:=True;
    TRYDS(FSoundBuffer.QueryInterface(IID_IDirectSound3DBuffer,F3DBuffer),'setWaveData 3DTEhobt@̍쐬Ɏs܂');
    Params3D:=TDDSDWave3D(wav).Params3D;
  end else begin
    FIs3D:=False;
  end;

  FSrcFreq:=wav.FWaveFormat.nSamplesPerSec;
  FWaveData:=wav;
end;

procedure TDDSDChannel.Play;
begin
  if not Assigned(FSoundBuffer) then
    Exit;

  {
  if not Is3D then
    FSoundBuffer.SetPan(FPan);
  FSoundBuffer.Setfrequency(FFreq);
  FSoundBuffer.SetVolume(FVolume);

  FSoundBuffer.Stop;
  }

  //Xg[̏ꍇAʒmp̃XbhANeBx[g
  {
  if IsStream then begin
    if FWaveData.FNotifyThread.Suspended then
      FWaveData.FNotifyThread.Resume;
  end;
  }

  FSoundBuffer.SetCurrentPosition(0);
  FSoundBuffer.Play(0,0,0);
end;

procedure TDDSDChannel.Stop;
begin

  if not Assigned(FSoundBuffer) then begin
    Exit;
  end;

  FSoundBuffer.Stop;
  

  //Xg[̏ꍇAXbhTXyh܂ő҂
  {
  if IsStream then begin
    //while not FWaveData.FNotifyThread.Suspended do
    //  ;
  end;
  }
end;

procedure TDDSDChannel.LoopPlay;
begin
  if not Assigned(FSoundBuffer) then
    Exit;

  {
  FSoundBuffer.SetPan(FPan);
  FSoundBuffer.setfrequency(FFreq);
  FSoundBuffer.SetVolume(FVolume);
  FSoundBuffer.Stop;
  }
  //Xg[̏ꍇAʒmp̃XbhANeBx[g
  {
  if IsStream then begin
    if FWaveData.FNotifyThread.Suspended then
      FWaveData.FNotifyThread.Resume;
  end;
  }
  
  FSoundBuffer.SetCurrentPosition(0);
  FSoundbuffer.Play(0,0,DSBPLAY_LOOPING);
end;


//obt@̔Cӂ̃ItZbgĐ
procedure TDDSDChannel.PlayAt(ofs:DWord);
begin
  if not Assigned(FSoundBuffer) then
    Exit;

  //Xg[̏ꍇAʒmp̃XbhANeBx[g
  {
  if IsStream then begin
    if FWaveData.FNotifyThread.Suspended then
      FWaveData.FNotifyThread.Resume;
  end;
  }
  
  FSoundBuffer.SetCurrentPosition(ofs);
  FSoundbuffer.Play(0,0,0);
end;

procedure TDDSDChannel.LoopPlayAt(ofs:DWord);
begin
  if not Assigned(FSoundBuffer) then
    Exit;

  //Xg[̏ꍇAʒmp̃XbhANeBx[g
  {
  if IsStream then begin
    if FWaveData.FNotifyThread.Suspended then
      FWaveData.FNotifyThread.Resume;
  end;
  }
  
  FSoundBuffer.SetCurrentPosition(ofs);
  FSoundbuffer.Play(0,0,DSBPLAY_LOOPING);
end;

procedure TDDSDChannel.setFreqRate(v:Double);
begin
  if not Assigned(FSoundBuffer) then
    Exit;

  FFreq:=Trunc(v*FSrcFreq);
  FSoundBuffer.setfrequency(FFreq);
end;

procedure TDDSDChannel.setVolume(v:Integer);
begin
  if not Assigned(FSoundBuffer) then
    Exit;
  FVolume:=v;
  FSoundBuffer.SetVolume(FVolume);
end;

procedure TDDSDChannel.setPan(v:Integer);
begin
  if not Assigned(FSoundBuffer) then
    Exit;

  if not Is3D then begin
    FPan:=v;
    FSoundBuffer.SetPan(FPan);
  end;
end;

function TDDSDChannel.getStatus:DWORD;
var
  ret:DWORD;
begin
  if not Assigned(FSoundBuffer) then begin
    result:=0;
    Exit;
  end;
  FSoundBuffer.GetStatus(@ret);
  result:=ret;
end;

procedure TDDSDChannel.setParams3D(v:TDDSDParams3D);
begin
  FParams3D.Assign(v);
  //TRYDS(F3DBuffer.SetAllParameters(@v,DS3D_IMMEDIATE),'Params3DɎw肳ꂽp[^sK؂ł');
end;

//obt@̉oCgڂ݉t
function TDDSDChannel.getPlayPosition:DWord;
var
  pos:DWord;
begin
  if not Assigned(FSoundBuffer) then begin
    result:=0;
    Exit;
  end;

  FSoundBuffer.GetCurrentPosition(@pos,Nil);
  result:=pos;
end;

//Đʒu̎w
procedure TDDSDChannel.setPlayPosition(pos:DWord);
begin
  if not Assigned(FSoundBuffer) then begin
    Exit;
  end;

  FSoundBuffer.SetCurrentPosition(pos);
end;

(******************************************************************************
  DDSDR|[lg{
******************************************************************************)

constructor TDDSD.Create(AOWner:TComponent);
var
  i,count:Integer;
begin
  inherited Create(AOWner);

  if (csDesigning in ComponentState) then begin
    //DDSDR|tH[ɒĂȂA`FbN
    count:=0;
    for i:=0 to Owner.ComponentCount-1 do begin
      if Owner.Components[i] is TDDSD then begin
        Inc(count);
      end;
    end;

    if count >=2 then begin
      raise Exception.Create('DDSDR|[lgAtH[2ȏ\鎖͂ł܂');
      exit;
    end;
  end;
  
  //ftHgl̐ݒ
  ChannelCount:=8;
  FStickyFocus:=True;
  FUse3D:=False;
  DebugOption:=[dsoHaltOnError];
end;

destructor TDDSD.Destroy;
var
  i:DWORD;
begin
  if (csDesigning in ComponentState) then begin
    inherited destroy;
    Exit;
  end;

  For i:=0 to FChannelCount-1 do
    Channels[i].Free;

  if Assigned(FListener) then
    FListener.Free;

  if Assigned(F3DListener) then
    TRYDS(F3DListener.Release,'DirectSound3D Listner̉Ɏs܂');
  if Assigned(FPrimaryBuffer) then
    TRYDS(FPrimaryBuffer.Release,'ꎟobt@̉Ɏs܂');

  if Assigned(FDSound) then
    TRYDS(FDSound.Release,'DirectSound̉Ɏs܂');

  FreeMem(FChannels);

  inherited Destroy;
end;


//DirectSound
function TDDSD.forceInitialize:Boolean;     //DirectSound̍ď
var
  i:DWORD;
  dsbd:DSBUFFERDESC;
begin

  result:=True;

  if Assigned(FChannels) then begin
    For i:=0 to FChannelCount-1 do begin
      FChannels^[i].Free;
    end;
    FreeMem(FChannels);
  end;

  GetMem(FChannels,sizeof(TDDSDChannel)*FChannelCount);

  For i:=0 to FChannelCount-1 do begin
    FChannels^[i]:=TDDSDChannel.Create(Self);
  end;

  //DirectSound̏
  if DirectSoundCreate(Nil,FDSound,Nil)<>DS_OK then begin
    FInitialized:=False;
    result:=False;
    Exit;
  end;
  FInitialized:=True;

  TRYDS(FDSound.SetCooperativeLevel(TForm(Owner).Handle,DSSCL_PRIORITY),'DirectSound̋x̐ݒɎs܂');

  //ꎟobt@̏
  ZeroMemory(@dsbd,sizeof(dsbd));
  with dsbd do begin
    dwSize:=sizeof(dsbd);
    if Use3D then
      dwFlags:=DSBCAPS_PRIMARYBUFFER Or DSBCAPS_CTRL3D
    else
      dwFlags:=DSBCAPS_PRIMARYBUFFER;

    TRYDS(FDSound.CreateSoundBuffer(@dsbd,FPrimaryBuffer,Nil),'ꎟobt@̍쐬Ɏs܂');
  end;

  //3DΉɂ
  if Use3D then begin
    TRYDS(FPrimaryBuffer.QueryInterface(IID_IDirectSound3DListener,F3DListener),'DirectSound3D Listener̍쐬Ɏs܂');
    if FListener <> Nil then
      FListener.Free;
    FListener:=TDDSDListener.Create(Self);
  end;

end;


procedure TDDSD.SetDebugOption(const Value: TDDSDDebugOption);
begin
  FDebugOption := Value;

  DDSD_DebugMessage := dsoDebugMessage in Value;
  DDSD_ExceptOnError := dsoExceptOnError in Value;
  DDSD_HaltOnError := dsoHaltOnError in Value;

end;


procedure TDDSD.Loaded;
begin
  inherited Loaded;

  if (csDesigning in ComponentState) then
    Exit;

  DebugOption:=DebugOption;
  forceInitialize;
end;


function TDDSD.GetChannels(iCh:Integer):TDDSDChannel;
begin
  if DWORD(iCh) > FChannelCount then begin
    PutDebugMessage(Format('`lԍ%d͖łA%d`%d͈̔͂Ŏw肵Ă',[iCh,0,FChannelCount-1]));
    if DDSD_HaltOnError then
      Halt;
    result:=Nil;
    Exit;
  end;
  result:=FChannels^[iCh];
end;

procedure TDDSD.setListener(const v:TDDSDListener);
begin
  FListener.Assign(v);
end;

//vC}Eobt@̃tH[}bgݒ
procedure TDDSD.SetPrimaryBufferFotmat(freq, bps: DWord;
  isStereo: Boolean);
var
  format:TWaveFormatEx;
begin
  //TEhJ[h̖ȂAȂ
  if not FInitialized then
    exit;

  //vC}obt@̃tH[}bgݒ肷
  with format do begin
    wFormatTag := WAVE_FORMAT_PCM;

    if isStereo then
      nChannels := 2
    else
      nChannels := 1;

    nSamplesPerSec := freq;
    wBitsPerSample := bps;
    nBlockAlign := wBitsPerSample div 8 * nChannels;
    nAvgBytesPerSec := nSamplesPerSec * nBlockAlign;
    cbSize:=0;
  end;

  TRYDS(PrimaryBuffer.SetFormat(@format),'vC}Eobt@̃tH[}bg̐ݒɎs܂');
end;




{ TDDSDCapture }

//RXgN^
constructor TDDSDCapture.Create(OWner: TObject);
begin
  FOwner:=Owner;
  FLength:=0;
  FOnRecording:=Nil;

  //DirectSoundCaptureIuWFNg̐
  if DirectSoundCaptureCreate(Nil, FDSCapture, Nil) <> DS_OK then begin
    FInitialized:=False;
    exit;
  end;

  //OK
  FInitialized:=True;

end;

//fXgN^
destructor TDDSDCapture.Destroy;
begin
  //ƂĂȂȂAA
  if not FInitialized then
    exit;

  if Assigned(FCaptureBuffer) then
    FCaptureBuffer.Release;

  FDSCapture.Release;
end;


//ǂݍOKȕ̐擪ItZbgԂ
function TDDSDCapture.GetPosition: DWord;
var
  pos:DWord;
begin
  //ƂĂȂȂAA
  if not FInitialized then begin
    result:=0;
    exit;
  end;

  Buffer.GetCurrentPosition(Nil, @pos);
  result:=pos;
end;

//^Ԃ̎擾
function TDDSDCapture.GetStatus: DWord;
var
  stat:DWord;
begin
  //ƂĂȂȂAA
  if not FInitialized then begin
    result:=0;
    exit;
  end;

  Buffer.GetStatus(@stat);
  result:=stat;
end;


//߂I܂ł𖄂߂邾Lv`
procedure TDDSDCapture.Start(wait: Boolean);
begin
  //ƂĂȂȂAA
  if not FInitialized then
    exit;

  //Lv`ȂȂɂȂ
  if Status <> 0 then
    exit;

  //Lv`
  Buffer.Start(0);

  //waitTrueȂLv`I܂ő҂
  if wait then
    while Status <> 0 do
      ;
end;

//ƃLv`
procedure TDDSDCapture.StartLoop;
begin
  //ƂĂȂȂAA
  if not FInitialized then
    exit;

  //Lv`ȂȂɂȂ
  if Status <> 0 then
    exit;

  //Lv`Jn
  Buffer.Start(DSCBSTART_LOOPING);
end;

//Lv`I
procedure TDDSDCapture.Stop;
begin
  //ƂĂȂȂAA
  if not FInitialized then
    exit;

  Buffer.Stop;
end;

//L̂Ƃ܂Ř^ł
procedure TDDSDCapture.Sync;
begin
  if Assigned(FOnRecording) then begin
    if FNotifyThread.IsTop then
      FOnRecording(Self, FLength - FHalfPos,FHalfPos)
    else
      FOnRecording(Self,0, FHalfPos);
  end;
end;

//ubN]
procedure TDDSDCapture.BlockCopy(offset: DWord; dest: Pointer;
  length: DWord);
var
  len1,len2:DWord;
  pBuf1,pBuf2:Pointer;
begin
  //ƂĂȂȂAA
  if not FInitialized then
    exit;

  //bN
  TRYDS(FCaptureBuffer.Lock(offset,length,pBuf1,@len1,pBuf2,@len2,0), 'DirectSoundCaptureBuffer̃bNɎs܂');

  //Buf1Rs[
  Move(pBuf1^,dest^,len1);

  //Buf2Rs[
  if len1 < length then begin
    Inc(pByte(dest),len1);
    Move(pBuf2^,dest^,len2);
  end;

  //AbN
  FCaptureBuffer.Unlock(pBuf1,len1,pBuf2,len2);
end;



//T|[gĂtH[}bg̃`FbN
function TDDSDCapture.IsSupportedFormat(freq, bps: DWord;
  isStereo: Boolean): Boolean;
var
  caps:DSCCAPS;
begin
  //ɎsĂȂAI
  if not FInitialized then begin
    result:=False;
    exit;
  end;

  DSCapture.GetCaps(@caps);

  if (caps.dwFormats And BufferFormatToDWord(freq,bps,IsStereo)) <> 0 then
    result:=True
  else
    result:=False;
end;


//Lv`obt@̃tH[}bgݒ
procedure TDDSDCapture.SetupCaptureBuffer(freq, bps: DWord;
  isStereo: Boolean; length: DWord);
var
  desc:DSCBUFFERDESC;
  pn:Array[0..2] of DSBPOSITIONNOTIFY;
begin
  //ɎsĂȂAI
  if not FInitialized then begin
    exit;
  end;

  //ɊmۂĂȂA
  if Assigned(FCaptureBuffer) then
    FCaptureBuffer.Release;


  //vpeBɔf
  FLength:=length;
  FHalfPos:=length shr 1;

  //Lv`tH[}bg̐ݒ
  with FWaveFormat do begin
    wFormatTag:=WAVE_FORMAT_PCM;
    if isStereo then
      nChannels:=2
    else
      nChannels:=1;
    nSamplesPerSec:=freq;
    nBlockAlign:=nChannels * bps div 8;
    nAvgBytesPerSec:=freq * nBlockAlign;
    wBitsPerSample:=bps;
    cbSize:=0;
  end;

  //Lv`obt@̃tH[}bgݒ
  ZeroMemory(@desc,sizeof(desc));
  with desc do begin
    dwSize:=Sizeof(desc);
    dwBufferBytes:=length;
    lpwfxFormat:=@FWaveFormat;
  end;

  //Lv`obt@̐
  TRYDS(DSCapture.CreateCaptureBuffer(@desc, FCaptureBuffer, Nil), 'DirectSoundCaptureBufferIuWFNg̐Ɏs܂B');


  (* ʒmpXbh̐ݒ *)

  //CxgIuWFNg̐
  FEvent[0]:=CreateEvent(Nil,False,False,Nil);
  FEvent[1]:=CreateEvent(Nil,False,False,Nil);
  FEvent[2]:=CreateEvent(Nil,False,False,Nil);

  //Cxg̐ݒ
  pn[0].dwOffset:=0;  //擪
  pn[0].hEventNotify:=FEvent[0];

  pn[1].dwOffset:=FHalfPos;  //^
  pn[1].hEventNotify:=FEvent[1];

  pn[2].dwOffset:=DSBPN_OFFSETSTOP;  //Đ~
  pn[2].hEventNotify:=FEvent[2];

  //m[eBt@CIuWFNg̍쐬
  TRYDS(FCaptureBuffer.QueryInterface(IID_IDirectSoundNotify,FDSNotify),'DirectSoundNotifyIuWFNg̍쐬Ɏs܂');
  TRYDS(FDSNotify.SetNotificationPositions(3,@pn), 'NotifyPosition̐ݒɎs܂');

  //CxgʒmpXbh̍쐬
  FNotifyThread:=TDDSDCaptureNotifyThread.Create(Self);
  //FnotifyThread.Priority:=tpHigher;
end;



end.
