unit DX3DRap;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

{$DEFINE usedx3d} // Direct-XgȂ̓RgAEgB(Direct-XgȂWindows95ł悤ɂȂ܂BԂB)

function dx3dEnabled:boolean;
procedure dx3dLoadWindow;
procedure dx3dFreeMemory;
procedure dx3dSetVisible(v:boolean);
procedure dx3dChangePosition;
procedure dx3dDDVisParamInit;
procedure dx3dDDVis;

implementation

uses
{$IFDEF usedx3d}
     DX3DWin,
{$ENDIF}
     _MDXWinINI,_Vis_const;

var
  DX3DLoadFlag:boolean;

function dx3dEnabled:boolean;
begin
{$IFDEF usedx3d}
  Result:=True;
{$ENDIF}

{$IFNDEF usedx3d}
  Result:=False;
{$ENDIF}
end;

procedure dx3dLoadWindow;
begin
{$IFDEF usedx3d}
  if DX3DLoadFlag=False then begin
    DX3DLoadFlag:=True;
    Application.CreateForm(TDX3D, DX3D);
    DX3D.Color:=$000000;
    DX3D.ChangePosition;
  end;
{$ENDIF}
end;

procedure dx3dFreeMemory;
begin
{$IFDEF usedx3d}
  if DX3DLoadFlag=True then begin
    VisINI.Effect3DRot:=trunc(DX3D.Rot*1000);
    VisINI.Effect3DRotAuto:=DX3D.RotAuto;
    DX3D.Visible:=False;
    Application.ProcessMessages;
    DX3D.FreeMemory;
    DX3D.Free;
    DX3D:=nil;
  end;
{$ENDIF}
end;

procedure dx3dSetVisible(v:boolean);
begin
{$IFDEF usedx3d}
  if DX3DLoadFlag=True then begin
    if v=False then DX3D.Visible:=False;
    if v=True then begin
      if (VisINI.VisualMode<>VisualModeKeyboard) and (VisINI.VisualMode<>VisualModeSonar) and (VisINI.VisualMode<>VisualModeMDXDis) then begin
        DX3D.Visible:=True;
      end;
    end;
  end;
{$ENDIF}
end;

procedure dx3dChangePosition;
begin
{$IFDEF usedx3d}
  if DX3DLoadFlag=True then DX3D.ChangePosition;
{$ENDIF}
end;

procedure dx3dDDVisParamInit;
begin
{$IFDEF usedx3d}
  if DX3DLoadFlag=True then DX3D.DDVisParamInit;
{$ENDIF}
end;

procedure dx3dDDVis;
begin
{$IFDEF usedx3d}
  if DX3DLoadFlag=True then DX3D.DDVis;
{$ENDIF}
end;

begin
  DX3DLoadFlag:=False;

end.
