unit waveencExistDlg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TwaveencExist = class(TForm)
    FilenameLbl: TLabel;
    Label2: TLabel;
    SkipBtn: TButton;
    OverrideBtn: TButton;
    CancelBtn: TButton;
    TitleLbl: TLabel;
    procedure OverrideBtnClick(Sender: TObject);
    procedure SkipBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    procedure SetPosition(src:TForm);
    procedure SetInfo(idx,idxCount:integer;Filename,Title:string);
  end;

var
  waveencExist: TwaveencExist;

implementation

{$R *.dfm}

procedure TwaveEncExist.SetPosition(src:TForm);
begin
  Left:=src.Left+((src.Width-Width) div 2);
  Top:=src.Top+((src.Height-Height) div 2);
end;

procedure TwaveEncExist.SetInfo(idx,idxCount:integer;Filename,Title:string);
begin
  Caption:=format('I [%d/%d]',[idx,idxCount]);
  FilenameLbl.Caption:=Filename;
  TitleLbl.Caption:=Title;
end;

procedure TwaveencExist.OverrideBtnClick(Sender: TObject);
begin
  ModalResult:=mrOK;
end;

procedure TwaveencExist.SkipBtnClick(Sender: TObject);
begin
  ModalResult:=mrIgnore;
end;

procedure TwaveencExist.CancelBtnClick(Sender: TObject);
begin
  ModalResult:=mrCancel;
end;

end.
