/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class KunststoffTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final int SHADOW_WIDTH = 5;

    public static ComponentUI createUI(JComponent c2) {
        return new KunststoffTabbedPaneUI();
    }

    protected void installDefaults() {
        super.installDefaults();
    }

    protected void paintTab(Graphics g2, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        Rectangle gradientRect;
        super.paintTab(g2, tabPlacement, rects, tabIndex, iconRect, textRect);
        Graphics2D g2D = (Graphics2D)g2;
        Rectangle tabRect = rects[tabIndex];
        ColorUIResource colorShadow = KunststoffLookAndFeel.getComponentGradientColorShadow();
        Color colorShadowFaded = KunststoffUtilities.getTranslucentColor(colorShadow, 0);
        ColorUIResource colorReflection = KunststoffLookAndFeel.getComponentGradientColorReflection();
        Color colorReflectionFaded = KunststoffUtilities.getTranslucentColor(colorReflection, 0);
        int selectedIndex = this.tabPane.getSelectedIndex();
        if (this.lastTabInRun(this.tabPane.getTabCount(), this.selectedRun) != selectedIndex) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                if (tabIndex == selectedIndex + 1) {
                    gradientRect = new Rectangle((int)tabRect.getX(), (int)tabRect.getY(), 5, (int)tabRect.getHeight());
                    KunststoffUtilities.drawGradient(g2, colorShadow, colorShadowFaded, gradientRect, false);
                }
            } else if (tabIndex == selectedIndex + 1) {
                gradientRect = new Rectangle((int)tabRect.getX(), (int)tabRect.getY(), (int)tabRect.getWidth(), 5);
                KunststoffUtilities.drawGradient(g2, colorShadow, colorShadowFaded, gradientRect, true);
            }
        }
        if (tabPlacement == 1) {
            gradientRect = new Rectangle((int)tabRect.getX(), (int)tabRect.getY(), (int)tabRect.getWidth(), 5);
            KunststoffUtilities.drawGradient(g2, colorReflection, colorReflectionFaded, gradientRect, true);
        } else if (tabPlacement == 3) {
            if (tabIndex != selectedIndex) {
                gradientRect = new Rectangle((int)tabRect.getX(), (int)tabRect.getY(), (int)tabRect.getWidth(), 5);
                KunststoffUtilities.drawGradient(g2, colorShadow, colorShadowFaded, gradientRect, true);
            }
        } else if (tabPlacement == 4 && tabIndex != selectedIndex) {
            gradientRect = new Rectangle((int)tabRect.getX(), (int)tabRect.getY(), 5, (int)tabRect.getHeight());
            KunststoffUtilities.drawGradient(g2, colorShadow, colorShadowFaded, gradientRect, false);
        }
    }

    protected void paintTabBackground(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        if (isSelected) {
            g2.setColor(UIManager.getColor("TabbedPane.selected"));
        } else {
            g2.setColor(this.tabPane.getBackgroundAt(tabIndex));
        }
        switch (tabPlacement) {
            case 2: {
                g2.fillRect(x + 1, y + 1, w - 2, h2 - 3);
                break;
            }
            case 4: {
                g2.fillRect(x, y + 1, w - 2, h2 - 3);
                break;
            }
            case 3: {
                g2.fillRect(x + 1, y, w - 3, h2 - 1);
                break;
            }
            default: {
                g2.fillRect(x + 1, y + 1, w - 3, h2 - 1);
            }
        }
    }

    static {
        SHADOW_WIDTH = 5;
    }
}

