/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.io.Serializable;

public class VerticalFlowLayout
extends FlowLayout
implements Serializable {
    public static final int TOP = 0;
    public static final int sc = 1;
    public static final int BOTTOM = 2;
    int tc;
    int uc;
    boolean vc;
    boolean wc;

    public VerticalFlowLayout() {
        this(0, 5, 5, true, false);
    }

    public VerticalFlowLayout(boolean bl, boolean bl2) {
        this(0, 5, 5, bl, bl2);
    }

    public VerticalFlowLayout(int n2) {
        this(n2, 5, 5, true, false);
    }

    public VerticalFlowLayout(int n2, boolean bl, boolean bl2) {
        this(n2, 5, 5, bl, bl2);
    }

    public VerticalFlowLayout(int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.setAlignment(n2);
        this.tc = n3;
        this.uc = n4;
        this.vc = bl;
        this.wc = bl2;
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n2 = 0;
        while (n2 < container.getComponentCount()) {
            Component component = container.getComponent(n2);
            if (component.isVisible()) {
                Dimension dimension2 = component.getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                if (n2 > 0) {
                    dimension.height += this.tc;
                }
                dimension.height += dimension2.height;
            }
            ++n2;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right + this.tc * 2;
        dimension.height += insets.top + insets.bottom + this.uc * 2;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n2 = 0;
        while (n2 < container.getComponentCount()) {
            Component component = container.getComponent(n2);
            if (component.isVisible()) {
                Dimension dimension2 = component.getMinimumSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                if (n2 > 0) {
                    dimension.height += this.uc;
                }
                dimension.height += dimension2.height;
            }
            ++n2;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right + this.tc * 2;
        dimension.height += insets.top + insets.bottom + this.uc * 2;
        return dimension;
    }

    public void setVerticalFill(boolean bl) {
        this.wc = bl;
    }

    public boolean getVerticalFill() {
        return this.wc;
    }

    public void setHorizontalFill(boolean bl) {
        this.vc = bl;
    }

    public boolean getHorizontalFill() {
        return this.vc;
    }

    private void placethem(Container container, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = this.getAlignment();
        if (n8 == 1) {
            n3 += n5 / 2;
        }
        if (n8 == 2) {
            n3 += n5;
        }
        int n9 = n6;
        while (n9 < n7) {
            Component component = container.getComponent(n9);
            Dimension dimension = component.getSize();
            if (component.isVisible()) {
                int n10 = n2 + (n4 - dimension.width) / 2;
                component.setLocation(n10, n3);
                n3 += this.uc + dimension.height;
            }
            ++n9;
        }
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n2 = container.getSize().height - (insets.top + insets.bottom + this.uc * 2);
        int n3 = container.getSize().width - (insets.left + insets.right + this.tc * 2);
        int n4 = container.getComponentCount();
        int n5 = insets.left + this.tc;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n4) {
            Component component = container.getComponent(n9);
            if (component.isVisible()) {
                Dimension dimension = component.getPreferredSize();
                if (this.wc && n9 == n4 - 1) {
                    dimension.height = Math.max(n2 - n6, component.getPreferredSize().height);
                }
                if (this.vc) {
                    component.setSize(n3, dimension.height);
                    dimension.width = n3;
                } else {
                    component.setSize(dimension.width, dimension.height);
                }
                if (n6 + dimension.height > n2) {
                    this.placethem(container, n5, insets.top + this.uc, n7, n2 - n6, n8, n9);
                    n6 = dimension.height;
                    n5 += this.tc + n7;
                    n7 = dimension.width;
                    n8 = n9;
                } else {
                    if (n6 > 0) {
                        n6 += this.uc;
                    }
                    n6 += dimension.height;
                    n7 = Math.max(n7, dimension.width);
                }
            }
            ++n9;
        }
        this.placethem(container, n5, insets.top + this.uc, n7, n2 - n6, n8, n4);
    }
}

