/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Branch;
import org.dom4j.Comment;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.tree.AbstractNode;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.ContentListFacade;

public abstract class AbstractBranch
extends AbstractNode
implements Branch {
    protected static final OutputFormat HVd;
    protected static final int F3d = 5;
    private static String bb = "\uad66\uad6b";
    private static String cb = "";
    private static String db = "\uad0f";
    private static String eb = "\uad66\uad41\uad59\uad4e\uad43\uad46\uad4b\uad0f\uad41\uad40\uad4b\uad4a\uad0f\uad5b\uad56\uad5f\uad4a\uad01\uad0f\uad6c\uad4e\uad41\uad41\uad40\uad5b\uad0f\uad4e\uad4b\uad4b\uad0f\uad41\uad40\uad4b\uad4a\uad15\uad0f";
    private static String fb = "\uad0f\uad5b\uad40\uad0f\uad5b\uad47\uad46\uad5c\uad0f\uad4d\uad5d\uad4e\uad41\uad4c\uad47\uad15\uad0f";

    public void setProcessingInstructions(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)iterator.next();
            this.addNode(processingInstruction);
        }
    }

    public void add(Comment comment) {
        this.addNode(comment);
    }

    public void add(Element element) {
        this.addNode(element);
    }

    public void add(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                this.add((Element)node);
                break;
            }
            case 8: {
                this.add((Comment)node);
                break;
            }
            case 7: {
                this.add((ProcessingInstruction)node);
                break;
            }
            default: {
                this.invalidNodeTypeAddException(node);
            }
        }
    }

    public void add(ProcessingInstruction processingInstruction) {
        this.addNode(processingInstruction);
    }

    public Element addElement(String string) {
        Element element = this.getDocumentFactory().createElement(string);
        this.add(element);
        return element;
    }

    public Element addElement(String string, String string2) {
        Element element = this.getDocumentFactory().createElement(string, string2);
        this.add(element);
        return element;
    }

    public Element addElement(String string, String string2, String string3) {
        Namespace namespace = Namespace.get(string2, string3);
        QName qName = this.getDocumentFactory().createQName(string, namespace);
        return this.addElement(qName);
    }

    public Element addElement(QName qName) {
        Element element = this.getDocumentFactory().createElement(qName);
        this.add(element);
        return element;
    }

    protected abstract void addNode(Node var1);

    public void appendContent(Branch branch) {
        int n2 = 0;
        int n3 = branch.nodeCount();
        while (n2 < n3) {
            Node node = branch.node(n2);
            this.add((Node)node.clone());
            ++n2;
        }
    }

    protected abstract void childAdded(Node var1);

    protected abstract void childRemoved(Node var1);

    public abstract void clearContent();

    public List content() {
        List list = this.contentList();
        return new ContentListFacade(this, list);
    }

    protected abstract List contentList();

    protected void contentRemoved() {
        List list = this.contentList();
        int n2 = 0;
        int n3 = list.size();
        while (n2 < n3) {
            Object e2 = list.get(n2);
            if (e2 instanceof Node) {
                this.childRemoved((Node)e2);
            }
            ++n2;
        }
    }

    protected List createContentList() {
        return new ArrayList(5);
    }

    protected List createContentList(int n2) {
        return new ArrayList(n2);
    }

    protected List createEmptyList() {
        return new BackedList(this, this.contentList(), 0);
    }

    protected BackedList createResultList() {
        return new BackedList(this, this.contentList());
    }

    protected List createSingleResultList(Object object) {
        BackedList backedList = new BackedList(this, this.contentList(), 1);
        backedList.addLocal(object);
        return backedList;
    }

    public Element elementByID(String string) {
        int n2 = 0;
        int n3 = this.nodeCount();
        while (n2 < n3) {
            Node node = this.node(n2);
            if (node instanceof Element) {
                Element element = (Element)node;
                String string2 = this.elementID(element);
                if (string2 != null && string2.equals(string)) {
                    return element;
                }
                if ((element = element.elementByID(string)) != null) {
                    return element;
                }
            }
            ++n2;
        }
        return null;
    }

    protected String elementID(Element element) {
        return element.attributeValue(bb);
    }

    protected String getContentAsStringValue(Object object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            switch (node.getNodeType()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    return node.getStringValue();
                }
                default: {
                    return cb;
                }
            }
        }
        if (object instanceof String) {
            return (String)object;
        }
        return cb;
    }

    protected String getContentAsText(Object object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            switch (node.getNodeType()) {
                case 3: 
                case 4: 
                case 5: {
                    return node.getText();
                }
                default: {
                    return cb;
                }
            }
        }
        if (object instanceof String) {
            return (String)object;
        }
        return cb;
    }

    public String getText() {
        int n2;
        List list = this.contentList();
        if (list != null && (n2 = list.size()) >= 1) {
            Object e2 = list.get(0);
            String string = this.getContentAsText(e2);
            if (n2 == 1) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            int n3 = 1;
            while (n3 < n2) {
                Object e3 = list.get(n3);
                stringBuffer.append(this.getContentAsText(e3));
                ++n3;
            }
            return stringBuffer.toString();
        }
        return cb;
    }

    public String getTextTrim() {
        String string = this.getText();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2);
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(db);
        }
        return stringBuffer.toString();
    }

    public boolean hasContent() {
        return this.nodeCount() > 0;
    }

    public int indexOf(Node node) {
        return this.contentList().indexOf(node);
    }

    protected void invalidNodeTypeAddException(Node node) {
        throw new IllegalAddException(eb + node + fb + this);
    }

    public boolean isReadOnly() {
        return false;
    }

    public Node node(int n2) {
        Object e2 = this.contentList().get(n2);
        if (e2 instanceof Node) {
            return (Node)e2;
        }
        if (e2 instanceof String) {
            return this.getDocumentFactory().createText(e2.toString());
        }
        return null;
    }

    public int nodeCount() {
        return this.contentList().size();
    }

    public Iterator nodeIterator() {
        return this.contentList().iterator();
    }

    public abstract void normalize();

    public abstract ProcessingInstruction processingInstruction(String var1);

    public abstract List processingInstructions();

    public abstract List processingInstructions(String var1);

    public boolean remove(Comment comment) {
        return this.removeNode(comment);
    }

    public boolean remove(Element element) {
        return this.removeNode(element);
    }

    public boolean remove(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                return this.remove((Element)node);
            }
            case 8: {
                return this.remove((Comment)node);
            }
            case 7: {
                return this.remove((ProcessingInstruction)node);
            }
        }
        this.invalidNodeTypeAddException(node);
        return false;
    }

    public boolean remove(ProcessingInstruction processingInstruction) {
        return this.removeNode(processingInstruction);
    }

    protected abstract boolean removeNode(Node var1);

    public abstract boolean removeProcessingInstruction(String var1);

    public abstract void setContent(List var1);

    static {
        bb = AbstractBranch.$decryptString$org$dom4j$tree$AbstractBranch(bb);
        cb = AbstractBranch.$decryptString$org$dom4j$tree$AbstractBranch(cb);
        db = AbstractBranch.$decryptString$org$dom4j$tree$AbstractBranch(db);
        eb = AbstractBranch.$decryptString$org$dom4j$tree$AbstractBranch(eb);
        fb = AbstractBranch.$decryptString$org$dom4j$tree$AbstractBranch(fb);
        HVd = new OutputFormat();
    }

    private static String $decryptString$org$dom4j$tree$AbstractBranch(String string) {
        int n2 = string.length();
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = (char)(string.charAt(i2) ^ 0xFFFEAD2F);
        }
        return new String(cArray);
    }
}

