/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class QNameCache {
    protected Map mc = new HashMap();
    protected Map nc = new HashMap();
    private DocumentFactory M3d;

    public QNameCache() {
    }

    public QNameCache(DocumentFactory documentFactory) {
        this.M3d = documentFactory;
    }

    protected Map createMap() {
        return new HashMap();
    }

    protected QName createQName(String string) {
        return new QName(string);
    }

    protected QName createQName(String string, Namespace namespace) {
        return new QName(string, namespace);
    }

    protected QName createQName(String string, Namespace namespace, String string2) {
        return new QName(string, namespace, string2);
    }

    public QName get(String string) {
        QName qName = (QName)this.mc.get(string);
        if (qName == null) {
            qName = this.createQName(string);
            qName.setDocumentFactory(this.M3d);
            this.mc.put(string, qName);
        }
        return qName;
    }

    public QName get(String string, String string2) {
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return this.get(string, Namespace.get(string2));
        }
        String string3 = string.substring(n2 + 1);
        String string4 = string.substring(0, n2);
        return this.get(string3, Namespace.get(string4, string2));
    }

    public QName get(String string, Namespace namespace) {
        Map map = this.getNamespaceCache(namespace);
        QName qName = (QName)map.get(string);
        if (qName == null) {
            qName = this.createQName(string, namespace);
            qName.setDocumentFactory(this.M3d);
            map.put(string, qName);
        }
        return qName;
    }

    public QName get(String string, Namespace namespace, String string2) {
        Map map = this.getNamespaceCache(namespace);
        QName qName = (QName)map.get(string);
        if (qName == null) {
            qName = this.createQName(string, namespace, string2);
            qName.setDocumentFactory(this.M3d);
            map.put(string, qName);
        }
        return qName;
    }

    protected Map getNamespaceCache(Namespace namespace) {
        if (namespace == Namespace.D3d) {
            return this.mc;
        }
        Map map = (Map)this.nc.get(namespace);
        if (map == null) {
            map = this.createMap();
            this.nc.put(namespace, map);
        }
        return map;
    }

    public List getQNames() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.mc.values());
        Iterator iterator = this.nc.values().iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            arrayList.addAll(map.values());
        }
        return arrayList;
    }

    public QName intern(QName qName) {
        return this.get(qName.getName(), qName.getNamespace(), qName.getQualifiedName());
    }
}

