diff -Naur seal-1.07.orig/include/audio.h seal-1.07/include/audio.h
--- seal-1.07.orig/include/audio.h	Fri Jul 30 01:07:00 1999
+++ seal-1.07/include/audio.h	Tue May 14 13:09:44 2002
@@ -89,6 +89,7 @@
 #define AUDIO_FORMAT_REVERSE            0x0080
 #define AUDIO_FORMAT_MONO               0x0000
 #define AUDIO_FORMAT_STEREO             0x0100
+#define AUDIO_FORMAT_RAW_SAMPLE         0x4000
 #define AUDIO_FORMAT_FILTER             0x8000
 
 /* audio resource limits defines */
diff -Naur seal-1.07.orig/src/DOS/DPMI32/DJGPP/Makefile seal-1.07/src/DOS/DPMI32/DJGPP/Makefile
--- seal-1.07.orig/src/DOS/DPMI32/DJGPP/Makefile	Fri Jul 30 01:07:00 1999
+++ seal-1.07/src/DOS/DPMI32/DJGPP/Makefile	Tue May 14 13:09:44 2002
@@ -5,7 +5,7 @@
 RANLIB = ranlib
 STRIP = strip
 COFF2EXE = stubify
-CFLAGS = -c -Wall -mpentium -O2 -D__DPMI__ -D__ASM__
+CFLAGS = -c -Wall -mcpu=pentium -O2 -D__DPMI__ -D__ASM__
 LFLAGS =
 
 #OBJS = audio.o wavfile.o xmfile.o s3mfile.o modfile.o mtmfile.o \
diff -Naur seal-1.07.orig/src/audio.h seal-1.07/src/audio.h
--- seal-1.07.orig/src/audio.h	Fri Jul 30 01:07:00 1999
+++ seal-1.07/src/audio.h	Tue May 14 13:09:44 2002
@@ -89,6 +89,7 @@
 #define AUDIO_FORMAT_REVERSE            0x0080
 #define AUDIO_FORMAT_MONO               0x0000
 #define AUDIO_FORMAT_STEREO             0x0100
+#define AUDIO_FORMAT_RAW_SAMPLE         0x4000
 #define AUDIO_FORMAT_FILTER             0x8000
 
 /* audio resource limits defines */
diff -Naur seal-1.07.orig/src/mixdrv.c seal-1.07/src/mixdrv.c
--- seal-1.07.orig/src/mixdrv.c	Fri Jul 30 01:07:00 1999
+++ seal-1.07/src/mixdrv.c	Tue May 14 13:09:44 2002
@@ -78,6 +78,8 @@
 LPLONG lpVolumeTable;
 LPBYTE lpFilterTable;
 
+static signed int MixerValue = 0;
+
 static VOID AIAPI UpdateVoices(LPBYTE lpData, UINT nCount);
 
 /* low level resamplation and quantization routines */
@@ -412,6 +414,61 @@
 
 #endif
 
+static VOID AIAPI
+MixAudioData16MRaw(LPLONG lpBuffer, UINT nCount, LPVOICE lpVoice)
+{
+    signed int a;
+
+    DWORD accum, delta;
+    signed long* buf;
+    signed short* data;
+
+    accum = lpVoice->dwAccum;
+    delta = lpVoice->dwFrequency;
+    data = lpVoice->lpData;
+    buf = lpBuffer;
+
+
+    do {
+	a = data[accum >> ACCURACY];
+	a = (a*MixerValue)>>8; //since MixerValue is in 0-256 range
+	buf[0] += a;
+	accum += delta;
+        buf++;
+    } while (--nCount != 0);
+
+    lpVoice->dwAccum = accum;
+}
+
+static VOID AIAPI
+MixAudioData16SRaw(LPLONG lpBuffer, UINT nCount, LPVOICE lpVoice)
+{
+    signed int a;
+    DWORD accum, delta;
+    signed long* buf;
+    signed short* data;
+
+    accum = lpVoice->dwAccum;
+    delta = lpVoice->dwFrequency;
+    data = lpVoice->lpData;
+    buf = lpBuffer;
+
+    if (lpVoice->nPanning >= 0x80)
+	buf++; //set pointer to right channel
+
+    do {
+	a = data[accum >> ACCURACY];
+	a = (a*MixerValue)>>8; //since MixerValue is in 0-256 range
+	buf[0] += a;
+	//buf[1] += 0; //skip the other channel
+	accum += delta;
+	buf += 2;
+    } while (--nCount != 0);
+
+    lpVoice->dwAccum = accum;
+}
+
+
 static VOID MixAudioData(LPLONG lpBuffer, UINT nCount, LPVOICE lpVoice)
 {
     UINT nSize;
@@ -549,8 +606,18 @@
     else {
 	Synth.lpfnMixAudioProc[0] = (Synth.wFormat & AUDIO_FORMAT_STEREO) ?
 	    MixAudioData08S : MixAudioData08M;
-	Synth.lpfnMixAudioProc[1] = (Synth.wFormat & AUDIO_FORMAT_STEREO) ?
-	    MixAudioData16S : MixAudioData16M;
+
+	if (Synth.wFormat & AUDIO_FORMAT_RAW_SAMPLE)
+	{
+		Synth.lpfnMixAudioProc[1] = (Synth.wFormat & AUDIO_FORMAT_STEREO) ?
+		    MixAudioData16SRaw : MixAudioData16MRaw;
+	}
+	else
+	{
+		Synth.lpfnMixAudioProc[1] = (Synth.wFormat & AUDIO_FORMAT_STEREO) ?
+		    MixAudioData16S : MixAudioData16M;
+	}
+
     }
 
     /* allocate volume (0-64) and filter (0-31) table */
@@ -587,6 +654,8 @@
     /* master volume must be less than 256 units */
     if (nChannel != AUDIO_MIXER_MASTER_VOLUME || nMixerValue > 256)
 	return AUDIO_ERROR_INVALPARAM;
+
+    MixerValue = nMixerValue;
 
     /* half dynamic range for mono output */
     if (!(Synth.wFormat & AUDIO_FORMAT_STEREO))
diff -Naur seal-1.07.orig/src/nondrv.c seal-1.07/src/nondrv.c
--- seal-1.07.orig/src/nondrv.c	Fri Jul 30 01:07:00 1999
+++ seal-1.07/src/nondrv.c	Tue May 14 13:09:44 2002
@@ -21,10 +21,9 @@
 #else
 #include "msdos.h"
 #define AAD(val) (((val)&15)+10*((val)>>4))
-typedef unsigned long time_t;
-static time_t time(time_t *t)
+static unsigned long time(time_t *t)
 {
-    long secs, val;
+    unsigned long secs, val;
 
     /* secs */
     OUTB(0x70, 0x00);
diff -Naur seal-1.07.orig/src/sbdrv.c seal-1.07/src/sbdrv.c
--- seal-1.07.orig/src/sbdrv.c	Fri Jul 30 01:07:00 1999
+++ seal-1.07/src/sbdrv.c	Tue May 14 13:09:44 2002
@@ -323,6 +323,11 @@
 {
     DWORD dwBytesPerSecond;
 
+	DEBUG(printf("DSPStartPlayback: reset DSP processor\n"));
+
+    /* reset the DSP processor */
+    DSPReset();
+
     DEBUG(printf("DSPStartPlayback: set DMA %d and IRQ %d resources\n", SB.nDmaChannel, SB.nIrqLine));
 
     /* setup the DMA channel parameters */
@@ -330,11 +335,6 @@
 
     /* setup our IRQ interrupt handler */
     DosSetVectorHandler(SB.nIrqLine, DSPInterruptHandler);
-
-    DEBUG(printf("DSPStartPlayback: reset DSP processor\n"));
-
-    /* reset the DSP processor */
-    DSPReset();
 
     DEBUG(printf("DSPStartPlayback: turn on speaker\n"));
 
