/*
 * SBGEN - Super Bombe Generator.
 *
 * Public domain software.
 *
 * Author Nik Shaylor (nshaylor@tcp.co.uk)
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int  startPosition = 0;
int  letterPairs[26][26];
char plain[80];
char cipher[80];
char position[80];

    
void write_setOnCable( int cable, char done[] )
    {
    int i;

    printf( "\n\nvoid setOnCable%c( int ch )\n", cable+65 );
    printf( "    {\n" );
    printf( "    if( cable%c[ch] == 0 )\n", cable+65 );
    printf( "        {\n" );
    printf( "        cable%c[ch] = 1;\n", cable+65 );
    for( i = 0 ; i < 26 ; i++ )
        {
        char pos = letterPairs[cable][i];
        
        if( pos != -1 )
            printf( "        setOnCable%c( scramble( %d, ch ) );\n",
                                        i+65, pos+startPosition );
        }
    printf( "        setDiagonal( ch, Letter%c );\n", cable+65 );
    printf( "        }\n" );
    printf( "    }\n" );    
    }


void write_main( int testCable, int testWire )
    {
    printf( "\n\nvoid main()\n" );
    printf( "    {\n" );    
    printf( "    plainText  = \"%s\";\n",plain );
    printf( "    cipherText = \"%s\";\n",cipher );
    printf( "    testCable  = %d;\n", testCable );
    printf( "    testWire   = %d;\n", testWire  );
    printf( "    realMain();\n" );
    printf( "    }\n" );
    }


void getString( char str[], char from[] )
    {
    int ch, i=0;
    
    while( (ch = from[i]) != '\0' )
        {
        if( ch >= 'a' && ch <= 'z' )
            ch -= ( 'a' - 'A');
            
        if( ch < 'A' || ch > 'Z' )
            {
            fprintf( stderr, "Bad character %c in input\n", ch );
            exit( 999 );            
            }

        str[i++] = ch;
        }
        
    str[i] = '\0';
    }


void main( int argc, char *argv[] )
    {
    int ch1, ch2, max, best, i, j;
    char done[26];

    if( argc < 3 || argc > 4 )
        {
        fprintf( stderr, "usage: bombgen <plain> <cipher> [<position>]\n" );
        exit( 999 );
        }
        
    getString( plain, argv[1] );
    getString( cipher, argv[2] );

    if( argc == 4 )
        {
        getString( position, argv[3] );
        startPosition = atoi( position );
        }

    if( strlen( plain ) != strlen( cipher ) )
        {
        fprintf( stderr, "Plain and cipher not same length" );
        exit( 999 );
        }

    for( i = 0 ; i < 26 ; i++ )
        for( j = 0 ; j < 26 ; j++ )
            letterPairs[i][j] = -1;

    for( i = 0 ; i < (int)strlen( plain ) ; i++ )
        {
        ch1 = plain[i]  - 65;
        ch2 = cipher[i] - 65;
        letterPairs[ch1][ch2] = i;
        letterPairs[ch2][ch1] = i;     
        }
   
    printf( "#include \"sb.h\"\n\n" );    
    
    for( j = 0 ; j < 26 ; j++ )
        write_setOnCable( j, done );

    max = 0;
    best = 0;

    for( i = 0 ; i < 26 ; i++ )
        {
        int count = 0;

        for( j = 0 ; j < 26 ; j++ )
            {
            if( letterPairs[i][j] != -1 )
                count++;
            }
        
        if( count > 0 )
            fprintf( stderr, "%c%d ", i+65, count );

        if( max < count )
            {
            max = count;
            best = i;
            }
        }

    write_main( best, best );    
    }
