/*
 * Decompiled with CFR 0.152.
 */
package gnu.vnc.awt.swing;

import gnu.awt.PixelsOwner;
import gnu.awt.virtual.swing.VirtualJFrame;
import gnu.rfb.Colour;
import gnu.rfb.PixelFormat;
import gnu.rfb.server.RFBClient;
import gnu.rfb.server.RFBClients;
import gnu.rfb.server.RFBServer;
import gnu.vnc.awt.VNCEvents;
import gnu.vnc.awt.swing.VNCRepaintManager;
import java.awt.Insets;
import java.awt.image.DirectColorModel;
import java.io.IOException;

public class VNCJFrame
extends VirtualJFrame
implements RFBServer {
    private RFBClients clients = new RFBClients();
    private VNCEvents events = new VNCEvents(this, this.clients);
    private boolean shared = false;
    private VNCRepaintManager repaintManager = new VNCRepaintManager((PixelsOwner)this, this.clients);

    public VNCJFrame(String name, int width, int height) {
        super(name);
        VNCRepaintManager.setCurrentManager(this.repaintManager);
        this.setSize(width, height);
        super.setResizable(false);
        this.setVisible(true);
    }

    @Override
    public void dispose() {
        this.clients.closeAll();
        super.dispose();
    }

    @Override
    public void addClient(RFBClient client) {
        this.clients.addClient(client);
    }

    @Override
    public void removeClient(RFBClient client) {
        this.clients.removeClient(client);
    }

    @Override
    public String getDesktopName(RFBClient client) {
        return this.getTitle();
    }

    @Override
    public int getFrameBufferWidth(RFBClient client) {
        Insets insets = this.getInsets();
        return this.getWidth() - insets.left - insets.right;
    }

    @Override
    public int getFrameBufferHeight(RFBClient client) {
        Insets insets = this.getInsets();
        return this.getHeight() - insets.top - insets.bottom;
    }

    @Override
    public PixelFormat getPreferredPixelFormat(RFBClient client) {
        return PixelFormat.RGB888;
    }

    @Override
    public boolean allowShared() {
        return true;
    }

    @Override
    public void setClientProtocolVersionMsg(RFBClient client, String protocolVersionMsg) throws IOException {
    }

    public void setShared(boolean shared) throws IOException {
        if (shared) {
            this.shared = true;
        }
    }

    @Override
    public void setPixelFormat(RFBClient client, PixelFormat pixelFormat) throws IOException {
        pixelFormat.setDirectColorModel((DirectColorModel)this.getToolkit().getColorModel());
    }

    @Override
    public void setEncodings(RFBClient client, int[] encodings) throws IOException {
    }

    @Override
    public void fixColourMapEntries(RFBClient client, int firstColour, Colour[] colourMap) throws IOException {
    }

    @Override
    public void frameBufferUpdateRequest(RFBClient client, boolean incremental, int x, int y, int w, int h) throws IOException {
        this.repaintManager.frameBufferUpdate(client, incremental, x, y, w, h);
    }

    @Override
    public void keyEvent(RFBClient client, boolean down, int key) throws IOException {
        this.events.translateKeyEvent(client, down, key);
    }

    @Override
    public void pointerEvent(RFBClient client, int buttonMask, int x, int y) throws IOException {
        this.events.translatePointerEvent(client, buttonMask, x, y);
    }

    @Override
    public void clientCutText(RFBClient client, String text) throws IOException {
    }

    @Override
    public void setShared(RFBClient client, boolean shared) throws IOException {
    }
}

