/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.GUI;
import dioscuri.config.AbstractModulePanel;
import dioscuri.config.AtaPanel;
import dioscuri.config.BiosPanel;
import dioscuri.config.BootPanel;
import dioscuri.config.CpuPanel;
import dioscuri.config.Emulator;
import dioscuri.config.FdcPanel;
import dioscuri.config.KeyboardPanel;
import dioscuri.config.MemoryPanel;
import dioscuri.config.MousePanel;
import dioscuri.config.PitPanel;
import dioscuri.config.VideoPanel;
import dioscuri.config.VncPanel;
import dioscuri.interfaces.Module;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConfigDialog
extends JDialog {
    private final Emulator emuConfig;
    private final GUI parent;
    private final Map<Module.Type, AbstractModulePanel> moduleMap;

    public ConfigDialog(GUI gUI) {
        super(gUI.asJFrame());
        this.parent = gUI;
        this.emuConfig = gUI.getEmuConfig();
        this.moduleMap = new LinkedHashMap<Module.Type, AbstractModulePanel>();
        super.setLayout(new BorderLayout(5, 5));
        this.setupModuleMap();
        this.setupGUI();
        super.setSize(gUI.asJFrame().getWidth(), gUI.asJFrame().getHeight());
        super.setLocation(gUI.asJFrame().getLocation());
        super.setResizable(false);
        super.setDefaultCloseOperation(2);
        super.setVisible(true);
    }

    private void loadPanel(JPanel jPanel, JList jList) {
        jPanel.removeAll();
        AbstractModulePanel abstractModulePanel = this.moduleMap.get((Object)((Module.Type)((Object)jList.getSelectedValue())));
        jPanel.add((Component)abstractModulePanel, "North");
        jPanel.validate();
        this.repaint();
    }

    private void setupGUI() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 5, 5));
        final JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
        jPanel3.add(new JLabel("Select a module in the left menu to change its properties."));
        JPanel jPanel4 = new JPanel(new BorderLayout(5, 5));
        jPanel4.setPreferredSize(new Dimension(180, 0));
        jPanel.add((Component)jPanel4, "West");
        jPanel.add((Component)jPanel3, "Center");
        final JList<Module.Type> jList = new JList<Module.Type>(this.moduleMap.keySet().toArray(new Module.Type[this.moduleMap.keySet().size()]));
        jPanel4.add(new JScrollPane(jList));
        jList.setSelectionMode(1);
        jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ConfigDialog.this.loadPanel(jPanel3, jList);
            }
        });
        JButton jButton = new JButton("cancel");
        JButton jButton2 = new JButton("save");
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigDialog.this.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (AbstractModulePanel abstractModulePanel : ConfigDialog.this.moduleMap.values()) {
                    try {
                        abstractModulePanel.saveAndWrite();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                ConfigDialog.this.dispose();
            }
        });
        super.getContentPane().add((Component)jPanel, "Center");
        super.getContentPane().add((Component)jPanel2, "South");
    }

    private void setupModuleMap() {
        this.moduleMap.put(Module.Type.ATA, new AtaPanel(this.parent, this.emuConfig));
        this.moduleMap.put(Module.Type.BIOS, new BiosPanel(this.parent, this.emuConfig));
        this.moduleMap.put(Module.Type.BOOT, new BootPanel(this.parent, this.emuConfig));
        this.moduleMap.put(Module.Type.CPU, new CpuPanel(this.parent, this.emuConfig));
        this.moduleMap.put(Module.Type.FDC, new FdcPanel(this.parent, this.emuConfig));
        this.moduleMap.put(Module.Type.KEYBOARD, new KeyboardPanel(this.parent, this.emuConfig));
        this.moduleMap.put(Module.Type.MOUSE, new MousePanel(this.parent, this.emuConfig));
        this.moduleMap.put(Module.Type.MEMORY, new MemoryPanel(this.parent, this.emuConfig));
        this.moduleMap.put(Module.Type.PIT, new PitPanel(this.parent, this.emuConfig));
        this.moduleMap.put(Module.Type.VIDEO, new VideoPanel(this.parent, this.emuConfig));
        this.moduleMap.put(Module.Type.VNC, new VncPanel(this.parent, this.emuConfig));
    }
}

