/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_SBB_AXIv
implements Instruction {
    private CPU cpu;
    byte[] immediateWord = new byte[2];
    byte[] oldDest = new byte[2];
    int iCarryFlag = 0;
    byte[] temp = new byte[2];

    public Instruction_SBB_AXIv() {
    }

    public Instruction_SBB_AXIv(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.iCarryFlag = this.cpu.flags[0] ? 1 : 0;
        this.immediateWord = this.cpu.getWordFromCode();
        System.arraycopy(this.cpu.ax, 0, this.oldDest, 0, this.cpu.ax.length);
        this.temp = Util.subtractWords(this.cpu.ax, this.immediateWord, this.iCarryFlag);
        System.arraycopy(this.temp, 0, this.cpu.ax, 0, this.temp.length);
        this.cpu.flags[4] = Util.test_AF_SUB(this.oldDest[1], this.cpu.ax[1]);
        this.cpu.flags[0] = Util.test_CF_SUB(this.oldDest, this.immediateWord, this.iCarryFlag);
        this.cpu.flags[11] = Util.test_OF_SUB(this.oldDest, this.immediateWord, this.cpu.ax, this.iCarryFlag);
        this.cpu.flags[6] = this.cpu.ax[0] == 0 && this.cpu.ax[1] == 0;
        this.cpu.flags[7] = this.cpu.ax[0] < 0;
        this.cpu.flags[2] = Util.checkParityOfByte(this.cpu.ax[1]);
    }
}

