/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.pic;

import dioscuri.Emulator;
import dioscuri.exception.UnknownPortException;
import dioscuri.interfaces.Module;
import dioscuri.module.AbstractModule;
import dioscuri.module.ModuleATA;
import dioscuri.module.ModuleCPU;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.ModulePIC;
import dioscuri.module.pic.TheProgrammableInterruptController;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PIC
extends ModulePIC {
    TheProgrammableInterruptController[] thePIC = new TheProgrammableInterruptController[]{new TheProgrammableInterruptController(), new TheProgrammableInterruptController()};
    private static final Logger logger = Logger.getLogger(PIC.class.getName());
    private AbstractModule[] irqList = null;
    private boolean[] irqEnabled = null;
    public static final int MASTER = 0;
    public static final int SLAVE = 1;
    private static final int MASTER_PIC_CMD_IRQ = 32;
    private static final int MASTER_PIC_MASK_REG = 33;
    private static final int SLAVE_PIC_CMD_IRQ = 160;
    private static final int SLAVE_PIC_MASK_REG = 161;
    private static final int PIC_IRQ_SPACE = 16;
    private static final int PIC_IRQ_NUMBER_PIT = 0;
    private static final int PIC_IRQ_NUMBER_KEYBOARD = 1;
    private static final int PIC_IRQ_NUMBER_SERIALPORT = 4;
    private static final int PIC_IRQ_NUMBER_FDC = 6;
    private static final int PIC_IRQ_NUMBER_RTC = 8;
    private static final int PIC_IRQ_NUMBER_MOUSE = 12;
    private static final int[] PIC_IRQ_NUMBER_ATA = new int[]{14, 15, 11, 9};

    public PIC(Emulator emulator) {
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " AbstractModule created successfully.");
    }

    @Override
    public boolean reset() {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        this.thePIC[0].reset();
        this.thePIC[1].reset();
        this.thePIC[0].interruptOffset = 8;
        this.thePIC[0].isMaster = true;
        this.thePIC[1].interruptOffset = 112;
        this.thePIC[1].isMaster = false;
        moduleMotherboard.setIOPort(32, this);
        moduleMotherboard.setIOPort(33, this);
        moduleMotherboard.setIOPort(160, this);
        moduleMotherboard.setIOPort(161, this);
        this.irqList = new AbstractModule[16];
        this.irqEnabled = new boolean[16];
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " AbstractModule has been reset.");
        return true;
    }

    @Override
    public String getDump() {
        String string = "";
        String string2 = "\r\n";
        String string3 = "\t";
        string = "PIC dump:" + string2;
        string = string + "IRQ |" + string3 + "device |" + string3 + "raised" + string2;
        string = string + "-----------------------------------------" + string2;
        for (int i = 0; i < this.irqList.length; ++i) {
            string = this.irqList[i] != null ? string + "" + i + string3 + (Object)((Object)this.irqList[i].getType()) + string3 + this.irqEnabled[i] + string2 : string + "" + i + string2;
        }
        return string;
    }

    @Override
    public byte getIOPortByte(int n) throws UnknownPortException {
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " IO read from 0x" + Integer.toHexString(n));
        if ((n == 32 || n == 33) && this.thePIC[0].isPolled) {
            this.clearHighestInterrupt(0);
            this.thePIC[0].isPolled = false;
            this.serviceMasterPIC();
            return this.thePIC[0].currentIrqNumber;
        }
        if ((n == 160 || n == 161) && this.thePIC[1].isPolled) {
            this.clearHighestInterrupt(1);
            this.thePIC[1].isPolled = false;
            this.serviceSlavePIC();
            return this.thePIC[1].currentIrqNumber;
        }
        switch (n) {
            case 32: {
                if (this.thePIC[0].readRegisterSelect != 0) {
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " read master ISR = " + this.thePIC[0].inServiceRegister);
                    return this.thePIC[0].inServiceRegister;
                }
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " read master IRR = " + this.thePIC[0].interruptRequestRegister);
                return this.thePIC[0].interruptRequestRegister;
            }
            case 33: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " read master IMR = " + this.thePIC[0].interruptMaskRegister);
                return this.thePIC[0].interruptMaskRegister;
            }
            case 160: {
                if (this.thePIC[1].readRegisterSelect != 0) {
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " read slave ISR = " + this.thePIC[1].inServiceRegister);
                    return this.thePIC[1].inServiceRegister;
                }
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " read slave IRR = " + this.thePIC[1].interruptRequestRegister);
                return this.thePIC[1].interruptRequestRegister;
            }
            case 161: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " read slave IMR = " + this.thePIC[1].interruptMaskRegister);
                return this.thePIC[1].interruptMaskRegister;
            }
        }
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Unknown I/O address " + n);
        throw new UnknownPortException("[" + (Object)((Object)super.getType()) + "]" + " does not recognise port 0x" + Integer.toHexString(n).toUpperCase());
    }

    @Override
    public void setIOPortByte(int n, byte by) {
        ModuleCPU moduleCPU = (ModuleCPU)super.getConnection(Module.Type.CPU);
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " IO write to 0x" + Integer.toHexString(n) + " = 0x" + Integer.toHexString(by));
        switch (n) {
            case 32: {
                if ((by & 0x10) != 0) {
                    logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " master: init command 1 found");
                    logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "         requires 4 = " + (by & 1));
                    logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + "         cascade mode: [0=cascade,1=single] " + ((by & 2) >> 1));
                    this.thePIC[0].initSequence.inInitSequence = true;
                    this.thePIC[0].initSequence.numComWordsReq = (byte)(by & 1);
                    this.thePIC[0].initSequence.currentComWordExpected = 2;
                    this.thePIC[0].interruptMaskRegister = 0;
                    this.thePIC[0].inServiceRegister = 0;
                    this.thePIC[0].interruptRequestRegister = 0;
                    this.thePIC[0].lowestPriorityIRQ = 7;
                    this.thePIC[0].intRequestPin = false;
                    this.thePIC[0].autoEndOfInt = false;
                    this.thePIC[0].rotateOnAutoEOI = false;
                    if ((by & 2) != 0) {
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " master: ICW1: single mode not supported");
                    }
                    if ((by & 8) != 0) {
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " master: ICW1: level sensitive mode not supported");
                    } else {
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " master: ICW1: edge triggered mode selected");
                    }
                    moduleCPU.interruptRequest(false);
                    return;
                }
                if ((by & 0x18) == 8) {
                    logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " master: OCW3; data: " + by);
                    int n2 = (by & 0xFF & 0x60) >> 5;
                    int n3 = (by & 0xFF & 4) >> 2;
                    int n4 = by & 0xFF & 3;
                    if (n3 != 0) {
                        this.thePIC[0].isPolled = true;
                        return;
                    }
                    if (n4 == 2) {
                        this.thePIC[0].readRegisterSelect = 0;
                    } else if (n4 == 3) {
                        this.thePIC[0].readRegisterSelect = 1;
                    }
                    if (n2 == 2) {
                        this.thePIC[0].specialMask = false;
                    } else if (n2 == 3) {
                        this.thePIC[0].specialMask = true;
                        this.serviceMasterPIC();
                    }
                    return;
                }
                switch (by) {
                    case -128: 
                    case 0: {
                        this.thePIC[0].rotateOnAutoEOI = by != 0;
                        break;
                    }
                    case 10: {
                        this.thePIC[0].readRegisterSelect = 0;
                        break;
                    }
                    case 11: {
                        this.thePIC[0].readRegisterSelect = 1;
                        break;
                    }
                    case -96: 
                    case 32: {
                        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " OCW2: Clear highest interrupt");
                        this.clearHighestInterrupt(0);
                        if (by == 160) {
                            ++this.thePIC[0].lowestPriorityIRQ;
                            if (this.thePIC[0].lowestPriorityIRQ > 7) {
                                this.thePIC[0].lowestPriorityIRQ = 0;
                            }
                        }
                        this.serviceMasterPIC();
                        break;
                    }
                    case 64: {
                        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " IRQ no-op");
                        break;
                    }
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: {
                        this.thePIC[0].inServiceRegister = (byte)(this.thePIC[0].inServiceRegister & ~(1 << (by & 0xFF) - 96));
                        this.serviceMasterPIC();
                        break;
                    }
                    case -64: 
                    case -63: 
                    case -62: 
                    case -61: 
                    case -60: 
                    case -59: 
                    case -58: 
                    case -57: {
                        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " IRQ lowest command " + by);
                        this.thePIC[0].lowestPriorityIRQ = (by & 0xFF) - 192;
                        break;
                    }
                    case -32: 
                    case -31: 
                    case -30: 
                    case -29: 
                    case -28: 
                    case -27: 
                    case -26: 
                    case -25: {
                        this.thePIC[0].inServiceRegister = (byte)(this.thePIC[0].inServiceRegister & ~(1 << (by & 0xFF) - 224));
                        this.thePIC[0].lowestPriorityIRQ = (by & 0xFF) - 224;
                        this.serviceMasterPIC();
                        break;
                    }
                    default: {
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " write to port 0x20 did not match");
                        return;
                    }
                }
                return;
            }
            case 33: {
                if (this.thePIC[0].initSequence.inInitSequence) {
                    switch (this.thePIC[0].initSequence.currentComWordExpected) {
                        case 2: {
                            this.thePIC[0].interruptOffset = by & 0xFF & 0xF8;
                            this.thePIC[0].initSequence.currentComWordExpected = 3;
                            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " master: init command 2 = " + by);
                            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "         offset = INT " + this.thePIC[0].interruptOffset);
                            return;
                        }
                        case 3: {
                            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " master: init command 3 = " + by);
                            if (this.thePIC[0].initSequence.numComWordsReq != 0) {
                                this.thePIC[0].initSequence.currentComWordExpected = 4;
                            } else {
                                this.thePIC[0].initSequence.inInitSequence = false;
                            }
                            return;
                        }
                        case 4: {
                            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " master: init command 4 = " + by);
                            if ((by & 2) != 0) {
                                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "        auto EOI");
                                this.thePIC[0].autoEndOfInt = true;
                            } else {
                                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " normal EOI interrupt");
                                this.thePIC[0].autoEndOfInt = false;
                            }
                            if ((by & 1) != 0) {
                                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "        80x86 mode");
                            } else {
                                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "        not 80x86 mode");
                            }
                            this.thePIC[0].initSequence.inInitSequence = false;
                            return;
                        }
                    }
                    logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " master expecting bad init command");
                    return;
                }
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " setting master pic IMR to %02x", by);
                this.thePIC[0].interruptMaskRegister = by;
                this.serviceMasterPIC();
                return;
            }
            case 160: {
                if ((by & 0x10) != 0) {
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " slave: init command 1 found");
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "        requires 4 = " + (by & 1));
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "        cascade mode: [0=cascade,1=single] " + ((by & 2) >> 1));
                    this.thePIC[1].initSequence.inInitSequence = true;
                    this.thePIC[1].initSequence.numComWordsReq = (byte)(by & 1);
                    this.thePIC[1].initSequence.currentComWordExpected = 2;
                    this.thePIC[1].interruptMaskRegister = 0;
                    this.thePIC[1].inServiceRegister = 0;
                    this.thePIC[1].interruptRequestRegister = 0;
                    this.thePIC[1].lowestPriorityIRQ = 7;
                    this.thePIC[1].intRequestPin = false;
                    this.thePIC[1].autoEndOfInt = false;
                    this.thePIC[1].rotateOnAutoEOI = false;
                    if ((by & 2) != 0) {
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " slave: ICW1: single mode not supported");
                    }
                    if ((by & 8) != 0) {
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " slave: ICW1: level sensitive mode not supported");
                    } else {
                        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " slave: ICW1: edge triggered mode selected");
                    }
                    return;
                }
                if ((by & 0x18) == 8) {
                    int n5 = (by & 0xFF & 0x60) >> 5;
                    int n6 = (by & 0xFF & 4) >> 2;
                    int n7 = by & 0xFF & 3;
                    if (n6 != 0) {
                        this.thePIC[1].isPolled = true;
                        return;
                    }
                    if (n7 == 2) {
                        this.thePIC[1].readRegisterSelect = 0;
                    } else if (n7 == 3) {
                        this.thePIC[1].readRegisterSelect = 1;
                    }
                    if (n5 == 2) {
                        this.thePIC[1].specialMask = false;
                    } else if (n5 == 3) {
                        this.thePIC[1].specialMask = true;
                        this.serviceSlavePIC();
                    }
                    return;
                }
                switch (by) {
                    case -128: 
                    case 0: {
                        this.thePIC[1].rotateOnAutoEOI = by != 0;
                        break;
                    }
                    case 10: {
                        this.thePIC[1].readRegisterSelect = 0;
                        break;
                    }
                    case 11: {
                        this.thePIC[1].readRegisterSelect = 1;
                        break;
                    }
                    case -96: 
                    case 32: {
                        this.clearHighestInterrupt(1);
                        if (by == 160) {
                            ++this.thePIC[1].lowestPriorityIRQ;
                            if (this.thePIC[1].lowestPriorityIRQ > 7) {
                                this.thePIC[1].lowestPriorityIRQ = 0;
                            }
                        }
                        this.serviceSlavePIC();
                        break;
                    }
                    case 64: {
                        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " IRQ no-op");
                        break;
                    }
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: {
                        this.thePIC[1].inServiceRegister = (byte)(this.thePIC[1].inServiceRegister & ~(1 << (by & 0xFF) - 96));
                        this.serviceSlavePIC();
                        break;
                    }
                    case -64: 
                    case -63: 
                    case -62: 
                    case -61: 
                    case -60: 
                    case -59: 
                    case -58: 
                    case -57: {
                        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " IRQ lowest command " + by);
                        this.thePIC[1].lowestPriorityIRQ = (by & 0xFF) - 192;
                        break;
                    }
                    case -32: 
                    case -31: 
                    case -30: 
                    case -29: 
                    case -28: 
                    case -27: 
                    case -26: 
                    case -25: {
                        this.thePIC[1].inServiceRegister = (byte)(this.thePIC[1].inServiceRegister & ~(1 << (by & 0xFF) - 224));
                        this.thePIC[1].lowestPriorityIRQ = (by & 0xFF) - 224;
                        this.serviceSlavePIC();
                        break;
                    }
                    default: {
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " write to port 0xA0 did not match");
                        return;
                    }
                }
                return;
            }
            case 161: {
                if (this.thePIC[1].initSequence.inInitSequence) {
                    switch (this.thePIC[1].initSequence.currentComWordExpected) {
                        case 2: {
                            this.thePIC[1].interruptOffset = by & 0xFF & 0xF8;
                            this.thePIC[1].initSequence.currentComWordExpected = 3;
                            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " slave: init command 2 = " + by);
                            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "        offset = INT " + this.thePIC[1].interruptOffset);
                            return;
                        }
                        case 3: {
                            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " slave: init command 3 = " + by);
                            if (this.thePIC[1].initSequence.numComWordsReq != 0) {
                                this.thePIC[1].initSequence.currentComWordExpected = 4;
                            } else {
                                this.thePIC[1].initSequence.inInitSequence = false;
                            }
                            return;
                        }
                        case 4: {
                            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " slave: init command 4 = " + by);
                            if ((by & 2) != 0) {
                                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "        auto EOI");
                                this.thePIC[1].autoEndOfInt = true;
                            } else {
                                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " normal EOI interrupt");
                                this.thePIC[1].autoEndOfInt = false;
                            }
                            if ((by & 1) != 0) {
                                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "        80x86 mode");
                            } else {
                                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + "        not 80x86 mode");
                            }
                            this.thePIC[1].initSequence.inInitSequence = false;
                            return;
                        }
                    }
                    logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " slave: encountered bad init command");
                    return;
                }
                return;
            }
        }
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " setting slave pic IMR to %02x", by);
        this.thePIC[1].interruptMaskRegister = by;
        this.serviceSlavePIC();
    }

    @Override
    public byte[] getIOPortWord(int n) {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " -> IN command (word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " -> Returned default value 0xFFFF");
        return new byte[]{-1, -1};
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " -> OUT command (word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " -> IN command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " -> Returned default value 0xFFFFFFFF");
        return new byte[]{-1, -1, -1, -1};
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " -> OUT command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public int requestIRQNumber(AbstractModule abstractModule) {
        int n = -1;
        if (abstractModule.getType() == Module.Type.PIT) {
            n = 0;
            this.irqList[n] = abstractModule;
            this.irqEnabled[n] = false;
        } else if (abstractModule.getType() == Module.Type.KEYBOARD) {
            n = 1;
            this.irqList[n] = abstractModule;
            this.irqEnabled[n] = false;
        } else if (abstractModule.getType() == Module.Type.SERIALPORT) {
            n = 4;
            this.irqList[n] = abstractModule;
            this.irqEnabled[n] = false;
        } else if (abstractModule.getType() == Module.Type.FDC) {
            n = 6;
            this.irqList[n] = abstractModule;
            this.irqEnabled[n] = false;
        } else if (abstractModule.getType() == Module.Type.RTC) {
            n = 8;
            this.irqList[n] = abstractModule;
            this.irqEnabled[n] = false;
        } else if (abstractModule.getType() == Module.Type.MOUSE) {
            n = 12;
            this.irqList[n] = abstractModule;
            this.irqEnabled[n] = false;
        } else if (abstractModule.getType() == Module.Type.ATA) {
            ModuleATA moduleATA = (ModuleATA)abstractModule;
            int n2 = moduleATA.getCurrentChannelIndex();
            n = PIC_IRQ_NUMBER_ATA[n2];
            this.irqList[n] = abstractModule;
            this.irqEnabled[n] = false;
        } else if (abstractModule.getType() == Module.Type.SERIALPORT) {
            n = 4;
            this.irqList[n] = abstractModule;
            this.irqEnabled[n] = false;
        } else {
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Should return free IRQ number, but is not implemented");
        }
        return n;
    }

    @Override
    public void setIRQ(int n) {
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " Attempting to set IRQ line " + n + " high");
        int n2 = 1 << (n & 7);
        if (n <= 7 && (this.thePIC[0].irqPins & n2) == 0) {
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " IRQ line " + n + " now high");
            this.thePIC[0].irqPins |= n2;
            this.thePIC[0].interruptRequestRegister = (byte)(this.thePIC[0].interruptRequestRegister | n2);
            this.serviceMasterPIC();
        } else if (n > 7 && n <= 15 && (this.thePIC[1].irqPins & n2) == 0) {
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " IRQ line " + n + " now high");
            this.thePIC[1].irqPins |= n2;
            this.thePIC[1].interruptRequestRegister = (byte)(this.thePIC[1].interruptRequestRegister | n2);
            this.serviceSlavePIC();
        }
    }

    @Override
    public void clearIRQ(int n) {
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " Attempting to set IRQ line " + n + " low");
        int n2 = 1 << (n & 7);
        if (n <= 7 && (this.thePIC[0].irqPins & n2) != 0) {
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " IRQ line " + n + " now low");
            this.thePIC[0].irqPins &= ~n2;
            this.thePIC[0].interruptRequestRegister = (byte)(this.thePIC[0].interruptRequestRegister & ~n2);
        } else if (n > 7 && n <= 15 && (this.thePIC[1].irqPins & n2) != 0) {
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " IRQ line " + n + " now low");
            this.thePIC[1].irqPins &= ~n2;
            this.thePIC[1].interruptRequestRegister = (byte)(this.thePIC[1].interruptRequestRegister & ~n2);
        }
    }

    @Override
    public int interruptAcknowledge() {
        int n;
        ModuleCPU moduleCPU = (ModuleCPU)super.getConnection(Module.Type.CPU);
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        moduleCPU.interruptRequest(false);
        this.thePIC[0].intRequestPin = false;
        if (this.thePIC[0].interruptRequestRegister == 0) {
            return (byte)(this.thePIC[0].interruptOffset + 7);
        }
        if ((this.thePIC[0].edgeLevel & 1 << this.thePIC[0].currentIrqNumber) == 0) {
            this.thePIC[0].interruptRequestRegister = (byte)(this.thePIC[0].interruptRequestRegister & ~(1 << this.thePIC[0].currentIrqNumber));
        }
        if (!this.thePIC[0].autoEndOfInt) {
            this.thePIC[0].inServiceRegister = (byte)(this.thePIC[0].inServiceRegister | 1 << this.thePIC[0].currentIrqNumber);
        } else if (this.thePIC[0].rotateOnAutoEOI) {
            this.thePIC[0].lowestPriorityIRQ = this.thePIC[0].currentIrqNumber;
        }
        if (this.thePIC[0].currentIrqNumber != 2) {
            byte by = this.thePIC[0].currentIrqNumber;
            n = by + this.thePIC[0].interruptOffset;
        } else {
            this.thePIC[1].intRequestPin = false;
            this.thePIC[0].irqPins &= 0xFFFFFFFB;
            if (this.thePIC[1].interruptRequestRegister == 0) {
                return this.thePIC[1].interruptOffset + 7;
            }
            byte by = this.thePIC[1].currentIrqNumber;
            n = by + this.thePIC[1].interruptOffset;
            if ((this.thePIC[1].edgeLevel & 1 << this.thePIC[1].currentIrqNumber) == 0) {
                this.thePIC[1].interruptRequestRegister = (byte)(this.thePIC[1].interruptRequestRegister & ~(1 << this.thePIC[1].currentIrqNumber));
            }
            if (!this.thePIC[1].autoEndOfInt) {
                this.thePIC[1].inServiceRegister = (byte)(this.thePIC[1].inServiceRegister | 1 << this.thePIC[1].currentIrqNumber);
            } else if (this.thePIC[1].rotateOnAutoEOI) {
                this.thePIC[1].lowestPriorityIRQ = this.thePIC[1].currentIrqNumber;
            }
            this.serviceSlavePIC();
        }
        this.serviceMasterPIC();
        return n;
    }

    private void serviceSlavePIC() {
        int n;
        int n2 = this.thePIC[1].lowestPriorityIRQ + 1;
        if (n2 > 7) {
            n2 = 0;
        }
        if (this.thePIC[1].intRequestPin) {
            return;
        }
        if (this.thePIC[1].specialMask) {
            n = n2;
        } else {
            byte by = this.thePIC[1].inServiceRegister;
            if (by != 0) {
                n = n2;
                while ((by & 1 << n) == 0) {
                    if (++n <= 7) continue;
                    n = 0;
                }
                if (n == n2) {
                    return;
                }
                if (n > 7) {
                    logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " error in serviceSlavePic()");
                }
            } else {
                n = n2;
            }
        }
        int n3 = this.thePIC[1].interruptRequestRegister & ~this.thePIC[1].interruptMaskRegister;
        if (n3 != 0) {
            int n4 = n2;
            do {
                if (!(this.thePIC[1].specialMask && (this.thePIC[1].inServiceRegister >> n4 & 1) != 0 || (n3 & 1 << n4) == 0)) {
                    logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " slave: signalling IRQ(" + 8 + n4 + ")");
                    this.thePIC[1].intRequestPin = true;
                    this.thePIC[1].currentIrqNumber = (byte)n4;
                    this.setIRQ(2);
                    return;
                }
                if (++n4 <= 7) continue;
                n4 = 0;
            } while (n4 != n);
        }
    }

    private void serviceMasterPIC() {
        int n;
        ModuleCPU moduleCPU = (ModuleCPU)super.getConnection(Module.Type.CPU);
        int n2 = this.thePIC[0].lowestPriorityIRQ + 1;
        if (n2 > 7) {
            n2 = 0;
        }
        if (this.thePIC[0].intRequestPin) {
            return;
        }
        if (this.thePIC[0].specialMask) {
            n = n2;
        } else {
            byte by = this.thePIC[0].inServiceRegister;
            if (by != 0) {
                n = n2;
                while ((by & 1 << n) == 0) {
                    if (++n <= 7) continue;
                    n = 0;
                }
                if (n == n2) {
                    return;
                }
                if (n > 7) {
                    logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " error in servicMasterPic()");
                }
            } else {
                n = n2;
            }
        }
        int n3 = this.thePIC[0].interruptRequestRegister & ~this.thePIC[0].interruptMaskRegister;
        if (n3 != 0) {
            int n4 = n2;
            do {
                if (!(this.thePIC[0].specialMask && (this.thePIC[0].inServiceRegister >> n4 & 1) != 0 || (n3 & 1 << n4) == 0)) {
                    logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " signalling IRQ(" + n4 + ")");
                    this.thePIC[0].intRequestPin = true;
                    this.thePIC[0].currentIrqNumber = (byte)n4;
                    moduleCPU.interruptRequest(true);
                    return;
                }
                if (++n4 <= 7) continue;
                n4 = 0;
            } while (n4 != n);
        }
    }

    private void clearHighestInterrupt(int n) {
        int n2 = this.thePIC[n].lowestPriorityIRQ;
        int n3 = n2 + 1;
        if (n3 > 7) {
            n3 = 0;
        }
        int n4 = n3;
        do {
            if ((this.thePIC[n].inServiceRegister & 1 << n4) != 0) {
                this.thePIC[n].inServiceRegister = (byte)(this.thePIC[n].inServiceRegister & ~(1 << n4));
                break;
            }
            if (++n4 <= 7) continue;
            n4 = 0;
        } while (n4 != n3);
    }
}

