/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_ENTER_IwIb
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte nestingLevel = 0;
    byte[] frameTemp = new byte[2];
    byte[] eFrameTemp = new byte[2];
    byte[] stackSizeWord = new byte[2];
    byte[] word0x0001 = new byte[]{0, 1};
    byte[] word0x0002 = new byte[]{0, 2};
    byte[] word0x0004 = new byte[]{0, 4};
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceValue = new byte[2];
    byte[] oldValue = new byte[2];
    byte[] destinationRegister = new byte[2];
    int internalCarry = 0;
    byte[] temp = new byte[2];
    byte[] eTemp = new byte[2];

    public Instruction_ENTER_IwIb() {
    }

    public Instruction_ENTER_IwIb(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        System.out.println("CPU -> instruction ENTER");
        this.cpu.stackSize = this.cpu.getByteFromCode();
        this.nestingLevel = (byte)(this.cpu.getByteFromCode() % 32);
        if (this.cpu.stackSize == 32) {
            System.out.println("CPU -> instruction ENTER in 32-bit stacksize not implemented completely");
            this.cpu.setWordToStack(this.cpu.ebp);
            this.cpu.setWordToStack(this.cpu.bp);
            this.eFrameTemp[0] = this.cpu.esp[0];
            this.eFrameTemp[1] = this.cpu.esp[1];
            this.frameTemp[0] = this.cpu.sp[0];
            this.frameTemp[1] = this.cpu.sp[1];
        } else {
            this.cpu.setWordToStack(this.cpu.bp);
            this.frameTemp[0] = this.cpu.sp[0];
            this.frameTemp[1] = this.cpu.sp[1];
        }
        if (this.cpu.doubleWord) {
            System.out.println("CPU -> instruction ENTER in 16-bit stacksize and doubleword (32 bit) not implemented");
        } else if (this.nestingLevel > 0 && this.cpu.stackSize != 32) {
            for (int i = 1; i < this.nestingLevel - 1; ++i) {
                this.temp = Util.subtractWords(this.cpu.bp, this.word0x0002, 0);
                System.arraycopy(this.temp, 0, this.cpu.bp, 0, this.temp.length);
                System.out.println("CPU -> instruction ENTER in 16-bit stacksize in nesting " + i);
                this.cpu.setWordToStack(this.cpu.bp);
            }
            this.cpu.setWordToStack(this.frameTemp);
        }
        if (this.cpu.stackSize == 32) {
            System.arraycopy(this.frameTemp, 0, this.cpu.bp, 0, this.frameTemp.length);
            System.arraycopy(this.eFrameTemp, 0, this.cpu.ebp, 0, this.eFrameTemp.length);
            this.stackSizeWord = new byte[]{0, this.cpu.stackSize};
            this.temp = Util.subtractWords(this.cpu.bp, this.stackSizeWord, 0);
            this.eTemp = Util.test_CF_SUB(this.cpu.bp, this.stackSizeWord, 0) ? Util.subtractWords(this.cpu.ebp, this.word0x0001, 0) : this.cpu.ebp;
            System.arraycopy(this.temp, 0, this.cpu.sp, 0, this.temp.length);
            System.arraycopy(this.eTemp, 0, this.cpu.esp, 0, this.eTemp.length);
        } else {
            System.arraycopy(this.frameTemp, 0, this.cpu.bp, 0, this.frameTemp.length);
            this.temp = Util.subtractWords(this.cpu.bp, this.stackSizeWord, 0);
            System.arraycopy(this.temp, 0, this.cpu.sp, 0, this.temp.length);
        }
    }
}

