/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

public class JavaOpcode {
    public static final int NOP = 0;
    public static final int ACONST_NULL = 1;
    public static final int ICONST_M1 = 2;
    public static final int ICONST_0 = 3;
    public static final int ICONST_1 = 4;
    public static final int ICONST_2 = 5;
    public static final int ICONST_3 = 6;
    public static final int ICONST_4 = 7;
    public static final int ICONST_5 = 8;
    public static final int LCONST_0 = 9;
    public static final int LCONST_1 = 10;
    public static final int FCONST_0 = 11;
    public static final int FCONST_1 = 12;
    public static final int FCONST_2 = 13;
    public static final int DCONST_0 = 14;
    public static final int DCONST_1 = 15;
    public static final int BIPUSH = 16;
    public static final int SIPUSH = 17;
    public static final int LDC = 18;
    public static final int LDC_W = 19;
    public static final int LDC2_W = 20;
    public static final int ILOAD = 21;
    public static final int LLOAD = 22;
    public static final int FLOAD = 23;
    public static final int DLOAD = 24;
    public static final int ALOAD = 25;
    public static final int ILOAD_0 = 26;
    public static final int ILOAD_1 = 27;
    public static final int ILOAD_2 = 28;
    public static final int ILOAD_3 = 29;
    public static final int LLOAD_0 = 30;
    public static final int LLOAD_1 = 31;
    public static final int LLOAD_2 = 32;
    public static final int LLOAD_3 = 33;
    public static final int FLOAD_0 = 34;
    public static final int FLOAD_1 = 35;
    public static final int FLOAD_2 = 36;
    public static final int FLOAD_3 = 37;
    public static final int DLOAD_0 = 38;
    public static final int DLOAD_1 = 39;
    public static final int DLOAD_2 = 40;
    public static final int DLOAD_3 = 41;
    public static final int ALOAD_0 = 42;
    public static final int ALOAD_1 = 43;
    public static final int ALOAD_2 = 44;
    public static final int ALOAD_3 = 45;
    public static final int IALOAD = 46;
    public static final int LALOAD = 47;
    public static final int FALOAD = 48;
    public static final int DALOAD = 49;
    public static final int AALOAD = 50;
    public static final int BALOAD = 51;
    public static final int CALOAD = 52;
    public static final int SALOAD = 53;
    public static final int ISTORE = 54;
    public static final int LSTORE = 55;
    public static final int FSTORE = 56;
    public static final int DSTORE = 57;
    public static final int ASTORE = 58;
    public static final int ISTORE_0 = 59;
    public static final int ISTORE_1 = 60;
    public static final int ISTORE_2 = 61;
    public static final int ISTORE_3 = 62;
    public static final int LSTORE_0 = 63;
    public static final int LSTORE_1 = 64;
    public static final int LSTORE_2 = 65;
    public static final int LSTORE_3 = 66;
    public static final int FSTORE_0 = 67;
    public static final int FSTORE_1 = 68;
    public static final int FSTORE_2 = 69;
    public static final int FSTORE_3 = 70;
    public static final int DSTORE_0 = 71;
    public static final int DSTORE_1 = 72;
    public static final int DSTORE_2 = 73;
    public static final int DSTORE_3 = 74;
    public static final int ASTORE_0 = 75;
    public static final int ASTORE_1 = 76;
    public static final int ASTORE_2 = 77;
    public static final int ASTORE_3 = 78;
    public static final int IASTORE = 79;
    public static final int LASTORE = 80;
    public static final int FASTORE = 81;
    public static final int DASTORE = 82;
    public static final int AASTORE = 83;
    public static final int BASTORE = 84;
    public static final int CASTORE = 85;
    public static final int SASTORE = 86;
    public static final int POP = 87;
    public static final int POP2 = 88;
    public static final int DUP = 89;
    public static final int DUP_X1 = 90;
    public static final int DUP_X2 = 91;
    public static final int DUP2 = 92;
    public static final int DUP2_X1 = 93;
    public static final int DUP2_X2 = 94;
    public static final int SWAP = 95;
    public static final int IADD = 96;
    public static final int LADD = 97;
    public static final int FADD = 98;
    public static final int DADD = 99;
    public static final int ISUB = 100;
    public static final int LSUB = 101;
    public static final int FSUB = 102;
    public static final int DSUB = 103;
    public static final int IMUL = 104;
    public static final int LMUL = 105;
    public static final int FMUL = 106;
    public static final int DMUL = 107;
    public static final int IDIV = 108;
    public static final int LDIV = 109;
    public static final int FDIV = 110;
    public static final int DDIV = 111;
    public static final int IREM = 112;
    public static final int LREM = 113;
    public static final int FREM = 114;
    public static final int DREM = 115;
    public static final int INEG = 116;
    public static final int LNEG = 117;
    public static final int FNEG = 118;
    public static final int DNEG = 119;
    public static final int ISHL = 120;
    public static final int LSHL = 121;
    public static final int ISHR = 122;
    public static final int LSHR = 123;
    public static final int IUSHR = 124;
    public static final int LUSHR = 125;
    public static final int IAND = 126;
    public static final int LAND = 127;
    public static final int IOR = 128;
    public static final int LOR = 129;
    public static final int IXOR = 130;
    public static final int LXOR = 131;
    public static final int IINC = 132;
    public static final int I2L = 133;
    public static final int I2F = 134;
    public static final int I2D = 135;
    public static final int L2I = 136;
    public static final int L2F = 137;
    public static final int L2D = 138;
    public static final int F2I = 139;
    public static final int F2L = 140;
    public static final int F2D = 141;
    public static final int D2I = 142;
    public static final int D2L = 143;
    public static final int D2F = 144;
    public static final int I2B = 145;
    public static final int I2C = 146;
    public static final int I2S = 147;
    public static final int LCMP = 148;
    public static final int FCMPL = 149;
    public static final int FCMPG = 150;
    public static final int DCMPL = 151;
    public static final int DCMPG = 152;
    public static final int IFEQ = 153;
    public static final int IFNE = 154;
    public static final int IFLT = 155;
    public static final int IFGE = 156;
    public static final int IFGT = 157;
    public static final int IFLE = 158;
    public static final int IF_ICMPEQ = 159;
    public static final int IF_ICMPNE = 160;
    public static final int IF_ICMPLT = 161;
    public static final int IF_ICMPGE = 162;
    public static final int IF_ICMPGT = 163;
    public static final int IF_ICMPLE = 164;
    public static final int IF_ACMPEQ = 165;
    public static final int IF_ACMPNE = 166;
    public static final int GOTO = 167;
    public static final int JSR = 168;
    public static final int RET = 169;
    public static final int TABLESWITCH = 170;
    public static final int LOOKUPSWITCH = 171;
    public static final int IRETURN = 172;
    public static final int LRETURN = 173;
    public static final int FRETURN = 174;
    public static final int DRETURN = 175;
    public static final int ARETURN = 176;
    public static final int RETURN = 177;
    public static final int GETSTATIC = 178;
    public static final int PUTSTATIC = 179;
    public static final int GETFIELD = 180;
    public static final int PUTFIELD = 181;
    public static final int INVOKEVIRTUAL = 182;
    public static final int INVOKESPECIAL = 183;
    public static final int INVOKESTATIC = 184;
    public static final int INVOKEINTERFACE = 185;
    public static final int XXXUNUSEDXXX = 186;
    public static final int NEW = 187;
    public static final int NEWARRAY = 188;
    public static final int ANEWARRAY = 189;
    public static final int ARRAYLENGTH = 190;
    public static final int ATHROW = 191;
    public static final int CHECKCAST = 192;
    public static final int INSTANCEOF = 193;
    public static final int MONITORENTER = 194;
    public static final int MONITOREXIT = 195;
    public static final int WIDE = 196;
    public static final int MULTIANEWARRAY = 197;
    public static final int IFNULL = 198;
    public static final int IFNONNULL = 199;
    public static final int GOTO_W = 200;
    public static final int JSR_W = 201;
    public static final int BREAKPOINT = 202;
    public static final int IMPDEP1 = 254;
    public static final int IMPDEP2 = 255;
    private static final String[] opcodes = new String[]{"NOP", "ACONST_NULL", "ICONST_M1", "ICONST_0", "ICONST_1", "ICONST_2", "ICONST_3", "ICONST_4", "ICONST_5", "LCONST_0", "LCONST_1", "FCONST_0", "FCONST_1", "FCONST_2", "DCONST_0", "DCONST_1", "BIPUSH", "SIPUSH", "LDC", "LDC_W", "LDC2_W", "ILOAD", "LLOAD", "FLOAD", "DLOAD", "ALOAD", "ILOAD_0", "ILOAD_1", "ILOAD_2", "ILOAD_3", "LLOAD_0", "LLOAD_1", "LLOAD_2", "LLOAD_3", "FLOAD_0", "FLOAD_1", "FLOAD_2", "FLOAD_3", "DLOAD_0", "DLOAD_1", "DLOAD_2", "DLOAD_3", "ALOAD_0", "ALOAD_1", "ALOAD_2", "ALOAD_3", "IALOAD", "LALOAD", "FALOAD", "DALOAD", "AALOAD", "BALOAD", "CALOAD", "SALOAD", "ISTORE", "LSTORE", "FSTORE", "DSTORE", "ASTORE", "ISTORE_0", "ISTORE_1", "ISTORE_2", "ISTORE_3", "LSTORE_0", "LSTORE_1", "LSTORE_2", "LSTORE_3", "FSTORE_0", "FSTORE_1", "FSTORE_2", "FSTORE_3", "DSTORE_0", "DSTORE_1", "DSTORE_2", "DSTORE_3", "ASTORE_0", "ASTORE_1", "ASTORE_2", "ASTORE_3", "IASTORE", "LASTORE", "FASTORE", "DASTORE", "AASTORE", "BASTORE", "CASTORE", "SASTORE", "POP", "POP2", "DUP", "DUP_X1", "DUP_X2", "DUP2", "DUP2_X1", "DUP2_X2", "SWAP", "IADD", "LADD", "FADD", "DADD", "ISUB", "LSUB", "FSUB", "DSUB", "IMUL", "LMUL", "FMUL", "DMUL", "IDIV", "LDIV", "FDIV", "DDIV", "IREM", "LREM", "FREM", "DREM", "INEG", "LNEG", "FNEG", "DNEG", "ISHL", "LSHL", "ISHR", "LSHR", "IUSHR", "LUSHR", "IAND", "LAND", "IOR", "LOR", "IXOR", "LXOR", "IINC", "I2L", "I2F", "I2D", "L2I", "L2F", "L2D", "F2I", "F2L", "F2D", "D2I", "D2L", "D2F", "I2B", "I2C", "I2S", "LCMP", "FCMPL", "FCMPG", "DCMPL", "DCMPG", "IFEQ", "IFNE", "IFLT", "IFGE", "IFGT", "IFLE", "IF_ICMPEQ", "IF_ICMPNE", "IF_ICMPLT", "IF_ICMPGE", "IF_ICMPGT", "IF_ICMPLE", "IF_ACMPEQ", "IF_ACMPNE", "GOTO", "JSR", "RET", "TABLESWITCH", "LOOKUPSWITCH", "IRETURN", "LRETURN", "FRETURN", "DRETURN", "ARETURN", "RETURN", "GETSTATIC", "PUTSTATIC", "GETFIELD", "PUTFIELD", "INVOKEVIRTUAL", "INVOKESPECIAL", "INVOKESTATIC", "INVOKEINTERFACE", "XXXUNUSEDXXX", "NEW", "NEWARRAY", "ANEWARRAY", "ARRAYLENGTH", "ATHROW", "CHECKCAST", "INSTANCEOF", "MONITORENTER", "MONITOREXIT", "WIDE", "MULTIANEWARRAY", "IFNULL", "IFNONNULL", "GOTO_W", "JSR_W", "BREAKPOINT", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "RESERVED", "IMPDEP1", "IMPDEP2"};
    public static final int CALC_FROM_CONST_POOL = 48879;

    public static String toString(int n) {
        return opcodes[n];
    }

    public static boolean isBranchInstruction(int n) {
        switch (n) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                return true;
            }
        }
        return false;
    }

    public static boolean isReturn(int n) {
        switch (n) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                return true;
            }
        }
        return false;
    }

    public static int getJumpOffset(int[] nArray, int n) {
        switch (nArray[n]) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                return (short)(nArray[n + 1] << 8 | nArray[n + 2]);
            }
            case 167: 
            case 168: {
                return (short)(nArray[n + 1] << 8 | nArray[n + 2]);
            }
            case 200: 
            case 201: {
                return nArray[n + 1] << 24 | nArray[n + 2] << 16 | nArray[n + 3] << 8 | nArray[n + 4];
            }
            case 169: {
                throw new IllegalStateException("Must fix stack delta measurement on methods with subroutines");
            }
        }
        return 0;
    }

    public static int getStackDelta(int[] nArray, int n) {
        switch (nArray[n]) {
            case 50: {
                return -1;
            }
            case 83: {
                return -3;
            }
            case 1: {
                return 1;
            }
            case 25: {
                return 1;
            }
            case 42: {
                return 1;
            }
            case 43: {
                return 1;
            }
            case 44: {
                return 1;
            }
            case 45: {
                return 1;
            }
            case 189: {
                return 0;
            }
            case 190: {
                return 0;
            }
            case 58: {
                return -1;
            }
            case 75: {
                return -1;
            }
            case 76: {
                return -1;
            }
            case 77: {
                return -1;
            }
            case 78: {
                return -1;
            }
            case 191: {
                return 0;
            }
            case 51: {
                return -1;
            }
            case 84: {
                return -3;
            }
            case 16: {
                return 1;
            }
            case 52: {
                return -1;
            }
            case 85: {
                return -3;
            }
            case 192: {
                return 0;
            }
            case 144: {
                return -1;
            }
            case 142: {
                return -1;
            }
            case 143: {
                return 0;
            }
            case 99: {
                return -2;
            }
            case 49: {
                return 0;
            }
            case 82: {
                return -4;
            }
            case 152: {
                return -3;
            }
            case 151: {
                return -3;
            }
            case 14: {
                return 2;
            }
            case 15: {
                return 2;
            }
            case 111: {
                return -2;
            }
            case 24: {
                return 2;
            }
            case 38: {
                return 2;
            }
            case 39: {
                return 2;
            }
            case 40: {
                return 2;
            }
            case 41: {
                return 2;
            }
            case 107: {
                return -2;
            }
            case 119: {
                return 0;
            }
            case 115: {
                return -2;
            }
            case 57: {
                return -2;
            }
            case 71: {
                return -2;
            }
            case 72: {
                return -2;
            }
            case 73: {
                return -2;
            }
            case 74: {
                return -2;
            }
            case 103: {
                return -2;
            }
            case 92: {
                return 2;
            }
            case 93: {
                return 2;
            }
            case 94: {
                return 2;
            }
            case 89: {
                return 1;
            }
            case 90: {
                return 1;
            }
            case 91: {
                return 1;
            }
            case 141: {
                return 1;
            }
            case 139: {
                return 0;
            }
            case 140: {
                return 1;
            }
            case 98: {
                return -1;
            }
            case 48: {
                return -1;
            }
            case 81: {
                return -3;
            }
            case 150: {
                return -1;
            }
            case 149: {
                return -1;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 1;
            }
            case 13: {
                return 1;
            }
            case 110: {
                return -1;
            }
            case 23: {
                return 1;
            }
            case 34: {
                return 1;
            }
            case 35: {
                return 1;
            }
            case 36: {
                return 1;
            }
            case 37: {
                return 1;
            }
            case 106: {
                return -1;
            }
            case 118: {
                return 0;
            }
            case 114: {
                return -1;
            }
            case 56: {
                return -1;
            }
            case 67: {
                return -1;
            }
            case 68: {
                return -1;
            }
            case 69: {
                return -1;
            }
            case 70: {
                return -1;
            }
            case 102: {
                return -1;
            }
            case 180: {
                return 48879;
            }
            case 178: {
                return 48879;
            }
            case 167: {
                return 0;
            }
            case 200: {
                return 0;
            }
            case 145: {
                return 0;
            }
            case 146: {
                return 0;
            }
            case 135: {
                return 1;
            }
            case 134: {
                return 0;
            }
            case 133: {
                return 1;
            }
            case 147: {
                return 0;
            }
            case 96: {
                return -1;
            }
            case 46: {
                return -1;
            }
            case 126: {
                return -1;
            }
            case 79: {
                return -3;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 1;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 108: {
                return -1;
            }
            case 153: {
                return -1;
            }
            case 156: {
                return -1;
            }
            case 157: {
                return -1;
            }
            case 158: {
                return -1;
            }
            case 155: {
                return -1;
            }
            case 154: {
                return -1;
            }
            case 199: {
                return -1;
            }
            case 198: {
                return -1;
            }
            case 165: {
                return -2;
            }
            case 166: {
                return -2;
            }
            case 159: {
                return -2;
            }
            case 162: {
                return -2;
            }
            case 163: {
                return -2;
            }
            case 164: {
                return -2;
            }
            case 161: {
                return -2;
            }
            case 160: {
                return -2;
            }
            case 132: {
                return 0;
            }
            case 21: {
                return 1;
            }
            case 26: {
                return 1;
            }
            case 27: {
                return 1;
            }
            case 28: {
                return 1;
            }
            case 29: {
                return 1;
            }
            case 104: {
                return -1;
            }
            case 116: {
                return 0;
            }
            case 193: {
                return 0;
            }
            case 185: {
                return 48879;
            }
            case 183: {
                return 48879;
            }
            case 184: {
                return 48879;
            }
            case 182: {
                return 48879;
            }
            case 128: {
                return -1;
            }
            case 112: {
                return -1;
            }
            case 120: {
                return -1;
            }
            case 122: {
                return -1;
            }
            case 54: {
                return -1;
            }
            case 59: {
                return -1;
            }
            case 60: {
                return -1;
            }
            case 61: {
                return -1;
            }
            case 62: {
                return -1;
            }
            case 100: {
                return -1;
            }
            case 124: {
                return -1;
            }
            case 130: {
                return -1;
            }
            case 168: {
                return 1;
            }
            case 201: {
                return 1;
            }
            case 138: {
                return 0;
            }
            case 137: {
                return -1;
            }
            case 136: {
                return -1;
            }
            case 97: {
                return -2;
            }
            case 47: {
                return 0;
            }
            case 127: {
                return -2;
            }
            case 80: {
                return -4;
            }
            case 148: {
                return -3;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 2;
            }
            case 20: {
                return 2;
            }
            case 18: {
                return 1;
            }
            case 19: {
                return 1;
            }
            case 109: {
                return -2;
            }
            case 22: {
                return 2;
            }
            case 30: {
                return 2;
            }
            case 31: {
                return 2;
            }
            case 32: {
                return 2;
            }
            case 33: {
                return 2;
            }
            case 105: {
                return -2;
            }
            case 117: {
                return 0;
            }
            case 171: {
                return -1;
            }
            case 129: {
                return -2;
            }
            case 113: {
                return -2;
            }
            case 121: {
                return -1;
            }
            case 123: {
                return -1;
            }
            case 55: {
                return -2;
            }
            case 63: {
                return -2;
            }
            case 64: {
                return -2;
            }
            case 65: {
                return -2;
            }
            case 66: {
                return -2;
            }
            case 101: {
                return -2;
            }
            case 125: {
                return -1;
            }
            case 131: {
                return -2;
            }
            case 194: {
                return -1;
            }
            case 195: {
                return -1;
            }
            case 197: {
                return 1 - nArray[n + 3];
            }
            case 187: {
                return 1;
            }
            case 188: {
                return 0;
            }
            case 0: {
                return 0;
            }
            case 88: {
                return -2;
            }
            case 87: {
                return -1;
            }
            case 181: {
                return 48879;
            }
            case 179: {
                return 48879;
            }
            case 169: {
                return 0;
            }
            case 53: {
                return -1;
            }
            case 86: {
                return -3;
            }
            case 17: {
                return 1;
            }
            case 95: {
                return 0;
            }
            case 170: {
                return -1;
            }
            case 196: {
                return JavaOpcode.getStackDelta(nArray, n + 1);
            }
            case 172: 
            case 174: 
            case 176: {
                return -1;
            }
            case 173: 
            case 175: {
                return -2;
            }
            case 177: {
                return 0;
            }
        }
        throw new IllegalStateException("JavaOpcode - getStackDelta - reserved instrution!");
    }

    public static int getLocalVariableAccess(int[] nArray, int n) {
        switch (nArray[n]) {
            case 25: {
                return nArray[n + 1];
            }
            case 42: {
                return 0;
            }
            case 43: {
                return 1;
            }
            case 44: {
                return 2;
            }
            case 45: {
                return 3;
            }
            case 58: {
                return nArray[n + 1];
            }
            case 75: {
                return 0;
            }
            case 76: {
                return 1;
            }
            case 77: {
                return 2;
            }
            case 78: {
                return 3;
            }
            case 24: {
                return nArray[n + 1] + 1;
            }
            case 38: {
                return 1;
            }
            case 39: {
                return 2;
            }
            case 40: {
                return 3;
            }
            case 41: {
                return 4;
            }
            case 57: {
                return nArray[n + 1] + 1;
            }
            case 71: {
                return 1;
            }
            case 72: {
                return 2;
            }
            case 73: {
                return 3;
            }
            case 74: {
                return 4;
            }
            case 23: {
                return nArray[n + 1];
            }
            case 34: {
                return 0;
            }
            case 35: {
                return 1;
            }
            case 36: {
                return 2;
            }
            case 37: {
                return 3;
            }
            case 56: {
                return nArray[n + 1];
            }
            case 67: {
                return 0;
            }
            case 68: {
                return 1;
            }
            case 69: {
                return 2;
            }
            case 70: {
                return 3;
            }
            case 21: {
                return nArray[n + 1];
            }
            case 26: {
                return 0;
            }
            case 27: {
                return 1;
            }
            case 28: {
                return 2;
            }
            case 29: {
                return 3;
            }
            case 54: {
                return nArray[n + 1];
            }
            case 59: {
                return 0;
            }
            case 60: {
                return 1;
            }
            case 61: {
                return 2;
            }
            case 62: {
                return 3;
            }
            case 22: {
                return nArray[n + 1] + 1;
            }
            case 30: {
                return 1;
            }
            case 31: {
                return 2;
            }
            case 32: {
                return 3;
            }
            case 33: {
                return 4;
            }
            case 55: {
                return nArray[n + 1] + 1;
            }
            case 63: {
                return 1;
            }
            case 64: {
                return 2;
            }
            case 65: {
                return 3;
            }
            case 66: {
                return 4;
            }
            case 132: {
                return nArray[n + 1];
            }
            case 169: {
                return nArray[n + 1];
            }
        }
        return 0;
    }

    public static int getConstantPoolIndexSize(int n) {
        switch (n) {
            case 18: {
                return 1;
            }
            case 19: 
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 197: {
                return 2;
            }
        }
        throw new IllegalStateException();
    }

    public static int getOpcodeLength(int[] nArray, int n) {
        switch (nArray[n]) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 190: 
            case 191: 
            case 194: 
            case 195: {
                return 1;
            }
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: 
            case 188: {
                return 2;
            }
            case 17: 
            case 19: 
            case 20: 
            case 132: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 198: 
            case 199: {
                return 3;
            }
            case 197: {
                return 4;
            }
            case 185: 
            case 200: 
            case 201: {
                return 5;
            }
            case 171: {
                return JavaOpcode.getLookupSwitchLength(nArray, n);
            }
            case 170: {
                return JavaOpcode.getTableSwitchLength(nArray, n);
            }
            case 196: {
                if (nArray[n + 1] == 132) {
                    return 6;
                }
                return 4;
            }
        }
        System.err.println("Java Opcode - getOpcodeLength - reserved instrution!");
        return 1;
    }

    private static int getLookupSwitchLength(int[] nArray, int n) {
        int n2 = n;
        for (n = n2 + 1; n < n2 + 5 && n % 4 != 0; ++n) {
        }
        int n3 = nArray[n += 4] << 24 | nArray[n + 1] << 16 | nArray[n + 2] << 8 | nArray[n + 3];
        n += 4;
        return (n += 8 * n3) - n2;
    }

    private static int getTableSwitchLength(int[] nArray, int n) {
        int n2 = n;
        for (n = n2 + 1; n < n2 + 4 && n % 4 != 0; ++n) {
        }
        int n3 = nArray[n += 4] << 24 | nArray[n + 1] << 16 | nArray[n + 2] << 8 | nArray[n + 3];
        int n4 = nArray[n += 4] << 24 | nArray[n + 1] << 16 | nArray[n + 2] << 8 | nArray[n + 3];
        n += 4;
        return (n += 4 * (n4 - n3 + 1)) - n2;
    }
}

