/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.clock;

import dioscuri.Emulator;
import dioscuri.interfaces.Module;
import dioscuri.interfaces.Updateable;
import dioscuri.module.ModuleCPU;
import dioscuri.module.ModuleClock;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.clock.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Clock
extends ModuleClock
implements Runnable {
    private static final Logger logger = Logger.getLogger(Clock.class.getName());
    private Timer[] timers = new Timer[10];
    private boolean keepRunning = true;
    private long sleepTime = 1000L;
    private int arrayIndex = 0;
    public static final int TIMER_ARRAY_SIZE = 10;

    public Clock(Emulator emulator) {
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + this.getClass().getName() + " -> AbstractModule created successfully.");
    }

    @Override
    public boolean reset() {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        if (!moduleMotherboard.registerClock(this)) {
            return false;
        }
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] AbstractModule has been reset.");
        return true;
    }

    @Override
    public void stop() {
        this.setKeepRunning(false);
    }

    @Override
    public String getDump() {
        String string = "";
        string = "Clock dump:\n";
        for (int i = 0; i < this.timers.length; ++i) {
            if (this.timers[i] == null) continue;
            string = string + "Timer " + i + ": " + (Object)((Object)this.timers[i].user.getType()) + ", updateInterval=" + this.timers[i].intervalLength + " instr., countdown=" + this.timers[i].currentCount + " instr.\n";
        }
        return string;
    }

    @Override
    public boolean registerDevice(Updateable updateable, int n, boolean bl) {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModuleCPU moduleCPU = (ModuleCPU)super.getConnection(Module.Type.CPU);
        if (this.arrayIndex < 10) {
            this.timers[this.arrayIndex] = new Timer(updateable, n * (moduleCPU.getIPS() / 1000000), bl);
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Device '" + (Object)((Object)updateable.getType()) + "' registered a timer with interval " + this.timers[this.arrayIndex].intervalLength + " instructions");
            ++this.arrayIndex;
            return true;
        }
        return false;
    }

    @Override
    public boolean resetTimer(Updateable updateable, int n) {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModuleCPU moduleCPU = (ModuleCPU)super.getConnection(Module.Type.CPU);
        int n2 = 0;
        while (this.timers[n2] != null) {
            if (this.timers[n2].user.getType() == updateable.getType()) {
                this.timers[n2].reset(n * (moduleCPU.getIPS() / 1000000));
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Device '" + (Object)((Object)updateable.getType()) + "' timer reset to " + this.timers[n2].intervalLength + " instructions");
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean setTimerActiveState(Updateable updateable, boolean bl) {
        int n = 0;
        while (this.timers[n] != null) {
            if (this.timers[n].user.getType() == updateable.getType()) {
                this.timers[n].active = bl;
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Device '" + (Object)((Object)updateable.getType()) + "' timer active state set to " + bl);
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void pulse() {
        int n = 0;
        while (this.timers[n] != null) {
            if (this.timers[n].active) {
                --this.timers[n].currentCount;
                if (this.timers[n].currentCount == 0) {
                    this.timers[n].reset();
                    this.timers[n].user.update();
                }
            }
            ++n;
        }
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                this.keepRunning = false;
            }
        }
    }

    protected void setKeepRunning(boolean bl) {
        this.keepRunning = bl;
    }
}

