/*
 * Decompiled with CFR 0.152.
 */
package gnu.vnc.awt;

import gnu.rfb.Colour;
import gnu.rfb.PixelFormat;
import gnu.rfb.Rect;
import gnu.rfb.keysym;
import gnu.rfb.server.RFBClient;
import gnu.rfb.server.RFBServer;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.io.IOException;

public class VNCRobot
extends Component
implements RFBServer {
    private String displayName;
    private GraphicsDevice device;
    private Robot robot;
    private int mouseModifiers = 0;

    public VNCRobot(int display, String displayName) {
        this.displayName = displayName;
        this.device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        try {
            this.robot = new Robot(this.device);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    @Override
    public void addClient(RFBClient client) {
    }

    @Override
    public void removeClient(RFBClient client) {
    }

    @Override
    public String getDesktopName(RFBClient client) {
        return this.displayName;
    }

    @Override
    public int getFrameBufferWidth(RFBClient client) {
        return this.device.getDefaultConfiguration().getBounds().width;
    }

    @Override
    public int getFrameBufferHeight(RFBClient client) {
        return this.device.getDefaultConfiguration().getBounds().height;
    }

    @Override
    public PixelFormat getPreferredPixelFormat(RFBClient client) {
        return PixelFormat.RGB888;
    }

    @Override
    public boolean allowShared() {
        return true;
    }

    @Override
    public void setClientProtocolVersionMsg(RFBClient client, String protocolVersionMsg) throws IOException {
    }

    @Override
    public void setShared(RFBClient client, boolean shared) throws IOException {
    }

    @Override
    public void setPixelFormat(RFBClient client, PixelFormat pixelFormat) throws IOException {
        pixelFormat.setDirectColorModel((DirectColorModel)Toolkit.getDefaultToolkit().getColorModel());
    }

    @Override
    public void setEncodings(RFBClient client, int[] encodings) throws IOException {
    }

    @Override
    public void fixColourMapEntries(RFBClient client, int firstColour, Colour[] colourMap) throws IOException {
    }

    @Override
    public void frameBufferUpdateRequest(RFBClient client, boolean incremental, int x, int y, int w, int h) throws IOException {
        if (incremental) {
            return;
        }
        BufferedImage image = this.robot.createScreenCapture(new Rectangle(x, y, w, h));
        Rect r = Rect.encode(client.getPreferredEncoding(), client.getPixelFormat(), image, x, y, w, h);
        Rect[] rects = new Rect[]{r};
        try {
            client.writeFrameBufferUpdate(rects);
        }
        catch (IOException xx) {
            xx.printStackTrace();
        }
    }

    @Override
    public void keyEvent(RFBClient client, boolean down, int key) throws IOException {
        int vk = keysym.toVKall(key);
        if (vk != 0) {
            if (down) {
                this.robot.keyPress(vk);
            } else {
                this.robot.keyRelease(vk);
            }
        }
    }

    @Override
    public void pointerEvent(RFBClient client, int buttonMask, int x, int y) throws IOException {
        int newMouseModifiers = 0;
        if ((buttonMask & 1) != 0) {
            newMouseModifiers |= 0x10;
        }
        if ((buttonMask & 2) != 0) {
            newMouseModifiers |= 8;
        }
        if ((buttonMask & 4) != 0) {
            newMouseModifiers |= 4;
        }
        if (newMouseModifiers != this.mouseModifiers) {
            if (this.mouseModifiers == 0) {
                this.robot.keyPress(newMouseModifiers);
            } else {
                this.robot.keyRelease(newMouseModifiers);
            }
            this.mouseModifiers = newMouseModifiers;
        }
        this.robot.mouseMove(x, y);
    }

    @Override
    public void clientCutText(RFBClient client, String text) throws IOException {
    }

    public boolean isUpdateAvailable(RFBClient client) {
        return false;
    }
}

