/*
 * Decompiled with CFR 0.152.
 */
package gnu.awt.virtual;

import gnu.awt.PixelsOwner;
import gnu.awt.virtual.VirtualFramePeer;
import gnu.awt.virtual.VirtualLightweightPeer;
import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.SystemTray;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DesktopPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.LightweightPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.SystemTrayPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.TrayIconPeer;
import java.awt.peer.WindowPeer;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import sun.awt.SunToolkit;

public class VirtualToolkit
extends SunToolkit {
    private static EventQueue eventQueue = new EventQueue();
    protected SunToolkit defaultToolkit = null;
    private DirectColorModel colorModel;
    private Dimension screenSize;

    public void setDefaultToolkit(String className) {
        this.setDefaultToolkit();
        System.setProperty("awt.toolkit", className);
    }

    public VirtualToolkit(DirectColorModel colorModel, int width, int height) {
        if (this.defaultToolkit == null) {
            this.setDefaultToolkit();
        }
        this.colorModel = colorModel;
        this.screenSize = new Dimension(width, height);
    }

    public VirtualToolkit(int depth, int rMask, int gMask, int bMask, int width, int height) {
        this(new DirectColorModel(ColorSpace.getInstance(1000), depth, rMask, gMask, bMask, 0, true, 3), width, height);
    }

    public VirtualToolkit(int width, int height) {
        this(24, 0xFF0000, 65280, 255, width, height);
    }

    public VirtualToolkit(EventQueue eventQueue) {
        this(10000, 10000);
        VirtualToolkit.eventQueue = eventQueue;
    }

    public VirtualToolkit() {
        this(10000, 10000);
    }

    public void setColorModel(DirectColorModel colorModel) {
        this.colorModel = colorModel;
    }

    @Override
    public ButtonPeer createButton(Button target) {
        return null;
    }

    @Override
    public CanvasPeer createCanvas(Canvas target) {
        return null;
    }

    @Override
    public CheckboxPeer createCheckbox(Checkbox target) {
        return null;
    }

    @Override
    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem target) {
        return null;
    }

    @Override
    public ChoicePeer createChoice(Choice target) {
        return null;
    }

    @Override
    protected LightweightPeer createComponent(Component target) {
        return new VirtualLightweightPeer(this, target);
    }

    @Override
    public DialogPeer createDialog(Dialog target) {
        return null;
    }

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dge) {
        return null;
    }

    @Override
    public FileDialogPeer createFileDialog(FileDialog target) {
        return null;
    }

    @Override
    public FramePeer createFrame(Frame target) {
        if (!(target instanceof PixelsOwner)) {
            System.err.println("ERROR[VirtualToolkit]: Virtual toolkit does not support this frame - it is not a PixelsOwner - let's hope it is newer made visible");
            return new VirtualFramePeer(target, null);
        }
        return new VirtualFramePeer(target, (PixelsOwner)((Object)target));
    }

    @Override
    public LabelPeer createLabel(Label target) {
        return null;
    }

    @Override
    public ListPeer createList(List target) {
        return null;
    }

    @Override
    public MenuPeer createMenu(Menu target) {
        return null;
    }

    @Override
    public MenuBarPeer createMenuBar(MenuBar target) {
        return null;
    }

    @Override
    public MenuItemPeer createMenuItem(MenuItem target) {
        return null;
    }

    @Override
    public PanelPeer createPanel(Panel target) {
        return null;
    }

    @Override
    public PopupMenuPeer createPopupMenu(PopupMenu target) {
        return null;
    }

    @Override
    public ScrollbarPeer createScrollbar(Scrollbar target) {
        return null;
    }

    @Override
    public ScrollPanePeer createScrollPane(ScrollPane target) {
        return null;
    }

    @Override
    public TextAreaPeer createTextArea(TextArea target) {
        return null;
    }

    @Override
    public TextFieldPeer createTextField(TextField target) {
        return null;
    }

    @Override
    public WindowPeer createWindow(Window target) {
        return null;
    }

    @Override
    public int checkImage(Image image, int width, int height, ImageObserver observer) {
        return this.defaultToolkit.checkImage(image, width, height, observer);
    }

    @Override
    public Image createImage(byte[] imagedata, int imageoffset, int imagelength) {
        return this.defaultToolkit.createImage(imagedata, imageoffset, imagelength);
    }

    @Override
    public Image createImage(ImageProducer producer) {
        return this.defaultToolkit.createImage(producer);
    }

    @Override
    public Image createImage(String filename) {
        return this.defaultToolkit.createImage(filename);
    }

    @Override
    public Image createImage(URL url) {
        return this.defaultToolkit.createImage(url);
    }

    @Override
    public Image getImage(String filename) {
        return this.defaultToolkit.getImage(filename);
    }

    @Override
    public Image getImage(URL url) {
        return this.defaultToolkit.getImage(url);
    }

    @Override
    public boolean prepareImage(Image image, int width, int height, ImageObserver observer) {
        return this.defaultToolkit.prepareImage(image, width, height, observer);
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public String[] getFontList() {
        return this.defaultToolkit.getFontList();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.defaultToolkit.getFontMetrics(font);
    }

    @Override
    public FontPeer getFontPeer(String name, int style) {
        return null;
    }

    @Override
    public void beep() {
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String jobtitle, Properties prop) {
        return null;
    }

    @Override
    public int getScreenResolution() {
        return -1;
    }

    @Override
    public Dimension getScreenSize() {
        return this.screenSize;
    }

    @Override
    public Clipboard getSystemClipboard() {
        return null;
    }

    @Override
    protected EventQueue getSystemEventQueueImpl() {
        return eventQueue;
    }

    public EventQueue getTheEventQueue() {
        return eventQueue;
    }

    public Map mapInputMethodHighlight(InputMethodHighlight highlight) {
        return null;
    }

    @Override
    public void sync() {
    }

    @Override
    public InputMethodDescriptor getInputMethodAdapterDescriptor() throws AWTException {
        return this.defaultToolkit.getInputMethodAdapterDescriptor();
    }

    public RobotPeer createRobot(Robot p0, GraphicsDevice p1) throws AWTException {
        return this.defaultToolkit.createRobot(p0, p1);
    }

    protected int getScreenWidth() {
        return this.getScreenSize().width;
    }

    protected int getScreenHeight() {
        return this.getScreenSize().height;
    }

    private void setDefaultToolkit() {
        boolean notfound = true;
        String configuredDefaultToolkit = System.getProperty("gnu.awt.virtual.VirtualToolkit.OldDefaultToolkit");
        if (configuredDefaultToolkit != null) {
            try {
                this.defaultToolkit = (SunToolkit)Class.forName(configuredDefaultToolkit).newInstance();
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.defaultToolkit = (SunToolkit)Class.forName("sun.awt.motif.MToolkit").newInstance();
            return;
        }
        catch (Exception exception) {
            try {
                this.defaultToolkit = (SunToolkit)Class.forName("sun.awt.windows.WToolkit").newInstance();
                return;
            }
            catch (Exception exception2) {
                this.defaultToolkit = null;
                if (notfound) {
                    System.err.println("ERROR[gnu.awt.virtual.VirtualToolkit]: could not guess System-toolkit, please set the system-property \"gnu.awt.virtual.VirtualToolkit.OldDefaultToolkit\" to the classname your system-toolkit!");
                }
                this.defaultToolkit = (SunToolkit)Toolkit.getDefaultToolkit();
                return;
            }
        }
    }

    public String getDefaultCharacterEncoding() {
        return null;
    }

    @Override
    public SystemTrayPeer createSystemTray(SystemTray arg0) {
        return null;
    }

    @Override
    public TrayIconPeer createTrayIcon(TrayIcon arg0) throws HeadlessException, AWTException {
        return null;
    }

    @Override
    public void grab(Window arg0) {
    }

    @Override
    public boolean isDesktopSupported() {
        return false;
    }

    @Override
    public boolean isTraySupported() {
        return false;
    }

    public boolean isWindowOpacityControlSupported() {
        return false;
    }

    @Override
    public boolean isWindowShapingSupported() {
        return false;
    }

    @Override
    public boolean isWindowTranslucencySupported() {
        return false;
    }

    protected boolean syncNativeQueue() {
        return false;
    }

    @Override
    public void ungrab(Window arg0) {
    }

    @Override
    protected DesktopPeer createDesktopPeer(Desktop target) throws HeadlessException {
        return null;
    }
}

