/*
 * Decompiled with CFR 0.152.
 */
package gnu.rfb.server;

import gnu.rfb.server.DesCipher;
import gnu.rfb.server.RFBAuthenticator;
import gnu.rfb.server.RFBClient;
import gnu.rfb.server.RFBSocket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;

public class DefaultRFBAuthenticator
implements RFBAuthenticator {
    private int auth;
    String password = null;
    boolean authSuccessfull = false;
    String ip = null;

    public DefaultRFBAuthenticator(String password) {
        this.password = password;
        this.auth = 2;
    }

    @Override
    public int getAuthScheme(RFBClient client) {
        return this.auth;
    }

    @Override
    public boolean authenticate(DataInputStream in, DataOutputStream out, RFBSocket clientSocket) throws IOException {
        System.out.println("Starting authenication for defaultRFBAuthenicator: ");
        out.writeInt(2);
        this.ip = clientSocket.getInetAddress().getHostAddress();
        System.out.println("Starting authenication for SecurityRFBAuthenicator: " + this.ip);
        this.authSuccessfull = DefaultRFBAuthenticator.enterPassword(in, out, this.password);
        if (this.authSuccessfull) {
            System.out.println("authentication successfull.  Asking user to enter password");
        } else {
            out.writeInt(0);
            out.writeBytes("Security Authentication failed.  You must be logged on to ESPM in order to use this function");
        }
        out.flush();
        return this.authSuccessfull;
    }

    public static boolean enterPassword(DataInputStream in, DataOutputStream out, String password) throws IOException {
        Random rand = new Random(System.currentTimeMillis());
        byte[] bytes = new byte[16];
        rand.nextBytes(bytes);
        out.write(bytes);
        out.flush();
        byte[] encryptedBytes = new byte[16];
        byte[] decryptedBytes = new byte[16];
        in.read(encryptedBytes);
        DesCipher cipher = new DesCipher(password.getBytes());
        System.out.println("Password is:" + new String(password));
        cipher.decrypt(encryptedBytes, 0, decryptedBytes, 0);
        cipher.decrypt(encryptedBytes, 8, decryptedBytes, 8);
        System.out.println("Client sent us:" + new String(decryptedBytes));
        boolean authSuccessful = true;
        int i = 0;
        while (i < 16) {
            if (bytes[i] != decryptedBytes[i]) {
                authSuccessful = false;
                break;
            }
            ++i;
        }
        if (authSuccessful) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
        }
        out.flush();
        return authSuccessful;
    }
}

