/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends OutputStream {
    private final OutputStream backing;
    private int count;

    public CountingOutputStream(OutputStream outputStream) {
        this.backing = outputStream;
        this.count = 0;
    }

    public int position() {
        return this.count;
    }

    @Override
    public void close() throws IOException {
        this.backing.close();
    }

    @Override
    public void flush() throws IOException {
        this.backing.flush();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (this.count + byArray.length > 65535) {
            throw new IllegalStateException("Oversize Method");
        }
        this.backing.write(byArray);
        this.count += byArray.length;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.count + n2 > 65535) {
            throw new IllegalStateException("Oversize Method");
        }
        this.backing.write(byArray, n, n2);
        this.count += n2;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.count + 1 > 65535) {
            throw new IllegalStateException("Oversize Method");
        }
        this.backing.write(n);
        ++this.count;
    }
}

