/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.ByteSourceWrappedMemory;
import dioscuri.module.cpu32.CodeBlock;
import dioscuri.module.cpu32.CodeBlockFactory;
import dioscuri.module.cpu32.PhysicalAddressSpace;
import dioscuri.module.cpu32.Processor;
import dioscuri.module.cpu32.RealModeCodeBlock;
import dioscuri.module.cpu32.SpanningCodeBlock;

public class SpanningRealModeCodeBlock
extends SpanningCodeBlock
implements RealModeCodeBlock {
    private ByteSourceWrappedMemory byteSource = new ByteSourceWrappedMemory();
    private CodeBlockFactory[] factories;

    public SpanningRealModeCodeBlock(CodeBlockFactory[] codeBlockFactoryArray) {
        this.factories = codeBlockFactoryArray;
    }

    @Override
    protected CodeBlock decode(Processor processor) {
        RealModeCodeBlock realModeCodeBlock = null;
        PhysicalAddressSpace physicalAddressSpace = processor.physicalMemory;
        int n = processor.getInstructionPointer();
        for (int i = 0; i < this.factories.length && realModeCodeBlock == null; ++i) {
            try {
                this.byteSource.set(physicalAddressSpace, n);
                realModeCodeBlock = this.factories[i].getRealModeCodeBlock(this.byteSource);
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return realModeCodeBlock;
    }

    @Override
    public String getDisplayString() {
        return "Spanning Real Mode CodeBlock";
    }
}

