/*
 * Decompiled with CFR 0.152.
 */
package gnu.rfb;

import gnu.rfb.CoRRE;
import gnu.rfb.PixelFormat;
import gnu.rfb.Rect;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;

public class CoRREStub
extends Rect {
    public CoRRE[] rects;

    public CoRREStub(int[] pixels, PixelFormat pixelFormat, int offsetX, int offsetY, int scanline, int x, int y, int w, int h) {
        super(x, y, w, h);
        Vector<CoRRE> vector = new Vector<CoRRE>();
        if (w <= 255 && h <= 255) {
            CoRRE rect = new CoRRE(pixels, pixelFormat, offsetX, offsetY, scanline, x, y, w, h);
            vector.addElement(rect);
        } else {
            int currentY = 0;
            while (currentY < h) {
                int currentX = 0;
                while (currentX < w) {
                    int currentW = w - currentX;
                    int currentH = h - currentY;
                    if (currentW > 255) {
                        currentW = 255;
                    }
                    if (currentH > 255) {
                        currentH = 255;
                    }
                    CoRRE rect = new CoRRE(pixels, pixelFormat, offsetX, offsetY, scanline, x + currentX, y + currentY, currentW, currentH);
                    vector.addElement(rect);
                    currentX += 255;
                }
                currentY += 255;
            }
        }
        this.rects = new CoRRE[vector.size()];
        vector.toArray(this.rects);
        this.count = this.rects.length;
    }

    public CoRREStub(int x, int y, int w, int h, CoRRE[] rects) {
        super(x, y, w, h);
        this.rects = rects;
    }

    @Override
    public void writeData(DataOutput output) throws IOException {
        int i = 0;
        while (i < this.rects.length) {
            this.rects[i].writeData(output);
            ++i;
        }
    }

    @Override
    public void transform(int transformX, int transformY) {
        int i = 0;
        while (i < this.rects.length) {
            this.rects[i].transform(transformX, transformY);
            ++i;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CoRRE[] rectsClone = new CoRRE[this.rects.length];
        int i = 0;
        while (i < this.rects.length) {
            rectsClone[i] = (CoRRE)this.rects[i].clone();
            ++i;
        }
        return new CoRREStub(this.x, this.y, this.w, this.h, rectsClone);
    }
}

