/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.GUI;
import dioscuri.config.AbstractModulePanel;
import dioscuri.config.Emulator;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.math.BigInteger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class BiosPanel
extends AbstractModulePanel {
    final Emulator.Architecture.Modules.Bios bios;
    final JTextField sysBios = new JTextField();
    final JButton browseSysBios = new JButton("browse");
    final JTextField vgaBios = new JTextField();
    final JButton browseVgaBios = new JButton("browse");
    final JTextField sysBiosStart = new JTextField();
    final JTextField vgaBiosStart = new JTextField();

    BiosPanel(GUI gUI, Emulator emulator) {
        super(gUI, emulator);
        this.bios = emulator.getArchitecture().getModules().getBios().get(0);
        super.setLayout(new GridLayout(0, 3, 5, 5));
        this.sysBios.setText(new File(this.bios.getSysbiosfilepath()).getAbsolutePath());
        this.vgaBios.setText(new File(this.bios.getVgabiosfilepath()).getAbsolutePath());
        this.sysBiosStart.setText(this.bios.getRamaddresssysbiosstartdec().toString());
        this.vgaBiosStart.setText(this.bios.getRamaddressvgabiosstartdec().toString());
        this.sysBios.setToolTipText(this.sysBios.getText());
        this.vgaBios.setToolTipText(this.vgaBios.getText());
        this.sysBios.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                BiosPanel.this.sysBios.setCaretPosition(BiosPanel.this.sysBios.getText().length());
            }
        });
        this.vgaBios.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                BiosPanel.this.vgaBios.setCaretPosition(BiosPanel.this.vgaBios.getText().length());
            }
        });
        super.add(new JLabel("System BIOS"));
        super.add(this.sysBios);
        super.add(this.browseSysBios);
        this.sysBios.setEditable(false);
        super.add(new JLabel("VGA BIOS"));
        super.add(this.vgaBios);
        super.add(this.browseVgaBios);
        this.vgaBios.setEditable(false);
        super.add(new JLabel("System BIOS start"));
        super.add(this.sysBiosStart);
        super.add(new JLabel());
        super.add(new JLabel("System BIOS start"));
        super.add(this.vgaBiosStart);
        super.add(new JLabel());
        this.browseSysBios.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = BiosPanel.super.chooseFile();
                if (file != null) {
                    BiosPanel.this.sysBios.setText(file.getAbsolutePath());
                    BiosPanel.this.sysBios.setToolTipText(BiosPanel.this.sysBios.getText());
                }
            }
        });
        this.browseVgaBios.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = BiosPanel.super.chooseFile();
                if (file != null) {
                    BiosPanel.this.vgaBios.setText(file.getAbsolutePath());
                    BiosPanel.this.vgaBios.setToolTipText(BiosPanel.this.vgaBios.getText());
                }
            }
        });
    }

    @Override
    void save() throws Exception {
        this.bios.setSysbiosfilepath(this.sysBios.getText());
        this.bios.setVgabiosfilepath(this.vgaBios.getText());
        this.bios.setRamaddresssysbiosstartdec(new BigInteger(this.sysBiosStart.getText()));
        this.bios.setRamaddressvgabiosstartdec(new BigInteger(this.vgaBiosStart.getText()));
    }
}

