/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.ByteSource;
import dioscuri.module.cpu32.Memory;

public class ByteSourceWrappedMemory
implements ByteSource {
    private Memory source;
    private int offset;
    private int startingPosition;

    public void set(Memory memory, int n) {
        this.source = memory;
        this.offset = n;
        this.startingPosition = n;
    }

    public Memory getMemory() {
        return this.source;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public byte getByte() {
        return this.source.getByte(this.offset++);
    }

    @Override
    public boolean skip(int n) {
        if ((long)(this.offset + n) >= this.source.getSize()) {
            return false;
        }
        this.offset += n;
        return true;
    }

    @Override
    public boolean rewind(int n) {
        if (this.offset - n < this.startingPosition) {
            return false;
        }
        this.offset -= n;
        return true;
    }

    @Override
    public boolean reset() {
        this.offset = this.startingPosition;
        return true;
    }
}

