/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.ClassFile;
import dioscuri.module.cpu32.CountingOutputStream;
import dioscuri.module.cpu32.ExceptionHandler;
import dioscuri.module.cpu32.Processor;
import dioscuri.module.cpu32.ProcessorException;
import dioscuri.module.cpu32.RPNNode;
import dioscuri.module.cpu32.RealModeRPNNode;
import java.io.IOException;
import java.util.Map;

public class RealModeExceptionHandler
extends ExceptionHandler {
    public RealModeExceptionHandler(int n, RealModeRPNNode realModeRPNNode, Map<Integer, RPNNode> map) {
        super(n, realModeRPNNode, map);
    }

    @Override
    protected void writeHandlerRoutine(CountingOutputStream countingOutputStream, ClassFile classFile) throws IOException {
        int n;
        countingOutputStream.write(182);
        try {
            n = classFile.addToConstantPool(ProcessorException.class.getDeclaredMethod("getVector", null));
            if (n > 65535) {
                throw new IllegalStateException("Compilation ran out of constant pool slots");
            }
            countingOutputStream.write(n >>> 8);
            countingOutputStream.write(n & 0xFF);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(noSuchMethodException);
        }
        countingOutputStream.write(43);
        countingOutputStream.write(95);
        countingOutputStream.write(182);
        try {
            n = classFile.addToConstantPool(Processor.class.getDeclaredMethod("handleRealModeException", Integer.TYPE));
            if (n > 65535) {
                throw new IllegalStateException("Compilation ran out of constant pool slots");
            }
            countingOutputStream.write(n >>> 8);
            countingOutputStream.write(n & 0xFF);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(noSuchMethodException);
        }
    }
}

