/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.serialport;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.UnknownPortException;
import dioscuri.exception.WriteOnlyPortException;
import dioscuri.interfaces.Module;
import dioscuri.interfaces.UART;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.ModulePIC;
import dioscuri.module.ModuleSerialPort;
import dioscuri.module.serialport.ComPort;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SerialPort
extends ModuleSerialPort {
    private static final Logger logger = Logger.getLogger(SerialPort.class.getName());
    private int updateInterval;
    private ComPort[] comPorts = new ComPort[4];
    public static final int TOTALCOMPORTS = 4;
    private static final int[] IOPORTS = new int[]{1016, 760, 1000, 744};
    private static final int THR = 0;
    private static final int RBR = 0;
    private static final int DLL = 0;
    private static final int DLM = 1;
    private static final int IER = 1;
    private static final int IIR = 2;
    private static final int FCR = 2;
    private static final int LCR = 3;
    private static final int MCR = 4;
    private static final int LSR = 5;
    private static final int MSR = 6;
    private static final int SCR = 7;
    private static final int INTERRUPT_IER = 0;
    private static final int INTERRUPT_RXDATA = 1;
    private static final int INTERRUPT_TXHOLD = 2;
    private static final int INTERRUPT_RXLSTAT = 3;
    private static final int INTERRUPT_MODSTAT = 4;
    private static final int INTERRUPT_FIFO = 5;
    private static final int BUFFERSIZE = 16;
    private static final double CLOCKSPEED = 1843200.0;

    public SerialPort(Emulator emulator) {
        for (int i = 0; i < 4; ++i) {
            this.comPorts[i] = new ComPort();
        }
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] " + this.getClass().getName() + " -> AbstractModule created successfully.");
    }

    @Override
    public boolean reset() {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
        for (int i = 0; i < this.comPorts.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                moduleMotherboard.setIOPort(IOPORTS[i] + j, this);
            }
            this.comPorts[i].reset();
            if (i >= 1) continue;
            this.comPorts[i].irq = modulePIC.requestIRQNumber(this);
            if (this.comPorts[i].irq > -1) {
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " IRQ number set to: " + this.comPorts[i].irq);
                continue;
            }
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Request of IRQ number failed.");
        }
        this.updateInterval = 0;
        if (!moduleMotherboard.requestTimer(this, this.updateInterval, false)) {
            return false;
        }
        moduleMotherboard.setTimerActiveState(this, false);
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] AbstractModule has been reset.");
        return true;
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void setUpdateInterval(int n) {
        this.updateInterval = n > 0 ? n : 200;
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        moduleMotherboard.resetTimer(this, this.updateInterval);
    }

    @Override
    public void update() {
        int n = 0;
        boolean bl = false;
        if (this.comPorts[n].uartDevice != null) {
            int n2 = this.comPorts[n].baudrate / (this.comPorts[n].lcr_wordlen_sel + 5);
            byte by = 0;
            if (this.comPorts[n].lsr_rxdata_ready == 0 || this.comPorts[n].fcr_enable == 1) {
                if (this.comPorts[n].uartDevice.isDataAvailable()) {
                    by = this.comPorts[n].uartDevice.getSerialData();
                    bl = true;
                }
                if (bl) {
                    if (this.comPorts[n].mcr_local_loopback != 1) {
                        this.enqueueReceivedData(n, by);
                    }
                } else if (this.comPorts[n].fcr_enable == 0) {
                    n2 = 10;
                }
            } else {
                n2 *= 4;
            }
            ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
            moduleMotherboard.resetTimer(this, (int)(1000000.0 / (double)this.comPorts[n].baudrate));
            moduleMotherboard.setTimerActiveState(this, true);
        }
    }

    @Override
    public byte getIOPortByte(int n) throws UnknownPortException, WriteOnlyPortException {
        int n2;
        byte by = 0;
        int n3 = n & 7;
        switch (n & 0x3F8) {
            case 1016: {
                n2 = 0;
                break;
            }
            case 760: {
                n2 = 1;
                break;
            }
            case 1000: {
                n2 = 2;
                break;
            }
            case 744: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 0;
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Unknown COM-port. Selected default (COM1)");
            }
        }
        switch (n3) {
            case 0: {
                if (this.comPorts[n2].lcr_dlab == 1) {
                    by = this.comPorts[n2].dll;
                    break;
                }
                if (this.comPorts[n2].fcr_enable == 1) {
                    by = this.comPorts[n2].rcvrFIFO.poll();
                    if (!this.comPorts[n2].rcvrFIFO.isEmpty()) break;
                    this.comPorts[n2].lsr_rxdata_ready = 0;
                    this.comPorts[n2].rx_interrupt = 0;
                    this.comPorts[n2].rx_ipending = 0;
                    this.comPorts[n2].fifo_interrupt = 0;
                    this.comPorts[n2].fifo_ipending = 0;
                    this.clearIRQ(n2);
                    break;
                }
                by = this.comPorts[n2].rbr;
                this.comPorts[n2].lsr_rxdata_ready = 0;
                this.comPorts[n2].rx_interrupt = 0;
                this.comPorts[n2].rx_ipending = 0;
                this.clearIRQ(n2);
                break;
            }
            case 1: {
                if (this.comPorts[n2].lcr_dlab == 1) {
                    by = this.comPorts[n2].dlm;
                    break;
                }
                by = (byte)(this.comPorts[n2].ier_rxdata_enable | this.comPorts[n2].ier_txhold_enable << 1 | this.comPorts[n2].ier_rxlstat_enable << 2 | this.comPorts[n2].ier_modstat_enable << 3);
                break;
            }
            case 2: {
                if (this.comPorts[n2].ls_interrupt == 1) {
                    this.comPorts[n2].iir_int_ID = 3;
                    this.comPorts[n2].iir_ipending = 0;
                } else if (this.comPorts[n2].fifo_interrupt == 1) {
                    this.comPorts[n2].iir_int_ID = 6;
                    this.comPorts[n2].iir_ipending = 0;
                } else if (this.comPorts[n2].rx_interrupt == 1) {
                    this.comPorts[n2].iir_int_ID = 2;
                    this.comPorts[n2].iir_ipending = 0;
                } else if (this.comPorts[n2].tx_interrupt == 1) {
                    this.comPorts[n2].iir_int_ID = 1;
                    this.comPorts[n2].iir_ipending = 0;
                } else if (this.comPorts[n2].ms_interrupt == 1) {
                    this.comPorts[n2].iir_int_ID = 0;
                    this.comPorts[n2].iir_ipending = 0;
                } else {
                    this.comPorts[n2].iir_int_ID = 0;
                    this.comPorts[n2].iir_ipending = 1;
                }
                this.comPorts[n2].tx_interrupt = 0;
                this.clearIRQ(n2);
                by = (byte)(this.comPorts[n2].iir_ipending | this.comPorts[n2].iir_int_ID << 1 | (this.comPorts[n2].fcr_enable == 1 ? 192 : 0));
                break;
            }
            case 3: {
                by = (byte)(this.comPorts[n2].lcr_wordlen_sel | this.comPorts[n2].lcr_stopbits << 2 | this.comPorts[n2].lcr_parity_enable << 3 | this.comPorts[n2].lcr_evenparity_sel << 4 | this.comPorts[n2].lcr_stick_parity << 5 | this.comPorts[n2].lcr_break_cntl << 6 | this.comPorts[n2].lcr_dlab << 7);
                break;
            }
            case 4: {
                by = (byte)(this.comPorts[n2].mcr_dtr | this.comPorts[n2].mcr_rts << 1 | this.comPorts[n2].mcr_out1 << 2 | this.comPorts[n2].mcr_out2 << 3 | this.comPorts[n2].mcr_local_loopback << 4);
                break;
            }
            case 5: {
                by = (byte)(this.comPorts[n2].lsr_rxdata_ready | this.comPorts[n2].lsr_overrun_error << 1 | this.comPorts[n2].lsr_parity_error << 2 | this.comPorts[n2].lsr_framing_error << 3 | this.comPorts[n2].lsr_break_int << 4 | this.comPorts[n2].lsr_thr_empty << 5 | this.comPorts[n2].lsr_tsr_empty << 6 | this.comPorts[n2].lsr_fifo_error << 7);
                this.comPorts[n2].lsr_overrun_error = 0;
                this.comPorts[n2].lsr_parity_error = 0;
                this.comPorts[n2].lsr_framing_error = 0;
                this.comPorts[n2].lsr_break_int = 0;
                this.comPorts[n2].lsr_fifo_error = 0;
                this.comPorts[n2].ls_interrupt = 0;
                this.comPorts[n2].ls_ipending = 0;
                this.clearIRQ(n2);
                break;
            }
            case 6: {
                by = (byte)(this.comPorts[n2].msr_delta_cts | this.comPorts[n2].msr_delta_dsr << 1 | this.comPorts[n2].msr_ri_trailedge << 2 | this.comPorts[n2].msr_delta_dcd << 3 | this.comPorts[n2].msr_cts << 4 | this.comPorts[n2].msr_dsr << 5 | this.comPorts[n2].msr_ri << 6 | this.comPorts[n2].msr_dcd << 7);
                this.comPorts[n2].msr_delta_cts = 0;
                this.comPorts[n2].msr_delta_dsr = 0;
                this.comPorts[n2].msr_ri_trailedge = 0;
                this.comPorts[n2].msr_delta_dcd = 0;
                this.comPorts[n2].ms_interrupt = 0;
                this.comPorts[n2].ms_ipending = 0;
                this.clearIRQ(n2);
                break;
            }
            case 7: {
                by = this.comPorts[n2].scr;
                break;
            }
            default: {
                by = -1;
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Error while reading I/O port 0x" + Integer.toHexString(n).toUpperCase() + ": no case match");
            }
        }
        logger.log(Level.FINE, "[" + (Object)((Object)super.getType()) + "]" + " Read (byte) from port 0x" + Integer.toHexString(n).toUpperCase() + ": 0x" + Integer.toHexString(by & 0xFF).toUpperCase());
        return by;
    }

    @Override
    public void setIOPortByte(int n, byte by) throws UnknownPortException {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Write (byte) to port " + Integer.toHexString(n).toUpperCase() + ": 0x" + Integer.toHexString(by & 0xFF).toUpperCase());
        boolean bl = false;
        int n2 = 0;
        int n3 = by & 1;
        int n4 = (by & 2) >> 1;
        int n5 = (by & 4) >> 2;
        int n6 = (by & 8) >> 3;
        int n7 = (by & 0x10) >> 4;
        int n8 = (by & 0x20) >> 5;
        int n9 = (by & 0x40) >> 6;
        int n10 = (by & 0x80) >> 7 & 1;
        int n11 = n & 7;
        switch (n & 0x3F8) {
            case 1016: {
                n2 = 0;
                break;
            }
            case 760: {
                n2 = 1;
                break;
            }
            case 1000: {
                n2 = 2;
                break;
            }
            case 744: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 0;
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Unknown COM-port. Selected default (COM1)");
            }
        }
        switch (n11) {
            case 0: {
                if (this.comPorts[n2].lcr_dlab == 1) {
                    this.comPorts[n2].dll = by;
                    if (this.comPorts[n2].dll == 0 && this.comPorts[n2].dlm == 0) break;
                    this.comPorts[n2].baudrate = (int)(1843200.0 / (double)(16 * (this.comPorts[n2].dlm << 8 | this.comPorts[n2].dll)));
                    break;
                }
                byte by2 = (byte)(255 >> 3 - this.comPorts[n2].lcr_wordlen_sel);
                if (this.comPorts[n2].lsr_thr_empty == 1) {
                    if (this.comPorts[n2].fcr_enable == 1) {
                        this.comPorts[n2].xmitFIFO.offer((byte)(by & by2));
                    } else {
                        this.comPorts[n2].thr = (byte)(by & by2);
                    }
                    this.comPorts[n2].lsr_thr_empty = 0;
                    if (this.comPorts[n2].lsr_tsr_empty == 1) {
                        if (this.comPorts[n2].fcr_enable == 1) {
                            this.comPorts[n2].tsr = this.comPorts[n2].xmitFIFO.poll();
                            this.comPorts[n2].lsr_thr_empty = this.comPorts[n2].xmitFIFO.isEmpty() ? 1 : 0;
                        } else {
                            this.comPorts[n2].tsr = this.comPorts[n2].thr;
                            this.comPorts[n2].lsr_thr_empty = 1;
                        }
                        this.comPorts[n2].lsr_tsr_empty = 0;
                        this.setIRQ(n2, 2);
                        moduleMotherboard.resetTimer(this, (int)(1000000.0 / (double)this.comPorts[n2].baudrate * (double)(this.comPorts[n2].lcr_wordlen_sel + 5)));
                        moduleMotherboard.setTimerActiveState(this, true);
                        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Timer activated");
                        break;
                    }
                    this.comPorts[n2].tx_interrupt = 0;
                    this.clearIRQ(n2);
                    break;
                }
                if (this.comPorts[n2].fcr_enable == 1) {
                    if (this.comPorts[n2].xmitFIFO.size() < 16) {
                        this.comPorts[n2].xmitFIFO.offer((byte)(by & by2));
                        break;
                    }
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Error: FIFO buffer overflow");
                    this.comPorts[n2].lsr_overrun_error = 1;
                    break;
                }
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Error: THR buffer overflow. Can not write to buffer while not empty");
                this.comPorts[n2].lsr_overrun_error = 1;
                break;
            }
            case 1: {
                if (this.comPorts[n2].lcr_dlab == 1) {
                    this.comPorts[n2].dlm = by;
                    if (this.comPorts[n2].dlm == 0 && this.comPorts[n2].dll == 0) break;
                    this.comPorts[n2].baudrate = (int)(1843200.0 / (double)(16 * (this.comPorts[n2].dlm << 8 | this.comPorts[n2].dll)));
                    break;
                }
                if (n6 != this.comPorts[n2].ier_modstat_enable) {
                    this.comPorts[n2].ier_modstat_enable = n6;
                    if (this.comPorts[n2].ier_modstat_enable == 1) {
                        if (this.comPorts[n2].ms_ipending == 1) {
                            this.comPorts[n2].ms_interrupt = 1;
                            this.comPorts[n2].ms_ipending = 0;
                            bl = true;
                        }
                    } else if (this.comPorts[n2].ms_interrupt == 1) {
                        this.comPorts[n2].ms_interrupt = 0;
                        this.comPorts[n2].ms_ipending = 1;
                        this.clearIRQ(n2);
                    }
                }
                if (n3 != this.comPorts[n2].ier_rxdata_enable) {
                    this.comPorts[n2].ier_rxdata_enable = n3;
                    if (this.comPorts[n2].ier_rxdata_enable == 1) {
                        if (this.comPorts[n2].fifo_ipending == 1) {
                            this.comPorts[n2].fifo_interrupt = 1;
                            this.comPorts[n2].fifo_ipending = 0;
                            bl = true;
                        }
                        if (this.comPorts[n2].rx_ipending == 1) {
                            this.comPorts[n2].rx_interrupt = 1;
                            this.comPorts[n2].rx_ipending = 0;
                            bl = true;
                        }
                    } else {
                        if (this.comPorts[n2].rx_interrupt == 1) {
                            this.comPorts[n2].rx_interrupt = 0;
                            this.comPorts[n2].rx_ipending = 1;
                            this.clearIRQ(n2);
                        }
                        if (this.comPorts[n2].fifo_interrupt == 1) {
                            this.comPorts[n2].fifo_interrupt = 0;
                            this.comPorts[n2].fifo_ipending = 1;
                            this.clearIRQ(n2);
                        }
                    }
                }
                if (n4 != this.comPorts[n2].ier_txhold_enable) {
                    this.comPorts[n2].ier_txhold_enable = n4;
                    if (this.comPorts[n2].ier_txhold_enable == 1) {
                        this.comPorts[n2].tx_interrupt = this.comPorts[n2].lsr_thr_empty;
                        if (this.comPorts[n2].tx_interrupt == 1) {
                            bl = true;
                        }
                    } else {
                        this.comPorts[n2].tx_interrupt = 0;
                        this.clearIRQ(n2);
                    }
                }
                if (n5 != this.comPorts[n2].ier_rxlstat_enable) {
                    this.comPorts[n2].ier_rxlstat_enable = n5;
                    if (this.comPorts[n2].ier_rxlstat_enable == 1) {
                        if (this.comPorts[n2].ls_ipending == 1) {
                            this.comPorts[n2].ls_interrupt = 1;
                            this.comPorts[n2].ls_ipending = 0;
                            bl = true;
                        }
                    } else if (this.comPorts[n2].ls_interrupt == 1) {
                        this.comPorts[n2].ls_interrupt = 0;
                        this.comPorts[n2].ls_ipending = 1;
                        this.clearIRQ(n2);
                    }
                }
                if (!bl) break;
                this.setIRQ(n2, 0);
                break;
            }
            case 2: {
                if (n3 == 1 && this.comPorts[n2].fcr_enable != 1) {
                    this.comPorts[n2].rcvrFIFO.clear();
                    this.comPorts[n2].xmitFIFO.clear();
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " FIFO buffer enabled");
                }
                this.comPorts[n2].fcr_enable = n3;
                if (n4 == 1) {
                    this.comPorts[n2].rcvrFIFO.clear();
                }
                if (n5 == 1) {
                    this.comPorts[n2].xmitFIFO.clear();
                }
                this.comPorts[n2].fcr_rxtrigger = (by & 0xC0) >> 6;
                break;
            }
            case 3: {
                int n12;
                this.comPorts[n2].lcr_wordlen_sel = n12 = by & 3;
                this.comPorts[n2].lcr_stopbits = n5;
                this.comPorts[n2].lcr_parity_enable = n6;
                this.comPorts[n2].lcr_evenparity_sel = n7;
                this.comPorts[n2].lcr_stick_parity = n8;
                this.comPorts[n2].lcr_break_cntl = n9;
                if (this.comPorts[n2].mcr_local_loopback == 1 && this.comPorts[n2].lcr_break_cntl == 1) {
                    this.comPorts[n2].lsr_break_int = 1;
                    this.comPorts[n2].lsr_framing_error = 1;
                    this.enqueueReceivedData(n2, (byte)0);
                }
                if (n10 == 0 && this.comPorts[n2].lcr_dlab == 1) {
                    if (this.comPorts[n2].rx_pollstate == 0 && this.comPorts[n2].baudrate != 0) {
                        this.comPorts[n2].rx_pollstate = 1;
                        moduleMotherboard.resetTimer(this, (int)(1000000.0 / (double)this.comPorts[n2].baudrate * (double)(this.comPorts[n2].lcr_wordlen_sel + 5)));
                        moduleMotherboard.setTimerActiveState(this, true);
                        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Timer activated");
                    }
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " baud rate of COM1 set to " + this.comPorts[n2].baudrate);
                }
                this.comPorts[n2].lcr_dlab = n10;
                break;
            }
            case 4: {
                this.comPorts[n2].mcr_dtr = n3;
                this.comPorts[n2].mcr_rts = n4;
                this.comPorts[n2].mcr_out1 = n5;
                this.comPorts[n2].mcr_out2 = n6;
                if (n7 != this.comPorts[n2].mcr_local_loopback) {
                    this.comPorts[n2].mcr_local_loopback = n7;
                    if (this.comPorts[n2].mcr_local_loopback == 1 && this.comPorts[n2].lcr_break_cntl == 1) {
                        this.comPorts[n2].lsr_break_int = 1;
                        this.comPorts[n2].lsr_framing_error = 1;
                        this.enqueueReceivedData(n2, (byte)0);
                    }
                }
                if (this.comPorts[n2].mcr_local_loopback == 1) {
                    int n13 = this.comPorts[n2].msr_cts;
                    int n14 = this.comPorts[n2].msr_dsr;
                    int n15 = this.comPorts[n2].msr_ri;
                    int n16 = this.comPorts[n2].msr_dcd;
                    this.comPorts[n2].msr_cts = this.comPorts[n2].mcr_rts;
                    this.comPorts[n2].msr_dsr = this.comPorts[n2].mcr_dtr;
                    this.comPorts[n2].msr_ri = this.comPorts[n2].mcr_out1;
                    this.comPorts[n2].msr_dcd = this.comPorts[n2].mcr_out2;
                    if (this.comPorts[n2].msr_cts != n13) {
                        this.comPorts[n2].msr_delta_cts = 1;
                        this.comPorts[n2].ms_ipending = 1;
                    }
                    if (this.comPorts[n2].msr_dsr != n14) {
                        this.comPorts[n2].msr_delta_dsr = 1;
                        this.comPorts[n2].ms_ipending = 1;
                    }
                    if (this.comPorts[n2].msr_ri != n15) {
                        this.comPorts[n2].ms_ipending = 1;
                    }
                    if (this.comPorts[n2].msr_ri == 0 && n15 == 1) {
                        this.comPorts[n2].msr_ri_trailedge = 1;
                    }
                    if (this.comPorts[n2].msr_dcd != n16) {
                        this.comPorts[n2].msr_delta_dcd = 1;
                        this.comPorts[n2].ms_ipending = 1;
                    }
                    this.setIRQ(n2, 4);
                }
                this.comPorts[n2].msr_cts = 1;
                this.comPorts[n2].msr_dsr = 1;
                this.comPorts[n2].msr_ri = 0;
                this.comPorts[n2].msr_dcd = 0;
                break;
            }
            case 5: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Not allowed to write to line status register (LSR) on port 0x" + Integer.toHexString(n).toUpperCase());
                break;
            }
            case 6: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Not allowed to write to modem status register (MSR) on port 0x" + Integer.toHexString(n).toUpperCase());
                break;
            }
            case 7: {
                this.comPorts[n2].scr = by;
                break;
            }
            default: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Error while writing I/O port 0x" + Integer.toHexString(n).toUpperCase() + ": no case match");
            }
        }
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException, WriteOnlyPortException {
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] IN command (word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Returned default value 0xFFFF to AX");
        return new byte[]{-1, -1};
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] OUT command (word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException, WriteOnlyPortException {
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] IN command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Returned default value 0xFFFFFFFF to eAX");
        return new byte[]{-1, -1, -1, -1};
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] OUT command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public boolean setUARTDevice(UART uART, int n) {
        if (n >= 0 && n < this.comPorts.length) {
            if (this.comPorts[n].uartDevice == null) {
                this.comPorts[n].uartDevice = uART;
                return true;
            }
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] COM port " + (n + 1) + " already occupied.");
        }
        return false;
    }

    private void setIRQ(int n, int n2) {
        boolean bl = false;
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
        switch (n2) {
            case 0: {
                bl = true;
                break;
            }
            case 1: {
                if (this.comPorts[n].ier_rxdata_enable == 1) {
                    this.comPorts[n].rx_interrupt = 1;
                    bl = true;
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] RXDATA interrupt raised and enabled");
                    break;
                }
                this.comPorts[n].rx_ipending = 1;
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] RXDATA interrupt pending...");
                break;
            }
            case 2: {
                if (this.comPorts[n].ier_txhold_enable != 1) break;
                this.comPorts[n].tx_interrupt = 1;
                bl = true;
                break;
            }
            case 3: {
                if (this.comPorts[n].ier_rxlstat_enable == 1) {
                    this.comPorts[n].ls_interrupt = 1;
                    bl = true;
                    break;
                }
                this.comPorts[n].ls_ipending = 1;
                break;
            }
            case 4: {
                if (this.comPorts[n].ier_modstat_enable != 1 || this.comPorts[n].ms_ipending != 1) break;
                this.comPorts[n].ms_interrupt = 1;
                this.comPorts[n].ms_ipending = 0;
                bl = true;
                break;
            }
            case 5: {
                if (this.comPorts[n].ier_rxdata_enable == 1) {
                    this.comPorts[n].fifo_interrupt = 1;
                    bl = true;
                    break;
                }
                this.comPorts[n].fifo_ipending = 1;
            }
        }
        if (bl && this.comPorts[n].mcr_out2 == 1) {
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] Raising IRQ (signalling to PIC)");
            modulePIC.setIRQ(this.comPorts[n].irq);
        }
    }

    private void clearIRQ(int n) {
        if (this.comPorts[n].rx_interrupt == 0 && this.comPorts[n].tx_interrupt == 0 && this.comPorts[n].ls_interrupt == 0 && this.comPorts[n].ms_interrupt == 0 && this.comPorts[n].fifo_interrupt == 0) {
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] Lowering IRQ (signalling to PIC)");
            ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
            modulePIC.clearIRQ(this.comPorts[n].irq);
        }
    }

    private void enqueueReceivedData(int n, byte by) {
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] enqueueReceivedData(...)");
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
        boolean bl = false;
        if (this.comPorts[n].fcr_enable == 1) {
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] enqueue data in FIFO");
            if (this.comPorts[n].rcvrFIFO.size() == 16) {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] FIFO buffer overflow");
                this.comPorts[n].lsr_overrun_error = 1;
                this.setIRQ(n, 3);
            } else {
                this.comPorts[n].rcvrFIFO.offer(by);
                switch (this.comPorts[n].fcr_rxtrigger) {
                    case 1: {
                        if (this.comPorts[n].rcvrFIFO.size() != 4) break;
                        bl = true;
                        break;
                    }
                    case 2: {
                        if (this.comPorts[n].rcvrFIFO.size() != 8) break;
                        bl = true;
                        break;
                    }
                    case 3: {
                        if (this.comPorts[n].rcvrFIFO.size() != 14) break;
                        bl = true;
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    moduleMotherboard.setTimerActiveState(this, false);
                    this.comPorts[n].lsr_rxdata_ready = 1;
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Timer deactivated");
                    this.setIRQ(n, 1);
                } else {
                    moduleMotherboard.resetTimer(this, (int)(1000000.0 / (double)this.comPorts[n].baudrate * (double)(this.comPorts[n].lcr_wordlen_sel + 5) * 16.0));
                    moduleMotherboard.setTimerActiveState(this, true);
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Timer activated");
                }
            }
        } else {
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] enqueue data in RBR");
            if (this.comPorts[n].lsr_rxdata_ready == 1) {
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "] Overflow in receive buffer");
                this.comPorts[n].lsr_overrun_error = 1;
                this.setIRQ(n, 3);
            }
            this.comPorts[n].rbr = by;
            this.comPorts[n].lsr_rxdata_ready = 1;
            this.setIRQ(n, 1);
        }
    }
}

