/*
 * Decompiled with CFR 0.152.
 */
package vncjdemo;

import gnu.rfb.server.RFBClient;
import gnu.vnc.pixels.VNCPixels;
import java.io.IOException;
import java.util.Calendar;

public class PixelModelTest
extends VNCPixels {
    int b = 0;
    private static final int[] sectionX;
    private static final int[] sectionY;
    private static final int[] sectionW;
    private static final int[] sectionH;
    private static final int[] sections;
    private static final int marginX = 10;
    private static final int marginY = 10;
    private static final int scale = 5;
    private int[] oldDigit = new int[]{10, 10, 10, 10, 10, 10};
    private int pixel = 255;

    static {
        int[] nArray = new int[7];
        nArray[0] = 1;
        nArray[2] = 7;
        nArray[3] = 1;
        nArray[5] = 7;
        nArray[6] = 1;
        sectionX = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 1;
        nArray2[2] = 1;
        nArray2[3] = 7;
        nArray2[4] = 8;
        nArray2[5] = 8;
        nArray2[6] = 14;
        sectionY = nArray2;
        sectionW = new int[]{6, 1, 1, 6, 1, 1, 6};
        sectionH = new int[]{1, 6, 6, 1, 6, 6, 1};
        int[] nArray3 = new int[11];
        nArray3[0] = 119;
        nArray3[1] = 36;
        nArray3[2] = 93;
        nArray3[3] = 109;
        nArray3[4] = 46;
        nArray3[5] = 107;
        nArray3[6] = 123;
        nArray3[7] = 37;
        nArray3[8] = 127;
        nArray3[9] = 111;
        sections = nArray3;
    }

    public PixelModelTest(int display, String displayName) {
        super(displayName, 305, 95);
        this.colon(true);
    }

    @Override
    public void frameBufferUpdateRequest(RFBClient client, boolean incremental, int x, int y, int w, int h) throws IOException {
        Calendar calendar = Calendar.getInstance();
        System.out.println(calendar);
        int hours = calendar.get(11);
        int minutes = calendar.get(12);
        int seconds = calendar.get(13);
        this.digit(0, hours / 10);
        this.digit(1, hours % 10);
        this.digit(2, minutes / 10);
        this.digit(3, minutes % 10);
        this.digit(4, seconds / 10);
        this.digit(5, seconds % 10);
        super.frameBufferUpdateRequest(client, incremental, x, y, w, h);
    }

    private void colon(boolean on) {
        this.bar(100, 20, 5, 10, on ? this.pixel : 0);
        this.bar(100, 60, 5, 10, on ? this.pixel : 0);
        this.bar(200, 20, 5, 10, on ? this.pixel : 0);
        this.bar(200, 60, 5, 10, on ? this.pixel : 0);
    }

    private void digit(int digit, int number) {
        if (this.oldDigit[digit] != number) {
            int bits = sections[number];
            int oldBits = sections[this.oldDigit[digit]];
            int i = 0;
            while (i < 7) {
                int oldBit = oldBits & 1;
                if (oldBit != (bits & 1)) {
                    this.section(digit, i, oldBit == 0);
                }
                bits >>= 1;
                oldBits >>= 1;
                ++i;
            }
            this.oldDigit[digit] = number;
        }
    }

    private void section(int digit, int section, boolean on) {
        int x = 8 * digit * 5 + (digit > 0 ? 5 * digit : 0) + (digit > 1 ? 10 : 0) + (digit > 3 ? 10 : 0);
        this.bar(10 + x + sectionX[section] * 5, 10 + sectionY[section] * 5, sectionW[section] * 5, sectionH[section] * 5, on ? this.pixel : 0);
    }

    private void bar(int x, int y, int w, int h, int pixel) {
        int[] pixels = this.getPixels();
        int scanline = this.getPixelWidth();
        int jump = scanline - w;
        int size = w * h;
        int p = y * scanline + x;
        int s = 0;
        int i = 0;
        while (i < size) {
            pixels[p++] = pixel;
            if (++s == w) {
                p += jump;
                s = 0;
            }
            ++i;
        }
        p = y * scanline + x;
        pixels[p] = 0;
        pixels[p += w - 1] = 0;
        pixels[p += scanline * (h - 1)] = 0;
        pixels[p -= w - 1] = 0;
        this.queue.addRectangle(x, y, w, h, this);
    }
}

