/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.exception.CPUInstructionException;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_UnaryGrp3_Eb
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = false;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte sourceByte1 = 0;
    byte sourceByte2 = 0;
    byte resultByte = 0;
    byte[] sourceValue = new byte[2];
    byte[] destinationRegister = new byte[2];
    byte registerHighLow = 0;
    int quotient = 0;
    int remainder = 0;
    int overFlowCheck = 0;

    public Instruction_UnaryGrp3_Eb() {
    }

    public Instruction_UnaryGrp3_Eb(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() throws CPUInstructionException {
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        switch ((this.addressByte & 0x38) >> 3) {
            case 0: {
                this.cpu.flags[11] = false;
                this.cpu.flags[0] = false;
                this.cpu.flags[4] = false;
                this.sourceByte1 = this.cpu.getByteFromCode();
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                    this.sourceByte2 = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7)[this.registerHighLow];
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceByte2 = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.resultByte = (byte)(this.sourceByte1 & this.sourceByte2);
                this.cpu.flags[6] = this.resultByte == 0;
                this.cpu.flags[7] = this.resultByte < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.resultByte);
                break;
            }
            case 1: {
                throw new CPUInstructionException("Unary Group 3 (0xF6) illegal reg bits");
            }
            case 2: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                    this.sourceValue[this.registerHighLow] = ~this.sourceValue[this.registerHighLow];
                    break;
                }
                this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                this.sourceByte1 = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                this.sourceByte1 = ~this.sourceByte1;
                this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceByte1);
                break;
            }
            case 3: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                    this.sourceByte1 = this.sourceValue[this.registerHighLow];
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceByte1 = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.sourceByte2 = (byte)(0 - this.sourceByte1);
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceByte2);
                } else {
                    this.sourceValue[this.registerHighLow] = this.sourceByte2;
                }
                this.cpu.flags[0] = this.sourceByte2 != 0;
                this.cpu.flags[11] = Util.test_OF_SUB((byte)0, this.sourceByte1, this.sourceByte2, 0);
                this.cpu.flags[4] = (this.sourceByte2 & 0xF) != 0;
                this.cpu.flags[6] = this.sourceByte2 == 0;
                this.cpu.flags[7] = this.sourceByte2 < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.sourceByte2);
                break;
            }
            case 4: {
                this.destinationRegister = this.cpu.ax;
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.overFlowCheck = (this.destinationRegister[1] & 0xFF) * (this.sourceValue[(this.addressByte & 7) > 3 ? 0 : 1] & 0xFF);
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceByte1 = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                    this.overFlowCheck = (this.destinationRegister[1] & 0xFF) * (this.sourceByte1 & 0xFF);
                }
                this.destinationRegister[1] = (byte)this.overFlowCheck;
                this.destinationRegister[0] = (byte)(this.overFlowCheck >> 8);
                this.cpu.flags[0] = this.destinationRegister[0] != 0;
                this.cpu.flags[11] = this.cpu.flags[0];
                this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
                this.cpu.flags[4] = false;
                this.cpu.flags[6] = this.destinationRegister[1] == 0;
                this.cpu.flags[7] = this.destinationRegister[1] < 0;
                break;
            }
            case 5: {
                this.destinationRegister = this.cpu.ax;
                if ((this.addressByte & 0xC0) >> 6 == 3) {
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                    this.sourceByte1 = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7)[this.registerHighLow];
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceByte1 = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                int n = this.sourceByte1 * this.cpu.ax[1];
                this.cpu.ax[0] = (byte)(n >> 8);
                this.cpu.ax[1] = (byte)(n & 0xFF);
                if (this.cpu.ax[0] == 0) {
                    this.cpu.flags[0] = false;
                    this.cpu.flags[11] = false;
                    break;
                }
                this.cpu.flags[0] = true;
                this.cpu.flags[11] = true;
                break;
            }
            case 6: {
                this.destinationRegister = this.cpu.ax;
                if ((this.addressByte & 0xC0) >> 6 == 3) {
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                    this.sourceByte1 = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7)[this.registerHighLow];
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceByte1 = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.quotient = (((this.destinationRegister[0] & 0xFF) << 8) + (this.destinationRegister[1] & 0xFF)) / (this.sourceByte1 & 0xFF);
                this.remainder = (((this.destinationRegister[0] & 0xFF) << 8) + (this.destinationRegister[1] & 0xFF)) % (this.sourceByte1 & 0xFF);
                this.destinationRegister[1] = (byte)this.quotient;
                this.destinationRegister[0] = (byte)this.remainder;
                break;
            }
            case 7: {
                this.destinationRegister = this.cpu.ax;
                if ((this.addressByte & 0xC0) >> 6 == 3) {
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                    this.sourceByte1 = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7)[this.registerHighLow];
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.sourceByte1 = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.quotient = ((this.destinationRegister[0] << 8) + (this.destinationRegister[1] & 0xFF)) / (this.sourceByte1 & 0xFF);
                this.remainder = ((this.destinationRegister[0] << 8) + (this.destinationRegister[1] & 0xFF)) % (this.sourceByte1 & 0xFF);
                this.destinationRegister[1] = (byte)this.quotient;
                this.destinationRegister[0] = (byte)this.remainder;
                break;
            }
            default: {
                throw new CPUInstructionException("Unary Group 3 (0xF6) illegal reg bits");
            }
        }
    }
}

