/*
 * Decompiled with CFR 0.152.
 */
package gnu.rfb;

import gnu.rfb.PixelFormat;
import gnu.rfb.Rect;
import java.io.DataOutput;
import java.io.IOException;

public class Raw
extends Rect {
    public PixelFormat pixelFormat;
    public byte[] bytes;

    public Raw(int[] pixels, PixelFormat pixelFormat, int offsetX, int offsetY, int scanline, int x, int y, int w, int h) {
        super(x, y, w, h);
        this.pixelFormat = pixelFormat;
        int b = 0;
        int i = 0;
        int s = 0;
        int size = w * h;
        int jump = scanline - w;
        int p = (y - offsetY) * scanline + x - offsetX;
        switch (pixelFormat.bitsPerPixel) {
            case 32: {
                this.bytes = new byte[size << 2];
                while (i < size) {
                    if (s == w) {
                        s = 0;
                        p += jump;
                    }
                    int pixel = pixelFormat.translatePixel(pixels[p]);
                    this.bytes[b++] = (byte)(pixel & 0xFF);
                    this.bytes[b++] = (byte)(pixel >> 8 & 0xFF);
                    this.bytes[b++] = (byte)(pixel >> 16 & 0xFF);
                    this.bytes[b++] = (byte)(pixel >> 24 & 0xFF);
                    ++i;
                    ++s;
                    ++p;
                }
                break;
            }
            case 16: {
                this.bytes = new byte[size << 1];
                while (i < size) {
                    if (s == w) {
                        s = 0;
                        p += jump;
                    }
                    int pixel = pixelFormat.translatePixel(pixels[p]);
                    this.bytes[b++] = (byte)(pixel & 0xFF);
                    this.bytes[b++] = (byte)(pixel >> 8 & 0xFF);
                    ++i;
                    ++s;
                    ++p;
                }
                break;
            }
            case 8: {
                this.bytes = new byte[size];
                while (i < size) {
                    if (s == w) {
                        s = 0;
                        p += jump;
                    }
                    this.bytes[i] = (byte)pixelFormat.translatePixel(pixels[p]);
                    ++i;
                    ++s;
                    ++p;
                }
                break;
            }
        }
    }

    public Raw(int x, int y, int w, int h, PixelFormat pixelFormat, byte[] bytes) {
        super(x, y, w, h);
        this.pixelFormat = pixelFormat;
        this.bytes = bytes;
    }

    @Override
    public void writeData(DataOutput output) throws IOException {
        super.writeData(output);
        output.writeInt(0);
        output.write(this.bytes);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new Raw(this.x, this.y, this.w, this.h, this.pixelFormat, (byte[])this.bytes.clone());
    }
}

