/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_LDS_GvMp
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] segmentSelector = new byte[2];
    byte[] segmentOffset = new byte[2];
    byte[] eSegmentOffset = new byte[2];
    byte[] destinationRegister = new byte[2];
    byte[] eDestinationRegister = new byte[2];

    public Instruction_LDS_GvMp() {
    }

    public Instruction_LDS_GvMp(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
        this.segmentOffset = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
        this.memoryReferenceDisplacement = Util.addWords(this.memoryReferenceDisplacement, new byte[]{0, 2}, 0);
        this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
        this.segmentSelector = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
        this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, (this.addressByte & 0x38) >> 3);
        this.cpu.ds[1] = this.segmentSelector[1];
        this.cpu.ds[0] = this.segmentSelector[0];
        this.destinationRegister[1] = this.segmentOffset[1];
        this.destinationRegister[0] = this.segmentOffset[0];
        if (this.cpu.doubleWord) {
            Util.addWords(this.memoryReferenceDisplacement, new byte[]{0, 4}, 0);
            this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
            this.eSegmentOffset = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
            this.eDestinationRegister = this.cpu.decodeExtraRegister(this.addressByte & 7);
            this.eDestinationRegister[1] = this.eSegmentOffset[1];
            this.eDestinationRegister[0] = this.eSegmentOffset[0];
        }
    }
}

