/*
 * Decompiled with CFR 0.152.
 */
package gnu.rfb;

import gnu.rfb.Rect;
import java.util.Hashtable;

public class RectLibrary {
    private Hashtable rects = new Hashtable();
    private Rect defaultRect = null;

    public Rect getRect(int key) {
        Rect rect = (Rect)this.rects.get(new Integer(key));
        if (rect == null) {
            rect = this.defaultRect;
        }
        return rect;
    }

    public Rect getRect(int key, int originX, int originY) {
        Rect rect = this.getRect(key);
        if (rect != null) {
            try {
                rect = (Rect)rect.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            rect.transform(originX, originY);
        }
        return rect;
    }

    public void putRect(int key, Rect rect) {
        this.rects.put(new Integer(key), rect);
    }

    public void putDefaultRect(Rect rect) {
        this.defaultRect = rect;
    }
}

