/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module;

import dioscuri.interfaces.Module;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractModule
implements Module {
    private static Logger logger = Logger.getLogger(AbstractModule.class.getName());
    protected final Module.Type type;
    private final Map<Module.Type, Module> connections;
    private boolean debugMode;

    public AbstractModule(Module.Type type, Module.Type ... typeArray) {
        if (type == null) {
            throw new NullPointerException("The type of class " + this.getClass().getName() + " cannot be null");
        }
        if (typeArray == null) {
            throw new NullPointerException("The expectedConnections of class " + this.getClass().getName() + " cannot be null");
        }
        this.type = type;
        this.connections = new HashMap<Module.Type, Module>();
        this.debugMode = false;
        for (Module.Type type2 : typeArray) {
            this.connections.put(type2, null);
        }
    }

    @Override
    public final Module getConnection(Module.Type type) {
        return this.connections.get((Object)type);
    }

    @Override
    public final Map<Module.Type, Module> getConnections() {
        return this.connections;
    }

    @Override
    public final boolean getDebugMode() {
        return this.debugMode;
    }

    @Override
    public String getDump() {
        return "No getDump() method provided for " + (Object)((Object)this.getType());
    }

    @Override
    public final Module.Type[] getExpectedConnections() {
        return this.connections.keySet().toArray(new Module.Type[this.connections.size()]);
    }

    @Override
    public final Module.Type getType() {
        return this.type;
    }

    @Override
    public final boolean isConnected() {
        for (Map.Entry<Module.Type, Module> entry : this.connections.entrySet()) {
            if (entry.getValue() != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public abstract boolean reset();

    @Override
    public final boolean setConnection(Module module) {
        if (module == null) {
            logger.log(Level.SEVERE, "m == null");
            return false;
        }
        if (this.connections.get((Object)module.getType()) != null) {
            logger.log(Level.INFO, (Object)((Object)this.type) + " already connected to " + (Object)((Object)module.getType()));
            return false;
        }
        logger.log(Level.INFO, (Object)((Object)this.type) + " is connected to " + (Object)((Object)module.getType()));
        this.connections.put(module.getType(), module);
        module.getConnections().put(this.type, this);
        return true;
    }

    @Override
    public final void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

