/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;

public class Instruction_LEAVE
implements Instruction {
    private CPU cpu;
    byte[] destWord = new byte[2];
    byte[] destDoubleWord = new byte[2];

    public Instruction_LEAVE() {
    }

    public Instruction_LEAVE(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        System.out.println("CPU -> instruction LEAVE");
        if (this.cpu.stackSize == 32) {
            this.cpu.esp[0] = this.cpu.ebp[0];
            this.cpu.esp[1] = this.cpu.ebp[1];
            this.cpu.sp[0] = this.cpu.bp[0];
            this.cpu.sp[1] = this.cpu.bp[1];
        } else {
            this.cpu.sp[0] = this.cpu.bp[0];
            this.cpu.sp[1] = this.cpu.bp[1];
        }
        if (this.cpu.doubleWord) {
            this.destWord = this.cpu.getWordFromStack();
            System.arraycopy(this.destWord, 0, this.cpu.bp, 0, this.destWord.length);
            this.destDoubleWord = this.cpu.getWordFromStack();
            System.arraycopy(this.destDoubleWord, 0, this.cpu.ebp, 0, this.destDoubleWord.length);
        } else {
            this.destWord = this.cpu.getWordFromStack();
            System.arraycopy(this.destWord, 0, this.cpu.bp, 0, this.destWord.length);
        }
    }
}

