/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.motherboard;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.UnknownPortException;
import dioscuri.exception.WriteOnlyPortException;
import dioscuri.interfaces.Addressable;
import dioscuri.interfaces.Module;
import dioscuri.interfaces.Updateable;
import dioscuri.module.ModuleCPU;
import dioscuri.module.ModuleClock;
import dioscuri.module.ModuleMemory;
import dioscuri.module.ModuleMotherboard;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Motherboard
extends ModuleMotherboard {
    private Emulator emu;
    private boolean A20Enabled;
    protected int ioSpaceSize;
    public Addressable[] ioAddressSpace;
    private static final Logger logger = Logger.getLogger(Motherboard.class.getName());
    public static final int IOSPACE_ISA_SIZE = 1024;
    public static final int IOSPACE_EISA_SIZE = 65536;
    public static final int SYSTEM_CONTROL_PORT_A = 146;

    public Motherboard(Emulator emulator) {
        this.emu = emulator;
        this.ioSpaceSize = 65536;
        this.ioAddressSpace = new Addressable[this.ioSpaceSize];
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + this.getClass().getName() + " -> AbstractModule created successfully.");
    }

    @Override
    public boolean reset() {
        this.A20Enabled = true;
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  AbstractModule has been reset.");
        return true;
    }

    @Override
    public String getDump() {
        String string = "";
        String string2 = "\r\n";
        String string3 = "\t";
        string = "Dump of I/O address space:" + string2;
        for (int i = 0; i < 1024; ++i) {
            if (this.ioAddressSpace[i] == null || this.ioAddressSpace[i].getType() == Module.Type.DUMMY) continue;
            string = string + "0x" + Integer.toHexString(0x10000 | i & 0xFFFF).substring(1).toUpperCase() + string3 + ": " + this.ioAddressSpace[i].getType().toString() + " (" + (Object)((Object)this.ioAddressSpace[i].getType()) + ")" + string2;
        }
        return string;
    }

    @Override
    public boolean registerClock(ModuleClock moduleClock) {
        super.setConnection(moduleClock);
        return true;
    }

    @Override
    public boolean requestTimer(Updateable updateable, int n, boolean bl) {
        ModuleClock moduleClock = (ModuleClock)super.getConnection(Module.Type.CLOCK);
        if (moduleClock != null) {
            return moduleClock.registerDevice(updateable, n, bl);
        }
        return false;
    }

    @Override
    public boolean setTimerActiveState(Updateable updateable, boolean bl) {
        ModuleClock moduleClock = (ModuleClock)super.getConnection(Module.Type.CLOCK);
        if (moduleClock != null) {
            return moduleClock.setTimerActiveState(updateable, bl);
        }
        return false;
    }

    @Override
    public boolean resetTimer(Updateable updateable, int n) {
        ModuleClock moduleClock = (ModuleClock)super.getConnection(Module.Type.CLOCK);
        if (moduleClock != null) {
            return moduleClock.resetTimer(updateable, n);
        }
        return false;
    }

    @Override
    public boolean setIOPort(int n, Addressable addressable) {
        if (this.ioAddressSpace[n] == null) {
            this.ioAddressSpace[n] = addressable;
            return true;
        }
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  I/O address space: Registration for " + (Object)((Object)addressable.getType()) + " failed. I/O port address already registered by " + (Object)((Object)this.ioAddressSpace[n].getType()));
        return false;
    }

    @Override
    public byte getIOPortByte(int n) throws ModuleException {
        if (this.ioAddressSpace[n] != null) {
            try {
                return this.ioAddressSpace[n].getIOPortByte(n);
            }
            catch (UnknownPortException unknownPortException) {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
                throw new ModuleException("Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
            }
            catch (WriteOnlyPortException writeOnlyPortException) {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Writing to I/O port not allowed.");
                throw new ModuleException("I/O port is read-only.");
            }
        }
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Requested I/O port 0x" + Integer.toHexString(n) + " (getByte) is not in use.");
        return -1;
    }

    @Override
    public void setIOPortByte(int n, byte by) throws ModuleException {
        if (n == 1024 || n == 1025) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " Problem occurred in ROM BIOS at line: " + by);
            return;
        }
        if (n == 1026 || n == 1027) {
            try {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " I/O port (0x" + Integer.toHexString(n).toUpperCase() + "): " + new String(new byte[]{by}, "US-ASCII"));
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " I/O port (0x" + Integer.toHexString(n).toUpperCase() + "): " + new String(new byte[]{by}));
            }
            return;
        }
        if (n == 35072) {
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " I/O port (0x" + Integer.toHexString(n).toUpperCase() + "): attempting to shutdown.");
            return;
        }
        if (this.ioAddressSpace[n] != null) {
            try {
                this.ioAddressSpace[n].setIOPortByte(n, by);
            }
            catch (UnknownPortException unknownPortException) {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
                throw new ModuleException("Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
            }
        } else {
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + "  Requested I/O port (0x" + Integer.toHexString(n).toUpperCase() + ", setByte) is not available/registered.");
        }
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException {
        if (this.ioAddressSpace[n] != null && this.ioAddressSpace[n + 1] != null) {
            try {
                return this.ioAddressSpace[n].getIOPortWord(n);
            }
            catch (UnknownPortException unknownPortException) {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
                throw new ModuleException("Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
            }
            catch (WriteOnlyPortException writeOnlyPortException) {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Writing to I/O port not allowed.");
                throw new ModuleException("I/O port is read-only.");
            }
        }
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Requested I/O port 0x" + Integer.toHexString(n) + " (getWord) is not in use.");
        return new byte[]{-1, -1};
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException {
        if (this.ioAddressSpace[n] != null && this.ioAddressSpace[n + 1] != null) {
            try {
                this.ioAddressSpace[n].setIOPortWord(n, byArray);
            }
            catch (UnknownPortException unknownPortException) {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
                throw new ModuleException("Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
            }
        }
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException {
        if (this.ioAddressSpace[n] != null && this.ioAddressSpace[n + 1] != null && this.ioAddressSpace[n + 2] != null && this.ioAddressSpace[n + 3] != null) {
            try {
                return this.ioAddressSpace[n].getIOPortDoubleWord(n);
            }
            catch (UnknownPortException unknownPortException) {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
                throw new ModuleException("Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
            }
            catch (WriteOnlyPortException writeOnlyPortException) {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Writing to I/O port not allowed.");
                throw new ModuleException("I/O port is read-only.");
            }
        }
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Requested I/O port 0x" + Integer.toHexString(n) + " (getDoubleWord) is not in use.");
        return new byte[]{-1, -1, -1, -1};
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException {
        if (this.ioAddressSpace[n] != null && this.ioAddressSpace[n + 1] != null && this.ioAddressSpace[n + 2] != null && this.ioAddressSpace[n + 3] != null) {
            try {
                this.ioAddressSpace[n].setIOPortDoubleWord(n, byArray);
            }
            catch (UnknownPortException unknownPortException) {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "  Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
                throw new ModuleException("Unknown I/O port requested (0x" + Integer.toHexString(n).toUpperCase() + ").");
            }
        }
    }

    @Override
    public boolean getA20() {
        return this.A20Enabled;
    }

    @Override
    public void setA20(boolean bl) {
        this.A20Enabled = bl;
        if (this.emu.isCpu32bit()) {
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Attempting to set memory A20 line in 32-bit mode (unsupported)");
        } else {
            ModuleMemory moduleMemory = (ModuleMemory)super.getConnection(Module.Type.MEMORY);
            moduleMemory.setA20AddressLine(bl);
        }
    }

    @Override
    public long getCurrentInstructionNumber() {
        if (this.emu.isCpu32bit()) {
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + "Attempting to get CPU instruction number in 32-bit mode (unsupported)");
            return 1L;
        }
        ModuleCPU moduleCPU = (ModuleCPU)super.getConnection(Module.Type.CPU);
        return moduleCPU.getCurrentInstructionNumber();
    }
}

