/*
 * Decompiled with CFR 0.152.
 */
package gnu.rfb;

import gnu.rfb.CoRREStub;
import gnu.rfb.Hextile;
import gnu.rfb.PixelFormat;
import gnu.rfb.RRE;
import gnu.rfb.Raw;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.DataOutput;
import java.io.IOException;

public abstract class Rect
implements Cloneable {
    public int x;
    public int y;
    public int w;
    public int h;
    public int count = 1;

    public static int bestEncoding(int[] encodings) {
        int i = 0;
        while (i < encodings.length) {
            switch (encodings[i]) {
                case 0: 
                case 2: 
                case 4: 
                case 5: {
                    return encodings[i];
                }
            }
            ++i;
        }
        return 5;
    }

    public static Rect encode(int encoding, PixelFormat pixelFormat, Image image, int x, int y, int w, int h) {
        int[] pixels = new int[w * h];
        PixelGrabber grabber = new PixelGrabber(image, x, y, w, h, pixels, 0, w);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Rect.encode(encoding, pixels, pixelFormat, x, y, w, x, y, w, h);
    }

    public static Rect encode(int encoding, int[] pixels, PixelFormat pixelFormat, int scanline, int x, int y, int w, int h) {
        return Rect.encode(encoding, pixels, pixelFormat, 0, 0, scanline, x, y, w, h);
    }

    public static Rect encode(int encoding, int[] pixels, PixelFormat pixelFormat, int offsetX, int offsetY, int scanline, int x, int y, int w, int h) {
        if (w == 0 && h == 0) {
            Exception e = new Exception("w==h==0");
            e.printStackTrace();
        }
        switch (encoding) {
            case 0: {
                return new Raw(pixels, pixelFormat, offsetX, offsetY, scanline, x, y, w, h);
            }
            case 1: {
                return null;
            }
            case 2: {
                return new RRE(pixels, pixelFormat, offsetX, offsetY, scanline, x, y, w, h);
            }
            case 4: {
                return new CoRREStub(pixels, pixelFormat, offsetX, offsetY, scanline, x, y, w, h);
            }
            case 5: {
                return new Hextile(pixels, pixelFormat, offsetX, offsetY, scanline, x, y, w, h);
            }
        }
        return null;
    }

    public Rect(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public void writeData(DataOutput output) throws IOException {
        output.writeShort(this.x);
        output.writeShort(this.y);
        output.writeShort(this.w);
        output.writeShort(this.h);
    }

    public void transform(int transformX, int transformY) {
        this.x += transformX;
        this.y += transformY;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.x)) + "," + this.y + "," + this.w + "," + this.h;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Rect not cloneable");
    }

    protected static int[] copyPixels(int[] pixels, int scanline, int x, int y, int w, int h) {
        int size = w * h;
        int[] ourPixels = new int[size];
        int jump = scanline - w;
        int s = 0;
        int p = y * scanline + x;
        int i = 0;
        while (i < size) {
            if (s == w) {
                s = 0;
                p += jump;
            }
            ourPixels[i] = pixels[p];
            ++i;
            ++s;
            ++p;
        }
        return ourPixels;
    }

    protected static void writePixel(DataOutput output, PixelFormat pixelFormat, int pixel) throws IOException {
        pixel = pixelFormat.translatePixel(pixel);
        switch (pixelFormat.bitsPerPixel) {
            case 32: {
                output.writeByte(pixel & 0xFF);
                output.writeByte(pixel >> 8 & 0xFF);
                output.writeByte(pixel >> 16 & 0xFF);
                output.writeByte(pixel >> 24 & 0xFF);
                break;
            }
            case 16: {
                output.writeByte(pixel & 0xFF);
                output.writeByte(pixel >> 8 & 0xFF);
                break;
            }
            case 8: {
                output.writeByte(pixel & 0xFF);
            }
        }
    }

    protected static int getBackground(int[] pixels, int scanline, int x, int y, int w, int h) {
        return pixels[y * scanline + x];
    }
}

