/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.GUI;
import dioscuri.config.AbstractModulePanel;
import dioscuri.config.Emulator;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.math.BigInteger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FdcPanel
extends AbstractModulePanel {
    final Emulator.Architecture.Modules.Fdc fdc;
    final Emulator.Architecture.Modules.Fdc.Floppy floppy;
    final String[] driveChoices = new String[]{"A", "B"};
    final String[] formatChoices = new String[]{"2.88M", "1.44M", "1.2M", "720K", "360K", "320K", "180K", "160K"};
    final JTextField updateInterval = new JTextField();
    final JCheckBox enabled = new JCheckBox();
    final JCheckBox inserted = new JCheckBox();
    final JComboBox driveCombo = new JComboBox<String>(this.driveChoices);
    final JComboBox formatCombo = new JComboBox<String>(this.formatChoices);
    final JCheckBox writeProtected = new JCheckBox();
    final JTextField imageFile = new JTextField();
    final JButton browse = new JButton("browse");

    FdcPanel(GUI gUI, Emulator emulator) {
        super(gUI, emulator);
        this.fdc = emulator.getArchitecture().getModules().getFdc();
        this.floppy = emulator.getArchitecture().getModules().getFdc().getFloppy().get(0);
        super.setLayout(new GridLayout(0, 3, 5, 5));
        this.updateInterval.setText(this.fdc.getUpdateintervalmicrosecs().toString());
        this.enabled.setSelected(this.floppy.isEnabled());
        this.inserted.setSelected(this.floppy.isInserted());
        this.driveCombo.setSelectedItem(this.floppy.getDriveletter());
        this.formatCombo.setSelectedItem(this.floppy.getDiskformat());
        this.writeProtected.setSelected(this.floppy.isWriteprotected());
        this.imageFile.setText(this.floppy.getImagefilepath());
        this.imageFile.setToolTipText(this.imageFile.getText());
        this.imageFile.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                FdcPanel.this.imageFile.setCaretPosition(FdcPanel.this.imageFile.getText().length());
            }
        });
        super.add(new JLabel("update interval"));
        super.add(this.updateInterval);
        super.add(new JLabel());
        super.add(new JLabel("enabled"));
        super.add(this.enabled);
        super.add(new JLabel());
        super.add(new JLabel("inserted"));
        super.add(this.inserted);
        super.add(new JLabel());
        super.add(new JLabel("drive letter"));
        super.add(this.driveCombo);
        super.add(new JLabel());
        super.add(new JLabel("disk format"));
        super.add(this.formatCombo);
        super.add(new JLabel());
        super.add(new JLabel("write protected"));
        super.add(this.writeProtected);
        super.add(new JLabel());
        super.add(new JLabel("image file"));
        super.add(this.imageFile);
        super.add(this.browse);
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = FdcPanel.super.chooseFile();
                if (file != null) {
                    FdcPanel.this.imageFile.setText(file.getAbsolutePath());
                    FdcPanel.this.imageFile.setToolTipText(FdcPanel.this.imageFile.getText());
                }
            }
        });
    }

    @Override
    void save() throws Exception {
        this.fdc.setUpdateintervalmicrosecs(new BigInteger(this.updateInterval.getText()));
        this.floppy.setEnabled(this.enabled.isSelected());
        this.floppy.setInserted(this.inserted.isSelected());
        this.floppy.setDriveletter(this.driveCombo.getSelectedItem().toString());
        this.floppy.setDiskformat(this.formatCombo.getSelectedItem().toString());
        this.floppy.setWriteprotected(this.writeProtected.isSelected());
        this.floppy.setImagefilepath(this.imageFile.getText());
    }
}

