/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.exception.ModuleException;
import dioscuri.interfaces.Addressable;
import dioscuri.interfaces.Module;
import dioscuri.module.AbstractModule;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.cpu32.HardwareComponent;
import dioscuri.module.cpu32.IOPortCapable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IOPortHandler
implements IOPortCapable,
HardwareComponent {
    private ModuleMotherboard mb;
    private final int MAX_IOPORTS = 65536;
    IOPortCapable[] ioPortDevice = new IOPortCapable[65536];
    private static final IOPortCapable defaultDevice = new UnconnectedIOPort();

    public IOPortHandler() {
        for (int i = 0; i < this.ioPortDevice.length; ++i) {
            this.ioPortDevice[i] = defaultDevice;
        }
    }

    public boolean setConnection(AbstractModule abstractModule) {
        if (abstractModule.getType() == Module.Type.MOTHERBOARD) {
            this.mb = (ModuleMotherboard)abstractModule;
            return true;
        }
        return false;
    }

    @Override
    public void dumpState(DataOutput dataOutput) throws IOException {
    }

    @Override
    public void loadState(DataInput dataInput) throws IOException {
        this.reset();
    }

    @Override
    public int ioPortReadByte(int n) throws ModuleException {
        int n2 = this.mb.getIOPortByte(n);
        return n2 &= 0xFF;
    }

    @Override
    public int ioPortReadWord(int n) throws ModuleException {
        byte[] byArray = this.mb.getIOPortWord(n);
        int n2 = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
        return n2;
    }

    @Override
    public int ioPortReadLong(int n) throws ModuleException {
        byte[] byArray = this.mb.getIOPortDoubleWord(n);
        int n2 = ((byArray[3] & 0xFF) << 24) + ((byArray[2] & 0xFF) << 16) + ((byArray[1] & 0xFF) << 8) + (byArray[0] & 0xFF);
        return n2;
    }

    @Override
    public void ioPortWriteByte(int n, int n2) throws ModuleException {
        this.mb.setIOPortByte(n, (byte)n2);
    }

    @Override
    public void ioPortWriteWord(int n, int n2) throws ModuleException {
        byte[] byArray = new byte[]{(byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
        this.mb.setIOPortWord(n, byArray);
    }

    @Override
    public void ioPortWriteLong(int n, int n2) throws ModuleException {
        byte[] byArray = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 24 & 0xFF)};
        this.mb.setIOPortDoubleWord(n, byArray);
    }

    @Override
    public int[] ioPortsRequested() {
        return null;
    }

    public void registerIOPortCapable(IOPortCapable iOPortCapable) {
        int[] nArray = iOPortCapable.ioPortsRequested();
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (this.ioPortDevice[n] != defaultDevice && this.ioPortDevice[n] != iOPortCapable) continue;
            this.mb.setIOPort(n, (Addressable)((Object)iOPortCapable));
        }
    }

    public void deregisterIOPortCapable(IOPortCapable iOPortCapable) {
        int[] nArray = iOPortCapable.ioPortsRequested();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            this.ioPortDevice[n] = defaultDevice;
        }
    }

    public String map() {
        String string = "";
        string = string + "IO Port Handler:\n";
        string = string + "Registered Ports:\n";
        for (int i = 0; i < 65536; ++i) {
            if (this.ioPortDevice[i] == defaultDevice) continue;
            string = string + "Port: 0x" + Integer.toHexString(0xFFFF & i) + " - ";
            string = string + this.ioPortDevice[i].getClass().getName() + "\n";
        }
        return string;
    }

    @Override
    public boolean reset() {
        this.ioPortDevice = new IOPortCapable[65536];
        for (int i = 0; i < this.ioPortDevice.length; ++i) {
            this.ioPortDevice[i] = defaultDevice;
        }
        return true;
    }

    @Override
    public boolean initialised() {
        return true;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
    }

    public String toString() {
        return "IOPort Bus";
    }

    @Override
    public void updateComponent(HardwareComponent hardwareComponent) {
    }

    @Override
    public boolean updated() {
        return true;
    }

    @Override
    public void timerCallback() {
    }

    static class UnconnectedIOPort
    implements IOPortCapable {
        UnconnectedIOPort() {
        }

        @Override
        public int ioPortReadByte(int n) {
            return 255;
        }

        @Override
        public int ioPortReadWord(int n) {
            return 65535;
        }

        @Override
        public int ioPortReadLong(int n) {
            return -1;
        }

        @Override
        public void ioPortWriteByte(int n, int n2) {
        }

        @Override
        public void ioPortWriteWord(int n, int n2) {
        }

        @Override
        public void ioPortWriteLong(int n, int n2) {
        }

        @Override
        public int[] ioPortsRequested() {
            return null;
        }

        @Override
        public void timerCallback() {
        }

        @Override
        public void dumpState(DataOutput dataOutput) {
        }

        @Override
        public void loadState(DataInput dataInput) {
        }

        @Override
        public boolean reset() {
            return true;
        }

        @Override
        public void updateComponent(HardwareComponent hardwareComponent) {
        }

        @Override
        public boolean updated() {
            return true;
        }

        @Override
        public void acceptComponent(HardwareComponent hardwareComponent) {
        }

        @Override
        public boolean initialised() {
            return true;
        }
    }
}

