/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.AddressSpace;
import dioscuri.module.cpu32.CodeBlock;
import dioscuri.module.cpu32.HardwareComponent;
import dioscuri.module.cpu32.LazyMemory;
import dioscuri.module.cpu32.LinearAddressSpace;
import dioscuri.module.cpu32.Memory;
import dioscuri.module.cpu32.Processor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class PhysicalAddressSpace
extends AddressSpace
implements HardwareComponent {
    private static final int GATEA20_MASK = -1048577;
    public static final int SYS_RAM_SIZE = 0x10000000;
    private static final int QUICK_INDEX_SIZE = 65536;
    private static final int TOP_INDEX_BITS = 10;
    private static final int BOTTOM_INDEX_BITS = 10;
    private static final int TOP_INDEX_SHIFT = 22;
    private static final int TOP_INDEX_SIZE = 1024;
    private static final int BOTTOM_INDEX_SHIFT = 12;
    private static final int BOTTOM_INDEX_SIZE = 1024;
    private static final int BOTTOM_INDEX_MASK = 1023;
    private boolean gateA20MaskState;
    private int mappedRegionCount = 0;
    private Memory[] quickNonA20MaskedIndex = new Memory[65536];
    private Memory[] quickA20MaskedIndex;
    private Memory[] quickIndex;
    private Memory[][] nonA20MaskedIndex;
    private Memory[][] a20MaskedIndex;
    private Memory[][] index;
    public static final Memory UNCONNECTED = new UnconnectedMemoryBlock();
    private LinearAddressSpace linearAddr;

    public PhysicalAddressSpace() {
        PhysicalAddressSpace.clearArray(this.quickNonA20MaskedIndex, UNCONNECTED);
        this.quickA20MaskedIndex = new Memory[65536];
        PhysicalAddressSpace.clearArray(this.quickA20MaskedIndex, UNCONNECTED);
        this.nonA20MaskedIndex = new Memory[1024][];
        this.a20MaskedIndex = new Memory[1024][];
        this.setGateA20State(false);
    }

    private void dumpMemory(DataOutput dataOutput, Memory[] memoryArray) throws IOException {
        byte[] byArray = new byte[]{};
        for (int i = 0; i < memoryArray.length; ++i) {
            long l = memoryArray[i].getSize();
            if (byArray.length < (int)l) {
                byArray = new byte[(int)l];
            }
            if (memoryArray[i].isAllocated()) {
                try {
                    if (memoryArray[i] instanceof MapWrapper) {
                        l = 0L;
                    } else {
                        memoryArray[i].copyContentsInto(0, byArray, 0, (int)l);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    l = 0L;
                }
                dataOutput.writeLong(l);
                if (l <= 0L) continue;
                dataOutput.write(byArray);
                continue;
            }
            dataOutput.writeLong(0L);
        }
    }

    private void dumpLotsOfMemory(DataOutput dataOutput, Memory[][] memoryArray) throws IOException {
        dataOutput.writeInt(memoryArray.length);
        for (int i = 0; i < memoryArray.length; ++i) {
            if (memoryArray[i] == null) {
                dataOutput.writeInt(0);
                continue;
            }
            this.dumpMemory(dataOutput, memoryArray[i]);
        }
    }

    @Override
    public void dumpState(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.gateA20MaskState);
        dataOutput.writeInt(this.mappedRegionCount);
        dataOutput.writeInt(this.quickA20MaskedIndex.length);
        this.dumpMemory(dataOutput, this.quickA20MaskedIndex);
        dataOutput.writeInt(this.quickNonA20MaskedIndex.length);
        this.dumpMemory(dataOutput, this.quickNonA20MaskedIndex);
        if (this.quickIndex == this.quickNonA20MaskedIndex) {
            dataOutput.writeInt(1);
        } else {
            dataOutput.writeInt(2);
        }
        this.dumpLotsOfMemory(dataOutput, this.nonA20MaskedIndex);
        this.dumpLotsOfMemory(dataOutput, this.a20MaskedIndex);
        if (this.index == this.nonA20MaskedIndex) {
            dataOutput.writeInt(1);
        } else {
            dataOutput.writeInt(2);
        }
    }

    private void loadMemory(DataInput dataInput, Memory[] memoryArray, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            long l = dataInput.readLong();
            byte[] byArray = new byte[(int)l];
            if (l <= 0L) continue;
            dataInput.readFully(byArray, 0, (int)l);
            memoryArray[i].copyContentsFrom(0, byArray, 0, (int)l);
        }
    }

    private void loadLotsOfMemory(DataInput dataInput, Memory[][] memoryArray) throws IOException {
        int n = dataInput.readInt();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            this.loadMemory(dataInput, memoryArray[i], n2);
        }
    }

    @Override
    public void loadState(DataInput dataInput) throws IOException {
        int n;
        PhysicalAddressSpace.clearArray(this.quickA20MaskedIndex, UNCONNECTED);
        PhysicalAddressSpace.clearArray(this.quickNonA20MaskedIndex, UNCONNECTED);
        PhysicalAddressSpace.clearArray(this.quickIndex, UNCONNECTED);
        this.reset();
        for (n = 0; n < 0x10000000; n += 4096) {
            this.allocateMemory(n, new LazyMemory(4096));
        }
        this.gateA20MaskState = dataInput.readBoolean();
        this.mappedRegionCount = dataInput.readInt();
        n = dataInput.readInt();
        this.loadMemory(dataInput, this.quickA20MaskedIndex, n);
        n = dataInput.readInt();
        this.loadMemory(dataInput, this.quickNonA20MaskedIndex, n);
        int n2 = dataInput.readInt();
        this.quickIndex = n2 == 1 ? this.quickNonA20MaskedIndex : this.quickA20MaskedIndex;
        this.loadLotsOfMemory(dataInput, this.nonA20MaskedIndex);
        this.loadLotsOfMemory(dataInput, this.a20MaskedIndex);
        n2 = dataInput.readInt();
        this.index = n2 == 1 ? this.nonA20MaskedIndex : this.a20MaskedIndex;
    }

    public void setGateA20State(boolean bl) {
        this.gateA20MaskState = bl;
        if (bl) {
            this.quickIndex = this.quickNonA20MaskedIndex;
            this.index = this.nonA20MaskedIndex;
        } else {
            this.quickIndex = this.quickA20MaskedIndex;
            this.index = this.a20MaskedIndex;
        }
        if (this.linearAddr != null && !this.linearAddr.pagingDisabled()) {
            this.linearAddr.flush();
        }
    }

    public boolean getGateA20State() {
        return this.gateA20MaskState;
    }

    public int getAllocatedBufferSize() {
        return this.mappedRegionCount * 4096;
    }

    @Override
    public Memory getReadMemoryBlockAt(int n) {
        return this.getMemoryBlockAt(n);
    }

    @Override
    public Memory getWriteMemoryBlockAt(int n) {
        return this.getMemoryBlockAt(n);
    }

    @Override
    public int execute(Processor processor, int n) {
        return this.getReadMemoryBlockAt(n).execute(processor, n & 0xFFF);
    }

    @Override
    public CodeBlock decodeCodeBlockAt(Processor processor, int n) {
        CodeBlock codeBlock = this.getReadMemoryBlockAt(n).decodeCodeBlockAt(processor, n & 0xFFF);
        return codeBlock;
    }

    @Override
    void replaceBlocks(Memory memory, Memory memory2) {
        Memory[] memoryArray;
        int n;
        for (n = 0; n < this.quickA20MaskedIndex.length; ++n) {
            if (this.quickA20MaskedIndex[n] != memory) continue;
            this.quickA20MaskedIndex[n] = memory2;
        }
        for (n = 0; n < this.quickNonA20MaskedIndex.length; ++n) {
            if (this.quickNonA20MaskedIndex[n] != memory) continue;
            this.quickNonA20MaskedIndex[n] = memory2;
        }
        for (n = 0; n < this.a20MaskedIndex.length; ++n) {
            memoryArray = this.a20MaskedIndex[n];
            try {
                for (int i = 0; i < memoryArray.length; ++i) {
                    if (memoryArray[i] != memory) continue;
                    memoryArray[i] = memory2;
                }
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        for (n = 0; n < this.nonA20MaskedIndex.length; ++n) {
            memoryArray = this.nonA20MaskedIndex[n];
            try {
                for (int i = 0; i < memoryArray.length; ++i) {
                    if (memoryArray[i] != memory) continue;
                    memoryArray[i] = memory2;
                }
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void clear() {
        int n;
        for (n = 0; n < this.quickNonA20MaskedIndex.length; ++n) {
            this.quickNonA20MaskedIndex[n].clear();
        }
        for (n = 0; n < this.nonA20MaskedIndex.length; ++n) {
            Memory[] memoryArray = this.nonA20MaskedIndex[n];
            try {
                for (int i = 0; i < memoryArray.length; ++i) {
                    try {
                        memoryArray[i].clear();
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void unmap(int n, int n2) {
        if (n % 4096 != 0) {
            throw new IllegalStateException("Cannot deallocate memory starting at " + Integer.toHexString(n) + "; this is not block aligned at " + 4096 + " boundaries");
        }
        if (n2 % 4096 != 0) {
            throw new IllegalStateException("Cannot deallocate memory in partial blocks. " + n2 + " is not a multiple of " + 4096);
        }
        for (int i = n; i < n + n2; i += 4096) {
            if (this.getMemoryBlockAt(i) != UNCONNECTED) {
                --this.mappedRegionCount;
            }
            this.setMemoryBlockAt(i, UNCONNECTED);
        }
    }

    public void mapMemoryRegion(Memory memory, int n, int n2) {
        long l;
        if (memory.getSize() < (long)n2) {
            throw new IllegalStateException("Underlying memory (length=" + memory.getSize() + ") is too short for mapping into region " + n2 + " bytes long");
        }
        if (n % 4096 != 0) {
            throw new IllegalStateException("Cannot map memory starting at " + Integer.toHexString(n) + "; this is not aligned to " + 4096 + " blocks");
        }
        if (n2 % 4096 != 0) {
            throw new IllegalStateException("Cannot map memory in partial blocks: " + n2 + " is not a multiple of " + 4096);
        }
        this.unmap(n, n2);
        for (long i = l = 0xFFFFFFFFL & (long)n; i < l + (long)n2; i += 4096L) {
            MapWrapper mapWrapper = new MapWrapper(memory, (int)(i - l));
            this.setMemoryBlockAt((int)i, mapWrapper);
            ++this.mappedRegionCount;
        }
    }

    public void allocateMemory(int n, Memory memory) {
        if (n % 4096 != 0) {
            throw new IllegalStateException("Cannot allocate memory starting at " + Integer.toHexString(n) + "; this is not aligned to " + 4096 + " blocks");
        }
        if (memory.getSize() != 4096L) {
            throw new IllegalStateException("Can only allocate memory in blocks of 4096");
        }
        this.unmap(n, 4096);
        long l = 0xFFFFFFFFL & (long)n;
        this.setMemoryBlockAt((int)l, memory);
        ++this.mappedRegionCount;
    }

    @Override
    public boolean reset() {
        this.clear();
        this.setGateA20State(false);
        this.linearAddr = null;
        return true;
    }

    @Override
    public boolean updated() {
        return true;
    }

    @Override
    public void updateComponent(HardwareComponent hardwareComponent) {
    }

    @Override
    public boolean initialised() {
        return this.linearAddr != null;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof LinearAddressSpace) {
            this.linearAddr = (LinearAddressSpace)hardwareComponent;
        }
    }

    public String toString() {
        return "Physical Address Bus";
    }

    private Memory getMemoryBlockAt(int n) {
        try {
            return this.quickIndex[n >>> 12];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                return this.index[n >>> 22][n >>> 12 & 0x3FF];
            }
            catch (NullPointerException nullPointerException) {
                return UNCONNECTED;
            }
        }
    }

    private void setMemoryBlockAt(int n, Memory memory) {
        block9: {
            try {
                int n2 = n >>> 12;
                this.quickNonA20MaskedIndex[n2] = memory;
                if ((n2 & 0xFFEFF) == n2) {
                    this.quickA20MaskedIndex[n2] = memory;
                    this.quickA20MaskedIndex[n2 | 0x100] = memory;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                try {
                    this.nonA20MaskedIndex[n >>> 22][n >>> 12 & 0x3FF] = memory;
                }
                catch (NullPointerException nullPointerException) {
                    this.nonA20MaskedIndex[n >>> 22] = new Memory[1024];
                    this.nonA20MaskedIndex[n >>> 22][n >>> 12 & 0x3FF] = memory;
                }
                if ((n & 0xFFEFFFFF) != n) break block9;
                try {
                    this.a20MaskedIndex[n >>> 22][n >>> 12 & 0x3FF] = memory;
                }
                catch (NullPointerException nullPointerException) {
                    this.a20MaskedIndex[n >>> 22] = new Memory[1024];
                    this.a20MaskedIndex[n >>> 22][n >>> 12 & 0x3FF] = memory;
                }
                int n3 = n | 0x100000;
                try {
                    this.a20MaskedIndex[n3 >>> 22][n3 >>> 12 & 0x3FF] = memory;
                }
                catch (NullPointerException nullPointerException) {
                    this.a20MaskedIndex[n3 >>> 22] = new Memory[1024];
                    this.a20MaskedIndex[n3 >>> 22][n3 >>> 12 & 0x3FF] = memory;
                }
            }
        }
    }

    @Override
    public void timerCallback() {
    }

    public static final class UnconnectedMemoryBlock
    extends Memory {
        @Override
        public void clear() {
        }

        @Override
        public void clear(int n, int n2) {
        }

        @Override
        public void copyContentsInto(int n, byte[] byArray, int n2, int n3) {
        }

        @Override
        public void copyContentsFrom(int n, byte[] byArray, int n2, int n3) {
            n3 = Math.min(4096 - n, Math.min(byArray.length - n2, n3));
            for (int i = n2; i < n3; ++i) {
                byArray[i] = this.getByte(0);
            }
        }

        @Override
        public long getSize() {
            return 4096L;
        }

        @Override
        public byte getByte(int n) {
            return -1;
        }

        @Override
        public short getWord(int n) {
            return -1;
        }

        @Override
        public int getDoubleWord(int n) {
            return -1;
        }

        @Override
        public long getQuadWord(int n) {
            return -1L;
        }

        @Override
        public long getLowerDoubleQuadWord(int n) {
            return -1L;
        }

        @Override
        public long getUpperDoubleQuadWord(int n) {
            return -1L;
        }

        @Override
        public void setByte(int n, byte by) {
        }

        @Override
        public void setWord(int n, short s) {
        }

        @Override
        public void setDoubleWord(int n, int n2) {
        }

        @Override
        public void setQuadWord(int n, long l) {
        }

        @Override
        public void setLowerDoubleQuadWord(int n, long l) {
        }

        @Override
        public void setUpperDoubleQuadWord(int n, long l) {
        }

        @Override
        public int execute(Processor processor, int n) {
            throw new IllegalStateException("Trying to execute in Unconnected Block @ 0x" + Integer.toHexString(n));
        }

        @Override
        public CodeBlock decodeCodeBlockAt(Processor processor, int n) {
            throw new IllegalStateException("Trying to execute in Unconnected Block @ 0x" + Integer.toHexString(n));
        }
    }

    public static class MapWrapper
    extends Memory {
        private Memory memory;
        private int baseAddress;

        MapWrapper(Memory memory, int n) {
            this.baseAddress = n;
            this.memory = memory;
        }

        @Override
        public long getSize() {
            return 4096L;
        }

        @Override
        public void clear() {
            this.memory.clear(this.baseAddress, (int)this.getSize());
        }

        @Override
        public void clear(int n, int n2) {
            if ((long)(n + n2) > this.getSize()) {
                throw new ArrayIndexOutOfBoundsException("Attempt to clear outside of memory bounds");
            }
            n = this.baseAddress | n;
            this.memory.clear(n, n2);
        }

        @Override
        public void copyContentsInto(int n, byte[] byArray, int n2, int n3) {
            n = this.baseAddress | n;
            this.memory.copyContentsInto(n, byArray, n2, n3);
        }

        @Override
        public void copyContentsFrom(int n, byte[] byArray, int n2, int n3) {
            n = this.baseAddress | n;
            this.memory.copyContentsFrom(n, byArray, n2, n3);
        }

        @Override
        public byte getByte(int n) {
            n = this.baseAddress | n;
            return this.memory.getByte(n);
        }

        @Override
        public short getWord(int n) {
            n = this.baseAddress | n;
            return this.memory.getWord(n);
        }

        @Override
        public int getDoubleWord(int n) {
            n = this.baseAddress | n;
            return this.memory.getDoubleWord(n);
        }

        @Override
        public long getQuadWord(int n) {
            n = this.baseAddress | n;
            return this.memory.getQuadWord(n);
        }

        @Override
        public long getLowerDoubleQuadWord(int n) {
            n = this.baseAddress | n;
            return this.memory.getQuadWord(n);
        }

        @Override
        public long getUpperDoubleQuadWord(int n) {
            n += 8;
            n = this.baseAddress | n;
            return this.memory.getQuadWord(n);
        }

        @Override
        public void setByte(int n, byte by) {
            n = this.baseAddress | n;
            this.memory.setByte(n, by);
        }

        @Override
        public void setWord(int n, short s) {
            n = this.baseAddress | n;
            this.memory.setWord(n, s);
        }

        @Override
        public void setDoubleWord(int n, int n2) {
            n = this.baseAddress | n;
            this.memory.setDoubleWord(n, n2);
        }

        @Override
        public void setQuadWord(int n, long l) {
            n = this.baseAddress | n;
            this.memory.setQuadWord(n, l);
        }

        @Override
        public void setLowerDoubleQuadWord(int n, long l) {
            n = this.baseAddress | n;
            this.memory.setQuadWord(n, l);
        }

        @Override
        public void setUpperDoubleQuadWord(int n, long l) {
            n += 8;
            n = this.baseAddress | n;
            this.memory.setQuadWord(n, l);
        }

        @Override
        public int execute(Processor processor, int n) {
            n = this.baseAddress | n;
            return this.memory.execute(processor, n);
        }

        @Override
        public CodeBlock decodeCodeBlockAt(Processor processor, int n) {
            CodeBlock codeBlock = this.memory.decodeCodeBlockAt(processor, n = this.baseAddress | n);
            if (codeBlock != null) {
                System.out.println(this.getClass().getName() + ":1");
            } else {
                System.out.println(this.getClass().getName() + ":0");
            }
            return codeBlock;
        }
    }
}

