/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.memory;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.interfaces.Module;
import dioscuri.module.ModuleCPU;
import dioscuri.module.ModuleMemory;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.ModuleVideo;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DynamicAllocationMemory
extends ModuleMemory {
    private static final Logger logger = Logger.getLogger(DynamicAllocationMemory.class.getName());
    private byte[][] ram;
    private int ramBlock = 64;
    private int ramBlockSize = this.ramSize / this.ramBlock;
    private int blockIndex;
    protected static long A20mask;
    private static final int BYTES_IN_MB = 0x100000;
    private int ramSize = 0x100000;
    private boolean watchValue;
    private int watchAddress;
    private ModuleVideo video = null;
    private ModuleCPU cpu = null;
    private ModuleMotherboard motherboard = null;

    public DynamicAllocationMemory(Emulator emulator) {
        this.ram = new byte[this.ramBlock][this.ramBlockSize];
        Arrays.fill((Object[])this.ram, null);
        this.blockIndex = 0;
        for (int i = this.ramBlockSize; i > 1; i >>= 1) {
            ++this.blockIndex;
        }
        this.watchValue = false;
        this.watchAddress = -1;
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] " + this.getClass().getName() + " AbstractModule created successfully.");
    }

    @Override
    public boolean reset() {
        Arrays.fill((Object[])this.ram, null);
        this.setA20AddressLine(true);
        for (int i = 786432; i <= 1048575; ++i) {
            this.setByte(i, (byte)-1);
        }
        logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "] AbstractModule has been reset.");
        return true;
    }

    @Override
    public String getDump() {
        String string = "";
        String string2 = "\r\n";
        String string3 = "\t";
        String string4 = " ";
        string = "Memory dump of first 3200 bytes as stored in RAM:" + string2;
        for (int i = 0; i < 200; ++i) {
            string = string + i + string3 + ": ";
            for (int j = 0; j < 16; ++j) {
                int n = i * 16 + j;
                int n2 = n >> this.blockIndex;
                int n3 = this.ram[n2] == null ? 0 : this.ram[n2][n & this.ramBlockSize - 1];
                string = string + Integer.toHexString(0x100 | n3 & 0xFF).substring(1).toUpperCase() + string4;
            }
            string = string + string2;
        }
        logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "] GetDump()");
        return string;
    }

    @Override
    public byte getByte(int n) {
        if (this.video == null) {
            this.video = (ModuleVideo)super.getConnection(Module.Type.VIDEO);
            this.cpu = (ModuleCPU)super.getConnection(Module.Type.CPU);
            this.motherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        }
        n = (int)((long)n & A20mask);
        int n2 = n >> this.blockIndex;
        byte by = 0;
        by = this.ram[n2] == null ? (byte)0 : this.ram[n2][n & this.ramBlockSize - 1];
        try {
            if (this.watchValue && n == this.watchAddress) {
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] " + this.cpu.getRegisterHex(0) + ":" + this.cpu.getRegisterHex(1) + " Watched BYTE at address " + this.watchAddress + " is read: [" + Integer.toHexString(by).toUpperCase() + "]");
            }
            if (n >= 655360 && n <= 786431) {
                return this.video.readMode(n);
            }
            return by;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "] Access outside memory bounds; returning 0xFF");
            return -1;
        }
    }

    @Override
    public void setByte(int n, byte by) {
        if (this.video == null) {
            this.video = (ModuleVideo)super.getConnection(Module.Type.VIDEO);
            this.cpu = (ModuleCPU)super.getConnection(Module.Type.CPU);
            this.motherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        }
        n = (int)((long)n & A20mask);
        int n2 = n >> this.blockIndex;
        try {
            if (this.watchValue && n == this.watchAddress) {
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] " + this.cpu.getRegisterHex(0) + ":" + this.cpu.getRegisterHex(1) + " Watched BYTE at address " + this.watchAddress + " is written: [" + Integer.toHexString(by).toUpperCase() + "]");
            }
            if (n >= 655360 && n <= 786431) {
                this.video.writeMode(n, by);
            } else {
                if (n >= 786432 && n <= 1048575) {
                    return;
                }
                if (this.ram[n2] == null) {
                    logger.log(Level.SEVERE, "Allocating an extra " + this.ramBlockSize + " bytes for block " + n2);
                    this.ram[n2] = new byte[this.ramBlockSize];
                }
                this.ram[n2][n & this.ramBlockSize - 1] = by;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "] setByte: setByte: Out of memory during write byte");
        }
    }

    @Override
    public byte[] getWord(int n) {
        if (this.video == null) {
            this.video = (ModuleVideo)super.getConnection(Module.Type.VIDEO);
            this.cpu = (ModuleCPU)super.getConnection(Module.Type.CPU);
            this.motherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        }
        n = (int)((long)n & A20mask);
        int n2 = n >> this.blockIndex;
        int n3 = n + 1 >> this.blockIndex;
        byte by = 0;
        byte by2 = 0;
        by = this.ram[n2] == null ? (byte)0 : this.ram[n2][n & this.ramBlockSize - 1];
        by2 = this.ram[n3] == null ? (byte)0 : this.ram[n3][n + 1 & this.ramBlockSize - 1];
        try {
            if (this.watchValue && (n == this.watchAddress || n + 1 == this.watchAddress)) {
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] " + this.cpu.getRegisterHex(0) + ":" + this.cpu.getRegisterHex(1) + " Watched WORD at address " + this.watchAddress + " is read: [" + Integer.toHexString(by2).toUpperCase() + "] [" + Integer.toHexString(by).toUpperCase() + "]");
            }
            if (n >= 655360 && n <= 786431) {
                return new byte[]{this.video.readMode(n + 1), this.video.readMode(n)};
            }
            return new byte[]{by2, by};
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "] Access outside memory bounds; returning 0xFFFF");
            return new byte[]{-1, -1};
        }
    }

    @Override
    public void setWord(int n, byte[] byArray) {
        if (this.video == null) {
            this.video = (ModuleVideo)super.getConnection(Module.Type.VIDEO);
            this.cpu = (ModuleCPU)super.getConnection(Module.Type.CPU);
            this.motherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        }
        n = (int)((long)n & A20mask);
        int n2 = n >> this.blockIndex;
        int n3 = n + 1 >> this.blockIndex;
        try {
            if (this.watchValue && (n == this.watchAddress || n + 1 == this.watchAddress)) {
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] " + this.cpu.getRegisterHex(0) + ":" + this.cpu.getRegisterHex(1) + " Watched WORD at address " + this.watchAddress + " is written: [" + Integer.toHexString(byArray[0]).toUpperCase() + "][" + Integer.toHexString(byArray[1]).toUpperCase() + "]");
            }
            if (n >= 655360 && n <= 786431) {
                this.video.writeMode(n, byArray[1]);
                this.video.writeMode(n + 1, byArray[0]);
            } else {
                if (n >= 786432 && n <= 1048575) {
                    return;
                }
                if (this.ram[n2] == null) {
                    logger.log(Level.SEVERE, "Allocating an extra " + this.ramBlockSize + " bytes for block " + n2);
                    this.ram[n2] = new byte[this.ramBlockSize];
                }
                this.ram[n2][n & this.ramBlockSize - 1] = byArray[1];
                if (this.ram[n3] == null) {
                    logger.log(Level.SEVERE, "Allocating an extra " + this.ramBlockSize + " bytes for block " + n3);
                    this.ram[n3] = new byte[this.ramBlockSize];
                }
                this.ram[n3][n + 1 & this.ramBlockSize - 1] = byArray[0];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "] setWord: Out of memory during write word");
        }
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws ModuleException {
        int n2 = byArray.length;
        int n3 = 0;
        try {
            for (int i = 0; i < n2; ++i) {
                n3 = n + i >> this.blockIndex;
                if (this.ram[n3] == null) {
                    logger.log(Level.SEVERE, "Allocating an extra " + this.ramBlockSize + " bytes for block " + n3);
                    this.ram[n3] = new byte[this.ramBlockSize];
                }
                this.ram[n3][n + i & this.ramBlockSize - 1] = byArray[i];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "] setBytes: Out of memory during write stream of bytes");
            throw new ModuleException("[" + (Object)((Object)super.getType()) + "] setBytes: Out of memory at byte " + arrayIndexOutOfBoundsException.getMessage());
        }
    }

    @Override
    public void setA20AddressLine(boolean bl) {
        A20mask = bl ? -1L : -1048577L;
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " A20 address line status: " + bl + " A20mask: [0x" + Long.toHexString(A20mask) + "]");
    }

    @Override
    public void setWatchValueAndAddress(boolean bl, int n) {
        this.watchValue = bl;
        this.watchAddress = n;
    }

    @Override
    public void setRamSizeInMB(int n) {
        this.ramSize = n * 0x100000;
        this.ramBlockSize = this.ramSize / this.ramBlock;
        this.blockIndex = 0;
        for (int i = this.ramBlockSize; i > 1; i >>= 1) {
            ++this.blockIndex;
        }
        A20mask = -1048577L;
        logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " setting ram size to: " + n + "Mb, ramSize = " + this.ramSize + ", blocks = " + this.ramBlock + ", block size = " + this.ramBlockSize);
    }

    private int convertStringToByte(String string) {
        try {
            int n = 0;
            for (int i = string.length(); i > 0; --i) {
                n += (int)Math.pow(16.0, string.length() - i) * Integer.parseInt(string.substring(i - 1, i), 16);
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " Error while parsing input");
            return -1;
        }
    }
}

