/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.GUI;
import dioscuri.config.AbstractModulePanel;
import dioscuri.config.Emulator;
import java.awt.GridLayout;
import java.math.BigDecimal;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CpuPanel
extends AbstractModulePanel {
    final Emulator.Architecture.Modules.Cpu cpu;
    final JRadioButton cpu16 = new JRadioButton("16 bit");
    final JRadioButton cpu32 = new JRadioButton("32 bit");
    final JTextField mhz = new JTextField();

    CpuPanel(GUI gUI, Emulator emulator) {
        super(gUI, emulator);
        this.cpu = emulator.getArchitecture().getModules().getCpu();
        super.setLayout(new GridLayout(0, 3, 5, 5));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.cpu16);
        buttonGroup.add(this.cpu32);
        this.cpu16.setSelected(!this.cpu.isCpu32Bit());
        this.cpu32.setSelected(this.cpu.isCpu32Bit());
        this.mhz.setText(this.cpu.getSpeedmhz().toString());
        super.add(new JLabel("CPU bits"));
        super.add(this.cpu16);
        super.add(this.cpu32);
        super.add(new JLabel("Speed (MHZ)"));
        super.add(this.mhz);
        super.add(new JLabel());
    }

    @Override
    void save() throws Exception {
        this.cpu.setCpu32Bit(this.cpu32.isSelected());
        this.cpu.setSpeedmhz(new BigDecimal(this.mhz.getText()));
    }
}

