/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_TEST_EbGb
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = false;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte sourceValue1 = 0;
    byte sourceValue2 = 0;
    byte registerHighLow = 0;
    byte tempResult = 0;

    public Instruction_TEST_EbGb() {
        this.memoryReferenceLocation = new byte[2];
        this.memoryReferenceDisplacement = new byte[2];
    }

    public Instruction_TEST_EbGb(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.cpu.flags[11] = false;
        this.cpu.flags[0] = false;
        this.cpu.flags[4] = false;
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        this.registerHighLow = (this.addressByte & 0x20) >> 5 == 0 ? (byte)1 : 0;
        this.sourceValue1 = this.cpu.decodeRegister(this.operandWordSize, (this.addressByte & 0x38) >> 3)[this.registerHighLow];
        if ((this.addressByte >> 6 & 3) == 3) {
            this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
            this.sourceValue2 = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7)[this.registerHighLow];
        } else {
            this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
            this.sourceValue2 = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
        }
        this.tempResult = (byte)(this.sourceValue1 & this.sourceValue2);
        this.cpu.flags[6] = this.tempResult == 0;
        this.cpu.flags[7] = this.tempResult < 0;
        this.cpu.flags[2] = Util.checkParityOfByte(this.tempResult);
    }
}

