/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_CMP_AXIv
implements Instruction {
    private CPU cpu;
    byte[] immediateWord = new byte[2];
    byte[] immediateDoubleWord = new byte[2];
    byte[] resultWord = new byte[2];
    byte[] resultDoubleWord = new byte[2];
    int tempCF = 0;
    boolean tempOF = false;

    public Instruction_CMP_AXIv() {
    }

    public Instruction_CMP_AXIv(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        if (this.cpu.doubleWord) {
            this.immediateWord = this.cpu.getWordFromCode();
            this.immediateDoubleWord = this.cpu.getWordFromCode();
            this.resultWord = Util.subtractWords(this.cpu.ax, this.immediateWord, 0);
            this.tempCF = Util.test_CF_SUB(this.cpu.ax, this.immediateWord, 0) ? 1 : 0;
            this.resultDoubleWord = Util.subtractWords(this.cpu.eax, this.immediateDoubleWord, this.tempCF);
            this.cpu.flags[4] = Util.test_AF_SUB(this.cpu.ax[1], this.resultWord[1]);
            this.cpu.flags[0] = Util.test_CF_SUB(this.cpu.eax, this.immediateDoubleWord, this.tempCF);
            this.cpu.flags[11] = Util.test_OF_SUB(this.cpu.eax, this.immediateDoubleWord, this.resultDoubleWord, this.tempCF);
            this.cpu.flags[6] = this.resultDoubleWord[0] == 0 && this.resultDoubleWord[1] == 0 && this.resultWord[0] == 0 && this.resultWord[1] == 0;
            this.cpu.flags[7] = this.resultDoubleWord[0] < 0;
            this.cpu.flags[2] = Util.checkParityOfByte(this.resultWord[1]);
        } else {
            this.immediateWord = this.cpu.getWordFromCode();
            this.resultWord = Util.subtractWords(this.cpu.ax, this.immediateWord, 0);
            this.cpu.flags[4] = Util.test_AF_SUB(this.cpu.ax[1], this.resultWord[1]);
            this.cpu.flags[0] = Util.test_CF_SUB(this.cpu.ax, this.immediateWord, 0);
            this.cpu.flags[11] = Util.test_OF_SUB(this.cpu.ax, this.immediateWord, this.resultWord, 0);
            this.cpu.flags[6] = this.resultWord[0] == 0 && this.resultWord[1] == 0;
            this.cpu.flags[7] = this.resultWord[0] < 0;
            this.cpu.flags[2] = Util.checkParityOfByte(this.resultWord[1]);
        }
    }
}

